/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.sectioning;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.event.logical.shared.OpenEvent;
import com.google.gwt.event.logical.shared.OpenHandler;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.http.client.URL;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.i18n.client.NumberFormat;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FocusPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.SuggestOracle;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.client.page.UniTimeNotifications;
import org.unitime.timetable.gwt.client.sectioning.EnrollmentTable;
import org.unitime.timetable.gwt.client.sectioning.SectioningStatusFilterBox;
import org.unitime.timetable.gwt.client.widgets.LoadingWidget;
import org.unitime.timetable.gwt.client.widgets.SimpleForm;
import org.unitime.timetable.gwt.client.widgets.UniTimeDialogBox;
import org.unitime.timetable.gwt.client.widgets.UniTimeHeaderPanel;
import org.unitime.timetable.gwt.client.widgets.UniTimeTabPanel;
import org.unitime.timetable.gwt.client.widgets.UniTimeTable;
import org.unitime.timetable.gwt.client.widgets.UniTimeTableHeader;
import org.unitime.timetable.gwt.client.widgets.UniTimeTextBox;
import org.unitime.timetable.gwt.client.widgets.UniTimeWidget;
import org.unitime.timetable.gwt.resources.StudentSectioningConstants;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.resources.StudentSectioningResources;
import org.unitime.timetable.gwt.services.SectioningService;
import org.unitime.timetable.gwt.services.SectioningServiceAsync;
import org.unitime.timetable.gwt.shared.ClassAssignmentInterface;
import org.unitime.timetable.gwt.shared.OnlineSectioningInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SectioningStatusPage
extends Composite {
    public static final StudentSectioningMessages MESSAGES = (StudentSectioningMessages)GWT.create(StudentSectioningMessages.class);
    public static final StudentSectioningResources RESOURCES = (StudentSectioningResources)GWT.create(StudentSectioningResources.class);
    public static final StudentSectioningConstants CONSTANTS = (StudentSectioningConstants)GWT.create(StudentSectioningConstants.class);
    private static DateTimeFormat sDF = DateTimeFormat.getFormat((String)CONSTANTS.requestDateFormat());
    private static DateTimeFormat sTSF = DateTimeFormat.getFormat((String)CONSTANTS.timeStampFormat());
    private final SectioningServiceAsync iSectioningService = (SectioningServiceAsync)GWT.create(SectioningService.class);
    private SectioningStatusFilterBox iFilter;
    private Button iSearch = null;
    private Image iLoadingImage = null;
    private VerticalPanel iSectioningPanel = null;
    private VerticalPanel iPanel = null;
    private HorizontalPanel iFilterPanel = null;
    private UniTimeTable<ClassAssignmentInterface.EnrollmentInfo> iCourseTable = null;
    private UniTimeTable<ClassAssignmentInterface.StudentInfo> iStudentTable = null;
    private UniTimeTable<ClassAssignmentInterface.SectioningAction> iLogTable = null;
    private UniTimeDialogBox iEnrollmentDialog = null;
    private EnrollmentTable iEnrollmentTable = null;
    private ScrollPanel iEnrollmentScroll = null;
    private UniTimeTabPanel iTabPanel = null;
    private int iTabIndex = 0;
    private FocusPanel iTabPanelWithFocus = null;
    private OnlineSectioningInterface.SectioningProperties iProperties = null;
    private HTML iError = null;
    private HTML iCourseTableHint;
    private HTML iStudentTableHint;
    private String iLastFilterOnEnter = null;
    private String iCourseFilter = null;
    private SectioningStatusFilterBox.SectioningStatusFilterRpcRequest iCourseFilterRequest = null;
    private Map<String, String> iStates = null;
    private int iStatusColumn = 0;
    private UniTimeTextBox iSubject;
    private UniTimeTextBox iCC;
    private UniTimeWidget<ListBox> iStatus;
    private TextArea iMessage;
    private Set<Long> iSelectedStudentIds = new HashSet<Long>();
    private boolean iOnline;

    public SectioningStatusPage(boolean online) {
        this.iOnline = online;
        this.iPanel = new VerticalPanel();
        this.iSectioningPanel = new VerticalPanel();
        this.iFilterPanel = new HorizontalPanel();
        this.iFilterPanel.setSpacing(3);
        Label filterLabel = new Label(MESSAGES.filter());
        this.iFilterPanel.add((Widget)filterLabel);
        this.iFilterPanel.setCellVerticalAlignment((Widget)filterLabel, HasVerticalAlignment.ALIGN_MIDDLE);
        this.iFilter = new SectioningStatusFilterBox(online);
        this.iFilterPanel.add((Widget)this.iFilter);
        this.iSearch = new Button(MESSAGES.buttonSearch());
        this.iSearch.setAccessKey('s');
        this.iSearch.addStyleName("unitime-NoPrint");
        this.iFilterPanel.add((Widget)this.iSearch);
        this.iFilterPanel.setCellVerticalAlignment((Widget)this.iSearch, HasVerticalAlignment.ALIGN_MIDDLE);
        this.iLoadingImage = new Image(RESOURCES.loading_small());
        this.iLoadingImage.setVisible(false);
        this.iFilterPanel.add((Widget)this.iLoadingImage);
        this.iFilterPanel.setCellVerticalAlignment((Widget)this.iLoadingImage, HasVerticalAlignment.ALIGN_MIDDLE);
        this.iSectioningPanel.add((Widget)this.iFilterPanel);
        this.iSectioningPanel.setCellHorizontalAlignment((Widget)this.iFilterPanel, HasHorizontalAlignment.ALIGN_CENTER);
        this.iCourseTable = new UniTimeTable();
        this.iStudentTable = new UniTimeTable();
        this.iLogTable = new UniTimeTable();
        VerticalPanel courseTableWithHint = new VerticalPanel();
        courseTableWithHint.add(this.iCourseTable);
        this.iCourseTableHint = new HTML(MESSAGES.sectioningStatusReservationHint());
        this.iCourseTableHint.setStyleName("unitime-Hint");
        courseTableWithHint.add((Widget)this.iCourseTableHint);
        courseTableWithHint.setCellHorizontalAlignment((Widget)this.iCourseTableHint, HasHorizontalAlignment.ALIGN_RIGHT);
        VerticalPanel studentTableWithHint = new VerticalPanel();
        studentTableWithHint.add(this.iStudentTable);
        this.iStudentTableHint = new HTML(MESSAGES.sectioningStatusPriorityHint());
        this.iStudentTableHint.setStyleName("unitime-Hint");
        studentTableWithHint.add((Widget)this.iStudentTableHint);
        studentTableWithHint.setCellHorizontalAlignment((Widget)this.iStudentTableHint, HasHorizontalAlignment.ALIGN_RIGHT);
        this.iTabPanel = new UniTimeTabPanel();
        this.iTabPanel.add((Widget)courseTableWithHint, MESSAGES.tabEnrollments(), true);
        this.iTabPanel.selectTab(0);
        this.iTabPanel.add((Widget)studentTableWithHint, MESSAGES.tabStudents(), true);
        this.iTabPanel.setVisible(false);
        this.iTabPanel.addSelectionHandler(new SelectionHandler<Integer>(){

            public void onSelection(SelectionEvent<Integer> event) {
                SectioningStatusPage.this.iTabIndex = (Integer)event.getSelectedItem();
                SectioningStatusPage.this.loadDataIfNeeded();
            }
        });
        this.iTabPanelWithFocus = new FocusPanel((Widget)this.iTabPanel);
        this.iTabPanelWithFocus.setStyleName("unitime-FocusPanel");
        this.iSectioningPanel.add((Widget)this.iTabPanelWithFocus);
        this.iTabPanelWithFocus.addKeyUpHandler(new KeyUpHandler(){

            public void onKeyUp(KeyUpEvent event) {
                if (event.getNativeEvent().getCtrlKey() && (event.getNativeKeyCode() == 101 || event.getNativeKeyCode() == 69)) {
                    SectioningStatusPage.this.iTabPanel.selectTab(0);
                    event.preventDefault();
                }
                if (event.getNativeEvent().getCtrlKey() && (event.getNativeKeyCode() == 115 || event.getNativeKeyCode() == 83)) {
                    SectioningStatusPage.this.iTabPanel.selectTab(1);
                    event.preventDefault();
                }
                if (event.getNativeEvent().getCtrlKey() && (event.getNativeKeyCode() == 108 || event.getNativeKeyCode() == 76)) {
                    SectioningStatusPage.this.iTabPanel.selectTab(2);
                    event.preventDefault();
                }
            }
        });
        this.iSectioningPanel.setWidth("100%");
        this.iPanel.add((Widget)this.iSectioningPanel);
        this.iError = new HTML();
        this.iError.setStyleName("unitime-ErrorMessage");
        this.iError.setVisible(false);
        this.iPanel.add((Widget)this.iError);
        this.iPanel.setCellHorizontalAlignment((Widget)this.iError, HasHorizontalAlignment.ALIGN_CENTER);
        this.initWidget((Widget)this.iPanel);
        this.iSearch.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                SectioningStatusPage.this.loadData();
            }
        });
        this.iFilter.addKeyUpHandler(new KeyUpHandler(){

            public void onKeyUp(KeyUpEvent event) {
                if (event.getNativeKeyCode() == 13) {
                    if (SectioningStatusPage.this.iFilter.getValue().equals(SectioningStatusPage.this.iLastFilterOnEnter) && !SectioningStatusPage.this.iFilter.getValue().equals(SectioningStatusPage.this.iCourseFilter)) {
                        SectioningStatusPage.this.loadData();
                    } else {
                        SectioningStatusPage.this.iLastFilterOnEnter = SectioningStatusPage.this.iFilter.getValue();
                    }
                }
            }
        });
        this.iCourseTable.addMouseClickListener(new UniTimeTable.MouseClickListener<ClassAssignmentInterface.EnrollmentInfo>(){

            @Override
            public void onMouseClick(final UniTimeTable.TableEvent<ClassAssignmentInterface.EnrollmentInfo> event) {
                if (event.getData() == null || event.getData().getCourseId() == null) {
                    return;
                }
                SectioningStatusPage.this.iCourseTable.clearHover();
                SectioningStatusPage.this.setLoading(true);
                final Long id = event.getData().getConfigId() == null ? event.getData().getOfferingId() : -event.getData().getClazzId().longValue();
                SectioningStatusPage.this.iError.setVisible(false);
                if (event.getData().getConfigId() == null) {
                    LoadingWidget.getInstance().show(MESSAGES.loadingEnrollments(MESSAGES.course(event.getData().getSubject(), event.getData().getCourseNbr())));
                } else {
                    LoadingWidget.getInstance().show(MESSAGES.loadingEnrollments(MESSAGES.clazz(event.getData().getSubject(), event.getData().getCourseNbr(), event.getData().getSubpart(), event.getData().getClazz())));
                }
                if (SectioningStatusPage.this.iOnline) {
                    SectioningStatusPage.this.iSectioningService.canApprove(id, new AsyncCallback<List<Long>>(){

                        public void onSuccess(final List<Long> courseIdsCanApprove) {
                            SectioningStatusPage.this.iSectioningService.findEnrollments(SectioningStatusPage.this.iOnline, SectioningStatusPage.this.iCourseFilter, SectioningStatusPage.this.iCourseFilterRequest, ((ClassAssignmentInterface.EnrollmentInfo)event.getData()).getCourseId(), ((ClassAssignmentInterface.EnrollmentInfo)event.getData()).getClazzId(), new AsyncCallback<List<ClassAssignmentInterface.Enrollment>>(){

                                public void onFailure(Throwable caught) {
                                    LoadingWidget.getInstance().hide();
                                    UniTimeNotifications.error(caught);
                                    SectioningStatusPage.this.setLoading(false);
                                    SectioningStatusPage.this.iError.setHTML(caught.getMessage());
                                    SectioningStatusPage.this.iError.setVisible(true);
                                    ToolBox.checkAccess(caught);
                                }

                                public void onSuccess(List<ClassAssignmentInterface.Enrollment> result) {
                                    LoadingWidget.getInstance().hide();
                                    SectioningStatusPage.this.setLoading(false);
                                    SectioningStatusPage.this.iEnrollmentTable.clear();
                                    SectioningStatusPage.this.iEnrollmentTable.setId(id);
                                    SectioningStatusPage.this.iEnrollmentTable.populate(result, courseIdsCanApprove);
                                    if (((ClassAssignmentInterface.EnrollmentInfo)event.getData()).getConfigId() == null) {
                                        SectioningStatusPage.this.iEnrollmentDialog.setText(MESSAGES.titleEnrollments(MESSAGES.course(((ClassAssignmentInterface.EnrollmentInfo)event.getData()).getSubject(), ((ClassAssignmentInterface.EnrollmentInfo)event.getData()).getCourseNbr())));
                                    } else {
                                        SectioningStatusPage.this.iEnrollmentDialog.setText(MESSAGES.titleEnrollments(MESSAGES.clazz(((ClassAssignmentInterface.EnrollmentInfo)event.getData()).getSubject(), ((ClassAssignmentInterface.EnrollmentInfo)event.getData()).getCourseNbr(), ((ClassAssignmentInterface.EnrollmentInfo)event.getData()).getSubpart(), ((ClassAssignmentInterface.EnrollmentInfo)event.getData()).getClazz())));
                                    }
                                    SectioningStatusPage.this.iEnrollmentDialog.center();
                                }
                            });
                        }

                        public void onFailure(Throwable caught) {
                            LoadingWidget.getInstance().hide();
                            UniTimeNotifications.error(caught);
                            SectioningStatusPage.this.setLoading(false);
                            SectioningStatusPage.this.iError.setHTML(caught.getMessage());
                            SectioningStatusPage.this.iError.setVisible(true);
                            ToolBox.checkAccess(caught);
                        }
                    });
                } else {
                    SectioningStatusPage.this.iSectioningService.findEnrollments(SectioningStatusPage.this.iOnline, SectioningStatusPage.this.iCourseFilter, SectioningStatusPage.this.iCourseFilterRequest, event.getData().getCourseId(), event.getData().getClazzId(), new AsyncCallback<List<ClassAssignmentInterface.Enrollment>>(){

                        public void onFailure(Throwable caught) {
                            LoadingWidget.getInstance().hide();
                            UniTimeNotifications.error(caught);
                            SectioningStatusPage.this.setLoading(false);
                            SectioningStatusPage.this.iError.setHTML(caught.getMessage());
                            SectioningStatusPage.this.iError.setVisible(true);
                            ToolBox.checkAccess(caught);
                        }

                        public void onSuccess(List<ClassAssignmentInterface.Enrollment> result) {
                            LoadingWidget.getInstance().hide();
                            SectioningStatusPage.this.setLoading(false);
                            SectioningStatusPage.this.iEnrollmentTable.clear();
                            SectioningStatusPage.this.iEnrollmentTable.setId(id);
                            SectioningStatusPage.this.iEnrollmentTable.populate(result, null);
                            if (((ClassAssignmentInterface.EnrollmentInfo)event.getData()).getConfigId() == null) {
                                SectioningStatusPage.this.iEnrollmentDialog.setText(MESSAGES.titleEnrollments(MESSAGES.course(((ClassAssignmentInterface.EnrollmentInfo)event.getData()).getSubject(), ((ClassAssignmentInterface.EnrollmentInfo)event.getData()).getCourseNbr())));
                            } else {
                                SectioningStatusPage.this.iEnrollmentDialog.setText(MESSAGES.titleEnrollments(MESSAGES.clazz(((ClassAssignmentInterface.EnrollmentInfo)event.getData()).getSubject(), ((ClassAssignmentInterface.EnrollmentInfo)event.getData()).getCourseNbr(), ((ClassAssignmentInterface.EnrollmentInfo)event.getData()).getSubpart(), ((ClassAssignmentInterface.EnrollmentInfo)event.getData()).getClazz())));
                            }
                            SectioningStatusPage.this.iEnrollmentDialog.center();
                        }
                    });
                }
            }
        });
        this.iStudentTable.addMouseClickListener(new UniTimeTable.MouseClickListener<ClassAssignmentInterface.StudentInfo>(){

            @Override
            public void onMouseClick(UniTimeTable.TableEvent<ClassAssignmentInterface.StudentInfo> event) {
                if (event.getData() == null || event.getData().getStudent() == null) {
                    return;
                }
                SectioningStatusPage.this.iStudentTable.clearHover();
                LoadingWidget.getInstance().show(MESSAGES.loadingEnrollment(event.getData().getStudent().getName()));
                SectioningStatusPage.this.iError.setVisible(false);
                SectioningStatusPage.this.iEnrollmentTable.showStudentSchedule(event.getData().getStudent(), new AsyncCallback<Boolean>(){

                    public void onFailure(Throwable caught) {
                        LoadingWidget.getInstance().hide();
                        SectioningStatusPage.this.iError.setHTML(caught.getMessage());
                        SectioningStatusPage.this.iError.setVisible(true);
                    }

                    public void onSuccess(Boolean result) {
                        LoadingWidget.getInstance().hide();
                    }
                });
            }
        });
        this.iLogTable.addMouseClickListener(new UniTimeTable.MouseClickListener<ClassAssignmentInterface.SectioningAction>(){

            @Override
            public void onMouseClick(UniTimeTable.TableEvent<ClassAssignmentInterface.SectioningAction> event) {
                if (event.getData() != null && event.getData().getProto() != null) {
                    final HTML widget = new HTML(event.getData().getProto());
                    final ScrollPanel scroll = new ScrollPanel((Widget)widget);
                    scroll.setHeight((int)(0.8 * (double)Window.getClientHeight()) + "px");
                    scroll.setStyleName("unitime-ScrollPanel");
                    final UniTimeDialogBox dialog = new UniTimeDialogBox(true, false);
                    dialog.setWidget((Widget)scroll);
                    dialog.setText(MESSAGES.dialogChangeMessage(event.getData().getStudent().getName()));
                    dialog.setEscapeToHide(true);
                    dialog.addOpenHandler(new OpenHandler<UniTimeDialogBox>(){

                        public void onOpen(OpenEvent<UniTimeDialogBox> event) {
                            RootPanel.getBodyElement().getStyle().setOverflow(Style.Overflow.HIDDEN);
                            scroll.setHeight(Math.min(widget.getElement().getScrollHeight(), Window.getClientHeight() * 80 / 100) + "px");
                            dialog.setPopupPosition(Math.max(Window.getScrollLeft() + (Window.getClientWidth() - dialog.getOffsetWidth()) / 2, 0), Math.max(Window.getScrollTop() + (Window.getClientHeight() - dialog.getOffsetHeight()) / 2, 0));
                        }
                    });
                    dialog.addCloseHandler((CloseHandler)new CloseHandler<PopupPanel>(){

                        public void onClose(CloseEvent<PopupPanel> event) {
                            SectioningStatusPage.this.iLogTable.clearHover();
                            RootPanel.getBodyElement().getStyle().setOverflow(Style.Overflow.AUTO);
                        }
                    });
                    dialog.center();
                }
            }
        });
        History.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

            public void onValueChange(ValueChangeEvent<String> event) {
                SectioningStatusPage.this.iCourseTable.clearTable();
                SectioningStatusPage.this.iStudentTable.clearTable();
                SectioningStatusPage.this.iLogTable.clearTable();
                if (((String)event.getValue()).endsWith("@")) {
                    SectioningStatusPage.this.iFilter.setValue(((String)event.getValue()).substring(0, ((String)event.getValue()).length() - 1));
                    SectioningStatusPage.this.iTabPanel.selectTab(1);
                } else if (((String)event.getValue()).endsWith("$")) {
                    SectioningStatusPage.this.iFilter.setValue(((String)event.getValue()).substring(0, ((String)event.getValue()).length() - 1));
                    SectioningStatusPage.this.iTabPanel.selectTab(2);
                } else {
                    SectioningStatusPage.this.iFilter.setValue((String)event.getValue());
                    if (SectioningStatusPage.this.iTabIndex != 0) {
                        SectioningStatusPage.this.iTabPanel.selectTab(0);
                    } else {
                        SectioningStatusPage.this.loadData();
                    }
                }
            }
        });
        this.iEnrollmentTable = new EnrollmentTable(false, this.iOnline);
        this.iEnrollmentScroll = new ScrollPanel((Widget)this.iEnrollmentTable);
        this.iEnrollmentScroll.setHeight((int)(0.8 * (double)Window.getClientHeight()) + "px");
        this.iEnrollmentScroll.setStyleName("unitime-ScrollPanel");
        this.iEnrollmentDialog = new UniTimeDialogBox(true, false);
        this.iEnrollmentDialog.setEscapeToHide(true);
        this.iEnrollmentDialog.setWidget((Widget)this.iEnrollmentScroll);
        this.iEnrollmentDialog.addOpenHandler(new OpenHandler<UniTimeDialogBox>(){

            public void onOpen(OpenEvent<UniTimeDialogBox> event) {
                RootPanel.getBodyElement().getStyle().setOverflow(Style.Overflow.HIDDEN);
                SectioningStatusPage.this.iEnrollmentScroll.setHeight(Math.min(SectioningStatusPage.this.iEnrollmentTable.getElement().getScrollHeight(), Window.getClientHeight() * 80 / 100) + "px");
                SectioningStatusPage.this.iEnrollmentDialog.setPopupPosition(Math.max(Window.getScrollLeft() + (Window.getClientWidth() - SectioningStatusPage.this.iEnrollmentDialog.getOffsetWidth()) / 2, 0), Math.max(Window.getScrollTop() + (Window.getClientHeight() - SectioningStatusPage.this.iEnrollmentDialog.getOffsetHeight()) / 2, 0));
            }
        });
        this.iEnrollmentTable.getHeader().addButton("close", MESSAGES.buttonClose(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                SectioningStatusPage.this.iEnrollmentDialog.hide();
            }
        });
        this.iEnrollmentDialog.addCloseHandler((CloseHandler)new CloseHandler<PopupPanel>(){

            public void onClose(CloseEvent<PopupPanel> event) {
                RootPanel.getBodyElement().getStyle().setOverflow(Style.Overflow.AUTO);
            }
        });
        if (this.iOnline) {
            this.iSectioningService.getProperties(null, new AsyncCallback<OnlineSectioningInterface.SectioningProperties>(){

                public void onSuccess(OnlineSectioningInterface.SectioningProperties result) {
                    SectioningStatusPage.this.iProperties = result;
                    if (SectioningStatusPage.this.iProperties.isAdmin()) {
                        SectioningStatusPage.this.iTabPanel.add((Widget)SectioningStatusPage.this.iLogTable, MESSAGES.tabChangeLog(), true);
                    }
                    SectioningStatusPage.this.checkLastQuery();
                }

                public void onFailure(Throwable caught) {
                    SectioningStatusPage.this.iError.setHTML(caught.getMessage());
                    SectioningStatusPage.this.iError.setVisible(true);
                }
            });
        } else {
            this.checkLastQuery();
        }
        this.iStatus = new UniTimeWidget<ListBox>(new ListBox());
        this.iStatus.getWidget().addItem("");
        this.iStatus.getWidget().setSelectedIndex(0);
        this.iSectioningService.lookupStudentSectioningStates(new AsyncCallback<Map<String, String>>(){

            public void onFailure(Throwable caught) {
            }

            public void onSuccess(Map<String, String> result) {
                SectioningStatusPage.this.iStates = result;
                for (String ref : new TreeSet(SectioningStatusPage.this.iStates.keySet())) {
                    ((ListBox)SectioningStatusPage.this.iStatus.getWidget()).addItem((String)SectioningStatusPage.this.iStates.get(ref), ref);
                }
                for (int i = 0; i < ((ListBox)SectioningStatusPage.this.iStatus.getWidget()).getItemCount(); ++i) {
                    if (!"Cancelled".equalsIgnoreCase(((ListBox)SectioningStatusPage.this.iStatus.getWidget()).getValue(i))) continue;
                    ((ListBox)SectioningStatusPage.this.iStatus.getWidget()).setSelectedIndex(i);
                    break;
                }
            }
        });
        this.iSubject = new UniTimeTextBox(512, 473);
        this.iSubject.setText(MESSAGES.defaulSubject());
        this.iCC = new UniTimeTextBox(512, 473);
        this.iMessage = new TextArea();
        this.iMessage.setStyleName("unitime-TextArea");
        this.iMessage.setVisibleLines(10);
        this.iMessage.setCharacterWidth(80);
    }

    private void checkLastQuery() {
        if (Window.Location.getParameter((String)"q") != null) {
            this.iFilter.setValue(Window.Location.getParameter((String)"q"), true);
            if (Window.Location.getParameter((String)"t") != null) {
                if ("2".equals(Window.Location.getParameter((String)"t"))) {
                    this.iTabPanel.selectTab(1);
                } else {
                    this.iTabPanel.selectTab(0);
                }
            } else {
                this.loadData();
            }
        } else if (Window.Location.getHash() != null && !Window.Location.getHash().isEmpty()) {
            String hash = URL.decode((String)Window.Location.getHash().substring(1));
            if (!hash.matches("^[0-9]+\\:?[0-9]*@?$")) {
                if (hash.endsWith("@")) {
                    this.iFilter.setValue(hash.substring(0, hash.length() - 1), true);
                    this.iTabPanel.selectTab(1);
                } else if (hash.endsWith("$")) {
                    this.iFilter.setValue(hash.substring(0, hash.length() - 1), true);
                    this.iTabPanel.selectTab(2);
                } else {
                    this.iFilter.setValue(hash, true);
                    this.loadData();
                }
            }
        } else {
            this.iSectioningService.lastStatusQuery(new AsyncCallback<String>(){

                public void onFailure(Throwable caught) {
                    SectioningStatusPage.this.iError.setHTML(caught.getMessage());
                    SectioningStatusPage.this.iError.setVisible(true);
                    ToolBox.checkAccess(caught);
                }

                public void onSuccess(String result) {
                    if (result != null) {
                        SectioningStatusPage.this.iFilter.setValue(result, true);
                        SectioningStatusPage.this.loadData();
                    }
                }
            });
        }
    }

    private void setLoading(boolean loading) {
        this.iLoadingImage.setVisible(loading);
        this.iSearch.setVisible(!loading);
    }

    private void loadData() {
        this.iCourseTable.clearTable();
        this.iStudentTable.clearTable();
        this.iLogTable.clearTable();
        this.loadDataIfNeeded();
    }

    private void loadDataIfNeeded() {
        this.iCourseFilter = this.iFilter.getValue();
        this.iCourseFilterRequest = (SectioningStatusFilterBox.SectioningStatusFilterRpcRequest)this.iFilter.getElementsRequest();
        History.newItem((String)(this.iCourseFilter + (this.iTabIndex == 1 ? "@" : (this.iTabIndex == 2 ? "$" : ""))), (boolean)false);
        if (this.iFilter.isFilterPopupShowing()) {
            this.iFilter.hideFilterPopup();
        }
        if (this.iTabIndex == 0 && this.iCourseTable.getRowCount() > 0) {
            return;
        }
        if (this.iTabIndex == 1 && this.iStudentTable.getRowCount() > 0) {
            return;
        }
        if (this.iTabIndex == 2 && this.iLogTable.getRowCount() > 0) {
            return;
        }
        LoadingWidget.getInstance().show(MESSAGES.loadingData());
        this.setLoading(true);
        this.iError.setVisible(false);
        if (this.iTabIndex == 0) {
            this.iSectioningService.findEnrollmentInfos(this.iOnline, this.iCourseFilter, this.iCourseFilterRequest, null, new AsyncCallback<List<ClassAssignmentInterface.EnrollmentInfo>>(){

                public void onFailure(Throwable caught) {
                    LoadingWidget.getInstance().hide();
                    SectioningStatusPage.this.setLoading(false);
                    SectioningStatusPage.this.iError.setHTML(caught.getMessage());
                    SectioningStatusPage.this.iError.setVisible(true);
                    SectioningStatusPage.this.iTabPanel.setVisible(false);
                    ToolBox.checkAccess(caught);
                }

                public void onSuccess(List<ClassAssignmentInterface.EnrollmentInfo> result) {
                    if (result.isEmpty()) {
                        SectioningStatusPage.this.iError.setHTML(MESSAGES.exceptionNoMatchingResultsFound(SectioningStatusPage.this.iCourseFilter));
                        SectioningStatusPage.this.iError.setVisible(true);
                        SectioningStatusPage.this.iTabPanel.setVisible(false);
                    } else {
                        SectioningStatusPage.this.populateCourseTable(result);
                        SectioningStatusPage.this.iTabPanel.setVisible(true);
                    }
                    SectioningStatusPage.this.setLoading(false);
                    LoadingWidget.getInstance().hide();
                }
            });
        } else if (this.iTabIndex == 1) {
            if (this.iOnline) {
                this.iSectioningService.findStudentInfos(this.iOnline, this.iCourseFilter, this.iCourseFilterRequest, new AsyncCallback<List<ClassAssignmentInterface.StudentInfo>>(){

                    public void onFailure(Throwable caught) {
                        LoadingWidget.getInstance().hide();
                        SectioningStatusPage.this.setLoading(false);
                        SectioningStatusPage.this.iError.setHTML(caught.getMessage());
                        SectioningStatusPage.this.iError.setVisible(true);
                        SectioningStatusPage.this.iTabPanel.setVisible(false);
                        ToolBox.checkAccess(caught);
                    }

                    public void onSuccess(List<ClassAssignmentInterface.StudentInfo> result) {
                        if (result.isEmpty()) {
                            SectioningStatusPage.this.iError.setHTML(MESSAGES.exceptionNoMatchingResultsFound(SectioningStatusPage.this.iCourseFilter));
                            SectioningStatusPage.this.iError.setVisible(true);
                            SectioningStatusPage.this.iTabPanel.setVisible(false);
                        } else {
                            SectioningStatusPage.this.populateStudentTable(result);
                            SectioningStatusPage.this.iTabPanel.setVisible(true);
                        }
                        SectioningStatusPage.this.setLoading(false);
                        LoadingWidget.getInstance().hide();
                    }
                });
            } else {
                this.iSectioningService.findStudentInfos(this.iOnline, this.iCourseFilter, this.iCourseFilterRequest, new AsyncCallback<List<ClassAssignmentInterface.StudentInfo>>(){

                    public void onFailure(Throwable caught) {
                        LoadingWidget.getInstance().hide();
                        SectioningStatusPage.this.setLoading(false);
                        SectioningStatusPage.this.iError.setHTML(caught.getMessage());
                        SectioningStatusPage.this.iError.setVisible(true);
                        SectioningStatusPage.this.iTabPanel.setVisible(false);
                        ToolBox.checkAccess(caught);
                    }

                    public void onSuccess(List<ClassAssignmentInterface.StudentInfo> result) {
                        if (result.isEmpty()) {
                            SectioningStatusPage.this.iError.setHTML(MESSAGES.exceptionNoMatchingResultsFound(SectioningStatusPage.this.iCourseFilter));
                            SectioningStatusPage.this.iError.setVisible(true);
                            SectioningStatusPage.this.iTabPanel.setVisible(false);
                        } else {
                            SectioningStatusPage.this.populateStudentTable(result);
                            SectioningStatusPage.this.iTabPanel.setVisible(true);
                        }
                        SectioningStatusPage.this.setLoading(false);
                        LoadingWidget.getInstance().hide();
                    }
                });
            }
        } else if (this.iOnline) {
            this.iSectioningService.changeLog(this.iCourseFilter, new AsyncCallback<List<ClassAssignmentInterface.SectioningAction>>(){

                public void onFailure(Throwable caught) {
                    LoadingWidget.getInstance().hide();
                    SectioningStatusPage.this.setLoading(false);
                    SectioningStatusPage.this.iError.setHTML(caught.getMessage());
                    SectioningStatusPage.this.iError.setVisible(true);
                    SectioningStatusPage.this.iTabPanel.setVisible(false);
                    ToolBox.checkAccess(caught);
                }

                public void onSuccess(List<ClassAssignmentInterface.SectioningAction> result) {
                    SectioningStatusPage.this.populateChangeLog(result);
                    SectioningStatusPage.this.iTabPanel.setVisible(true);
                    SectioningStatusPage.this.setLoading(false);
                    LoadingWidget.getInstance().hide();
                }
            });
        }
    }

    private List<Widget> line(final ClassAssignmentInterface.EnrollmentInfo e) {
        ArrayList<Widget> line = new ArrayList<Widget>();
        if (e.getConfigId() == null) {
            if (e.getCourseId() != null) {
                final Image showDetails = new Image(RESOURCES.treeClosed());
                showDetails.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        final int row = SectioningStatusPage.this.iCourseTable.getCellForEvent(event).getRowIndex();
                        if (row + 1 == SectioningStatusPage.this.iCourseTable.getRowCount() || ((ClassAssignmentInterface.EnrollmentInfo)SectioningStatusPage.this.iCourseTable.getData(row + 1)).getConfigId() == null) {
                            SectioningStatusPage.this.setLoading(true);
                            SectioningStatusPage.this.iError.setVisible(false);
                            showDetails.setResource(RESOURCES.treeOpen());
                            SectioningStatusPage.this.iSectioningService.findEnrollmentInfos(SectioningStatusPage.this.iOnline, SectioningStatusPage.this.iCourseFilter, SectioningStatusPage.this.iCourseFilterRequest, e.getCourseId(), new AsyncCallback<List<ClassAssignmentInterface.EnrollmentInfo>>(){

                                public void onFailure(Throwable caught) {
                                    SectioningStatusPage.this.setLoading(false);
                                    SectioningStatusPage.this.iError.setHTML(caught.getMessage());
                                    SectioningStatusPage.this.iError.setVisible(true);
                                    ToolBox.checkAccess(caught);
                                }

                                public void onSuccess(List<ClassAssignmentInterface.EnrollmentInfo> result) {
                                    SectioningStatusPage.this.setLoading(false);
                                    int r = row + 1;
                                    for (ClassAssignmentInterface.EnrollmentInfo e : result) {
                                        SectioningStatusPage.this.iCourseTable.insertRow(r);
                                        SectioningStatusPage.this.iCourseTable.setRow(r, e, SectioningStatusPage.this.line(e));
                                        ++r;
                                    }
                                }
                            });
                        } else {
                            for (int r = row + 1; r < SectioningStatusPage.this.iCourseTable.getRowCount() && ((ClassAssignmentInterface.EnrollmentInfo)SectioningStatusPage.this.iCourseTable.getData(r)).getConfigId() != null; ++r) {
                                SectioningStatusPage.this.iCourseTable.getRowFormatter().setVisible(r, !SectioningStatusPage.this.iCourseTable.getRowFormatter().isVisible(r));
                            }
                            showDetails.setResource(RESOURCES.treeClosed());
                        }
                        event.getNativeEvent().stopPropagation();
                        event.getNativeEvent().preventDefault();
                    }
                });
                line.add((Widget)showDetails);
            } else {
                line.add((Widget)new Label());
            }
            line.add((Widget)new Label(e.getSubject(), false));
            line.add((Widget)new Label(e.getCourseNbr(), false));
            line.add((Widget)new TitleCell(e.getTitle() == null ? "" : e.getTitle()));
            line.add((Widget)new Label(e.getConsent() == null ? "" : e.getConsent(), false));
        } else {
            line.add((Widget)new Label());
            line.add((Widget)new HTML("&nbsp;&nbsp;" + (e.getSubpart() == null ? "" : e.getIndent() + e.getSubpart()), false));
            line.add((Widget)new HTML(e.getClazz() == null ? "" : e.getIndent() + e.getClazz(), false));
            line.add((Widget)new Label(e.getAssignment().getDays().isEmpty() ? "" : e.getAssignment().getDaysString(CONSTANTS.shortDays()) + " " + e.getAssignment().getStartString(CONSTANTS.useAmPm()) + " - " + e.getAssignment().getEndString(CONSTANTS.useAmPm()), false));
            line.add((Widget)new Label(!e.getAssignment().hasDatePattern() ? "" : e.getAssignment().getDatePattern(), false));
            line.add((Widget)new Label(!e.getAssignment().hasRoom() ? "" : e.getAssignment().getRooms(","), false));
        }
        if (e.getCourseId() == null) {
            line.add((Widget)new NumberCell(e.getAvailable(), e.getLimit()));
        } else {
            line.add((Widget)new AvailableCell(e));
        }
        line.add((Widget)new NumberCell(null, e.getProjection()));
        line.add((Widget)new NumberCell(e.getEnrollment(), e.getTotalEnrollment()));
        line.add((Widget)new WaitListCell(e));
        line.add((Widget)new NumberCell(e.getReservation(), e.getTotalReservation()));
        line.add((Widget)new NumberCell(e.getConsentNeeded(), e.getTotalConsentNeeded()));
        return line;
    }

    public void populateCourseTable(List<ClassAssignmentInterface.EnrollmentInfo> result) {
        ArrayList<UniTimeTableHeader> header = new ArrayList<UniTimeTableHeader>();
        UniTimeTableHeader hOperations = new UniTimeTableHeader("");
        header.add(hOperations);
        final UniTimeTableHeader hSubject = new UniTimeTableHeader(MESSAGES.colSubject() + "<br>&nbsp;&nbsp;" + MESSAGES.colSubpart());
        header.add(hSubject);
        hSubject.addOperation(new UniTimeTableHeader.Operation(){

            public void execute() {
                SectioningStatusPage.this.iCourseTable.sort(hSubject, new EnrollmentComparator(EnrollmentComparator.SortBy.SUBJECT));
            }

            public boolean isApplicable() {
                return true;
            }

            public boolean hasSeparator() {
                return false;
            }

            public String getName() {
                return MESSAGES.sortBy(MESSAGES.colSubject());
            }
        });
        final UniTimeTableHeader hCourse = new UniTimeTableHeader(MESSAGES.colCourse() + "<br>" + MESSAGES.colClass());
        header.add(hCourse);
        hCourse.addOperation(new UniTimeTableHeader.Operation(){

            public void execute() {
                SectioningStatusPage.this.iCourseTable.sort(hCourse, new EnrollmentComparator(EnrollmentComparator.SortBy.COURSE));
            }

            public boolean isApplicable() {
                return true;
            }

            public boolean hasSeparator() {
                return false;
            }

            public String getName() {
                return MESSAGES.sortBy(MESSAGES.colCourse());
            }
        });
        final UniTimeTableHeader hTitleSubpart = new UniTimeTableHeader(MESSAGES.colTitle() + "<br>" + MESSAGES.colTime());
        header.add(hTitleSubpart);
        hTitleSubpart.addOperation(new UniTimeTableHeader.Operation(){

            public void execute() {
                SectioningStatusPage.this.iCourseTable.sort(hTitleSubpart, new EnrollmentComparator(EnrollmentComparator.SortBy.TITLE));
            }

            public boolean isApplicable() {
                return true;
            }

            public boolean hasSeparator() {
                return false;
            }

            public String getName() {
                return MESSAGES.sortBy(MESSAGES.colTitle());
            }
        });
        UniTimeTableHeader hStart = new UniTimeTableHeader("<br>" + MESSAGES.colDate());
        header.add(hStart);
        final UniTimeTableHeader hRoom = new UniTimeTableHeader(MESSAGES.colConsent() + "<br>" + MESSAGES.colRoom());
        header.add(hRoom);
        hRoom.addOperation(new UniTimeTableHeader.Operation(){

            public void execute() {
                SectioningStatusPage.this.iCourseTable.sort(hRoom, new EnrollmentComparator(EnrollmentComparator.SortBy.CONSENT));
            }

            public boolean isApplicable() {
                return true;
            }

            public boolean hasSeparator() {
                return false;
            }

            public String getName() {
                return MESSAGES.sortBy(MESSAGES.colConsent());
            }
        });
        final UniTimeTableHeader hLimit = new UniTimeTableHeader(MESSAGES.colAvailable());
        header.add(hLimit);
        hLimit.addOperation(new UniTimeTableHeader.Operation(){

            public void execute() {
                SectioningStatusPage.this.iCourseTable.sort(hLimit, new EnrollmentComparator(EnrollmentComparator.SortBy.LIMIT));
            }

            public boolean isApplicable() {
                return true;
            }

            public boolean hasSeparator() {
                return false;
            }

            public String getName() {
                return MESSAGES.sortBy(MESSAGES.colAvailable());
            }
        });
        final UniTimeTableHeader hProjection = new UniTimeTableHeader(MESSAGES.colProjection());
        header.add(hProjection);
        hProjection.addOperation(new UniTimeTableHeader.Operation(){

            public void execute() {
                SectioningStatusPage.this.iCourseTable.sort(hProjection, new EnrollmentComparator(EnrollmentComparator.SortBy.PROJECTION));
            }

            public boolean isApplicable() {
                return true;
            }

            public boolean hasSeparator() {
                return false;
            }

            public String getName() {
                return MESSAGES.sortBy(MESSAGES.colProjection());
            }
        });
        final UniTimeTableHeader hEnrollment = new UniTimeTableHeader(MESSAGES.colEnrollment());
        header.add(hEnrollment);
        hEnrollment.addOperation(new UniTimeTableHeader.Operation(){

            public void execute() {
                SectioningStatusPage.this.iCourseTable.sort(hEnrollment, new EnrollmentComparator(EnrollmentComparator.SortBy.ENROLLMENT));
            }

            public boolean isApplicable() {
                return true;
            }

            public boolean hasSeparator() {
                return false;
            }

            public String getName() {
                return MESSAGES.sortBy(MESSAGES.colEnrollment());
            }
        });
        final UniTimeTableHeader hWaitListed = new UniTimeTableHeader(MESSAGES.colWaitListed());
        header.add(hWaitListed);
        hWaitListed.addOperation(new UniTimeTableHeader.Operation(){

            public void execute() {
                SectioningStatusPage.this.iCourseTable.sort(hWaitListed, new EnrollmentComparator(EnrollmentComparator.SortBy.WAITLIST));
            }

            public boolean isApplicable() {
                return true;
            }

            public boolean hasSeparator() {
                return false;
            }

            public String getName() {
                return MESSAGES.sortBy(MESSAGES.colWaitListed());
            }
        });
        final UniTimeTableHeader hReserved = new UniTimeTableHeader(MESSAGES.colReserved());
        header.add(hReserved);
        hReserved.addOperation(new UniTimeTableHeader.Operation(){

            public void execute() {
                SectioningStatusPage.this.iCourseTable.sort(hReserved, new EnrollmentComparator(EnrollmentComparator.SortBy.RESERVATION));
            }

            public boolean isApplicable() {
                return true;
            }

            public boolean hasSeparator() {
                return false;
            }

            public String getName() {
                return MESSAGES.sortBy(MESSAGES.colReserved());
            }
        });
        final UniTimeTableHeader hConsent = new UniTimeTableHeader(MESSAGES.colNeedConsent());
        header.add(hConsent);
        hConsent.addOperation(new UniTimeTableHeader.Operation(){

            public void execute() {
                SectioningStatusPage.this.iCourseTable.sort(hConsent, new EnrollmentComparator(EnrollmentComparator.SortBy.NEED_CONSENT));
            }

            public boolean isApplicable() {
                return true;
            }

            public boolean hasSeparator() {
                return false;
            }

            public String getName() {
                return MESSAGES.sortBy(MESSAGES.colNeedConsent().replace("<br>", " "));
            }
        });
        this.iCourseTable.addRow(null, header);
        boolean hasReservation = false;
        for (ClassAssignmentInterface.EnrollmentInfo e : result) {
            this.iCourseTable.addRow(e, this.line(e));
            if (!hasReservation && AvailableCell.hasReservedSpace(e)) {
                hasReservation = true;
            }
            this.iCourseTable.getRowFormatter().getElement(this.iCourseTable.getRowCount() - 1).getStyle().setBackgroundColor("#f3f3f3");
        }
        if (this.iCourseTable.getRowCount() >= 2) {
            for (int c = 0; c < this.iCourseTable.getCellCount(this.iCourseTable.getRowCount() - 1); ++c) {
                this.iCourseTable.getCellFormatter().setStyleName(this.iCourseTable.getRowCount() - 1, c, "unitime-TotalRow");
            }
            this.iCourseTable.getRowFormatter().getElement(this.iCourseTable.getRowCount() - 1).getStyle().clearBackgroundColor();
        }
        this.iCourseTableHint.setVisible(hasReservation);
    }

    public void populateStudentTable(List<ClassAssignmentInterface.StudentInfo> result) {
        UniTimeTableHeader hTimeStamp;
        ArrayList<UniTimeTableHeader> header = new ArrayList<UniTimeTableHeader>();
        if (this.iOnline && this.iProperties != null && this.iProperties.isCanSelectStudent()) {
            UniTimeTableHeader hSelect = new UniTimeTableHeader("&otimes;", HasHorizontalAlignment.ALIGN_CENTER);
            header.add(hSelect);
            hSelect.setWidth("10px");
            hSelect.addAdditionalStyleName("unitime-NoPrint");
            hSelect.addOperation(new UniTimeTableHeader.Operation(){

                public String getName() {
                    return MESSAGES.selectAll();
                }

                public boolean hasSeparator() {
                    return false;
                }

                public boolean isApplicable() {
                    return SectioningStatusPage.this.iSelectedStudentIds.size() != SectioningStatusPage.this.iStudentTable.getRowCount() + 2;
                }

                public void execute() {
                    SectioningStatusPage.this.iSelectedStudentIds.clear();
                    for (int row = 0; row < SectioningStatusPage.this.iStudentTable.getRowCount(); ++row) {
                        ClassAssignmentInterface.StudentInfo i = (ClassAssignmentInterface.StudentInfo)SectioningStatusPage.this.iStudentTable.getData(row);
                        if (i == null || i.getStudent() == null) continue;
                        ((CheckBox)SectioningStatusPage.this.iStudentTable.getWidget(row, 0)).setValue(Boolean.valueOf(true));
                        SectioningStatusPage.this.iSelectedStudentIds.add(i.getStudent().getId());
                    }
                }
            });
            hSelect.addOperation(new UniTimeTableHeader.Operation(){

                public String getName() {
                    return MESSAGES.clearAll();
                }

                public boolean hasSeparator() {
                    return false;
                }

                public boolean isApplicable() {
                    return SectioningStatusPage.this.iSelectedStudentIds.size() > 0;
                }

                public void execute() {
                    SectioningStatusPage.this.iSelectedStudentIds.clear();
                    for (int row = 0; row < SectioningStatusPage.this.iStudentTable.getRowCount(); ++row) {
                        ClassAssignmentInterface.StudentInfo i = (ClassAssignmentInterface.StudentInfo)SectioningStatusPage.this.iStudentTable.getData(row);
                        if (i == null || i.getStudent() == null) continue;
                        ((CheckBox)SectioningStatusPage.this.iStudentTable.getWidget(row, 0)).setValue(Boolean.valueOf(false));
                    }
                }
            });
            hSelect.addOperation(new UniTimeTableHeader.Operation(){

                public String getName() {
                    return MESSAGES.sendStudentEmail();
                }

                public boolean hasSeparator() {
                    return true;
                }

                public boolean isApplicable() {
                    return SectioningStatusPage.this.iSelectedStudentIds.size() > 0 && SectioningStatusPage.this.iProperties != null && SectioningStatusPage.this.iProperties.isEmail();
                }

                public void execute() {
                    SimpleForm sf = new SimpleForm();
                    UniTimeHeaderPanel buttons = new UniTimeHeaderPanel();
                    sf.removeStyleName("unitime-NotPrintableBottomLine");
                    sf.addRow(MESSAGES.emailSubject(), (Widget)SectioningStatusPage.this.iSubject);
                    if (SectioningStatusPage.this.iSubject.getText().isEmpty() || SectioningStatusPage.this.iSubject.getText().equals(MESSAGES.defaulSubjectMassCancel())) {
                        SectioningStatusPage.this.iSubject.setText(MESSAGES.defaulSubject());
                    }
                    sf.addRow(MESSAGES.emailCC(), (Widget)SectioningStatusPage.this.iCC);
                    sf.addRow(MESSAGES.emailBody(), (Widget)SectioningStatusPage.this.iMessage);
                    sf.addBottomRow((Widget)buttons);
                    final UniTimeDialogBox dialog = new UniTimeDialogBox(true, false);
                    dialog.setWidget((Widget)sf);
                    dialog.setText(MESSAGES.sendStudentEmail());
                    dialog.setEscapeToHide(true);
                    buttons.addButton("send", MESSAGES.emailSend(), new ClickHandler(){

                        public void onClick(ClickEvent event) {
                            ArrayList<Long> studentIds = new ArrayList<Long>();
                            for (int row = 0; row < SectioningStatusPage.this.iStudentTable.getRowCount(); ++row) {
                                ClassAssignmentInterface.StudentInfo i = (ClassAssignmentInterface.StudentInfo)SectioningStatusPage.this.iStudentTable.getData(row);
                                if (i == null || i.getStudent() == null || !SectioningStatusPage.this.iSelectedStudentIds.contains(i.getStudent().getId())) continue;
                                studentIds.add(i.getStudent().getId());
                                SectioningStatusPage.this.iStudentTable.setWidget(row, SectioningStatusPage.this.iStudentTable.getCellCount(row) - 1, (Widget)new Image(RESOURCES.loading_small()));
                            }
                            dialog.hide();
                            SectioningStatusPage.this.sendEmail(studentIds.iterator(), SectioningStatusPage.this.iSubject.getText(), SectioningStatusPage.this.iMessage.getText(), SectioningStatusPage.this.iCC.getText(), 0);
                        }
                    });
                    buttons.addButton("close", MESSAGES.buttonClose(), new ClickHandler(){

                        public void onClick(ClickEvent event) {
                            dialog.hide();
                        }
                    });
                    dialog.center();
                }
            });
            hSelect.addOperation(new UniTimeTableHeader.Operation(){

                public String getName() {
                    return MESSAGES.massCancel();
                }

                public boolean hasSeparator() {
                    return false;
                }

                public boolean isApplicable() {
                    return SectioningStatusPage.this.iSelectedStudentIds.size() > 0 && SectioningStatusPage.this.iProperties != null && SectioningStatusPage.this.iProperties.isMassCancel();
                }

                public void execute() {
                    SimpleForm sf = new SimpleForm();
                    UniTimeHeaderPanel buttons = new UniTimeHeaderPanel();
                    sf.removeStyleName("unitime-NotPrintableBottomLine");
                    if (SectioningStatusPage.this.iSubject.getText().isEmpty() || SectioningStatusPage.this.iSubject.getText().equals(MESSAGES.defaulSubject())) {
                        SectioningStatusPage.this.iSubject.setText(MESSAGES.defaulSubjectMassCancel());
                    }
                    sf.addRow(MESSAGES.emailSubject(), (Widget)SectioningStatusPage.this.iSubject);
                    sf.addRow(MESSAGES.emailCC(), (Widget)SectioningStatusPage.this.iCC);
                    sf.addRow(MESSAGES.emailBody(), (Widget)SectioningStatusPage.this.iMessage);
                    sf.addRow(MESSAGES.newStatus(), (Widget)SectioningStatusPage.this.iStatus);
                    sf.addBottomRow((Widget)buttons);
                    final UniTimeDialogBox dialog = new UniTimeDialogBox(true, false);
                    dialog.setWidget((Widget)sf);
                    dialog.setText(MESSAGES.massCancel());
                    dialog.setEscapeToHide(true);
                    buttons.addButton("cancel", MESSAGES.buttonMassCancel(), new ClickHandler(){

                        public void onClick(ClickEvent event) {
                            if (!Window.confirm((String)MESSAGES.massCancelConfirmation())) {
                                dialog.hide();
                                return;
                            }
                            final ArrayList<Long> studentIds = new ArrayList<Long>();
                            for (int row = 0; row < SectioningStatusPage.this.iStudentTable.getRowCount(); ++row) {
                                ClassAssignmentInterface.StudentInfo i = (ClassAssignmentInterface.StudentInfo)SectioningStatusPage.this.iStudentTable.getData(row);
                                if (i == null || i.getStudent() == null || !SectioningStatusPage.this.iSelectedStudentIds.contains(i.getStudent().getId())) continue;
                                studentIds.add(i.getStudent().getId());
                                SectioningStatusPage.this.iStudentTable.setWidget(row, SectioningStatusPage.this.iStudentTable.getCellCount(row) - 1, (Widget)new Image(RESOURCES.loading_small()));
                            }
                            dialog.hide();
                            LoadingWidget.getInstance().show(MESSAGES.massCanceling());
                            SectioningStatusPage.this.iSectioningService.massCancel(studentIds, ((ListBox)SectioningStatusPage.this.iStatus.getWidget()).getValue(((ListBox)SectioningStatusPage.this.iStatus.getWidget()).getSelectedIndex()), SectioningStatusPage.this.iSubject.getText(), SectioningStatusPage.this.iMessage.getText(), SectioningStatusPage.this.iCC.getText(), new AsyncCallback<Boolean>(){

                                public void onFailure(Throwable caught) {
                                    LoadingWidget.getInstance().hide();
                                    UniTimeNotifications.error(caught);
                                    for (int row = 0; row < SectioningStatusPage.this.iStudentTable.getRowCount(); ++row) {
                                        ClassAssignmentInterface.StudentInfo i = (ClassAssignmentInterface.StudentInfo)SectioningStatusPage.this.iStudentTable.getData(row);
                                        if (i == null || i.getStudent() == null || !studentIds.contains(i.getStudent().getId())) continue;
                                        HTML error = new HTML(caught.getMessage());
                                        error.setStyleName("unitime-ErrorMessage");
                                        SectioningStatusPage.this.iStudentTable.setWidget(row, SectioningStatusPage.this.iStudentTable.getCellCount(row) - 1, (Widget)error);
                                        i.setEmailDate(null);
                                    }
                                }

                                public void onSuccess(Boolean result) {
                                    LoadingWidget.getInstance().hide();
                                    SectioningStatusPage.this.loadData();
                                }
                            });
                        }
                    });
                    buttons.addButton("close", MESSAGES.buttonClose(), new ClickHandler(){

                        public void onClick(ClickEvent event) {
                            dialog.hide();
                        }
                    });
                    dialog.center();
                }
            });
            hSelect.addOperation(new UniTimeTableHeader.Operation(){

                public String getName() {
                    return MESSAGES.requestStudentUpdate();
                }

                public boolean hasSeparator() {
                    return true;
                }

                public boolean isApplicable() {
                    return SectioningStatusPage.this.iSelectedStudentIds.size() > 0 && SectioningStatusPage.this.iProperties != null && SectioningStatusPage.this.iProperties.isRequestUpdate();
                }

                public void execute() {
                    ArrayList<Long> studentIds = new ArrayList<Long>(SectioningStatusPage.this.iSelectedStudentIds);
                    LoadingWidget.getInstance().show(MESSAGES.requestingStudentUpdate());
                    SectioningStatusPage.this.iSectioningService.requestStudentUpdate(studentIds, new AsyncCallback<Boolean>(){

                        public void onFailure(Throwable caught) {
                            LoadingWidget.getInstance().hide();
                            UniTimeNotifications.error(caught);
                        }

                        public void onSuccess(Boolean result) {
                            LoadingWidget.getInstance().hide();
                            UniTimeNotifications.info(MESSAGES.requestStudentUpdateSuccess());
                        }
                    });
                }
            });
            if (this.iStates != null) {
                for (final String ref : new TreeSet<String>(this.iStates.keySet())) {
                    hSelect.addOperation(new UniTimeTableHeader.Operation(){

                        public String getName() {
                            return MESSAGES.changeStatusTo((String)SectioningStatusPage.this.iStates.get(ref));
                        }

                        public boolean hasSeparator() {
                            return "".equals(ref);
                        }

                        public boolean isApplicable() {
                            return SectioningStatusPage.this.iSelectedStudentIds.size() > 0 && SectioningStatusPage.this.iProperties != null && SectioningStatusPage.this.iProperties.isChangeStatus();
                        }

                        public void execute() {
                            ArrayList<Long> studentIds = new ArrayList<Long>(SectioningStatusPage.this.iSelectedStudentIds);
                            LoadingWidget.getInstance().show(MESSAGES.changingStatusTo((String)SectioningStatusPage.this.iStates.get(ref)));
                            SectioningStatusPage.this.iSectioningService.changeStatus(studentIds, ref, new AsyncCallback<Boolean>(){

                                public void onFailure(Throwable caught) {
                                    LoadingWidget.getInstance().hide();
                                    UniTimeNotifications.error(caught);
                                }

                                public void onSuccess(Boolean result) {
                                    for (int row = 0; row < SectioningStatusPage.this.iStudentTable.getRowCount(); ++row) {
                                        ClassAssignmentInterface.StudentInfo i = (ClassAssignmentInterface.StudentInfo)SectioningStatusPage.this.iStudentTable.getData(row);
                                        if (i == null || i.getStudent() == null || !((CheckBox)SectioningStatusPage.this.iStudentTable.getWidget(row, 0)).getValue().booleanValue()) continue;
                                        i.setStatus(ref);
                                        ((HTML)SectioningStatusPage.this.iStudentTable.getWidget(row, SectioningStatusPage.this.iStatusColumn)).setHTML(ref);
                                    }
                                    LoadingWidget.getInstance().hide();
                                }
                            });
                        }
                    });
                }
            }
        }
        boolean hasExtId = false;
        for (ClassAssignmentInterface.StudentInfo e : result) {
            if (e.getStudent() == null || !e.getStudent().isCanShowExternalId()) continue;
            hasExtId = true;
            break;
        }
        if (hasExtId) {
            final UniTimeTableHeader hExtId = new UniTimeTableHeader(MESSAGES.colStudentExternalId());
            header.add(hExtId);
            hExtId.addOperation(new UniTimeTableHeader.Operation(){

                public void execute() {
                    SectioningStatusPage.this.iStudentTable.sort(hExtId, new Comparator<ClassAssignmentInterface.StudentInfo>(){

                        @Override
                        public int compare(ClassAssignmentInterface.StudentInfo e1, ClassAssignmentInterface.StudentInfo e2) {
                            if (e1.getStudent() == null) {
                                return 1;
                            }
                            if (e2.getStudent() == null) {
                                return -1;
                            }
                            int cmp = (e1.getStudent().isCanShowExternalId() ? e1.getStudent().getExternalId() : "").compareTo(e2.getStudent().isCanShowExternalId() ? e2.getStudent().getExternalId() : "");
                            if (cmp != 0) {
                                return cmp;
                            }
                            cmp = e1.getStudent().getName().compareTo(e2.getStudent().getName());
                            if (cmp != 0) {
                                return cmp;
                            }
                            return e1.getStudent().getId() < e2.getStudent().getId() ? -1 : 1;
                        }
                    });
                }

                public boolean isApplicable() {
                    return true;
                }

                public boolean hasSeparator() {
                    return false;
                }

                public String getName() {
                    return MESSAGES.sortBy(MESSAGES.colStudentExternalId());
                }
            });
        }
        final UniTimeTableHeader hStudent = new UniTimeTableHeader(MESSAGES.colStudent());
        header.add(hStudent);
        hStudent.addOperation(new UniTimeTableHeader.Operation(){

            public void execute() {
                SectioningStatusPage.this.iStudentTable.sort(hStudent, new Comparator<ClassAssignmentInterface.StudentInfo>(){

                    @Override
                    public int compare(ClassAssignmentInterface.StudentInfo e1, ClassAssignmentInterface.StudentInfo e2) {
                        if (e1.getStudent() == null) {
                            return 1;
                        }
                        if (e2.getStudent() == null) {
                            return -1;
                        }
                        int cmp = e1.getStudent().getName().compareTo(e2.getStudent().getName());
                        if (cmp != 0) {
                            return cmp;
                        }
                        return e1.getStudent().getId() < e2.getStudent().getId() ? -1 : 1;
                    }
                });
            }

            public boolean isApplicable() {
                return true;
            }

            public boolean hasSeparator() {
                return false;
            }

            public String getName() {
                return MESSAGES.sortBy(MESSAGES.colStudent());
            }
        });
        UniTimeTableHeader hTotal = new UniTimeTableHeader("&nbsp;");
        header.add(hTotal);
        boolean hasEnrollment = false;
        boolean hasWaitList = false;
        boolean hasArea = false;
        boolean hasMajor = false;
        boolean hasGroup = false;
        boolean hasAcmd = false;
        boolean hasReservation = false;
        boolean hasRequestedDate = false;
        boolean hasEnrolledDate = false;
        boolean hasConsent = false;
        boolean hasCredit = false;
        for (ClassAssignmentInterface.StudentInfo e : result) {
            if (e.getStudent() == null) continue;
            if (e.getTotalEnrollment() != null && e.getTotalEnrollment() > 0) {
                hasEnrollment = true;
            }
            if (e.getTotalUnassigned() != null && e.getTotalUnassigned() > 0) {
                hasWaitList = true;
            }
            if (e.getStudent().hasArea()) {
                hasArea = true;
            }
            if (e.getStudent().hasMajor()) {
                hasMajor = true;
            }
            if (e.getStudent().hasGroup()) {
                hasGroup = true;
            }
            if (e.getStudent().hasAccommodation()) {
                hasAcmd = true;
            }
            if (e.getTotalReservation() != null && e.getTotalReservation() > 0) {
                hasReservation = true;
            }
            if (e.getRequestedDate() != null) {
                hasRequestedDate = true;
            }
            if (e.getEnrolledDate() != null) {
                hasEnrolledDate = true;
            }
            if (e.getTotalConsentNeeded() != null && e.getTotalConsentNeeded() > 0) {
                hasConsent = true;
            }
            if (!e.hasTotalCredit()) continue;
            hasCredit = true;
        }
        if (hasArea) {
            final UniTimeTableHeader hArea = new UniTimeTableHeader(MESSAGES.colArea());
            header.add(hArea);
            hArea.addOperation(new UniTimeTableHeader.Operation(){

                public void execute() {
                    SectioningStatusPage.this.iStudentTable.sort(hArea, new Comparator<ClassAssignmentInterface.StudentInfo>(){

                        @Override
                        public int compare(ClassAssignmentInterface.StudentInfo e1, ClassAssignmentInterface.StudentInfo e2) {
                            if (e1.getStudent() == null) {
                                return 1;
                            }
                            if (e2.getStudent() == null) {
                                return -1;
                            }
                            int cmp = e1.getStudent().getAreaClasf("|").compareTo(e2.getStudent().getAreaClasf("|"));
                            if (cmp != 0) {
                                return cmp;
                            }
                            cmp = e1.getStudent().getMajor("|").compareTo(e2.getStudent().getMajor("|"));
                            if (cmp != 0) {
                                return cmp;
                            }
                            cmp = e1.getStudent().getName().compareTo(e2.getStudent().getName());
                            if (cmp != 0) {
                                return cmp;
                            }
                            return e1.getStudent().getId() < e2.getStudent().getId() ? -1 : 1;
                        }
                    });
                }

                public boolean isApplicable() {
                    return true;
                }

                public boolean hasSeparator() {
                    return false;
                }

                public String getName() {
                    return MESSAGES.sortBy(MESSAGES.colArea());
                }
            });
            final UniTimeTableHeader hClasf = new UniTimeTableHeader(MESSAGES.colClassification());
            header.add(hClasf);
            hClasf.addOperation(new UniTimeTableHeader.Operation(){

                public void execute() {
                    SectioningStatusPage.this.iStudentTable.sort(hClasf, new Comparator<ClassAssignmentInterface.StudentInfo>(){

                        @Override
                        public int compare(ClassAssignmentInterface.StudentInfo e1, ClassAssignmentInterface.StudentInfo e2) {
                            if (e1.getStudent() == null) {
                                return 1;
                            }
                            if (e2.getStudent() == null) {
                                return -1;
                            }
                            int cmp = e1.getStudent().getClassification("|").compareTo(e2.getStudent().getClassification("|"));
                            if (cmp != 0) {
                                return cmp;
                            }
                            cmp = e1.getStudent().getArea("|").compareTo(e2.getStudent().getArea("|"));
                            if (cmp != 0) {
                                return cmp;
                            }
                            cmp = e1.getStudent().getMajor("|").compareTo(e2.getStudent().getMajor("|"));
                            if (cmp != 0) {
                                return cmp;
                            }
                            cmp = e1.getStudent().getName().compareTo(e2.getStudent().getName());
                            if (cmp != 0) {
                                return cmp;
                            }
                            return e1.getStudent().getId() < e2.getStudent().getId() ? -1 : 1;
                        }
                    });
                }

                public boolean isApplicable() {
                    return true;
                }

                public boolean hasSeparator() {
                    return false;
                }

                public String getName() {
                    return MESSAGES.sortBy(MESSAGES.colClassification());
                }
            });
        }
        if (hasMajor) {
            final UniTimeTableHeader hMajor = new UniTimeTableHeader(MESSAGES.colMajor());
            header.add(hMajor);
            hMajor.addOperation(new UniTimeTableHeader.Operation(){

                public void execute() {
                    SectioningStatusPage.this.iStudentTable.sort(hMajor, new Comparator<ClassAssignmentInterface.StudentInfo>(){

                        @Override
                        public int compare(ClassAssignmentInterface.StudentInfo e1, ClassAssignmentInterface.StudentInfo e2) {
                            if (e1.getStudent() == null) {
                                return 1;
                            }
                            if (e2.getStudent() == null) {
                                return -1;
                            }
                            int cmp = e1.getStudent().getMajor("|").compareTo(e2.getStudent().getMajor("|"));
                            if (cmp != 0) {
                                return cmp;
                            }
                            cmp = e1.getStudent().getAreaClasf("|").compareTo(e2.getStudent().getAreaClasf("|"));
                            if (cmp != 0) {
                                return cmp;
                            }
                            cmp = e1.getStudent().getName().compareTo(e2.getStudent().getName());
                            if (cmp != 0) {
                                return cmp;
                            }
                            return e1.getStudent().getId() < e2.getStudent().getId() ? -1 : 1;
                        }
                    });
                }

                public boolean isApplicable() {
                    return true;
                }

                public boolean hasSeparator() {
                    return false;
                }

                public String getName() {
                    return MESSAGES.sortBy(MESSAGES.colMajor());
                }
            });
        }
        if (hasGroup) {
            final UniTimeTableHeader hGroup = new UniTimeTableHeader(MESSAGES.colGroup());
            header.add(hGroup);
            hGroup.addOperation(new UniTimeTableHeader.Operation(){

                public void execute() {
                    SectioningStatusPage.this.iStudentTable.sort(hGroup, new Comparator<ClassAssignmentInterface.StudentInfo>(){

                        @Override
                        public int compare(ClassAssignmentInterface.StudentInfo e1, ClassAssignmentInterface.StudentInfo e2) {
                            if (e1.getStudent() == null) {
                                return 1;
                            }
                            if (e2.getStudent() == null) {
                                return -1;
                            }
                            int cmp = e1.getStudent().getGroup("|").compareTo(e2.getStudent().getGroup("|"));
                            if (cmp != 0) {
                                return cmp;
                            }
                            cmp = e1.getStudent().getAreaClasf("|").compareTo(e2.getStudent().getAreaClasf("|"));
                            if (cmp != 0) {
                                return cmp;
                            }
                            cmp = e1.getStudent().getName().compareTo(e2.getStudent().getName());
                            if (cmp != 0) {
                                return cmp;
                            }
                            return e1.getStudent().getId() < e2.getStudent().getId() ? -1 : 1;
                        }
                    });
                }

                public boolean isApplicable() {
                    return true;
                }

                public boolean hasSeparator() {
                    return false;
                }

                public String getName() {
                    return MESSAGES.sortBy(MESSAGES.colGroup());
                }
            });
        }
        if (hasAcmd) {
            final UniTimeTableHeader hAcmd = new UniTimeTableHeader(MESSAGES.colAccommodation());
            header.add(hAcmd);
            hAcmd.addOperation(new UniTimeTableHeader.Operation(){

                public void execute() {
                    SectioningStatusPage.this.iStudentTable.sort(hAcmd, new Comparator<ClassAssignmentInterface.StudentInfo>(){

                        @Override
                        public int compare(ClassAssignmentInterface.StudentInfo e1, ClassAssignmentInterface.StudentInfo e2) {
                            if (e1.getStudent() == null) {
                                return 1;
                            }
                            if (e2.getStudent() == null) {
                                return -1;
                            }
                            int cmp = e1.getStudent().getAccommodation("|").compareTo(e2.getStudent().getAccommodation("|"));
                            if (cmp != 0) {
                                return cmp;
                            }
                            cmp = e1.getStudent().getAreaClasf("|").compareTo(e2.getStudent().getAreaClasf("|"));
                            if (cmp != 0) {
                                return cmp;
                            }
                            cmp = e1.getStudent().getName().compareTo(e2.getStudent().getName());
                            if (cmp != 0) {
                                return cmp;
                            }
                            return e1.getStudent().getId() < e2.getStudent().getId() ? -1 : 1;
                        }
                    });
                }

                public boolean isApplicable() {
                    return true;
                }

                public boolean hasSeparator() {
                    return false;
                }

                public String getName() {
                    return MESSAGES.sortBy(MESSAGES.colAccommodation());
                }
            });
        }
        this.iStatusColumn = header.size() - 1;
        final UniTimeTableHeader hStatus = new UniTimeTableHeader(MESSAGES.colStatus());
        header.add(hStatus);
        hStatus.addOperation(new UniTimeTableHeader.Operation(){

            public void execute() {
                SectioningStatusPage.this.iStudentTable.sort(hStatus, new Comparator<ClassAssignmentInterface.StudentInfo>(){

                    @Override
                    public int compare(ClassAssignmentInterface.StudentInfo e1, ClassAssignmentInterface.StudentInfo e2) {
                        if (e1.getStudent() == null) {
                            return 1;
                        }
                        if (e2.getStudent() == null) {
                            return -1;
                        }
                        int cmp = (e1.getStatus() == null ? "" : e1.getStatus()).compareToIgnoreCase(e2.getStatus() == null ? "" : e2.getStatus());
                        if (cmp != 0) {
                            return cmp;
                        }
                        cmp = e1.getStudent().getName().compareTo(e2.getStudent().getName());
                        if (cmp != 0) {
                            return cmp;
                        }
                        return e1.getStudent().getId() < e2.getStudent().getId() ? -1 : 1;
                    }
                });
            }

            public boolean isApplicable() {
                return true;
            }

            public boolean hasSeparator() {
                return false;
            }

            public String getName() {
                return MESSAGES.sortBy(MESSAGES.colStatus());
            }
        });
        if (hasEnrollment) {
            final UniTimeTableHeader hEnrollment = new UniTimeTableHeader(MESSAGES.colEnrollment());
            header.add(hEnrollment);
            hEnrollment.addOperation(new UniTimeTableHeader.Operation(){

                public void execute() {
                    SectioningStatusPage.this.iStudentTable.sort(hEnrollment, new Comparator<ClassAssignmentInterface.StudentInfo>(){

                        @Override
                        public int compare(ClassAssignmentInterface.StudentInfo e1, ClassAssignmentInterface.StudentInfo e2) {
                            if (e1.getStudent() == null) {
                                return 1;
                            }
                            if (e2.getStudent() == null) {
                                return -1;
                            }
                            int cmp = (e1.getEnrollment() == null ? new Integer(0) : e1.getEnrollment()).compareTo(e2.getEnrollment() == null ? 0 : e2.getEnrollment());
                            if (cmp != 0) {
                                return -cmp;
                            }
                            cmp = (e1.getTotalEnrollment() == null ? new Integer(0) : e1.getTotalEnrollment()).compareTo(e2.getTotalEnrollment() == null ? 0 : e2.getTotalEnrollment());
                            if (cmp != 0) {
                                return -cmp;
                            }
                            cmp = e1.getStudent().getName().compareTo(e2.getStudent().getName());
                            if (cmp != 0) {
                                return cmp;
                            }
                            return e1.getStudent().getId() < e2.getStudent().getId() ? -1 : 1;
                        }
                    });
                }

                public boolean isApplicable() {
                    return true;
                }

                public boolean hasSeparator() {
                    return false;
                }

                public String getName() {
                    return MESSAGES.sortBy(MESSAGES.colEnrollment());
                }
            });
        }
        if (hasWaitList) {
            final UniTimeTableHeader hWaitlist = new UniTimeTableHeader(MESSAGES.colWaitListed());
            header.add(hWaitlist);
            hWaitlist.addOperation(new UniTimeTableHeader.Operation(){

                public void execute() {
                    SectioningStatusPage.this.iStudentTable.sort(hWaitlist, new Comparator<ClassAssignmentInterface.StudentInfo>(){

                        @Override
                        public int compare(ClassAssignmentInterface.StudentInfo e1, ClassAssignmentInterface.StudentInfo e2) {
                            if (e1.getStudent() == null) {
                                return 1;
                            }
                            if (e2.getStudent() == null) {
                                return -1;
                            }
                            int cmp = (e1.getUnassigned() == null ? new Integer(0) : e1.getUnassigned()).compareTo(e2.getUnassigned() == null ? 0 : e2.getUnassigned());
                            if (cmp != 0) {
                                return -cmp;
                            }
                            cmp = (e1.getWaitlist() == null ? new Integer(0) : e1.getWaitlist()).compareTo(e2.getWaitlist() == null ? 0 : e2.getWaitlist());
                            if (cmp != 0) {
                                return -cmp;
                            }
                            cmp = (e1.getTotalUnassigned() == null ? new Integer(0) : e1.getTotalUnassigned()).compareTo(e2.getTotalUnassigned() == null ? 0 : e2.getTotalUnassigned());
                            if (cmp != 0) {
                                return -cmp;
                            }
                            cmp = (e1.getTotalWaitlist() == null ? new Integer(0) : e1.getTotalWaitlist()).compareTo(e2.getTotalWaitlist() == null ? 0 : e2.getTotalWaitlist());
                            if (cmp != 0) {
                                return -cmp;
                            }
                            cmp = (e1.getTopWaitingPriority() == null ? new Integer(Integer.MAX_VALUE) : e1.getTopWaitingPriority()).compareTo(e2.getTopWaitingPriority() == null ? Integer.MAX_VALUE : e2.getTopWaitingPriority());
                            if (cmp != 0) {
                                return cmp;
                            }
                            cmp = e1.getStudent().getName().compareTo(e2.getStudent().getName());
                            if (cmp != 0) {
                                return cmp;
                            }
                            return e1.getStudent().getId() < e2.getStudent().getId() ? -1 : 1;
                        }
                    });
                }

                public boolean isApplicable() {
                    return true;
                }

                public boolean hasSeparator() {
                    return false;
                }

                public String getName() {
                    return MESSAGES.sortBy(MESSAGES.colWaitListed());
                }
            });
        }
        if (hasReservation) {
            final UniTimeTableHeader hReservation = new UniTimeTableHeader(MESSAGES.colReservation());
            header.add(hReservation);
            hReservation.addOperation(new UniTimeTableHeader.Operation(){

                public void execute() {
                    SectioningStatusPage.this.iStudentTable.sort(hReservation, new Comparator<ClassAssignmentInterface.StudentInfo>(){

                        @Override
                        public int compare(ClassAssignmentInterface.StudentInfo e1, ClassAssignmentInterface.StudentInfo e2) {
                            if (e1.getStudent() == null) {
                                return 1;
                            }
                            if (e2.getStudent() == null) {
                                return -1;
                            }
                            int cmp = (e1.getReservation() == null ? new Integer(0) : e1.getReservation()).compareTo(e2.getReservation() == null ? 0 : e2.getReservation());
                            if (cmp != 0) {
                                return -cmp;
                            }
                            cmp = (e1.getTotalReservation() == null ? new Integer(0) : e1.getTotalReservation()).compareTo(e2.getTotalReservation() == null ? 0 : e2.getTotalReservation());
                            if (cmp != 0) {
                                return -cmp;
                            }
                            cmp = e1.getStudent().getName().compareTo(e2.getStudent().getName());
                            if (cmp != 0) {
                                return cmp;
                            }
                            return e1.getStudent().getId() < e2.getStudent().getId() ? -1 : 1;
                        }
                    });
                }

                public boolean isApplicable() {
                    return true;
                }

                public boolean hasSeparator() {
                    return false;
                }

                public String getName() {
                    return MESSAGES.sortBy(MESSAGES.colReservation());
                }
            });
        }
        if (hasConsent) {
            final UniTimeTableHeader hConsent = new UniTimeTableHeader(MESSAGES.colConsent());
            header.add(hConsent);
            hConsent.addOperation(new UniTimeTableHeader.Operation(){

                public void execute() {
                    SectioningStatusPage.this.iStudentTable.sort(hConsent, new Comparator<ClassAssignmentInterface.StudentInfo>(){

                        @Override
                        public int compare(ClassAssignmentInterface.StudentInfo e1, ClassAssignmentInterface.StudentInfo e2) {
                            if (e1.getStudent() == null) {
                                return 1;
                            }
                            if (e2.getStudent() == null) {
                                return -1;
                            }
                            int cmp = (e1.getConsentNeeded() == null ? new Integer(0) : e1.getConsentNeeded()).compareTo(e2.getConsentNeeded() == null ? 0 : e2.getConsentNeeded());
                            if (cmp != 0) {
                                return -cmp;
                            }
                            cmp = (e1.getTotalConsentNeeded() == null ? new Integer(0) : e1.getTotalConsentNeeded()).compareTo(e2.getTotalConsentNeeded() == null ? 0 : e2.getTotalConsentNeeded());
                            if (cmp != 0) {
                                return -cmp;
                            }
                            cmp = e1.getStudent().getName().compareTo(e2.getStudent().getName());
                            if (cmp != 0) {
                                return cmp;
                            }
                            return e1.getStudent().getId() < e2.getStudent().getId() ? -1 : 1;
                        }
                    });
                }

                public boolean isApplicable() {
                    return true;
                }

                public boolean hasSeparator() {
                    return false;
                }

                public String getName() {
                    return MESSAGES.sortBy(MESSAGES.colConsent());
                }
            });
        }
        if (hasCredit) {
            final UniTimeTableHeader hCredit = new UniTimeTableHeader(MESSAGES.colCredit());
            header.add(hCredit);
            hCredit.addOperation(new UniTimeTableHeader.Operation(){

                public void execute() {
                    SectioningStatusPage.this.iStudentTable.sort(hCredit, new Comparator<ClassAssignmentInterface.StudentInfo>(){

                        @Override
                        public int compare(ClassAssignmentInterface.StudentInfo e1, ClassAssignmentInterface.StudentInfo e2) {
                            if (e1.getStudent() == null) {
                                return 1;
                            }
                            if (e2.getStudent() == null) {
                                return -1;
                            }
                            int cmp = (e1.hasCredit() ? e1.getCredit() : new Float(0.0f)).compareTo(e2.hasCredit() ? e2.getCredit() : new Float(0.0f));
                            if (cmp != 0) {
                                return -cmp;
                            }
                            cmp = (e1.hasTotalCredit() ? e1.getTotalCredit() : new Float(0.0f)).compareTo(e2.hasTotalCredit() ? e2.getTotalCredit() : new Float(0.0f));
                            if (cmp != 0) {
                                return -cmp;
                            }
                            cmp = e1.getStudent().getName().compareTo(e2.getStudent().getName());
                            if (cmp != 0) {
                                return cmp;
                            }
                            return e1.getStudent().getId() < e2.getStudent().getId() ? -1 : 1;
                        }
                    });
                }

                public boolean isApplicable() {
                    return true;
                }

                public boolean hasSeparator() {
                    return false;
                }

                public String getName() {
                    return MESSAGES.sortBy(MESSAGES.colCredit());
                }
            });
        }
        if (hasRequestedDate) {
            hTimeStamp = new UniTimeTableHeader(MESSAGES.colRequestTimeStamp());
            hTimeStamp.addOperation(new UniTimeTableHeader.Operation(){

                public void execute() {
                    SectioningStatusPage.this.iStudentTable.sort(hTimeStamp, new Comparator<ClassAssignmentInterface.StudentInfo>(){

                        @Override
                        public int compare(ClassAssignmentInterface.StudentInfo e1, ClassAssignmentInterface.StudentInfo e2) {
                            if (e1.getStudent() == null) {
                                return 1;
                            }
                            if (e2.getStudent() == null) {
                                return -1;
                            }
                            int cmp = (e1.getRequestedDate() == null ? new Date(0L) : e1.getRequestedDate()).compareTo(e2.getRequestedDate() == null ? new Date(0L) : e2.getRequestedDate());
                            if (cmp != 0) {
                                return cmp;
                            }
                            cmp = e1.getStudent().getName().compareTo(e2.getStudent().getName());
                            if (cmp != 0) {
                                return cmp;
                            }
                            return e1.getStudent().getId() < e2.getStudent().getId() ? -1 : 1;
                        }
                    });
                }

                public boolean isApplicable() {
                    return true;
                }

                public boolean hasSeparator() {
                    return false;
                }

                public String getName() {
                    return MESSAGES.sortBy(MESSAGES.colRequestTimeStamp());
                }
            });
            header.add(hTimeStamp);
        }
        if (hasEnrolledDate) {
            hTimeStamp = new UniTimeTableHeader(MESSAGES.colEnrollmentTimeStamp());
            hTimeStamp.addOperation(new UniTimeTableHeader.Operation(){

                public void execute() {
                    SectioningStatusPage.this.iStudentTable.sort(hTimeStamp, new Comparator<ClassAssignmentInterface.StudentInfo>(){

                        @Override
                        public int compare(ClassAssignmentInterface.StudentInfo e1, ClassAssignmentInterface.StudentInfo e2) {
                            if (e1.getStudent() == null) {
                                return 1;
                            }
                            if (e2.getStudent() == null) {
                                return -1;
                            }
                            int cmp = (e1.getEnrolledDate() == null ? new Date(0L) : e1.getEnrolledDate()).compareTo(e2.getEnrolledDate() == null ? new Date(0L) : e2.getEnrolledDate());
                            if (cmp != 0) {
                                return cmp;
                            }
                            cmp = e1.getStudent().getName().compareTo(e2.getStudent().getName());
                            if (cmp != 0) {
                                return cmp;
                            }
                            return e1.getStudent().getId() < e2.getStudent().getId() ? -1 : 1;
                        }
                    });
                }

                public boolean isApplicable() {
                    return true;
                }

                public boolean hasSeparator() {
                    return false;
                }

                public String getName() {
                    return MESSAGES.sortBy(MESSAGES.colEnrollmentTimeStamp());
                }
            });
            header.add(hTimeStamp);
        }
        if (this.iOnline) {
            hTimeStamp = new UniTimeTableHeader(MESSAGES.colEmailTimeStamp());
            hTimeStamp.addOperation(new UniTimeTableHeader.Operation(){

                public void execute() {
                    SectioningStatusPage.this.iStudentTable.sort(hTimeStamp, new Comparator<ClassAssignmentInterface.StudentInfo>(){

                        @Override
                        public int compare(ClassAssignmentInterface.StudentInfo e1, ClassAssignmentInterface.StudentInfo e2) {
                            if (e1.getStudent() == null) {
                                return 1;
                            }
                            if (e2.getStudent() == null) {
                                return -1;
                            }
                            int cmp = (e1.getEmailDate() == null ? new Date(0L) : e1.getEmailDate()).compareTo(e2.getEmailDate() == null ? new Date(0L) : e2.getEmailDate());
                            if (cmp != 0) {
                                return cmp;
                            }
                            cmp = e1.getStudent().getName().compareTo(e2.getStudent().getName());
                            if (cmp != 0) {
                                return cmp;
                            }
                            return e1.getStudent().getId() < e2.getStudent().getId() ? -1 : 1;
                        }
                    });
                }

                public boolean isApplicable() {
                    return true;
                }

                public boolean hasSeparator() {
                    return false;
                }

                public String getName() {
                    return MESSAGES.sortBy(MESSAGES.colEmailTimeStamp());
                }
            });
            header.add(hTimeStamp);
        }
        this.iStudentTable.addRow(null, header);
        HashSet<Long> newlySelected = new HashSet<Long>();
        for (ClassAssignmentInterface.StudentInfo info : result) {
            ArrayList<Object> line = new ArrayList<Object>();
            if (info.getStudent() != null) {
                if (this.iOnline && this.iProperties != null && this.iProperties.isCanSelectStudent()) {
                    CheckBox ch = new CheckBox();
                    ch.addClickHandler(new ClickHandler(){

                        public void onClick(ClickEvent event) {
                            event.stopPropagation();
                        }
                    });
                    final Long sid = info.getStudent().getId();
                    if (this.iSelectedStudentIds.contains(sid)) {
                        ch.setValue(Boolean.valueOf(true));
                        newlySelected.add(sid);
                    }
                    ch.addClickHandler(new ClickHandler(){

                        public void onClick(ClickEvent event) {
                            event.stopPropagation();
                        }
                    });
                    ch.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

                        public void onValueChange(ValueChangeEvent<Boolean> event) {
                            if (((Boolean)event.getValue()).booleanValue()) {
                                SectioningStatusPage.this.iSelectedStudentIds.add(sid);
                            } else {
                                SectioningStatusPage.this.iSelectedStudentIds.remove(sid);
                            }
                        }
                    });
                    line.add(ch);
                }
                if (hasExtId) {
                    line.add(new Label(info.getStudent().isCanShowExternalId() ? info.getStudent().getExternalId() : "", false));
                }
                line.add(new TitleCell(info.getStudent().getName()));
                if (hasArea) {
                    line.add(new HTML(info.getStudent().getArea("<br>"), false));
                    line.add(new HTML(info.getStudent().getClassification("<br>"), false));
                }
                if (hasMajor) {
                    line.add(new HTML(info.getStudent().getMajor("<br>"), false));
                }
                if (hasGroup) {
                    line.add(new HTML(info.getStudent().getGroup("<br>"), false));
                }
                if (hasAcmd) {
                    line.add(new HTML(info.getStudent().getAccommodation("<br>"), false));
                }
                line.add(new HTML(info.getStatus(), false));
            } else {
                if (this.iOnline && this.iProperties != null && this.iProperties.isCanSelectStudent()) {
                    line.add(new HTML("&nbsp;", false));
                }
                if (hasExtId) {
                    line.add(new TitleCell(MESSAGES.total()));
                } else {
                    line.add(new Label(MESSAGES.total()));
                }
                line.add(new NumberCell(null, result.size() - 1));
                if (hasArea) {
                    line.add(new HTML("&nbsp;", false));
                    line.add(new HTML("&nbsp;", false));
                }
                if (hasMajor) {
                    line.add(new HTML("&nbsp;", false));
                }
                if (hasGroup) {
                    line.add(new HTML("&nbsp;", false));
                }
                if (hasAcmd) {
                    line.add(new HTML("&nbsp;", false));
                }
                line.add(new HTML("&nbsp;", false));
            }
            if (hasEnrollment) {
                line.add(new NumberCell(info.getEnrollment(), info.getTotalEnrollment()));
            }
            if (hasWaitList) {
                line.add(new WaitListCell(info));
            }
            if (hasReservation) {
                line.add(new NumberCell(info.getReservation(), info.getTotalReservation()));
            }
            if (hasConsent) {
                line.add(new NumberCell(info.getConsentNeeded(), info.getTotalConsentNeeded()));
            }
            if (hasCredit) {
                line.add(new CreditCell(info.getCredit(), info.getTotalCredit()));
            }
            if (info.getStudent() != null) {
                if (hasRequestedDate) {
                    line.add(new HTML(info.getRequestedDate() == null ? "&nbsp;" : sDF.format(info.getRequestedDate()), false));
                }
                if (hasEnrolledDate) {
                    line.add(new HTML(info.getEnrolledDate() == null ? "&nbsp;" : sDF.format(info.getEnrolledDate()), false));
                }
                if (this.iOnline) {
                    line.add(new HTML(info.getEmailDate() == null ? "&nbsp;" : sDF.format(info.getEmailDate()), false));
                }
            } else {
                if (hasRequestedDate) {
                    line.add(new HTML("&nbsp;", false));
                }
                if (hasEnrolledDate) {
                    line.add(new HTML("&nbsp;", false));
                }
                if (this.iOnline) {
                    line.add(new HTML("&nbsp;", false));
                }
            }
            this.iStudentTable.addRow(info, line);
        }
        this.iSelectedStudentIds.clear();
        this.iSelectedStudentIds.addAll(newlySelected);
        if (this.iStudentTable.getRowCount() >= 2) {
            for (int c = 0; c < this.iStudentTable.getCellCount(this.iStudentTable.getRowCount() - 1); ++c) {
                this.iStudentTable.getCellFormatter().setStyleName(this.iStudentTable.getRowCount() - 1, c, "unitime-TotalRow");
            }
        }
        this.iStudentTableHint.setVisible(hasWaitList);
    }

    public void populateChangeLog(List<ClassAssignmentInterface.SectioningAction> result) {
        ArrayList<UniTimeTableHeader> header = new ArrayList<UniTimeTableHeader>();
        final UniTimeTableHeader hStudent = new UniTimeTableHeader(MESSAGES.colStudent());
        header.add(hStudent);
        hStudent.addOperation(new UniTimeTableHeader.Operation(){

            public void execute() {
                SectioningStatusPage.this.iLogTable.sort(hStudent, new Comparator<ClassAssignmentInterface.SectioningAction>(){

                    @Override
                    public int compare(ClassAssignmentInterface.SectioningAction e1, ClassAssignmentInterface.SectioningAction e2) {
                        int cmp = e1.getStudent().getName().compareTo(e2.getStudent().getName());
                        if (cmp != 0) {
                            return cmp;
                        }
                        return -e1.getTimeStamp().compareTo(e2.getTimeStamp());
                    }
                });
            }

            public boolean isApplicable() {
                return true;
            }

            public boolean hasSeparator() {
                return false;
            }

            public String getName() {
                return MESSAGES.sortBy(MESSAGES.colStudent());
            }
        });
        final UniTimeTableHeader hOp = new UniTimeTableHeader(MESSAGES.colOperation());
        header.add(hOp);
        hOp.addOperation(new UniTimeTableHeader.Operation(){

            public void execute() {
                SectioningStatusPage.this.iLogTable.sort(hOp, new Comparator<ClassAssignmentInterface.SectioningAction>(){

                    @Override
                    public int compare(ClassAssignmentInterface.SectioningAction e1, ClassAssignmentInterface.SectioningAction e2) {
                        int cmp = e1.getOperation().compareTo(e2.getOperation());
                        if (cmp != 0) {
                            return cmp;
                        }
                        return -e1.getTimeStamp().compareTo(e2.getTimeStamp());
                    }
                });
            }

            public boolean isApplicable() {
                return true;
            }

            public boolean hasSeparator() {
                return false;
            }

            public String getName() {
                return MESSAGES.sortBy(MESSAGES.colOperation());
            }
        });
        final UniTimeTableHeader hTimeStamp = new UniTimeTableHeader(MESSAGES.colTimeStamp());
        header.add(hTimeStamp);
        hTimeStamp.addOperation(new UniTimeTableHeader.Operation(){

            public void execute() {
                SectioningStatusPage.this.iLogTable.sort(hTimeStamp, new Comparator<ClassAssignmentInterface.SectioningAction>(){

                    @Override
                    public int compare(ClassAssignmentInterface.SectioningAction e1, ClassAssignmentInterface.SectioningAction e2) {
                        return -e1.getTimeStamp().compareTo(e2.getTimeStamp());
                    }
                });
            }

            public boolean isApplicable() {
                return true;
            }

            public boolean hasSeparator() {
                return false;
            }

            public String getName() {
                return MESSAGES.sortBy(MESSAGES.colTimeStamp());
            }
        });
        final UniTimeTableHeader hResult = new UniTimeTableHeader(MESSAGES.colResult());
        header.add(hResult);
        hResult.addOperation(new UniTimeTableHeader.Operation(){

            public void execute() {
                SectioningStatusPage.this.iLogTable.sort(hResult, new Comparator<ClassAssignmentInterface.SectioningAction>(){

                    @Override
                    public int compare(ClassAssignmentInterface.SectioningAction e1, ClassAssignmentInterface.SectioningAction e2) {
                        int cmp = (e1.getResult() == null ? "" : e1.getResult()).compareTo(e2.getResult() == null ? "" : e2.getResult());
                        if (cmp != 0) {
                            return cmp;
                        }
                        return -e1.getTimeStamp().compareTo(e2.getTimeStamp());
                    }
                });
            }

            public boolean isApplicable() {
                return true;
            }

            public boolean hasSeparator() {
                return false;
            }

            public String getName() {
                return MESSAGES.sortBy(MESSAGES.colResult());
            }
        });
        final UniTimeTableHeader hUser = new UniTimeTableHeader(MESSAGES.colUser());
        header.add(hUser);
        hUser.addOperation(new UniTimeTableHeader.Operation(){

            public void execute() {
                SectioningStatusPage.this.iLogTable.sort(hUser, new Comparator<ClassAssignmentInterface.SectioningAction>(){

                    @Override
                    public int compare(ClassAssignmentInterface.SectioningAction e1, ClassAssignmentInterface.SectioningAction e2) {
                        int cmp = (e1.getUser() == null ? "" : e1.getUser()).compareTo(e2.getUser() == null ? "" : e2.getUser());
                        if (cmp != 0) {
                            return cmp;
                        }
                        return -e1.getTimeStamp().compareTo(e2.getTimeStamp());
                    }
                });
            }

            public boolean isApplicable() {
                return true;
            }

            public boolean hasSeparator() {
                return false;
            }

            public String getName() {
                return MESSAGES.sortBy(MESSAGES.colUser());
            }
        });
        final UniTimeTableHeader hMessage = new UniTimeTableHeader(MESSAGES.colMessage());
        header.add(hMessage);
        hMessage.addOperation(new UniTimeTableHeader.Operation(){

            public void execute() {
                SectioningStatusPage.this.iLogTable.sort(hMessage, new Comparator<ClassAssignmentInterface.SectioningAction>(){

                    @Override
                    public int compare(ClassAssignmentInterface.SectioningAction e1, ClassAssignmentInterface.SectioningAction e2) {
                        int cmp = (e1.getMessage() == null ? "" : e1.getMessage()).compareTo(e2.getMessage() == null ? "" : e2.getMessage());
                        if (cmp != 0) {
                            return cmp;
                        }
                        return -e1.getTimeStamp().compareTo(e2.getTimeStamp());
                    }
                });
            }

            public boolean isApplicable() {
                return true;
            }

            public boolean hasSeparator() {
                return false;
            }

            public String getName() {
                return MESSAGES.sortBy(MESSAGES.colMessage());
            }
        });
        this.iLogTable.addRow(null, header);
        for (ClassAssignmentInterface.SectioningAction log : result) {
            this.iLogTable.addRow(log, new Widget[]{new EnrollmentTable.TopCell(log.getStudent().getName()), new EnrollmentTable.TopCell(log.getOperation()), new EnrollmentTable.TopCell(sTSF.format(log.getTimeStamp())), new EnrollmentTable.TopCell(log.getResult()), new EnrollmentTable.TopCell(log.getUser() == null ? "" : log.getUser()), new HTML(log.getMessage() == null ? "" : log.getMessage())});
        }
    }

    private void sendEmail(final Iterator<Long> studentIds, final String subject, final String message, final String cc, final int fails) {
        if (!studentIds.hasNext()) {
            return;
        }
        final Long studentId = studentIds.next();
        this.iSectioningService.sendEmail(studentId, subject, message, cc, new AsyncCallback<Boolean>(){

            public void onFailure(Throwable caught) {
                for (int row = 0; row < SectioningStatusPage.this.iStudentTable.getRowCount(); ++row) {
                    ClassAssignmentInterface.StudentInfo i = (ClassAssignmentInterface.StudentInfo)SectioningStatusPage.this.iStudentTable.getData(row);
                    if (i == null || i.getStudent() == null || !studentId.equals(i.getStudent().getId())) continue;
                    HTML error = new HTML(caught.getMessage());
                    error.setStyleName("unitime-ErrorMessage");
                    SectioningStatusPage.this.iStudentTable.setWidget(row, SectioningStatusPage.this.iStudentTable.getCellCount(row) - 1, (Widget)error);
                    i.setEmailDate(null);
                }
                if (fails >= 4) {
                    while (studentIds.hasNext()) {
                        Long sid = (Long)studentIds.next();
                        for (int row = 0; row < SectioningStatusPage.this.iStudentTable.getRowCount(); ++row) {
                            ClassAssignmentInterface.StudentInfo i = (ClassAssignmentInterface.StudentInfo)SectioningStatusPage.this.iStudentTable.getData(row);
                            if (i == null || i.getStudent() == null || !sid.equals(i.getStudent().getId())) continue;
                            HTML error = new HTML(MESSAGES.exceptionCancelled(caught.getMessage()));
                            error.setStyleName("unitime-ErrorMessage");
                            SectioningStatusPage.this.iStudentTable.setWidget(row, SectioningStatusPage.this.iStudentTable.getCellCount(row) - 1, (Widget)error);
                            i.setEmailDate(null);
                        }
                    }
                }
                SectioningStatusPage.this.sendEmail(studentIds, subject, message, cc, fails + 1);
            }

            public void onSuccess(Boolean result) {
                for (int row = 0; row < SectioningStatusPage.this.iStudentTable.getRowCount(); ++row) {
                    ClassAssignmentInterface.StudentInfo i = (ClassAssignmentInterface.StudentInfo)SectioningStatusPage.this.iStudentTable.getData(row);
                    if (i != null && i.getStudent() != null && studentId.equals(i.getStudent().getId())) {
                        if (result.booleanValue()) {
                            i.setEmailDate(new Date());
                            SectioningStatusPage.this.iStudentTable.setWidget(row, SectioningStatusPage.this.iStudentTable.getCellCount(row) - 1, (Widget)new HTML(sDF.format(i.getEmailDate()), false));
                        } else {
                            HTML error = new HTML(MESSAGES.exceptionNoEmail());
                            error.setStyleName("unitime-ErrorMessage");
                            SectioningStatusPage.this.iStudentTable.setWidget(row, SectioningStatusPage.this.iStudentTable.getCellCount(row) - 1, (Widget)error);
                            i.setEmailDate(null);
                        }
                    }
                    SectioningStatusPage.this.sendEmail(studentIds, subject, message, cc, fails);
                }
            }
        });
    }

    public static class CreditCell
    extends HTML
    implements UniTimeTable.HasCellAlignment {
        private static NumberFormat df = NumberFormat.getFormat((String)"0.#");

        public CreditCell(Float value, Float total) {
            if (total != null && total.floatValue() > 0.0f) {
                if (total.equals(value)) {
                    this.setHTML(df.format((Number)total));
                } else {
                    this.setHTML(df.format((Number)value) + " / " + df.format((Number)total));
                }
            } else {
                this.setHTML("&nbsp;");
            }
        }

        public HasHorizontalAlignment.HorizontalAlignmentConstant getCellAlignment() {
            return HasHorizontalAlignment.ALIGN_RIGHT;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EnrollmentComparator
    implements Comparator<ClassAssignmentInterface.EnrollmentInfo> {
        private SortBy iSortBy;

        public EnrollmentComparator(SortBy sortBy) {
            this.iSortBy = sortBy;
        }

        @Override
        public int compare(ClassAssignmentInterface.EnrollmentInfo e1, ClassAssignmentInterface.EnrollmentInfo e2) {
            if (e1.getCourseId() == null) {
                return 1;
            }
            if (e2.getCourseId() == null) {
                return -1;
            }
            if (e1.getCourseId().equals(e2.getCourseId())) {
                if (e1.getConfigId() == null) {
                    return -1;
                }
                if (e2.getConfigId() == null) {
                    return -1;
                }
                return this.compareClasses(e1, e2);
            }
            return this.compareCourses(e1, e2);
        }

        private int compareClasses(ClassAssignmentInterface.EnrollmentInfo e1, ClassAssignmentInterface.EnrollmentInfo e2) {
            return 0;
        }

        private int compareCourses(ClassAssignmentInterface.EnrollmentInfo e1, ClassAssignmentInterface.EnrollmentInfo e2) {
            int cmp;
            switch (this.iSortBy) {
                case SUBJECT: {
                    break;
                }
                case COURSE: {
                    cmp = e1.getCourseNbr().compareTo(e2.getCourseNbr());
                    if (cmp == 0) break;
                    return cmp;
                }
                case TITLE: {
                    cmp = (e1.getTitle() == null ? "" : e1.getTitle()).compareTo(e2.getTitle() == null ? "" : e2.getTitle());
                    if (cmp == 0) break;
                    return cmp;
                }
                case CONSENT: {
                    cmp = (e1.getConsent() == null ? "" : e1.getConsent()).compareTo(e2.getConsent() == null ? "" : e2.getConsent());
                    if (cmp == 0) break;
                    return cmp;
                }
                case LIMIT: {
                    cmp = (e1.getAvailable() == null ? new Integer(0) : (e1.getAvailable() < 0 ? new Integer(Integer.MAX_VALUE) : e1.getAvailable())).compareTo(e2.getAvailable() == null ? 0 : (e2.getAvailable() < 0 ? Integer.MAX_VALUE : e2.getAvailable()));
                    if (cmp != 0) {
                        return cmp;
                    }
                    cmp = (e1.getLimit() == null ? new Integer(0) : e1.getLimit()).compareTo(e2.getLimit() == null ? 0 : e2.getLimit());
                    if (cmp == 0) break;
                    return cmp;
                }
                case PROJECTION: {
                    cmp = (e1.getProjection() == null ? new Integer(0) : e1.getProjection()).compareTo(e2.getProjection() == null ? 0 : e2.getProjection());
                    if (cmp == 0) break;
                    return -cmp;
                }
                case ENROLLMENT: {
                    cmp = (e1.getEnrollment() == null ? new Integer(0) : e1.getEnrollment()).compareTo(e2.getEnrollment() == null ? 0 : e2.getEnrollment());
                    if (cmp != 0) {
                        return -cmp;
                    }
                    cmp = (e1.getTotalEnrollment() == null ? new Integer(0) : e1.getTotalEnrollment()).compareTo(e2.getTotalEnrollment() == null ? 0 : e2.getTotalEnrollment());
                    if (cmp == 0) break;
                    return -cmp;
                }
                case WAITLIST: {
                    cmp = (e1.getWaitlist() == null ? new Integer(0) : e1.getWaitlist()).compareTo(e2.getWaitlist() == null ? 0 : e2.getWaitlist());
                    if (cmp != 0) {
                        return -cmp;
                    }
                    cmp = (e1.getUnassigned() == null ? new Integer(0) : e1.getUnassigned()).compareTo(e2.getUnassigned() == null ? 0 : e2.getUnassigned());
                    if (cmp != 0) {
                        return -cmp;
                    }
                    cmp = (e1.getTotalWaitlist() == null ? new Integer(0) : e1.getTotalWaitlist()).compareTo(e2.getTotalWaitlist() == null ? 0 : e2.getTotalWaitlist());
                    if (cmp != 0) {
                        return -cmp;
                    }
                    cmp = (e1.getTotalUnassigned() == null ? new Integer(0) : e1.getTotalUnassigned()).compareTo(e2.getTotalUnassigned() == null ? 0 : e2.getTotalUnassigned());
                    if (cmp == 0) break;
                    return -cmp;
                }
                case RESERVATION: {
                    cmp = (e1.getReservation() == null ? new Integer(0) : e1.getReservation()).compareTo(e2.getReservation() == null ? 0 : e2.getReservation());
                    if (cmp != 0) {
                        return -cmp;
                    }
                    cmp = (e1.getTotalReservation() == null ? new Integer(0) : e1.getTotalReservation()).compareTo(e2.getTotalReservation() == null ? 0 : e2.getTotalReservation());
                    if (cmp == 0) break;
                    return -cmp;
                }
                case NEED_CONSENT: {
                    cmp = (e1.getConsentNeeded() == null ? new Integer(0) : new Integer(e1.getConsentNeeded())).compareTo(e2.getConsentNeeded() == null ? 0 : e2.getConsentNeeded());
                    if (cmp != 0) {
                        return -cmp;
                    }
                    cmp = (e1.getTotalConsentNeeded() == null ? new Integer(0) : new Integer(e1.getTotalConsentNeeded())).compareTo(e2.getTotalConsentNeeded() == null ? 0 : e2.getTotalConsentNeeded());
                    if (cmp == 0) break;
                    return -cmp;
                }
            }
            cmp = e1.getSubject().compareTo(e2.getSubject());
            if (cmp != 0) {
                return cmp;
            }
            cmp = e1.getCourseNbr().compareTo(e2.getCourseNbr());
            if (cmp != 0) {
                return cmp;
            }
            return 0;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum SortBy {
            SUBJECT,
            COURSE,
            TITLE,
            CONSENT,
            LIMIT,
            PROJECTION,
            ENROLLMENT,
            WAITLIST,
            RESERVATION,
            NEED_CONSENT;

        }
    }

    public static class WaitListCell
    extends HTML
    implements UniTimeTable.HasCellAlignment {
        public WaitListCell(int wait, int tWait, int unasg, int tUnasg, Integer topWaitingPriority) {
            if (tWait == 0 || tWait == tUnasg) {
                if (unasg == tUnasg) {
                    this.setHTML(unasg == 0 ? "-" : String.valueOf(unasg));
                } else {
                    this.setHTML(unasg + " / " + tUnasg);
                }
                if (tWait > 0) {
                    this.setHTML(this.getHTML() + MESSAGES.htmlWaitListSign());
                }
            } else if (wait == tWait && unasg == tUnasg) {
                this.setHTML(wait == 0 ? String.valueOf(unasg) : (wait == unasg ? wait + MESSAGES.htmlWaitListSign() : unasg - wait + " + " + wait + MESSAGES.htmlWaitListSign()));
            } else {
                this.setHTML((wait == 0 ? String.valueOf(unasg) : (wait == unasg ? wait + MESSAGES.htmlWaitListSign() : unasg - wait + " + " + wait + MESSAGES.htmlWaitListSign())) + " / " + tUnasg);
            }
            if (topWaitingPriority != null) {
                this.setHTML(this.getHTML() + " " + MESSAGES.firstWaitListedPrioritySign(topWaitingPriority));
            }
        }

        public WaitListCell(ClassAssignmentInterface.StudentInfo e) {
            this(e.hasWaitlist() ? e.getWaitlist() : 0, e.hasTotalWaitlist() ? e.getTotalWaitlist() : 0, e.hasUnassigned() ? e.getUnassigned() : 0, e.hasTotalUnassigned() ? e.getTotalUnassigned() : 0, e.getTopWaitingPriority());
        }

        public WaitListCell(ClassAssignmentInterface.EnrollmentInfo e) {
            this(e.hasWaitlist() ? e.getWaitlist() : 0, e.hasTotalWaitlist() ? e.getTotalWaitlist() : 0, e.hasUnassigned() ? e.getUnassigned() : 0, e.hasTotalUnassigned() ? e.getTotalUnassigned() : 0, null);
        }

        public HasHorizontalAlignment.HorizontalAlignmentConstant getCellAlignment() {
            return HasHorizontalAlignment.ALIGN_RIGHT;
        }
    }

    public static class AvailableCell
    extends HTML
    implements UniTimeTable.HasCellAlignment {
        public AvailableCell(ClassAssignmentInterface.EnrollmentInfo e) {
            int other;
            int n = other = e.getOther() == null ? 0 : e.getOther();
            if (e.getLimit() == null) {
                this.setHTML("-");
                this.setTitle(MESSAGES.availableNoLimit());
            } else if (e.getLimit() < 0) {
                if (e.getAvailable() != null && e.getAvailable() == 0) {
                    this.setHTML("&infin;" + MESSAGES.htmlReservationSign());
                    this.setTitle(MESSAGES.availableUnlimitedWithReservation());
                } else {
                    this.setHTML("&infin;");
                    this.setTitle(MESSAGES.availableUnlimited());
                }
            } else if (e.getAvailable() == e.getLimit() - e.getTotalEnrollment() - other) {
                this.setHTML(e.getAvailable() + " / " + e.getLimit());
                if (e.getAvailable() == 0) {
                    this.setTitle(MESSAGES.availableNot(e.getLimit()));
                } else {
                    this.setTitle(MESSAGES.available(e.getAvailable(), e.getLimit()));
                }
            } else if (e.getAvailable() == 0 && e.getLimit() > e.getTotalEnrollment() + other) {
                this.setHTML(e.getLimit() - e.getTotalEnrollment() - other + MESSAGES.htmlReservationSign() + " / " + e.getLimit());
                this.setTitle(MESSAGES.availableWithReservation(e.getLimit() - e.getTotalEnrollment() - other, e.getLimit()));
            } else {
                this.setHTML(e.getAvailable() + " + " + (e.getLimit() - e.getTotalEnrollment() - e.getAvailable() - other) + MESSAGES.htmlReservationSign() + " / " + e.getLimit());
                this.setTitle(MESSAGES.availableSomeReservation(e.getAvailable(), e.getLimit(), e.getLimit() - e.getTotalEnrollment() - e.getAvailable() - other));
            }
        }

        public static boolean hasReservedSpace(ClassAssignmentInterface.EnrollmentInfo e) {
            if (e.getLimit() < 0) {
                return false;
            }
            if (e.getLimit() < 0) {
                return e.getAvailable() == 0;
            }
            return e.getAvailable() != e.getLimit() - e.getTotalEnrollment() - (e.getOther() == null ? 0 : e.getOther());
        }

        public HasHorizontalAlignment.HorizontalAlignmentConstant getCellAlignment() {
            return HasHorizontalAlignment.ALIGN_RIGHT;
        }
    }

    public static class TitleCell
    extends HTML
    implements UniTimeTable.HasColSpan {
        public TitleCell(String title) {
            super(title);
        }

        public int getColSpan() {
            return 2;
        }
    }

    public static class NumberCell
    extends HTML
    implements UniTimeTable.HasCellAlignment {
        public NumberCell(Integer value, Integer total) {
            if (value == null) {
                if (total != null) {
                    this.setHTML(total == 0 ? "-" : (total < 0 ? "&infin;" : total.toString()));
                }
            } else if (value.equals(total)) {
                this.setHTML(total == 0 ? "-" : (total < 0 ? "&infin;" : total.toString()));
            } else {
                this.setHTML((value < 0 ? "&infin;" : value.toString()) + " / " + (total < 0 ? "&infin;" : total.toString()));
            }
        }

        public HasHorizontalAlignment.HorizontalAlignmentConstant getCellAlignment() {
            return HasHorizontalAlignment.ALIGN_RIGHT;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class SuggestCallback
    implements AsyncCallback<List<String[]>> {
        private SuggestOracle.Request iRequest;
        private SuggestOracle.Callback iCallback;

        public SuggestCallback(SuggestOracle.Request request, SuggestOracle.Callback callback) {
            this.iRequest = request;
            this.iCallback = callback;
        }

        public void onFailure(Throwable caught) {
            ArrayList suggestions = new ArrayList();
            this.iCallback.onSuggestionsReady(this.iRequest, new SuggestOracle.Response(suggestions));
            ToolBox.checkAccess(caught);
        }

        public void onSuccess(List<String[]> result) {
            ArrayList<SimpleSuggestion> suggestions = new ArrayList<SimpleSuggestion>();
            for (String[] suggestion : result) {
                suggestions.add(new SimpleSuggestion(suggestion[1], suggestion[0]));
            }
            this.iCallback.onSuggestionsReady(this.iRequest, new SuggestOracle.Response(suggestions));
        }
    }

    public static class SimpleSuggestion
    implements SuggestOracle.Suggestion {
        private String iDisplay;
        private String iReplace;

        public SimpleSuggestion(String display, String replace) {
            this.iDisplay = display;
            this.iReplace = replace;
        }

        public SimpleSuggestion(String replace) {
            this(replace, replace);
        }

        public String getDisplayString() {
            return this.iDisplay;
        }

        public String getReplacementString() {
            return this.iReplace;
        }
    }
}

