/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.sectioning;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.TreeSet;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.client.sectioning.EnrollmentTable;
import org.unitime.timetable.gwt.client.sectioning.SectioningCookie;
import org.unitime.timetable.gwt.client.widgets.SimpleForm;
import org.unitime.timetable.gwt.client.widgets.UniTimeDialogBox;
import org.unitime.timetable.gwt.client.widgets.UniTimeHeaderPanel;
import org.unitime.timetable.gwt.client.widgets.UniTimeTable;
import org.unitime.timetable.gwt.client.widgets.UniTimeTableHeader;
import org.unitime.timetable.gwt.command.client.GwtRpcRequest;
import org.unitime.timetable.gwt.command.client.GwtRpcResponse;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseList;
import org.unitime.timetable.gwt.command.client.GwtRpcService;
import org.unitime.timetable.gwt.command.client.GwtRpcServiceAsync;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.ClassAssignmentInterface;
import org.unitime.timetable.gwt.shared.EventInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExaminationEnrollmentTable
extends EnrollmentTable {
    private static final GwtRpcServiceAsync RPC = (GwtRpcServiceAsync)GWT.create(GwtRpcService.class);
    private static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);

    public ExaminationEnrollmentTable(boolean showHeader, boolean online) {
        super(showHeader, online);
        this.getTable().setStyleName("unitime-Enrollments");
    }

    @Override
    protected void refresh() {
        this.clear();
        this.getHeader().showLoading();
        if (this.getId() != null) {
            RPC.execute(ExaminationEnrollmentsRpcRequest.getEnrollmentsForExam(this.getId()), new AsyncCallback<GwtRpcResponseList<ClassAssignmentInterface.Enrollment>>(){

                public void onFailure(Throwable caught) {
                    ExaminationEnrollmentTable.this.getHeader().setErrorMessage(MESSAGES.failedNoEnrollments(caught.getMessage()));
                }

                public void onSuccess(GwtRpcResponseList<ClassAssignmentInterface.Enrollment> result) {
                    ExaminationEnrollmentTable.this.getHeader().clearMessage();
                    ExaminationEnrollmentTable.this.populate(result, null);
                }
            });
        }
    }

    @Override
    public void showStudentSchedule(final ClassAssignmentInterface.Student student, final AsyncCallback<Boolean> callback) {
        RPC.execute(ExaminationScheduleRpcRequest.getScheduleForStudent(this.getId(), student.getId()), new AsyncCallback<ExaminationScheduleRpcResponse>(){

            public void onFailure(Throwable caught) {
                callback.onFailure(caught);
            }

            public void onSuccess(ExaminationScheduleRpcResponse result) {
                callback.onSuccess((Object)true);
                final UniTimeTable table = new UniTimeTable();
                table.setStyleName("unitime-EventOwners");
                ArrayList<ClickableUniTimeTableHeader> ownersHeader = new ArrayList<ClickableUniTimeTableHeader>();
                ownersHeader.add(new ClickableUniTimeTableHeader(MESSAGES.colCourse()));
                ownersHeader.add(new ClickableUniTimeTableHeader(MESSAGES.colSection()));
                ownersHeader.add(new ClickableUniTimeTableHeader(MESSAGES.colType()));
                ownersHeader.add(new ClickableUniTimeTableHeader(MESSAGES.colTitle()));
                ownersHeader.add(new ClickableUniTimeTableHeader(MESSAGES.colDate()));
                ownersHeader.add(new ClickableUniTimeTableHeader(MESSAGES.colTime()));
                ownersHeader.add(new ClickableUniTimeTableHeader(MESSAGES.colLocation()));
                ownersHeader.add(new ClickableUniTimeTableHeader(MESSAGES.colInstructor()));
                boolean hasConflicts = false;
                for (EventInterface.RelatedObjectInterface obj : result.getExams()) {
                    if (!obj.hasConflicts()) continue;
                    ownersHeader.add(new ClickableUniTimeTableHeader(MESSAGES.colConflict()));
                    hasConflicts = true;
                    break;
                }
                table.addRow(null, ownersHeader);
                table.addMouseClickListener(new UniTimeTable.MouseClickListener<EventInterface.RelatedObjectInterface>(){

                    @Override
                    public void onMouseClick(UniTimeTable.TableEvent<EventInterface.RelatedObjectInterface> event) {
                        if (event.getData() != null && event.getData().hasDetailPage()) {
                            ToolBox.open(GWT.getHostPageBaseURL() + event.getData().getDetailPage());
                        }
                        if (event.getData() == null && event.getCol() >= 0) {
                            table.sort(event.getCol(), new RelatedObjectComparator(event.getCol()));
                            boolean asc = table.getHeader(event.getCol()).getOrder();
                            SectioningCookie.getInstance().setRelatedSortBy(asc ? 1 + event.getCol() : -1 - event.getCol());
                        }
                    }
                });
                for (EventInterface.RelatedObjectInterface obj : result.getExams()) {
                    ArrayList<Object> row = new ArrayList<Object>();
                    String course = "";
                    if (obj.hasCourseNames()) {
                        for (String string : obj.getCourseNames()) {
                            if (course.isEmpty()) {
                                course = course + string;
                                continue;
                            }
                            course = course + "<span class='cross-list'>" + string + "</span>";
                        }
                    } else {
                        course = obj.getName();
                    }
                    row.add(new HTML(course, false));
                    String section = "";
                    if (obj.hasExternalIds()) {
                        for (String ex : obj.getExternalIds()) {
                            if (section.isEmpty()) {
                                section = section + ex;
                                continue;
                            }
                            section = section + "<span class='cross-list'>" + ex + "</span>";
                        }
                    } else if (obj.hasSectionNumber()) {
                        section = obj.getSectionNumber();
                    }
                    row.add(new HTML(section, false));
                    String string = obj.hasInstruction() ? obj.getInstruction() : obj.getType().name();
                    row.add(new Label(string, false));
                    String title = "";
                    if (obj.hasCourseTitles()) {
                        String last = null;
                        for (String ct : obj.getCourseTitles()) {
                            if (last != null && !last.isEmpty() && last.equals(ct)) {
                                ct = "";
                            } else {
                                last = ct;
                            }
                            if (title.isEmpty()) {
                                title = title + ct;
                                continue;
                            }
                            title = title + "<span class='cross-list'>" + ct + "</span>";
                        }
                    } else {
                        title = "";
                    }
                    row.add(new HTML(title, false));
                    if (obj.hasDate()) {
                        row.add(new Label(obj.getDate(), false));
                    } else {
                        row.add(new Label());
                    }
                    if (obj.hasTime()) {
                        row.add(new Label(obj.getTime(), false));
                    } else {
                        row.add(new Label());
                    }
                    String location = "";
                    if (obj.hasLocations()) {
                        for (EventInterface.ResourceInterface loc : obj.getLocations()) {
                            location = location + (location.isEmpty() ? "" : "<br>") + loc.getName();
                        }
                    }
                    row.add(new HTML(location, false));
                    if (obj.hasInstructors()) {
                        row.add(new HTML(obj.getInstructorNames("<br>", MESSAGES), false));
                    } else {
                        row.add(new HTML());
                    }
                    if (hasConflicts) {
                        if (obj.hasConflicts()) {
                            HTML html = new HTML(obj.getConflicts());
                            html.addStyleName("conflict");
                            row.add(html);
                        } else {
                            row.add(new HTML("&nbsp;", false));
                        }
                    }
                    int rowNumber = table.addRow(obj, row);
                    table.getRowFormatter().addStyleName(rowNumber, "owner-row");
                    for (int i = 0; i < table.getCellCount(rowNumber); ++i) {
                        table.getCellFormatter().addStyleName(rowNumber, i, "owner-cell");
                    }
                }
                int sort = SectioningCookie.getInstance().getRelatedSortBy();
                if (sort > 0) {
                    table.sort(table.getHeader(sort - 1), new RelatedObjectComparator(sort - 1), true);
                } else if (sort < 0) {
                    table.sort(table.getHeader(-1 - sort), new RelatedObjectComparator(-1 - sort), false);
                }
                SimpleForm form = new SimpleForm();
                form.addRow((Widget)table);
                UniTimeHeaderPanel buttons = new UniTimeHeaderPanel();
                form.addBottomRow((Widget)buttons);
                final UniTimeDialogBox dialog = new UniTimeDialogBox(true, false);
                dialog.setWidget((Widget)form);
                dialog.setText(MESSAGES.dialogExaminations(result.getExamType(), student.getName()));
                dialog.setEscapeToHide(true);
                buttons.addButton("close", MESSAGES.buttonClose(), new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        dialog.hide();
                    }
                });
                dialog.addCloseHandler((CloseHandler)new CloseHandler<PopupPanel>(){

                    public void onClose(CloseEvent<PopupPanel> event) {
                        ExaminationEnrollmentTable.this.getTable().clearHover();
                    }
                });
                dialog.center();
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RelatedObjectComparator
    implements Comparator<EventInterface.RelatedObjectInterface> {
        private int iColumn;

        public RelatedObjectComparator(int column) {
            this.iColumn = column;
        }

        private String course(EventInterface.RelatedObjectInterface obj) {
            String course = "";
            if (obj.hasCourseNames()) {
                for (String cn : obj.getCourseNames()) {
                    if (course.isEmpty()) {
                        course = course + cn;
                        continue;
                    }
                    course = course + "," + cn;
                }
            } else {
                course = obj.getName();
            }
            return course;
        }

        private String section(EventInterface.RelatedObjectInterface obj) {
            String section = "";
            if (obj.hasExternalIds()) {
                for (String ex : obj.getExternalIds()) {
                    if (section.isEmpty()) {
                        section = section + ex;
                        continue;
                    }
                    section = section + "," + ex;
                }
            } else if (obj.hasSectionNumber()) {
                section = obj.getSectionNumber();
            }
            return section;
        }

        private String type(EventInterface.RelatedObjectInterface obj) {
            return obj.hasInstruction() ? obj.getInstruction() : obj.getType().name();
        }

        private String title(EventInterface.RelatedObjectInterface obj) {
            String title = "";
            if (obj.hasCourseTitles()) {
                String last = null;
                for (String ct : obj.getCourseTitles()) {
                    if (last != null && !last.isEmpty() && last.equals(ct)) {
                        ct = "";
                    } else {
                        last = ct;
                    }
                    if (title.isEmpty()) {
                        title = title + ct;
                        continue;
                    }
                    title = title + "," + ct;
                }
            } else {
                title = "";
            }
            return title;
        }

        private String location(EventInterface.RelatedObjectInterface obj) {
            String location = "";
            if (obj.hasLocations()) {
                for (EventInterface.ResourceInterface loc : obj.getLocations()) {
                    location = location + (location.isEmpty() ? "" : "<br>") + loc.getName();
                }
            }
            return location;
        }

        private int compare(int column, EventInterface.RelatedObjectInterface o1, EventInterface.RelatedObjectInterface o2) {
            switch (column) {
                case 0: {
                    return this.course(o1).compareTo(this.course(o2));
                }
                case 1: {
                    return this.section(o1).compareTo(this.section(o2));
                }
                case 2: {
                    return this.type(o1).compareTo(this.type(o2));
                }
                case 3: {
                    return this.title(o1).compareTo(this.title(o2));
                }
                case 4: {
                    int cmp = (o1.hasDayOfYear() ? o1.getDayOfYear() : new Integer(-1)).compareTo(o2.hasDayOfYear() ? o2.getDayOfYear() : new Integer(-1));
                    if (cmp != 0) {
                        return cmp;
                    }
                }
                case 5: {
                    int cmp = (o1.hasStartSlot() ? o1.getStartSlot() : new Integer(-1)).compareTo(o2.hasStartSlot() ? o2.getStartSlot() : new Integer(-1));
                    if (cmp != 0) {
                        return cmp;
                    }
                    return (o1.hasEndSlot() ? o1.getEndSlot() : new Integer(-1)).compareTo(o2.hasEndSlot() ? o2.getEndSlot() : new Integer(-1));
                }
                case 6: {
                    return this.location(o1).compareTo(this.location(o2));
                }
                case 7: {
                    return (o1.hasInstructors() ? o1.getInstructorNames(",", MESSAGES) : "").compareToIgnoreCase(o2.hasInstructors() ? o2.getInstructorNames(",", MESSAGES) : "");
                }
                case 8: {
                    return (o1.hasConflicts() ? o1.getConflicts() : "").compareToIgnoreCase(o2.hasConflicts() ? o2.getConflicts() : "");
                }
            }
            return 0;
        }

        @Override
        public int compare(EventInterface.RelatedObjectInterface o1, EventInterface.RelatedObjectInterface o2) {
            int cmp = this.compare(this.iColumn, o1, o2);
            if (cmp != 0) {
                return cmp;
            }
            cmp = this.course(o1).compareTo(this.course(o2));
            if (cmp != 0) {
                return cmp;
            }
            return o1.compareTo(o2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ExaminationScheduleRpcResponse
    implements GwtRpcResponse {
        private String iExamType;
        private TreeSet<EventInterface.RelatedObjectInterface> iExams;

        public String getExamType() {
            return this.iExamType;
        }

        public void setExamType(String examType) {
            this.iExamType = examType;
        }

        public boolean hasExams() {
            return this.iExams != null && !this.iExams.isEmpty();
        }

        public void addExam(EventInterface.RelatedObjectInterface exam) {
            if (this.iExams == null) {
                this.iExams = new TreeSet();
            }
            this.iExams.add(exam);
        }

        public TreeSet<EventInterface.RelatedObjectInterface> getExams() {
            return this.iExams;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ExaminationScheduleRpcRequest
    implements GwtRpcRequest<ExaminationScheduleRpcResponse> {
        private Long iExamId;
        private Long iStudentId;

        public boolean hasExamId() {
            return this.iExamId != null;
        }

        public Long getExamId() {
            return this.iExamId;
        }

        public void setExamId(Long examId) {
            this.iExamId = examId;
        }

        public boolean hasStudentId() {
            return this.iStudentId != null;
        }

        public Long getStudentId() {
            return this.iStudentId;
        }

        public void setStudentId(Long studentId) {
            this.iStudentId = studentId;
        }

        @Override
        public String toString() {
            return (this.hasExamId() ? this.getExamId().toString() : "NULL") + "," + (this.hasStudentId() ? this.getStudentId().toString() : "NULL");
        }

        public static ExaminationScheduleRpcRequest getScheduleForStudent(Long examId, Long studentId) {
            ExaminationScheduleRpcRequest request = new ExaminationScheduleRpcRequest();
            request.setExamId(examId);
            request.setStudentId(studentId);
            return request;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ExaminationEnrollmentsRpcRequest
    implements GwtRpcRequest<GwtRpcResponseList<ClassAssignmentInterface.Enrollment>> {
        private Long iExamId;

        public boolean hasExamId() {
            return this.iExamId != null;
        }

        public Long getExamId() {
            return this.iExamId;
        }

        public void setExamId(Long examId) {
            this.iExamId = examId;
        }

        @Override
        public String toString() {
            return this.hasExamId() ? this.getExamId().toString() : "NULL";
        }

        public static ExaminationEnrollmentsRpcRequest getEnrollmentsForExam(Long examId) {
            ExaminationEnrollmentsRpcRequest request = new ExaminationEnrollmentsRpcRequest();
            request.setExamId(examId);
            return request;
        }
    }

    private static class ClickableUniTimeTableHeader
    extends UniTimeTableHeader {
        private ClickableUniTimeTableHeader(String title) {
            super(title);
        }

        public String getStyleName() {
            return "unitime-ClickableTableHeader";
        }
    }
}

