/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.sectioning;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.CheckBox;
import java.util.Collection;
import org.unitime.timetable.gwt.client.widgets.CourseFinder;
import org.unitime.timetable.gwt.client.widgets.CourseFinderClasses;
import org.unitime.timetable.gwt.client.widgets.CourseFinderCourses;
import org.unitime.timetable.gwt.client.widgets.CourseFinderDetails;
import org.unitime.timetable.gwt.client.widgets.CourseFinderDialog;
import org.unitime.timetable.gwt.client.widgets.CourseFinderFactory;
import org.unitime.timetable.gwt.client.widgets.CourseFinderFreeTime;
import org.unitime.timetable.gwt.client.widgets.CourseSelectionSuggestBox;
import org.unitime.timetable.gwt.client.widgets.DataProvider;
import org.unitime.timetable.gwt.client.widgets.FreeTimeParser;
import org.unitime.timetable.gwt.resources.GwtAriaMessages;
import org.unitime.timetable.gwt.resources.StudentSectioningConstants;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.resources.StudentSectioningResources;
import org.unitime.timetable.gwt.services.SectioningService;
import org.unitime.timetable.gwt.services.SectioningServiceAsync;
import org.unitime.timetable.gwt.shared.AcademicSessionProvider;
import org.unitime.timetable.gwt.shared.ClassAssignmentInterface;
import org.unitime.timetable.gwt.shared.CourseRequestInterface;

public class CourseSelectionBox
extends CourseSelectionSuggestBox {
    public static final StudentSectioningResources RESOURCES = (StudentSectioningResources)GWT.create(StudentSectioningResources.class);
    public static final StudentSectioningMessages MESSAGES = (StudentSectioningMessages)GWT.create(StudentSectioningMessages.class);
    public static final StudentSectioningConstants CONSTANTS = (StudentSectioningConstants)GWT.create(StudentSectioningConstants.class);
    public static final GwtAriaMessages ARIA = (GwtAriaMessages)GWT.create(GwtAriaMessages.class);
    private CourseSelectionBox iPrev;
    private CourseSelectionBox iNext;
    private CourseSelectionBox iPrimary;
    private CourseSelectionBox iAlternative;
    private CheckBox iWaitList;
    private AcademicSessionProvider iAcademicSessionProvider;
    private final SectioningServiceAsync iSectioningService = (SectioningServiceAsync)GWT.create(SectioningService.class);

    public CourseSelectionBox(AcademicSessionProvider acadSession, boolean enabled, boolean allowFreeTime) {
        this.iAcademicSessionProvider = acadSession;
        if (allowFreeTime) {
            FreeTimeParser parser = new FreeTimeParser();
            this.setFreeTimes(parser);
        }
        this.setCourseFinderFactory(new CourseFinderFactory(){

            public CourseFinder createCourseFinder() {
                CourseFinderDialog finder = new CourseFinderDialog();
                CourseFinderCourses courses = new CourseFinderCourses();
                courses.setDataProvider(new DataProvider<String, Collection<ClassAssignmentInterface.CourseAssignment>>(){

                    @Override
                    public void getData(String source, AsyncCallback<Collection<ClassAssignmentInterface.CourseAssignment>> callback) {
                        CourseSelectionBox.this.iSectioningService.listCourseOfferings(CourseSelectionBox.this.iAcademicSessionProvider.getAcademicSessionId(), source, null, callback);
                    }
                });
                CourseFinderDetails details = new CourseFinderDetails();
                details.setDataProvider(new DataProvider<String, String>(){

                    @Override
                    public void getData(String source, AsyncCallback<String> callback) {
                        CourseSelectionBox.this.iSectioningService.retrieveCourseDetails(CourseSelectionBox.this.iAcademicSessionProvider.getAcademicSessionId(), source, callback);
                    }
                });
                CourseFinderClasses classes = new CourseFinderClasses();
                classes.setDataProvider(new DataProvider<String, Collection<ClassAssignmentInterface.ClassAssignment>>(){

                    @Override
                    public void getData(String source, AsyncCallback<Collection<ClassAssignmentInterface.ClassAssignment>> callback) {
                        CourseSelectionBox.this.iSectioningService.listClasses(CourseSelectionBox.this.iAcademicSessionProvider.getAcademicSessionId(), source, callback);
                    }
                });
                courses.setCourseDetails(details, classes);
                if (CourseSelectionBox.this.getFreeTimes() != null) {
                    CourseFinderFreeTime free = new CourseFinderFreeTime();
                    free.setDataProvider(CourseSelectionBox.this.getFreeTimes());
                    finder.setTabs(courses, free);
                } else {
                    finder.setTabs(courses);
                }
                return finder;
            }
        });
        this.setSuggestions(new DataProvider<String, Collection<ClassAssignmentInterface.CourseAssignment>>(){

            @Override
            public void getData(String source, AsyncCallback<Collection<ClassAssignmentInterface.CourseAssignment>> callback) {
                CourseSelectionBox.this.iSectioningService.listCourseOfferings(CourseSelectionBox.this.iAcademicSessionProvider.getAcademicSessionId(), source, 20, callback);
            }
        });
    }

    public void setNext(CourseSelectionBox next) {
        this.iNext = next;
    }

    public void setPrev(CourseSelectionBox prev) {
        this.iPrev = prev;
    }

    public void setPrimary(CourseSelectionBox primary) {
        this.iPrimary = primary;
    }

    public void setAlternative(CourseSelectionBox alternative) {
        this.iAlternative = alternative;
    }

    public void setWaitList(CheckBox waitList) {
        this.iWaitList = waitList;
    }

    public void setWaitList(boolean waitList) {
        if (this.iWaitList != null) {
            this.iWaitList.setValue(Boolean.valueOf(waitList));
        }
    }

    public Boolean getWaitList() {
        return this.iWaitList == null ? null : this.iWaitList.getValue();
    }

    private void swapWith(CourseSelectionBox other) {
        this.hideSuggestionList();
        other.hideSuggestionList();
        String x = this.getError();
        this.setError(other.getError());
        other.setError(x);
        boolean b = this.isEnabled();
        this.setEnabled(other.isEnabled());
        other.setEnabled(b);
        if (this.iPrimary != null) {
            x = this.getHint();
            this.setHint(other.getHint());
            other.setHint(x);
        }
        x = this.getValue();
        this.setValue(other.getValue(), false);
        other.setValue(x, false);
        if (this.iAlternative != null) {
            this.iAlternative.swapWith(other.iAlternative);
        }
        if (this.iWaitList != null && other.iWaitList != null) {
            Boolean ch = this.iWaitList.getValue();
            this.iWaitList.setValue(other.iWaitList.getValue());
            other.iWaitList.setValue(ch);
        }
    }

    private void replaceWith(CourseSelectionBox other) {
        this.hideSuggestionList();
        if (other != null) {
            other.hideSuggestionList();
        }
        this.setError(other == null ? null : other.getError());
        this.setEnabled(other == null ? this.iPrimary == null || !this.iPrimary.getValue().isEmpty() : other.isEnabled());
        if (this.iPrimary != null) {
            this.setHint(other == null ? "" : other.getHint());
        }
        this.setValue(other == null ? null : other.getValue(), false);
        if (this.iAlternative != null) {
            this.iAlternative.replaceWith(other == null ? null : other.iAlternative);
        }
        if (this.iWaitList != null) {
            this.iWaitList.setValue(Boolean.valueOf(other == null || other.iWaitList == null ? false : other.iWaitList.getValue()));
        }
    }

    private void clearAllAlternatives() {
        if (this.iPrimary != null) {
            this.setHint("");
        }
        this.setValue(null);
        if (this.iAlternative != null) {
            this.iAlternative.clearAllAlternatives();
        }
    }

    private void clearAll() {
        if (this.iPrimary != null) {
            this.iPrimary.clearAll();
        } else {
            this.clearAllAlternatives();
        }
    }

    public void moveDown() {
        if (this.iPrimary != null) {
            this.iPrimary.moveDown();
        } else if (this.iNext == null) {
            this.clearAll();
        } else {
            this.iNext.moveDown();
            this.swapWith(this.iNext);
        }
    }

    public void moveUp() {
        if (this.iPrimary != null) {
            this.iPrimary.moveUp();
        } else if (this.iPrev == null) {
            this.clearAll();
        } else {
            this.iPrev.moveUp();
            this.swapWith(this.iPrev);
        }
    }

    public void swapDown() {
        if (this.iPrimary != null) {
            this.iPrimary.swapDown();
        } else {
            this.swapWith(this.iNext);
        }
    }

    public void swapUp() {
        if (this.iPrimary != null) {
            this.iPrimary.swapUp();
        } else {
            this.swapWith(this.iPrev);
        }
    }

    public void remove() {
        if (this.iPrimary != null) {
            this.iPrimary.remove();
        } else if (this.iNext != null && this.isAllowFreeTime() == this.iNext.isAllowFreeTime()) {
            this.replaceWith(this.iNext);
            this.iNext.remove();
        } else {
            this.replaceWith(null);
        }
    }

    public boolean fillInFreeTime(CourseRequestInterface.Request request) {
        try {
            if (this.getFreeTimes() != null) {
                for (CourseRequestInterface.FreeTime ft : this.getFreeTimes().parseFreeTime(this.getValue())) {
                    request.addRequestedFreeTime(ft);
                }
            }
            return request.hasRequestedFreeTime();
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }
}

