/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.rooms;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.event.dom.client.BlurEvent;
import com.google.gwt.event.dom.client.BlurHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.FocusEvent;
import com.google.gwt.event.dom.client.FocusHandler;
import com.google.gwt.event.dom.client.HasMouseDownHandlers;
import com.google.gwt.event.dom.client.KeyDownEvent;
import com.google.gwt.event.dom.client.KeyDownHandler;
import com.google.gwt.event.dom.client.KeyPressEvent;
import com.google.gwt.event.dom.client.KeyPressHandler;
import com.google.gwt.event.dom.client.MouseDownEvent;
import com.google.gwt.event.dom.client.MouseDownHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.event.shared.HasHandlers;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.rpc.IsSerializable;
import com.google.gwt.user.client.ui.AbsolutePanel;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.UIObject;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.client.aria.AriaButton;
import org.unitime.timetable.gwt.client.events.RoomFilterBox;
import org.unitime.timetable.gwt.client.page.UniTimeNotifications;
import org.unitime.timetable.gwt.client.widgets.LoadingWidget;
import org.unitime.timetable.gwt.client.widgets.SimpleForm;
import org.unitime.timetable.gwt.client.widgets.UniTimeHeaderPanel;
import org.unitime.timetable.gwt.command.client.GwtRpcRequest;
import org.unitime.timetable.gwt.command.client.GwtRpcResponse;
import org.unitime.timetable.gwt.command.client.GwtRpcService;
import org.unitime.timetable.gwt.command.client.GwtRpcServiceAsync;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.AcademicSessionProvider;
import org.unitime.timetable.gwt.shared.EventInterface;

public class TravelTimes
extends Composite {
    protected static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    private static GwtRpcServiceAsync RPC = (GwtRpcServiceAsync)GWT.create(GwtRpcService.class);
    private SimpleForm iForm;
    private Matrix iMatrix;
    private UniTimeHeaderPanel iHeader;
    private UniTimeHeaderPanel iFooter;
    private RoomFilterBox iRoomFilter;
    private AriaButton iShow;
    private KeyDownHandler iKeyDownHandler = new KeyDownHandler(){

        public void onKeyDown(KeyDownEvent event) {
            Time time = (Time)((Object)event.getSource());
            if (time.isReadOnly() || !time.isEnabled()) {
                return;
            }
            int row = time.getRow();
            int col = time.getColumn();
            switch (event.getNativeEvent().getKeyCode()) {
                case 40: {
                    Time t;
                    do {
                        if (++row <= TravelTimes.this.iMatrix.getRowCount() - 2) continue;
                        row = 1;
                        if (++col <= TravelTimes.this.iMatrix.getCellCount(row) - 2) continue;
                        col = 1;
                    } while (!(t = (Time)TravelTimes.this.iMatrix.getWidget(row, col)).isEnabled() || t.isReadOnly());
                    t.setFocus(true);
                    t.selectAll();
                    time.cancelKey();
                    return;
                }
                case 38: {
                    Time t;
                    do {
                        if (--row > 0) continue;
                        row = TravelTimes.this.iMatrix.getRowCount() - 2;
                        if (--col > 0) continue;
                        col = TravelTimes.this.iMatrix.getCellCount(row) - 2;
                    } while (!(t = (Time)TravelTimes.this.iMatrix.getWidget(row, col)).isEnabled() || t.isReadOnly());
                    t.setFocus(true);
                    t.selectAll();
                    time.cancelKey();
                    return;
                }
                case 37: {
                    Time t;
                    do {
                        if (--col > 0) continue;
                        col = TravelTimes.this.iMatrix.getCellCount(row) - 2;
                        if (--row > 0) continue;
                        row = TravelTimes.this.iMatrix.getRowCount() - 2;
                    } while (!(t = (Time)TravelTimes.this.iMatrix.getWidget(row, col)).isEnabled() || t.isReadOnly());
                    t.setFocus(true);
                    t.selectAll();
                    time.cancelKey();
                    return;
                }
                case 39: {
                    Time t;
                    do {
                        if (++col <= TravelTimes.this.iMatrix.getCellCount(row) - 2) continue;
                        col = 1;
                        if (++row <= TravelTimes.this.iMatrix.getRowCount() - 2) continue;
                        row = 1;
                    } while (!(t = (Time)TravelTimes.this.iMatrix.getWidget(row, col)).isEnabled() || t.isReadOnly());
                    t.setFocus(true);
                    t.selectAll();
                    time.cancelKey();
                    return;
                }
            }
        }
    };
    private KeyPressHandler iKeyPressHandler = new KeyPressHandler(){

        public void onKeyPress(KeyPressEvent event) {
            if (!Character.isDigit(event.getCharCode()) && event.getUnicodeCharCode() != 0) {
                ((TextBox)event.getSource()).cancelKey();
            }
        }
    };

    public TravelTimes() {
        this.iForm = new SimpleForm();
        this.iHeader = new UniTimeHeaderPanel(MESSAGES.sectTravelTimesInMintes());
        this.iHeader.addButton("save", MESSAGES.buttonSave(), 75, new ClickHandler(){

            public void onClick(ClickEvent event) {
                TravelTimes.this.iHeader.showLoading();
                RPC.execute(TravelTimesRequest.saveRooms(TravelTimes.this.iMatrix.getRooms()), new AsyncCallback<TravelTimeResponse>(){

                    public void onFailure(Throwable caught) {
                        TravelTimes.this.iHeader.setErrorMessage(MESSAGES.failedToSaveMatrix(caught.getMessage()));
                        UniTimeNotifications.error(MESSAGES.failedToSaveMatrix(caught.getMessage()), caught);
                    }

                    public void onSuccess(TravelTimeResponse result) {
                        TravelTimes.this.iHeader.clearMessage();
                        TravelTimes.this.iMatrix.onSaveChanges();
                        TravelTimes.this.iMatrix.setEditable(false);
                        TravelTimes.this.iHeader.setEnabled("save", false);
                        TravelTimes.this.iHeader.setEnabled("back", false);
                        TravelTimes.this.iHeader.setEnabled("edit", true);
                        TravelTimes.this.iShow.setEnabled(true);
                    }
                });
            }
        });
        this.iHeader.addButton("back", MESSAGES.buttonBack(), 75, new ClickHandler(){

            public void onClick(ClickEvent event) {
                TravelTimes.this.iHeader.clearMessage();
                TravelTimes.this.iMatrix.onCancelChanges();
                TravelTimes.this.iMatrix.setEditable(false);
                TravelTimes.this.iHeader.setEnabled("save", false);
                TravelTimes.this.iHeader.setEnabled("back", false);
                TravelTimes.this.iHeader.setEnabled("edit", true);
                TravelTimes.this.iShow.setEnabled(true);
            }
        });
        this.iHeader.addButton("edit", MESSAGES.buttonEdit(), 75, new ClickHandler(){

            public void onClick(ClickEvent event) {
                TravelTimes.this.iHeader.clearMessage();
                TravelTimes.this.iMatrix.setEditable(true);
                TravelTimes.this.iHeader.setEnabled("save", true);
                TravelTimes.this.iHeader.setEnabled("back", true);
                TravelTimes.this.iHeader.setEnabled("edit", false);
                TravelTimes.this.iShow.setEnabled(false);
            }
        });
        this.iHeader.setEnabled("save", false);
        this.iHeader.setEnabled("back", false);
        this.iHeader.setEnabled("edit", false);
        this.iRoomFilter = new RoomFilterBox(new Session());
        this.iRoomFilter.setValue("department:Managed");
        HorizontalPanel hp = new HorizontalPanel();
        hp.setSpacing(4);
        Label label = new Label(MESSAGES.propFilter());
        hp.add((Widget)label);
        hp.setCellVerticalAlignment((Widget)label, HasVerticalAlignment.ALIGN_MIDDLE);
        hp.add((Widget)this.iRoomFilter);
        this.iShow = new AriaButton(MESSAGES.buttonShow());
        this.iShow.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                TravelTimes.this.iHeader.setVisible(true);
                TravelTimes.this.iHeader.setEnabled("edit", false);
                TravelTimes.this.iFooter.setVisible(false);
                TravelTimes.this.iMatrix.clear();
                LoadingWidget.showLoading(MESSAGES.waitLoadingTravelTimes());
                TravelTimes.this.iRoomFilter.getElements(new AsyncCallback<List<EventInterface.FilterRpcResponse.Entity>>(){

                    public void onFailure(Throwable caught) {
                        LoadingWidget.hideLoading();
                        TravelTimes.this.iHeader.setErrorMessage(MESSAGES.failedToLoadRooms(caught.getMessage()));
                        UniTimeNotifications.error(MESSAGES.failedToLoadRooms(caught.getMessage()), caught);
                    }

                    public void onSuccess(List<EventInterface.FilterRpcResponse.Entity> result) {
                        if (result == null || result.isEmpty()) {
                            LoadingWidget.hideLoading();
                            TravelTimes.this.iHeader.setErrorMessage(MESSAGES.errorNoRoomsMatchingFilter());
                        } else if (result.size() == 1) {
                            LoadingWidget.hideLoading();
                            TravelTimes.this.iHeader.setErrorMessage(MESSAGES.errorOnlyOneRoomIsMatchingFilter());
                        } else {
                            TravelTimesRequest request = TravelTimesRequest.loadRooms();
                            for (EventInterface.FilterRpcResponse.Entity e : result) {
                                request.addRoom(new Room(e.getUniqueId(), null));
                            }
                            RPC.execute(request, new AsyncCallback<TravelTimeResponse>(){

                                public void onFailure(Throwable caught) {
                                    LoadingWidget.hideLoading();
                                    TravelTimes.this.iHeader.setErrorMessage(MESSAGES.failedToLoadMatrix(caught.getMessage()));
                                    UniTimeNotifications.error(MESSAGES.failedToLoadMatrix(caught.getMessage()), caught);
                                }

                                public void onSuccess(TravelTimeResponse result) {
                                    TravelTimes.this.iFooter.setVisible(true);
                                    LoadingWidget.hideLoading();
                                    if (result.hasRooms()) {
                                        TravelTimes.this.iMatrix.init(result.getRooms());
                                        TravelTimes.this.iHeader.clearMessage();
                                        TravelTimes.this.iMatrix.setEditable(false);
                                        TravelTimes.this.iHeader.setEnabled("edit", true);
                                    } else {
                                        TravelTimes.this.iHeader.setErrorMessage(MESSAGES.failedToLoadMatrixNoRooms());
                                    }
                                }
                            });
                        }
                    }
                });
            }
        });
        hp.add((Widget)this.iShow);
        hp.setCellVerticalAlignment((Widget)this.iShow, HasVerticalAlignment.ALIGN_MIDDLE);
        this.iShow.setWidth("75px");
        this.iForm.addRow((Widget)hp);
        this.iForm.addHeaderRow((Widget)this.iHeader);
        this.iMatrix = new Matrix();
        ScrollPanel scroll = new ScrollPanel((Widget)this.iMatrix);
        ToolBox.setMaxWidth(scroll.getElement().getStyle(), Window.getClientWidth() - 100 + "px");
        this.iForm.addRow((Widget)scroll);
        this.iFooter = this.iHeader.clonePanel("");
        this.iForm.addBottomRow((Widget)this.iFooter);
        this.iHeader.setVisible(false);
        this.iFooter.setVisible(false);
        this.initWidget((Widget)this.iForm);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TravelTimeResponse
    implements GwtRpcResponse {
        private Long iSessionId;
        private String iSessionName;
        private List<Room> iRooms;

        public TravelTimeResponse() {
        }

        public TravelTimeResponse(List<Room> rooms) {
            this.iRooms = rooms;
        }

        public TravelTimeResponse(Long sessionId, String sessionName) {
            this.iSessionId = sessionId;
            this.iSessionName = sessionName;
        }

        public boolean hasRooms() {
            return this.iRooms != null && !this.iRooms.isEmpty();
        }

        public List<Room> getRooms() {
            return this.iRooms;
        }

        public void addRoom(Room room) {
            if (this.iRooms == null) {
                this.iRooms = new ArrayList<Room>();
            }
            this.iRooms.add(room);
        }

        public Long getSessionId() {
            return this.iSessionId;
        }

        public String getSessionName() {
            return this.iSessionName;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TravelTimesRequest
    implements GwtRpcRequest<TravelTimeResponse> {
        private Command iCommand;
        private List<Room> iRooms;

        public TravelTimesRequest() {
        }

        private TravelTimesRequest(Command command, List<Room> rooms) {
            this.iCommand = command;
            this.iRooms = rooms;
        }

        public static TravelTimesRequest loadRooms() {
            return new TravelTimesRequest(Command.LOAD, null);
        }

        public static TravelTimesRequest saveRooms(List<Room> rooms) {
            return new TravelTimesRequest(Command.SAVE, rooms);
        }

        public static TravelTimesRequest init() {
            return new TravelTimesRequest(Command.INIT, null);
        }

        public Command getCommand() {
            return this.iCommand;
        }

        public boolean hasRooms() {
            return this.iRooms != null && !this.iRooms.isEmpty();
        }

        public List<Room> getRooms() {
            return this.iRooms;
        }

        public void addRoom(Room room) {
            if (this.iRooms == null) {
                this.iRooms = new ArrayList<Room>();
            }
            this.iRooms.add(room);
        }

        @Override
        public String toString() {
            return this.getCommand().name() + (this.hasRooms() ? this.getRooms() : "");
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Command implements IsSerializable
        {
            INIT,
            LOAD,
            SAVE;

        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Session
    implements AcademicSessionProvider {
        private List<AcademicSessionProvider.AcademicSessionChangeHandler> iHandlers = new ArrayList<AcademicSessionProvider.AcademicSessionChangeHandler>();
        private Long iId;
        private String iName;

        private Session() {
            RPC.execute(TravelTimesRequest.init(), new AsyncCallback<TravelTimeResponse>(){

                public void onFailure(Throwable caught) {
                    TravelTimes.this.iHeader.setErrorMessage("Failed to initialize: " + caught.getMessage());
                    ToolBox.checkAccess(caught);
                }

                public void onSuccess(TravelTimeResponse result) {
                    Session.this.iId = result.getSessionId();
                    Session.this.iName = result.getSessionName();
                    Session.this.fireChange();
                }
            });
        }

        @Override
        public void selectSession(Long sessionId, AsyncCallback<Boolean> callback) {
            callback.onSuccess((Object)false);
        }

        @Override
        public String getAcademicSessionName() {
            return this.iName;
        }

        @Override
        public Long getAcademicSessionId() {
            return this.iId;
        }

        @Override
        public void addAcademicSessionChangeHandler(AcademicSessionProvider.AcademicSessionChangeHandler handler) {
            this.iHandlers.add(handler);
        }

        @Override
        public AcademicSessionProvider.AcademicSessionInfo getAcademicSessionInfo() {
            return null;
        }

        private void fireChange() {
            AcademicSessionProvider.AcademicSessionChangeEvent event = new AcademicSessionProvider.AcademicSessionChangeEvent(){

                public Long getNewAcademicSessionId() {
                    return Session.this.iId;
                }

                public Long getOldAcademicSessionId() {
                    return null;
                }

                public boolean isChanged() {
                    return true;
                }
            };
            for (AcademicSessionProvider.AcademicSessionChangeHandler h : this.iHandlers) {
                h.onAcademicSessionChange(event);
            }
        }
    }

    public static class Room
    implements IsSerializable {
        private Long iId;
        private String iName;
        private Building iBuilding;
        private Map<Long, Integer> iTravelTimes = new HashMap<Long, Integer>();
        private Map<Long, Integer> iDistances = new HashMap<Long, Integer>();

        public Room() {
        }

        public Room(Long id, String name) {
            this(id, name, null);
        }

        public Room(Long id, String name, Building building) {
            this.iId = id;
            this.iName = name;
            this.iBuilding = building;
        }

        public Long getId() {
            return this.iId;
        }

        public String getName() {
            return this.iName;
        }

        public boolean hasBuilding() {
            return this.iBuilding != null;
        }

        public Building getBuilding() {
            return this.iBuilding;
        }

        public Integer getTravelTime(Long roomId) {
            return this.iTravelTimes.get(roomId);
        }

        public Integer getTravelTime(Room room) {
            return this.getTravelTime(room.getId());
        }

        public void setTravelTime(Long roomId, Integer time) {
            if (time == null) {
                this.iTravelTimes.remove(roomId);
            } else {
                this.iTravelTimes.put(roomId, time);
            }
        }

        public void setTravelTime(Room room, Integer time) {
            this.setTravelTime(room.getId(), time);
        }

        public Integer getDistance(Long roomId) {
            return this.iDistances.get(roomId);
        }

        public Integer getDistance(Room room) {
            return this.getDistance(room.getId());
        }

        public void setDistance(Long roomId, Integer time) {
            if (time == null) {
                this.iDistances.remove(roomId);
            } else {
                this.iDistances.put(roomId, time);
            }
        }

        public void setDistance(Room room, Integer time) {
            this.setDistance(room.getId(), time);
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof Room)) {
                return false;
            }
            return this.getId().equals(((Room)o).getId());
        }
    }

    public static class Building
    implements IsSerializable {
        private Long iId;
        private String iName;

        public Building() {
        }

        public Building(Long id, String name) {
            this.iId = id;
            this.iName = name;
        }

        public Long getId() {
            return this.iId;
        }

        public String getName() {
            return this.iName;
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof Building)) {
                return false;
            }
            return this.getId().equals(((Building)o).getId());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Time
    extends TextBox {
        private Time iOther = null;
        private int iRow;
        private int iCol;
        private Room iR1;
        private Room iR2;
        private boolean iDefault = false;
        private Integer iInitialTravel = null;

        public Time(int row, int col) {
            this.iRow = row;
            this.iCol = col;
            this.setReadOnly(true);
            this.setEnabled(false);
            this.setStyleName("gwt-SuggestBox");
            this.addStyleName("cell");
            this.addStyleName("disabled");
        }

        public Time(int row, int col, Room r1, Room r2) {
            this.iRow = row;
            this.iCol = col;
            this.setStyleName("gwt-SuggestBox");
            this.addStyleName("cell");
            this.iR1 = r1;
            this.iR2 = r2;
            this.iInitialTravel = r1.getTravelTime(r2.getId());
            if (this.iInitialTravel == null) {
                Integer distance = r1.getDistance(r2.getId());
                if (distance != null) {
                    this.setValue(distance.toString());
                    this.iDefault = true;
                    this.addStyleName("default");
                }
            } else {
                this.setValue(this.iInitialTravel.toString());
            }
            final PopupPanel popup = new PopupPanel(true, false);
            popup.setStyleName("unitime-PopupHint");
            popup.add((Widget)new P(r1.getName() + " &harr; " + r2.getName(), new String[0]));
            this.addFocusHandler(new FocusHandler(){

                public void onFocus(FocusEvent event) {
                    if (!popup.isShowing()) {
                        popup.showRelativeTo((UIObject)Time.this);
                    }
                    if (Time.this.iDefault) {
                        Time.this.removeStyleName("default");
                    }
                }
            });
            this.addBlurHandler(new BlurHandler(){

                public void onBlur(BlurEvent event) {
                    if (popup.isShowing()) {
                        popup.hide();
                    }
                    if (Time.this.iDefault) {
                        Time.this.addStyleName("default");
                    }
                }
            });
            this.setMaxLength(3);
            this.addKeyDownHandler(TravelTimes.this.iKeyDownHandler);
            this.addKeyPressHandler(TravelTimes.this.iKeyPressHandler);
        }

        public void onCancelChanges() {
            if (this.iRow == this.iCol) {
                return;
            }
            this.iR1.setTravelTime(this.iR2, this.iInitialTravel);
            if (this.iInitialTravel == null) {
                Integer distance = this.iR1.getDistance(this.iR2.getId());
                if (distance != null) {
                    this.setValue(distance.toString());
                    this.iDefault = true;
                    this.addStyleName("default");
                }
            } else {
                this.setValue(this.iInitialTravel.toString());
            }
        }

        public void onSaveChanges() {
            if (this.iRow == this.iCol) {
                return;
            }
            this.iInitialTravel = this.iR1.getTravelTime(this.iR2);
        }

        private void onChange(ValueChangeEvent<String> event) {
            Integer travel = null;
            try {
                if (!((String)event.getValue()).isEmpty()) {
                    travel = Integer.valueOf((String)event.getValue());
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            this.iR1.setTravelTime(this.iR2, travel);
            if (travel != null) {
                if (this.iDefault) {
                    this.iDefault = false;
                    this.removeStyleName("default");
                }
            } else {
                Integer distance = this.iR1.getDistance(this.iR2.getId());
                if (distance != null) {
                    this.setValue(distance.toString());
                    this.iDefault = true;
                    this.addStyleName("default");
                }
            }
        }

        public int getRow() {
            return this.iRow;
        }

        public int getColumn() {
            return this.iCol;
        }

        public void setOther(Time other) {
            this.iOther = other;
            this.iOther.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

                public void onValueChange(ValueChangeEvent<String> event) {
                    Time.this.setValue(event.getValue());
                    Time.this.iOther.onChange((ValueChangeEvent<String>)event);
                    Time.this.onChange((ValueChangeEvent<String>)event);
                }
            });
            other.iOther = this;
            this.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

                public void onValueChange(ValueChangeEvent<String> event) {
                    Time.this.iOther.setValue(event.getValue());
                    Time.this.iOther.onChange((ValueChangeEvent<String>)event);
                    Time.this.onChange((ValueChangeEvent<String>)event);
                }
            });
        }

        public Room getFirstRoom() {
            return this.iR1;
        }

        public Room getSecondRoom() {
            return this.iR2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Matrix
    extends FlexTable {
        private List<Room> iRooms;

        public Matrix() {
            this.setStyleName("unitime-TravelTimes");
            this.setCellPadding(0);
            this.setCellSpacing(1);
        }

        public void clear() {
            for (int row = this.getRowCount() - 1; row >= 0; --row) {
                this.removeRow(row);
            }
        }

        public void init(List<Room> rooms) {
            this.iRooms = rooms;
            this.clear();
            int col = 1;
            int row = 0;
            for (Room room : this.getRooms()) {
                this.setWidget(row, col, (Widget)new P(room.getName(), new String[]{"horizontal-header"}));
                this.getCellFormatter().setVerticalAlignment(row, col, HasVerticalAlignment.ALIGN_BOTTOM);
                ++col;
            }
            boolean rMark = false;
            Building prev = null;
            for (Room room : this.getRooms()) {
                col = 0;
                if (++row > 1) {
                    if (prev == null) {
                        if (room.getBuilding() != null) {
                            rMark = !rMark;
                        }
                    } else if (!prev.equals(room.getBuilding())) {
                        rMark = !rMark;
                    }
                }
                this.setWidget(row, col, (Widget)new P(room.getName(), new String[]{"vertical-header"}));
                this.getCellFormatter().setHorizontalAlignment(row, col, HasHorizontalAlignment.ALIGN_RIGHT);
                ++col;
                Building otherPrev = null;
                boolean cMark = false;
                for (Room other : this.getRooms()) {
                    if (col > 1) {
                        if (otherPrev == null) {
                            if (other.getBuilding() != null) {
                                cMark = !cMark;
                            }
                        } else if (!otherPrev.equals(other.getBuilding())) {
                            boolean bl = cMark = !cMark;
                        }
                    }
                    if (row == col) {
                        this.setWidget(row, col, (Widget)new Time(row, col));
                        ++col;
                    } else {
                        Time cell = new Time(row, col, room, other);
                        if (row > col) {
                            cell.setOther((Time)this.getWidget(col, row));
                            if (rMark) {
                                cell.addStyleName("mark");
                            }
                        } else if (cMark) {
                            cell.addStyleName("mark");
                        }
                        this.setWidget(row, col++, (Widget)cell);
                    }
                    otherPrev = other.getBuilding();
                }
                prev = room.getBuilding();
                this.setWidget(row, col, (Widget)new P(room.getName(), new String[]{"vertical-header"}));
                this.getCellFormatter().setHorizontalAlignment(row, col, HasHorizontalAlignment.ALIGN_LEFT);
            }
            col = 1;
            ++row;
            for (Room room : this.getRooms()) {
                this.setWidget(row, col, (Widget)new P(room.getName(), new String[]{"horizontal-header"}));
                this.getCellFormatter().setVerticalAlignment(row, col, HasVerticalAlignment.ALIGN_TOP);
                ++col;
            }
        }

        public List<Room> getRooms() {
            return this.iRooms;
        }

        public void setEditable(boolean editable) {
            for (int row = 1; row < this.getRowCount() - 1; ++row) {
                for (int col = 1; col < this.getCellCount(row) - 1; ++col) {
                    Time time = (Time)this.getWidget(row, col);
                    if (editable) {
                        time.getElement().getStyle().clearBorderColor();
                        time.setReadOnly(row == col);
                        continue;
                    }
                    time.getElement().getStyle().setBorderColor("transparent");
                    time.setReadOnly(true);
                }
            }
        }

        public void onCancelChanges() {
            for (int row = 1; row < this.getRowCount() - 1; ++row) {
                for (int col = 1; col < this.getCellCount(row) - 1; ++col) {
                    Time time = (Time)this.getWidget(row, col);
                    time.onCancelChanges();
                }
            }
        }

        public void onSaveChanges() {
            for (int row = 1; row < this.getRowCount() - 1; ++row) {
                for (int col = 1; col < this.getCellCount(row) - 1; ++col) {
                    Time time = (Time)this.getWidget(row, col);
                    time.onSaveChanges();
                }
            }
        }
    }

    public static class P
    extends AbsolutePanel
    implements HasMouseDownHandlers {
        private String iCaption;

        private P(String caption, String ... styles) {
            this.iCaption = caption;
            if (caption != null) {
                this.getElement().setInnerHTML(caption);
            }
            for (String style : styles) {
                if (style == null || style.isEmpty()) continue;
                this.addStyleName(style);
            }
            this.sinkEvents(4);
        }

        public void onBrowserEvent(Event event) {
            switch (DOM.eventGetType((Event)event)) {
                case 4: {
                    MouseDownEvent.fireNativeEvent((NativeEvent)event, (HasHandlers)this);
                    event.stopPropagation();
                    event.preventDefault();
                }
            }
        }

        public HandlerRegistration addMouseDownHandler(MouseDownHandler handler) {
            return this.addHandler((EventHandler)handler, (GwtEvent.Type)MouseDownEvent.getType());
        }

        public String getCaption() {
            return this.iCaption;
        }
    }
}

