/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.reservations;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.AbsolutePanel;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.unitime.timetable.gwt.client.events.SingleDateSelector;
import org.unitime.timetable.gwt.client.events.UniTimeFilterBox;
import org.unitime.timetable.gwt.client.widgets.FilterBox;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.EventInterface;
import org.unitime.timetable.gwt.shared.ReservationInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReservationFilterBox
extends UniTimeFilterBox<ReservationInterface.ReservationFilterRpcRequest> {
    private static final GwtConstants CONSTANTS = (GwtConstants)GWT.create(GwtConstants.class);
    private static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    private static DateTimeFormat sDateFormat = DateTimeFormat.getFormat((String)CONSTANTS.eventDateFormat());
    private ListBox iDepartments;
    private ListBox iSubjects;

    public ReservationFilterBox() {
        super(null);
        this.setShowSuggestionsOnFocus(false);
        FilterBox.StaticSimpleFilter mode = new FilterBox.StaticSimpleFilter("mode", new String[0]);
        mode.setMultipleSelection(false);
        this.addFilter(mode);
        this.addFilter(new FilterBox.StaticSimpleFilter("type", new String[0]));
        this.iDepartments = new ListBox(false);
        this.iDepartments.setWidth("100%");
        this.addFilter(new FilterBox.CustomFilter("department", new Widget[]{this.iDepartments}){

            @Override
            public void getSuggestions(List<FilterBox.Chip> chips, String text, AsyncCallback<Collection<FilterBox.Suggestion>> callback) {
                if (text.isEmpty()) {
                    callback.onSuccess(null);
                } else {
                    FilterBox.Chip oldChip = ReservationFilterBox.this.getChip("department");
                    ArrayList<FilterBox.Suggestion> suggestions = new ArrayList<FilterBox.Suggestion>();
                    for (int i = 0; i < ReservationFilterBox.this.iDepartments.getItemCount(); ++i) {
                        if (ReservationFilterBox.this.iDepartments.getItemText(i).endsWith(" (0)")) continue;
                        FilterBox.Chip chip = new FilterBox.Chip("department", ReservationFilterBox.this.iDepartments.getValue(i));
                        String name = ReservationFilterBox.this.iDepartments.getItemText(i);
                        if (ReservationFilterBox.this.iDepartments.getValue(i).toLowerCase().startsWith(text.toLowerCase())) {
                            suggestions.add(new FilterBox.Suggestion(name, chip, oldChip));
                            continue;
                        }
                        if (text.length() <= 2 || !name.toLowerCase().contains(" " + text.toLowerCase()) && !name.toLowerCase().contains(" (" + text.toLowerCase())) continue;
                        suggestions.add(new FilterBox.Suggestion(name, chip, oldChip));
                    }
                    callback.onSuccess(suggestions);
                }
            }
        });
        this.iDepartments.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                FilterBox.Chip newChip;
                FilterBox.Chip subjectChip = ReservationFilterBox.this.getChip("subject");
                while (subjectChip != null && ReservationFilterBox.this.iDepartments.getSelectedIndex() > 1) {
                    ReservationFilterBox.this.removeChip(subjectChip, false);
                    subjectChip = ReservationFilterBox.this.getChip("subject");
                }
                FilterBox.Chip oldChip = ReservationFilterBox.this.getChip("department");
                FilterBox.Chip chip = newChip = ReservationFilterBox.this.iDepartments.getSelectedIndex() <= 0 ? null : new FilterBox.Chip("department", ReservationFilterBox.this.iDepartments.getValue(ReservationFilterBox.this.iDepartments.getSelectedIndex()));
                if (oldChip != null) {
                    if (newChip == null) {
                        ReservationFilterBox.this.removeChip(oldChip, true);
                    } else if (!oldChip.getValue().equals(newChip.getValue())) {
                        ReservationFilterBox.this.removeChip(oldChip, false);
                        ReservationFilterBox.this.addChip(newChip, true);
                    }
                } else if (newChip != null) {
                    ReservationFilterBox.this.addChip(newChip, true);
                }
            }
        });
        this.iSubjects = new ListBox(true);
        this.iSubjects.setWidth("100%");
        this.iSubjects.setVisibleItemCount(3);
        this.addFilter(new FilterBox.CustomFilter("subject", new Widget[]{this.iSubjects}){

            @Override
            public void getSuggestions(List<FilterBox.Chip> chips, String text, AsyncCallback<Collection<FilterBox.Suggestion>> callback) {
                if (text.isEmpty()) {
                    callback.onSuccess(null);
                } else {
                    FilterBox.Chip deptChip = ReservationFilterBox.this.getChip("department");
                    ArrayList<FilterBox.Suggestion> suggestions = new ArrayList<FilterBox.Suggestion>();
                    for (int i = 0; i < ReservationFilterBox.this.iSubjects.getItemCount(); ++i) {
                        if (ReservationFilterBox.this.iSubjects.getItemText(i).endsWith(" (0)")) continue;
                        FilterBox.Chip chip = new FilterBox.Chip("subject", ReservationFilterBox.this.iSubjects.getValue(i));
                        String name = ReservationFilterBox.this.iSubjects.getItemText(i);
                        if (ReservationFilterBox.this.iSubjects.getValue(i).toLowerCase().startsWith(text.toLowerCase())) {
                            suggestions.add(new FilterBox.Suggestion(name, chip, deptChip));
                            continue;
                        }
                        if (text.length() <= 2 || !name.toLowerCase().contains(" " + text.toLowerCase()) && !name.toLowerCase().contains(" (" + text.toLowerCase())) continue;
                        suggestions.add(new FilterBox.Suggestion(name, chip, deptChip));
                    }
                    callback.onSuccess(suggestions);
                }
            }
        });
        this.iSubjects.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                boolean changed = false;
                FilterBox.Chip deptChip = ReservationFilterBox.this.getChip("department");
                for (int i = 0; i < ReservationFilterBox.this.iSubjects.getItemCount(); ++i) {
                    FilterBox.Chip chip = new FilterBox.Chip("subject", ReservationFilterBox.this.iSubjects.getValue(i));
                    if (ReservationFilterBox.this.iSubjects.isItemSelected(i)) {
                        if (!ReservationFilterBox.this.hasChip(chip)) {
                            ReservationFilterBox.this.addChip(chip, false);
                            changed = true;
                        }
                        if (deptChip == null || ReservationFilterBox.this.iSubjects.getSelectedIndex() <= 1) continue;
                        ReservationFilterBox.this.removeChip(deptChip, false);
                        deptChip = null;
                        changed = true;
                        continue;
                    }
                    if (!ReservationFilterBox.this.hasChip(chip)) continue;
                    ReservationFilterBox.this.removeChip(chip, false);
                    changed = true;
                }
                if (changed) {
                    ReservationFilterBox.this.fireValueChangeEvent();
                }
            }
        });
        this.addFilter(new FilterBox.StaticSimpleFilter("area", new String[0]));
        this.addFilter(new FilterBox.StaticSimpleFilter("group", new String[0]));
        AbsolutePanel m = new AbsolutePanel();
        m.setStyleName("unitime-DateSelector");
        final SingleDateSelector.SingleMonth m1 = new SingleDateSelector.SingleMonth("Before");
        m1.setAllowDeselect(true);
        final SingleDateSelector.SingleMonth m2 = new SingleDateSelector.SingleMonth("After");
        m2.setAllowDeselect(true);
        m.add((Widget)m2);
        m.add((Widget)m1);
        this.addFilter(new FilterBox.CustomFilter("date", new Widget[]{m}){

            @Override
            public void getSuggestions(List<FilterBox.Chip> chips, String text, AsyncCallback<Collection<FilterBox.Suggestion>> callback) {
                Date date;
                ArrayList<FilterBox.Suggestion> suggestions = new ArrayList<FilterBox.Suggestion>();
                FilterBox.Chip chFrom = null;
                FilterBox.Chip chTo = null;
                for (FilterBox.Chip c : chips) {
                    if (c.getCommand().equals("before")) {
                        chFrom = c;
                    }
                    if (!c.getCommand().equals("after")) continue;
                    chTo = c;
                }
                try {
                    date = DateTimeFormat.getFormat((String)"MM/dd").parse(text);
                    suggestions.add(new FilterBox.Suggestion(new FilterBox.Chip("before", sDateFormat.format(date)), chFrom));
                    suggestions.add(new FilterBox.Suggestion(new FilterBox.Chip("after", sDateFormat.format(date)), chTo));
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    date = DateTimeFormat.getFormat((String)"dd.MM").parse(text);
                    suggestions.add(new FilterBox.Suggestion(new FilterBox.Chip("before", sDateFormat.format(date)), chFrom));
                    suggestions.add(new FilterBox.Suggestion(new FilterBox.Chip("after", sDateFormat.format(date)), chTo));
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    date = DateTimeFormat.getFormat((String)"MM/dd/yy").parse(text);
                    suggestions.add(new FilterBox.Suggestion(new FilterBox.Chip("before", sDateFormat.format(date)), chFrom));
                    suggestions.add(new FilterBox.Suggestion(new FilterBox.Chip("after", sDateFormat.format(date)), chTo));
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    date = DateTimeFormat.getFormat((String)"dd.MM.yy").parse(text);
                    suggestions.add(new FilterBox.Suggestion(new FilterBox.Chip("before", sDateFormat.format(date)), chFrom));
                    suggestions.add(new FilterBox.Suggestion(new FilterBox.Chip("after", sDateFormat.format(date)), chTo));
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    date = DateTimeFormat.getFormat((String)"MMM dd").parse(text);
                    suggestions.add(new FilterBox.Suggestion(new FilterBox.Chip("before", sDateFormat.format(date)), chFrom));
                    suggestions.add(new FilterBox.Suggestion(new FilterBox.Chip("after", sDateFormat.format(date)), chTo));
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    date = DateTimeFormat.getFormat((String)"MMM dd yy").parse(text);
                    suggestions.add(new FilterBox.Suggestion(new FilterBox.Chip("before", sDateFormat.format(date)), chFrom));
                    suggestions.add(new FilterBox.Suggestion(new FilterBox.Chip("after", sDateFormat.format(date)), chTo));
                }
                catch (Exception e) {
                    // empty catch block
                }
                callback.onSuccess(suggestions);
            }
        });
        this.addFilter(new FilterBox.StaticSimpleFilter("before", new String[0]));
        this.addFilter(new FilterBox.StaticSimpleFilter("after", new String[0]));
        m1.addValueChangeHandler(new ValueChangeHandler<Date>(){

            public void onValueChange(ValueChangeEvent<Date> event) {
                FilterBox.Chip ch = ReservationFilterBox.this.getChip("before");
                if (event.getValue() == null) {
                    if (ch != null) {
                        ReservationFilterBox.this.removeChip(ch, true);
                    }
                } else {
                    String text = m1.toString();
                    if (ch != null) {
                        if (ch.getCommand().equals(text)) {
                            return;
                        }
                        ReservationFilterBox.this.removeChip(ch, false);
                    }
                    ReservationFilterBox.this.addChip(new FilterBox.Chip("before", text), true);
                }
            }
        });
        m2.addValueChangeHandler(new ValueChangeHandler<Date>(){

            public void onValueChange(ValueChangeEvent<Date> event) {
                FilterBox.Chip ch = ReservationFilterBox.this.getChip("after");
                if (event.getValue() == null) {
                    if (ch != null) {
                        ReservationFilterBox.this.removeChip(ch, true);
                    }
                } else {
                    String text = m2.toString();
                    if (ch != null) {
                        if (ch.getCommand().equals(text)) {
                            return;
                        }
                        ReservationFilterBox.this.removeChip(ch, false);
                    }
                    ReservationFilterBox.this.addChip(new FilterBox.Chip("after", text), true);
                }
            }
        });
        this.addValueChangeHandler(new ValueChangeHandler<String>(){

            public void onValueChange(ValueChangeEvent<String> event) {
                if (!ReservationFilterBox.this.isFilterPopupShowing()) {
                    String value;
                    int i;
                    ReservationFilterBox.this.iDepartments.setSelectedIndex(0);
                    for (i = 1; i < ReservationFilterBox.this.iDepartments.getItemCount(); ++i) {
                        value = ReservationFilterBox.this.iDepartments.getValue(i);
                        if (!ReservationFilterBox.this.hasChip(new FilterBox.Chip("department", value))) continue;
                        ReservationFilterBox.this.iDepartments.setSelectedIndex(i);
                        break;
                    }
                    for (i = 0; i < ReservationFilterBox.this.iSubjects.getItemCount(); ++i) {
                        value = ReservationFilterBox.this.iSubjects.getValue(i);
                        ReservationFilterBox.this.iSubjects.setItemSelected(i, ReservationFilterBox.this.hasChip(new FilterBox.Chip("subject", value)));
                    }
                    FilterBox.Chip chFrom = ReservationFilterBox.this.getChip("before");
                    if (chFrom != null) {
                        m1.setDate(sDateFormat.parse(chFrom.getValue()));
                    } else {
                        m1.clearSelection();
                    }
                    FilterBox.Chip chTo = ReservationFilterBox.this.getChip("after");
                    if (chTo != null) {
                        m2.setDate(sDateFormat.parse(chTo.getValue()));
                    } else {
                        m2.clearSelection();
                    }
                }
                ReservationFilterBox.this.init(false, ReservationFilterBox.this.getAcademicSessionId(), new Command(){

                    public void execute() {
                        if (ReservationFilterBox.this.isFilterPopupShowing()) {
                            ReservationFilterBox.this.showFilterPopup();
                        }
                    }
                });
            }
        });
        this.addFilter(new FilterBox.StaticSimpleFilter("student", new String[0]));
    }

    @Override
    protected boolean populateFilter(FilterBox.Filter filter, List<EventInterface.FilterRpcResponse.Entity> entities) {
        if ("department".equals(filter.getCommand())) {
            this.iDepartments.clear();
            this.iDepartments.addItem(MESSAGES.itemAllDepartments(), "");
            if (entities != null) {
                for (EventInterface.FilterRpcResponse.Entity entity : entities) {
                    this.iDepartments.addItem(entity.getName() + " (" + entity.getCount() + ")", entity.getAbbreviation());
                }
            }
            this.iDepartments.setSelectedIndex(0);
            FilterBox.Chip dept = this.getChip("department");
            if (dept != null) {
                for (int i = 1; i < this.iDepartments.getItemCount(); ++i) {
                    if (!dept.getValue().equals(this.iDepartments.getValue(i))) continue;
                    this.iDepartments.setSelectedIndex(i);
                    break;
                }
            }
            return true;
        }
        if ("subject".equals(filter.getCommand())) {
            this.iSubjects.clear();
            if (entities != null) {
                for (EventInterface.FilterRpcResponse.Entity entity : entities) {
                    this.iSubjects.addItem(entity.getName() + " (" + entity.getCount() + ")", entity.getAbbreviation());
                }
            }
            for (int i = 0; i < this.iSubjects.getItemCount(); ++i) {
                String value = this.iSubjects.getValue(i);
                this.iSubjects.setItemSelected(i, this.hasChip(new FilterBox.Chip("subject", value)));
            }
            return true;
        }
        if (filter != null && filter instanceof FilterBox.StaticSimpleFilter) {
            FilterBox.StaticSimpleFilter simple = (FilterBox.StaticSimpleFilter)filter;
            ArrayList<FilterBox.Chip> chips = new ArrayList<FilterBox.Chip>();
            if (entities != null) {
                for (EventInterface.FilterRpcResponse.Entity entity : entities) {
                    chips.add(new FilterBox.Chip(filter.getCommand(), entity.getAbbreviation(), entity.getName(), entity.getCount() <= 0 ? null : "(" + entity.getCount() + ")"));
                }
            }
            simple.setValues(chips);
            return true;
        }
        return false;
    }

    @Override
    public ReservationInterface.ReservationFilterRpcRequest createRpcRequest() {
        return new ReservationInterface.ReservationFilterRpcRequest();
    }
}

