/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.curricula;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.MenuBar;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.UIObject;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.client.aria.AriaButton;
import org.unitime.timetable.gwt.client.curricula.CurriculaClassifications;
import org.unitime.timetable.gwt.client.curricula.CurriculumCookie;
import org.unitime.timetable.gwt.client.curricula.CurriculumProjectionRulesPage;
import org.unitime.timetable.gwt.client.page.UniTimeNotifications;
import org.unitime.timetable.gwt.client.widgets.LoadingWidget;
import org.unitime.timetable.gwt.client.widgets.UniTimeDialogBox;
import org.unitime.timetable.gwt.client.widgets.UniTimeTable;
import org.unitime.timetable.gwt.client.widgets.UniTimeTableHeader;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.resources.GwtResources;
import org.unitime.timetable.gwt.services.CurriculaService;
import org.unitime.timetable.gwt.services.CurriculaServiceAsync;
import org.unitime.timetable.gwt.shared.CurriculumInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CurriculaTable
extends Composite {
    protected static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    public static final GwtResources RESOURCES = (GwtResources)GWT.create(GwtResources.class);
    private final CurriculaServiceAsync iService = (CurriculaServiceAsync)GWT.create(CurriculaService.class);
    private VerticalPanel iPanel = null;
    private Image iLoadingImage = null;
    private Label iErrorLabel = null;
    private UniTimeTable<CurriculumInterface> iTable = null;
    private CurriculumInterface.CurriculumFilterRpcRequest iLastQuery = null;
    private AriaButton iOperations = null;
    private AsyncCallback<List<CurriculumInterface.CurriculumClassificationInterface>> iLoadClassifications;
    private List<CurriculumClickHandler> iCurriculumClickHandlers = new ArrayList<CurriculumClickHandler>();
    private Comparator<CurriculumInterface> iLastSort = null;
    private UniTimeTableHeader iLastSortHeader = null;
    private Boolean iLastSortOrder = true;
    private Long iLastCurriculumId = null;
    private CurriculaClassifications iClassifications = null;
    private PopupPanel iClassificationsPopup = null;
    private HashSet<Long> iSelectedCurricula = new HashSet();
    private boolean iIsAdmin = false;
    private EditClassificationHandler iEditClassificationHandler = null;

    public CurriculaTable() {
        this.iOperations = new AriaButton(MESSAGES.buttonMoreOperations());
        this.iOperations.addStyleName("unitime-NoPrint");
        this.iTable = new UniTimeTable();
        ArrayList<UniTimeTableHeader> header = new ArrayList<UniTimeTableHeader>();
        final UniTimeTableHeader hSelect = new UniTimeTableHeader("&otimes;", HasHorizontalAlignment.ALIGN_CENTER);
        header.add(hSelect);
        hSelect.setWidth("10px");
        hSelect.addAdditionalStyleName("unitime-NoPrint");
        hSelect.addOperation(new UniTimeTableHeader.Operation(){

            public String getName() {
                return MESSAGES.opSelectAll();
            }

            public boolean hasSeparator() {
                return false;
            }

            public boolean isApplicable() {
                return true;
            }

            public void execute() {
                CurriculaTable.this.iSelectedCurricula.clear();
                for (int row = 0; row < CurriculaTable.this.iTable.getRowCount(); ++row) {
                    CurriculumInterface c = (CurriculumInterface)CurriculaTable.this.iTable.getData(row);
                    if (c == null || !c.isEditable()) continue;
                    CurriculaTable.this.iSelectedCurricula.add(c.getId());
                    ((CheckBox)CurriculaTable.this.iTable.getWidget(row, 0)).setValue(Boolean.valueOf(true));
                }
            }
        });
        hSelect.addOperation(new UniTimeTableHeader.Operation(){

            public String getName() {
                return MESSAGES.opClearSelection();
            }

            public boolean hasSeparator() {
                return false;
            }

            public boolean isApplicable() {
                return true;
            }

            public void execute() {
                CurriculaTable.this.iSelectedCurricula.clear();
                for (int row = 0; row < CurriculaTable.this.iTable.getRowCount(); ++row) {
                    CurriculumInterface c = (CurriculumInterface)CurriculaTable.this.iTable.getData(row);
                    if (c == null || !c.isEditable()) continue;
                    ((CheckBox)CurriculaTable.this.iTable.getWidget(row, 0)).setValue(Boolean.valueOf(false));
                }
            }
        });
        hSelect.addOperation(new UniTimeTableHeader.Operation(){

            public String getName() {
                return MESSAGES.opEditRequestedEnrollments();
            }

            public boolean hasSeparator() {
                return true;
            }

            public boolean isApplicable() {
                if (CurriculaTable.this.iSelectedCurricula.size() <= 1 || CurriculaTable.this.iEditClassificationHandler == null) {
                    return false;
                }
                for (CurriculumInterface c : CurriculaTable.this.selected()) {
                    if (c.hasClassifications()) continue;
                    return false;
                }
                return true;
            }

            public void execute() {
                CurriculaTable.this.iEditClassificationHandler.doEdit(CurriculaTable.this.selected());
            }
        });
        hSelect.addOperation(new UniTimeTableHeader.Operation(){

            public String getName() {
                return MESSAGES.opDeleteSelectedCurricula();
            }

            public boolean hasSeparator() {
                return false;
            }

            public boolean isApplicable() {
                return !CurriculaTable.this.iSelectedCurricula.isEmpty();
            }

            public void execute() {
                Set<Long> deleteIds = CurriculaTable.this.markSelected();
                if (!deleteIds.isEmpty()) {
                    if (Window.confirm((String)(deleteIds.size() == 1 ? MESSAGES.confirmDeleteSelectedCurriculum() : MESSAGES.confirmDeleteSelectedCurricula()))) {
                        LoadingWidget.getInstance().show(MESSAGES.waitDeletingSelectedCurricula());
                        CurriculaTable.this.iService.deleteCurricula(deleteIds, new AsyncCallback<Boolean>(){

                            public void onFailure(Throwable caught) {
                                LoadingWidget.getInstance().hide();
                                CurriculaTable.this.setError(MESSAGES.failedToDeleteSelectedCurricula(caught.getMessage()));
                                UniTimeNotifications.error(MESSAGES.failedToDeleteSelectedCurricula(caught.getMessage()), caught);
                                CurriculaTable.this.unmarkSelected();
                            }

                            public void onSuccess(Boolean result) {
                                LoadingWidget.getInstance().hide();
                                CurriculaTable.this.iSelectedCurricula.clear();
                                CurriculaTable.this.query(CurriculaTable.this.iLastQuery, null);
                            }
                        });
                    } else {
                        CurriculaTable.this.unmarkSelected();
                    }
                }
            }
        });
        hSelect.addOperation(new UniTimeTableHeader.Operation(){

            public String getName() {
                return MESSAGES.opMergeSelectedCurricula();
            }

            public boolean hasSeparator() {
                return false;
            }

            public boolean isApplicable() {
                if (CurriculaTable.this.iSelectedCurricula.size() <= 1) {
                    return false;
                }
                Long areaId = null;
                Long deptId = null;
                for (CurriculumInterface c : CurriculaTable.this.selected()) {
                    if (areaId == null) {
                        areaId = c.getAcademicArea().getId();
                    } else if (!areaId.equals(c.getAcademicArea().getId())) {
                        return false;
                    }
                    if (deptId == null) {
                        deptId = c.getDepartment().getId();
                        continue;
                    }
                    if (deptId.equals(c.getDepartment().getId())) continue;
                    return false;
                }
                return true;
            }

            public void execute() {
                Set<Long> mergeIds = CurriculaTable.this.markSelected();
                if (!mergeIds.isEmpty()) {
                    if (Window.confirm((String)(mergeIds.size() == 1 ? MESSAGES.confirmMergeSelectedCurriculum() : MESSAGES.confirmMergeSelectedCurricula()))) {
                        LoadingWidget.getInstance().show(MESSAGES.waitMergingSelectedCurricula());
                        CurriculaTable.this.iService.mergeCurricula(mergeIds, new AsyncCallback<Boolean>(){

                            public void onFailure(Throwable caught) {
                                LoadingWidget.getInstance().hide();
                                CurriculaTable.this.setError(MESSAGES.failedToMergeSelectedCurricula(caught.getMessage()));
                                UniTimeNotifications.error(MESSAGES.failedToMergeSelectedCurricula(caught.getMessage()), caught);
                                CurriculaTable.this.unmarkSelected();
                            }

                            public void onSuccess(Boolean result) {
                                LoadingWidget.getInstance().hide();
                                CurriculaTable.this.iSelectedCurricula.clear();
                                CurriculaTable.this.query(CurriculaTable.this.iLastQuery, null);
                            }
                        });
                    } else {
                        CurriculaTable.this.unmarkSelected();
                    }
                }
            }
        });
        hSelect.addOperation(new UniTimeTableHeader.Operation(){

            public String getName() {
                return MESSAGES.opCurriculumProjectionRules();
            }

            public boolean hasSeparator() {
                return true;
            }

            public boolean isApplicable() {
                return true;
            }

            public void execute() {
                CurriculaTable.this.openCurriculumProjectionRules();
            }
        });
        hSelect.addOperation(new UniTimeTableHeader.Operation(){

            public String getName() {
                return MESSAGES.opUpdateRequestedEnrollmentByProjectionRules();
            }

            public boolean hasSeparator() {
                return false;
            }

            public boolean isApplicable() {
                return true;
            }

            public void execute() {
                Set<Long> curIds = CurriculaTable.this.markSelected();
                if (CurriculaTable.this.iSelectedCurricula.isEmpty()) {
                    curIds = null;
                }
                String string = curIds == null ? (CurriculaTable.this.iIsAdmin ? MESSAGES.confirmUpdateAllCurricula() : MESSAGES.confirmUpdateYourCurricula()) : (curIds.size() == 1 ? MESSAGES.confirmUpdateSelectedCurriculum() : MESSAGES.confirmUpdateSelectedCurricula());
                if (Window.confirm((String)string)) {
                    LoadingWidget.getInstance().show(MESSAGES.waitUpdatingCurricula(), 300000);
                    CurriculaTable.this.iService.updateCurriculaByProjections(curIds, false, new AsyncCallback<Boolean>(){

                        public void onFailure(Throwable caught) {
                            LoadingWidget.getInstance().hide();
                            CurriculaTable.this.setError(MESSAGES.failedToUpdateCurricula(caught.getMessage()));
                            UniTimeNotifications.error(MESSAGES.failedToUpdateCurricula(caught.getMessage()), caught);
                            CurriculaTable.this.unmarkSelected();
                        }

                        public void onSuccess(Boolean result) {
                            LoadingWidget.getInstance().hide();
                            CurriculaTable.this.query(CurriculaTable.this.iLastQuery, null);
                        }
                    });
                } else {
                    CurriculaTable.this.unmarkSelected();
                }
            }
        });
        hSelect.addOperation(new UniTimeTableHeader.Operation(){

            public String getName() {
                return MESSAGES.opUpdateRequestedEnrollmentAndCourseProjections();
            }

            public boolean hasSeparator() {
                return false;
            }

            public boolean isApplicable() {
                return true;
            }

            public void execute() {
                Set<Long> curIds = CurriculaTable.this.markSelected();
                if (CurriculaTable.this.iSelectedCurricula.isEmpty()) {
                    curIds = null;
                }
                String string = curIds == null ? (CurriculaTable.this.iIsAdmin ? MESSAGES.confirmUpdateAllCurricula() : MESSAGES.confirmUpdateYourCurricula()) : (curIds.size() == 1 ? MESSAGES.confirmUpdateSelectedCurriculum() : MESSAGES.confirmUpdateSelectedCurricula());
                if (Window.confirm((String)string)) {
                    LoadingWidget.getInstance().show(MESSAGES.waitUpdatingCurricula(), 300000);
                    CurriculaTable.this.iService.updateCurriculaByProjections(curIds, true, new AsyncCallback<Boolean>(){

                        public void onFailure(Throwable caught) {
                            LoadingWidget.getInstance().hide();
                            CurriculaTable.this.setError(MESSAGES.failedToUpdateCurricula(caught.getMessage()));
                            UniTimeNotifications.error(MESSAGES.failedToUpdateCurricula(caught.getMessage()), caught);
                            CurriculaTable.this.unmarkSelected();
                        }

                        public void onSuccess(Boolean result) {
                            LoadingWidget.getInstance().hide();
                            CurriculaTable.this.query(CurriculaTable.this.iLastQuery, null);
                        }
                    });
                } else {
                    CurriculaTable.this.unmarkSelected();
                }
            }
        });
        hSelect.addOperation(new UniTimeTableHeader.Operation(){

            public String getName() {
                return MESSAGES.opPopulateCourseProjectedDemands();
            }

            public boolean hasSeparator() {
                return true;
            }

            public boolean isApplicable() {
                return CurriculaTable.this.iIsAdmin;
            }

            public void execute() {
                if (Window.confirm((String)MESSAGES.confirmPopulateProjectedDemands())) {
                    LoadingWidget.getInstance().show(MESSAGES.waitPopulatingProjectedDemands());
                    CurriculaTable.this.iService.populateCourseProjectedDemands(false, new AsyncCallback<Boolean>(){

                        public void onFailure(Throwable caught) {
                            CurriculaTable.this.setError(MESSAGES.failedToPopulateProjectedDemands(caught.getMessage()));
                            UniTimeNotifications.error(MESSAGES.failedToPopulateProjectedDemands(caught.getMessage()), caught);
                            LoadingWidget.getInstance().hide();
                        }

                        public void onSuccess(Boolean result) {
                            LoadingWidget.getInstance().hide();
                            CurriculaTable.this.iSelectedCurricula.clear();
                            CurriculaTable.this.query(CurriculaTable.this.iLastQuery, null);
                        }
                    });
                }
            }
        });
        hSelect.addOperation(new UniTimeTableHeader.Operation(){

            public String getName() {
                return MESSAGES.opPopulateCourseProjectedDemandsIncludeOther();
            }

            public boolean hasSeparator() {
                return false;
            }

            public boolean isApplicable() {
                return CurriculaTable.this.iIsAdmin;
            }

            public void execute() {
                if (Window.confirm((String)MESSAGES.confirmPopulateProjectedDemands())) {
                    LoadingWidget.getInstance().show(MESSAGES.waitPopulatingProjectedDemands());
                    CurriculaTable.this.iService.populateCourseProjectedDemands(true, new AsyncCallback<Boolean>(){

                        public void onFailure(Throwable caught) {
                            CurriculaTable.this.setError(MESSAGES.failedToPopulateProjectedDemands(caught.getMessage()));
                            UniTimeNotifications.error(MESSAGES.failedToPopulateProjectedDemands(caught.getMessage()), caught);
                            LoadingWidget.getInstance().hide();
                        }

                        public void onSuccess(Boolean result) {
                            LoadingWidget.getInstance().hide();
                            CurriculaTable.this.iSelectedCurricula.clear();
                            CurriculaTable.this.query(CurriculaTable.this.iLastQuery, null);
                        }
                    });
                }
            }
        });
        hSelect.addOperation(new UniTimeTableHeader.Operation(){

            public String getName() {
                return CurriculaTable.this.iTable.getRowCount() > 1 ? MESSAGES.opRecreateCurriculaFromLastLike() : MESSAGES.opCreateCurriculaFromLastLike();
            }

            public boolean hasSeparator() {
                return true;
            }

            public boolean isApplicable() {
                return CurriculaTable.this.iIsAdmin;
            }

            public void execute() {
                CurriculaTable.this.markAll();
                if (Window.confirm((String)MESSAGES.confirmDeleteAllCurricula())) {
                    if (Window.confirm((String)MESSAGES.confirmDeleteAllCurriculaSecondWarning())) {
                        LoadingWidget.getInstance().show(MESSAGES.waitCreatingAllCurricula(), 300000);
                        CurriculaTable.this.iService.makeupCurriculaFromLastLikeDemands(true, new AsyncCallback<Boolean>(){

                            public void onFailure(Throwable caught) {
                                CurriculaTable.this.setError(MESSAGES.failedToCreateCurricula(caught.getMessage()));
                                UniTimeNotifications.error(MESSAGES.failedToCreateCurricula(caught.getMessage()), caught);
                                CurriculaTable.this.unmarkAll();
                                LoadingWidget.getInstance().hide();
                            }

                            public void onSuccess(Boolean result) {
                                LoadingWidget.getInstance().hide();
                                CurriculaTable.this.iSelectedCurricula.clear();
                                CurriculaTable.this.query(CurriculaTable.this.iLastQuery, null);
                            }
                        });
                    } else {
                        CurriculaTable.this.unmarkAll();
                    }
                } else {
                    CurriculaTable.this.unmarkAll();
                }
            }
        });
        hSelect.addOperation(new UniTimeTableHeader.Operation(){

            public String getName() {
                return CurriculaTable.this.iTable.getRowCount() > 1 ? MESSAGES.opRecreateCurriculaFromCourseRequests() : MESSAGES.opCreateCurriculaFromCourseRequests();
            }

            public boolean hasSeparator() {
                return false;
            }

            public boolean isApplicable() {
                return CurriculaTable.this.iIsAdmin;
            }

            public void execute() {
                CurriculaTable.this.markAll();
                if (Window.confirm((String)MESSAGES.confirmDeleteAllCurricula())) {
                    if (Window.confirm((String)MESSAGES.confirmDeleteAllCurriculaSecondWarning())) {
                        LoadingWidget.getInstance().show(MESSAGES.waitCreatingAllCurricula(), 300000);
                        CurriculaTable.this.iService.makeupCurriculaFromLastLikeDemands(false, new AsyncCallback<Boolean>(){

                            public void onFailure(Throwable caught) {
                                CurriculaTable.this.setError(MESSAGES.failedToCreateCurricula(caught.getMessage()));
                                UniTimeNotifications.error(MESSAGES.failedToCreateCurricula(caught.getMessage()), caught);
                                CurriculaTable.this.unmarkAll();
                                LoadingWidget.getInstance().hide();
                            }

                            public void onSuccess(Boolean result) {
                                LoadingWidget.getInstance().hide();
                                CurriculaTable.this.iSelectedCurricula.clear();
                                CurriculaTable.this.query(CurriculaTable.this.iLastQuery, null);
                            }
                        });
                    } else {
                        CurriculaTable.this.unmarkAll();
                    }
                } else {
                    CurriculaTable.this.unmarkAll();
                }
            }
        });
        ArrayList<UniTimeTableHeader.Operation> hideOps = new ArrayList<UniTimeTableHeader.Operation>();
        hideOps.add(new UniTimeTableHeader.Operation(){

            public String getName() {
                return CurriculumCookie.getInstance().isShowLast() ? MESSAGES.opHide(MESSAGES.fieldLastLikeEnrollment()) : MESSAGES.opShow(MESSAGES.fieldLastLikeEnrollment());
            }

            public boolean hasSeparator() {
                return true;
            }

            public boolean isApplicable() {
                return true;
            }

            public void execute() {
                boolean show = !CurriculumCookie.getInstance().isShowLast();
                int col = CurriculaTable.this.iTable.getCellCount(0) - 5;
                CurriculumCookie.getInstance().setShowLast(show);
                CurriculaTable.this.iTable.setColumnVisible(col, show);
                if (CurriculumCookie.getInstance().isAllHidden()) {
                    CurriculumCookie.getInstance().setShowExpected(true);
                    CurriculaTable.this.iTable.setColumnVisible(CurriculaTable.this.iTable.getCellCount(0) - 3, true);
                }
            }
        });
        hideOps.add(new UniTimeTableHeader.Operation(){

            public String getName() {
                return CurriculumCookie.getInstance().isShowProjected() ? MESSAGES.opHide(MESSAGES.fieldProjectedByRule()) : MESSAGES.opShow(MESSAGES.fieldProjectedByRule());
            }

            public boolean hasSeparator() {
                return false;
            }

            public boolean isApplicable() {
                return true;
            }

            public void execute() {
                boolean show = !CurriculumCookie.getInstance().isShowProjected();
                int col = CurriculaTable.this.iTable.getCellCount(0) - 4;
                CurriculumCookie.getInstance().setShowProjected(show);
                CurriculaTable.this.iTable.setColumnVisible(col, show);
                if (CurriculumCookie.getInstance().isAllHidden()) {
                    CurriculumCookie.getInstance().setShowExpected(true);
                    CurriculaTable.this.iTable.setColumnVisible(CurriculaTable.this.iTable.getCellCount(0) - 3, true);
                }
            }
        });
        hideOps.add(new UniTimeTableHeader.Operation(){

            public String getName() {
                return CurriculumCookie.getInstance().isShowExpected() ? MESSAGES.opHide(MESSAGES.fieldRequestedEnrollment()) : MESSAGES.opShow(MESSAGES.fieldRequestedEnrollment());
            }

            public boolean hasSeparator() {
                return false;
            }

            public boolean isApplicable() {
                return true;
            }

            public void execute() {
                boolean show = !CurriculumCookie.getInstance().isShowExpected();
                int col = CurriculaTable.this.iTable.getCellCount(0) - 3;
                CurriculumCookie.getInstance().setShowExpected(show);
                CurriculaTable.this.iTable.setColumnVisible(col, show);
                if (CurriculumCookie.getInstance().isAllHidden()) {
                    CurriculumCookie.getInstance().setShowLast(true);
                    CurriculaTable.this.iTable.setColumnVisible(CurriculaTable.this.iTable.getCellCount(0) - 5, true);
                }
            }
        });
        hideOps.add(new UniTimeTableHeader.Operation(){

            public String getName() {
                return CurriculumCookie.getInstance().isShowEnrolled() ? MESSAGES.opHide(MESSAGES.fieldCurrentEnrollment()) : MESSAGES.opShow(MESSAGES.fieldCurrentEnrollment());
            }

            public boolean hasSeparator() {
                return false;
            }

            public boolean isApplicable() {
                return true;
            }

            public void execute() {
                boolean show = !CurriculumCookie.getInstance().isShowEnrolled();
                int col = CurriculaTable.this.iTable.getCellCount(0) - 2;
                CurriculumCookie.getInstance().setShowEnrolled(show);
                CurriculaTable.this.iTable.setColumnVisible(col, show);
                if (CurriculumCookie.getInstance().isAllHidden()) {
                    CurriculumCookie.getInstance().setShowExpected(true);
                    CurriculaTable.this.iTable.setColumnVisible(CurriculaTable.this.iTable.getCellCount(0) - 3, true);
                }
            }
        });
        hideOps.add(new UniTimeTableHeader.Operation(){

            public String getName() {
                return CurriculumCookie.getInstance().isShowRequested() ? MESSAGES.opHide(MESSAGES.fieldCourseRequests()) : MESSAGES.opShow(MESSAGES.fieldCourseRequests());
            }

            public boolean hasSeparator() {
                return false;
            }

            public boolean isApplicable() {
                return true;
            }

            public void execute() {
                boolean show = !CurriculumCookie.getInstance().isShowRequested();
                int col = CurriculaTable.this.iTable.getCellCount(0) - 1;
                CurriculumCookie.getInstance().setShowRequested(show);
                CurriculaTable.this.iTable.setColumnVisible(col, show);
                if (CurriculumCookie.getInstance().isAllHidden()) {
                    CurriculumCookie.getInstance().setShowExpected(true);
                    CurriculaTable.this.iTable.setColumnVisible(CurriculaTable.this.iTable.getCellCount(0) - 3, true);
                }
            }
        });
        for (UniTimeTableHeader.Operation op : hideOps) {
            hSelect.addOperation(op);
        }
        final UniTimeTableHeader hCurriculum = new UniTimeTableHeader("Curriculum");
        header.add(hCurriculum);
        hCurriculum.setWidth("100px");
        hCurriculum.addOperation(new UniTimeTableHeader.Operation(){

            public String getName() {
                return CurriculumCookie.getInstance().getCurriculaDisplayMode().isCurriculumAbbv() ? MESSAGES.opShowNames() : MESSAGES.opShowAbbreviations();
            }

            public boolean hasSeparator() {
                return false;
            }

            public boolean isApplicable() {
                return true;
            }

            public void execute() {
                boolean abbv = !CurriculumCookie.getInstance().getCurriculaDisplayMode().isCurriculumAbbv();
                CurriculumCookie.getInstance().getCurriculaDisplayMode().setCurriculumAbbv(abbv);
                for (int row = 0; row < CurriculaTable.this.iTable.getRowCount(); ++row) {
                    CurriculumInterface c = (CurriculumInterface)CurriculaTable.this.iTable.getData(row);
                    if (c == null) continue;
                    ((Label)CurriculaTable.this.iTable.getWidget(row, 1)).setText(abbv ? c.getAbbv() : c.getName());
                }
            }
        });
        hCurriculum.addOperation(new UniTimeTableHeader.Operation(){

            public String getName() {
                return MESSAGES.opSortBy(MESSAGES.colCurriculum());
            }

            public boolean hasSeparator() {
                return false;
            }

            public boolean isApplicable() {
                return true;
            }

            public void execute() {
                final boolean abbv = !CurriculumCookie.getInstance().getCurriculaDisplayMode().isCurriculumAbbv();
                CurriculaTable.this.iLastSort = new Comparator<CurriculumInterface>(){

                    @Override
                    public int compare(CurriculumInterface a, CurriculumInterface b) {
                        int cmp = (abbv ? a.getAbbv() : a.getName()).compareTo(abbv ? b.getAbbv() : b.getName());
                        if (cmp != 0) {
                            return cmp;
                        }
                        return a.compareTo(b);
                    }
                };
                CurriculaTable.this.iLastSortHeader = hCurriculum;
                CurriculaTable.this.iTable.sort(CurriculaTable.this.iLastSortHeader, CurriculaTable.this.iLastSort);
                CurriculaTable.this.iLastSortOrder = CurriculaTable.this.iLastSortHeader.getOrder();
            }
        });
        final UniTimeTableHeader hArea = new UniTimeTableHeader(MESSAGES.colAcademicArea());
        header.add(hArea);
        hArea.setWidth("100px");
        hArea.addOperation(new UniTimeTableHeader.Operation(){

            public String getName() {
                return CurriculumCookie.getInstance().getCurriculaDisplayMode().isAreaAbbv() ? MESSAGES.opShowNames() : MESSAGES.opShowAbbreviations();
            }

            public boolean hasSeparator() {
                return false;
            }

            public boolean isApplicable() {
                return true;
            }

            public void execute() {
                boolean abbv = !CurriculumCookie.getInstance().getCurriculaDisplayMode().isAreaAbbv();
                CurriculumCookie.getInstance().getCurriculaDisplayMode().setAreaAbbv(abbv);
                for (int row = 0; row < CurriculaTable.this.iTable.getRowCount(); ++row) {
                    CurriculumInterface c = (CurriculumInterface)CurriculaTable.this.iTable.getData(row);
                    if (c == null) continue;
                    ((Label)CurriculaTable.this.iTable.getWidget(row, 2)).setText(abbv ? c.getAcademicArea().getAbbv() : c.getAcademicArea().getName());
                }
            }
        });
        hArea.addOperation(new UniTimeTableHeader.Operation(){

            public String getName() {
                return MESSAGES.opSortBy(MESSAGES.colAcademicArea());
            }

            public boolean hasSeparator() {
                return false;
            }

            public boolean isApplicable() {
                return true;
            }

            public void execute() {
                final boolean abbv = !CurriculumCookie.getInstance().getCurriculaDisplayMode().isAreaAbbv();
                CurriculaTable.this.iLastSort = new Comparator<CurriculumInterface>(){

                    @Override
                    public int compare(CurriculumInterface a, CurriculumInterface b) {
                        int cmp = (abbv ? a.getAcademicArea().getAbbv() : a.getAcademicArea().getName()).compareTo(abbv ? b.getAcademicArea().getAbbv() : b.getAcademicArea().getName());
                        if (cmp != 0) {
                            return cmp;
                        }
                        return a.compareTo(b);
                    }
                };
                CurriculaTable.this.iLastSortHeader = hArea;
                CurriculaTable.this.iTable.sort(CurriculaTable.this.iLastSortHeader, CurriculaTable.this.iLastSort);
                CurriculaTable.this.iLastSortOrder = CurriculaTable.this.iLastSortHeader.getOrder();
            }
        });
        final UniTimeTableHeader hMajor = new UniTimeTableHeader(MESSAGES.colMajors());
        header.add(hMajor);
        hMajor.setWidth("100px");
        hMajor.addOperation(new UniTimeTableHeader.Operation(){

            public String getName() {
                return CurriculumCookie.getInstance().getCurriculaDisplayMode().isMajorAbbv() ? MESSAGES.opShowNames() : MESSAGES.opShowAbbreviations();
            }

            public boolean hasSeparator() {
                return false;
            }

            public boolean isApplicable() {
                return true;
            }

            public void execute() {
                boolean abbv = !CurriculumCookie.getInstance().getCurriculaDisplayMode().isMajorAbbv();
                CurriculumCookie.getInstance().getCurriculaDisplayMode().setMajorAbbv(abbv);
                for (int row = 0; row < CurriculaTable.this.iTable.getRowCount(); ++row) {
                    CurriculumInterface c = (CurriculumInterface)CurriculaTable.this.iTable.getData(row);
                    if (c == null) continue;
                    ((HTML)CurriculaTable.this.iTable.getWidget(row, 3)).setHTML(abbv ? c.getMajorCodes(", ") : c.getMajorNames("<br>"));
                    ((HTML)CurriculaTable.this.iTable.getWidget(row, 3)).setWordWrap(abbv);
                }
            }
        });
        hMajor.addOperation(new UniTimeTableHeader.Operation(){

            public String getName() {
                return MESSAGES.opSortBy(MESSAGES.colMajors());
            }

            public boolean hasSeparator() {
                return false;
            }

            public boolean isApplicable() {
                return true;
            }

            public void execute() {
                final boolean abbv = !CurriculumCookie.getInstance().getCurriculaDisplayMode().isMajorAbbv();
                CurriculaTable.this.iLastSort = new Comparator<CurriculumInterface>(){

                    @Override
                    public int compare(CurriculumInterface a, CurriculumInterface b) {
                        int cmp = (abbv ? a.getMajorCodes("|") : a.getMajorNames("|")).compareTo(abbv ? b.getMajorCodes("|") : b.getMajorNames("|"));
                        if (cmp != 0) {
                            return cmp;
                        }
                        return a.compareTo(b);
                    }
                };
                CurriculaTable.this.iLastSortHeader = hMajor;
                CurriculaTable.this.iTable.sort(CurriculaTable.this.iLastSortHeader, CurriculaTable.this.iLastSort);
                CurriculaTable.this.iLastSortOrder = CurriculaTable.this.iLastSortHeader.getOrder();
            }
        });
        final UniTimeTableHeader hDept = new UniTimeTableHeader(MESSAGES.colDepartment());
        header.add(hDept);
        hDept.setWidth("100px");
        for (final DeptMode deptMode : DeptMode.values()) {
            hDept.addOperation(new UniTimeTableHeader.Operation(){

                public String getName() {
                    return MESSAGES.opShowItem(deptMode.getName());
                }

                public boolean hasSeparator() {
                    return false;
                }

                public boolean isApplicable() {
                    return deptMode != CurriculumCookie.getInstance().getCurriculaDisplayMode().getDeptMode();
                }

                public void execute() {
                    CurriculumCookie.getInstance().getCurriculaDisplayMode().setDeptMode(deptMode);
                    DisplayMode dm = CurriculumCookie.getInstance().getCurriculaDisplayMode();
                    for (int row = 0; row < CurriculaTable.this.iTable.getRowCount(); ++row) {
                        CurriculumInterface c = (CurriculumInterface)CurriculaTable.this.iTable.getData(row);
                        if (c == null) continue;
                        ((Label)CurriculaTable.this.iTable.getWidget(row, 4)).setText(dm.formatDepartment(c.getDepartment()));
                    }
                }
            });
        }
        hDept.addOperation(new UniTimeTableHeader.Operation(){

            public String getName() {
                return MESSAGES.opSortBy(MESSAGES.colDepartment());
            }

            public boolean hasSeparator() {
                return true;
            }

            public boolean isApplicable() {
                return true;
            }

            public void execute() {
                final DisplayMode dm = CurriculumCookie.getInstance().getCurriculaDisplayMode();
                CurriculaTable.this.iLastSort = new Comparator<CurriculumInterface>(){

                    @Override
                    public int compare(CurriculumInterface a, CurriculumInterface b) {
                        int cmp = dm.formatDepartment(a.getDepartment()).compareTo(dm.formatDepartment(b.getDepartment()));
                        if (cmp != 0) {
                            return cmp;
                        }
                        return a.compareTo(b);
                    }
                };
                CurriculaTable.this.iLastSortHeader = hDept;
                CurriculaTable.this.iTable.sort(CurriculaTable.this.iLastSortHeader, CurriculaTable.this.iLastSort);
                CurriculaTable.this.iLastSortOrder = CurriculaTable.this.iLastSortHeader.getOrder();
            }
        });
        final UniTimeTableHeader hLastLike = new UniTimeTableHeader(MESSAGES.colLastLikeEnrollment());
        header.add(hLastLike);
        hLastLike.setWidth("90px");
        for (UniTimeTableHeader.Operation op : hideOps) {
            hLastLike.addOperation(op);
        }
        hLastLike.addOperation(new UniTimeTableHeader.Operation(){

            public String getName() {
                return MESSAGES.opSortBy(MESSAGES.fieldLastLikeEnrollment());
            }

            public boolean hasSeparator() {
                return true;
            }

            public boolean isApplicable() {
                return true;
            }

            public void execute() {
                CurriculaTable.this.iLastSort = new Comparator<CurriculumInterface>(){

                    @Override
                    public int compare(CurriculumInterface a, CurriculumInterface b) {
                        Integer e = a.getLastLike() == null ? -1 : a.getLastLike();
                        Integer f = b.getLastLike() == null ? -1 : b.getLastLike();
                        int cmp = f.compareTo(e);
                        if (cmp != 0) {
                            return cmp;
                        }
                        return a.compareTo(b);
                    }
                };
                CurriculaTable.this.iLastSortHeader = hLastLike;
                CurriculaTable.this.iTable.sort(CurriculaTable.this.iLastSortHeader, CurriculaTable.this.iLastSort);
                CurriculaTable.this.iLastSortOrder = CurriculaTable.this.iLastSortHeader.getOrder();
            }
        });
        final UniTimeTableHeader hProjected = new UniTimeTableHeader(MESSAGES.colProjectedByRule());
        header.add(hProjected);
        hProjected.setWidth("90px");
        for (UniTimeTableHeader.Operation operation : hideOps) {
            hProjected.addOperation(operation);
        }
        hProjected.addOperation(new UniTimeTableHeader.Operation(){

            public String getName() {
                return MESSAGES.opCurriculumProjectionRules();
            }

            public boolean hasSeparator() {
                return true;
            }

            public boolean isApplicable() {
                return true;
            }

            public void execute() {
                CurriculaTable.this.openCurriculumProjectionRules();
            }
        });
        hProjected.addOperation(new UniTimeTableHeader.Operation(){

            public String getName() {
                return MESSAGES.opSortBy(MESSAGES.fieldProjectedByRule());
            }

            public boolean hasSeparator() {
                return false;
            }

            public boolean isApplicable() {
                return true;
            }

            public void execute() {
                CurriculaTable.this.iLastSort = new Comparator<CurriculumInterface>(){

                    @Override
                    public int compare(CurriculumInterface a, CurriculumInterface b) {
                        Integer e = a.getProjection() == null ? -1 : a.getProjection();
                        Integer f = b.getProjection() == null ? -1 : b.getProjection();
                        int cmp = f.compareTo(e);
                        if (cmp != 0) {
                            return cmp;
                        }
                        return a.compareTo(b);
                    }
                };
                CurriculaTable.this.iLastSortHeader = hProjected;
                CurriculaTable.this.iTable.sort(CurriculaTable.this.iLastSortHeader, CurriculaTable.this.iLastSort);
                CurriculaTable.this.iLastSortOrder = CurriculaTable.this.iLastSortHeader.getOrder();
            }
        });
        final UniTimeTableHeader hExpected = new UniTimeTableHeader(MESSAGES.colRequestedEnrollment());
        header.add(hExpected);
        hExpected.setWidth("90px");
        for (UniTimeTableHeader.Operation operation : hideOps) {
            hExpected.addOperation(operation);
        }
        hExpected.addOperation(new UniTimeTableHeader.Operation(){

            public String getName() {
                return MESSAGES.opSortBy(MESSAGES.fieldRequestedEnrollment());
            }

            public boolean hasSeparator() {
                return true;
            }

            public boolean isApplicable() {
                return true;
            }

            public void execute() {
                CurriculaTable.this.iLastSort = new Comparator<CurriculumInterface>(){

                    @Override
                    public int compare(CurriculumInterface a, CurriculumInterface b) {
                        Integer e = a.getExpected() == null ? -1 : a.getExpected();
                        Integer f = b.getExpected() == null ? -1 : b.getExpected();
                        int cmp = f.compareTo(e);
                        if (cmp != 0) {
                            return cmp;
                        }
                        return a.compareTo(b);
                    }
                };
                CurriculaTable.this.iLastSortHeader = hExpected;
                CurriculaTable.this.iTable.sort(CurriculaTable.this.iLastSortHeader, CurriculaTable.this.iLastSort);
                CurriculaTable.this.iLastSortOrder = CurriculaTable.this.iLastSortHeader.getOrder();
            }
        });
        final UniTimeTableHeader uniTimeTableHeader = new UniTimeTableHeader(MESSAGES.colCurrentEnrollment());
        header.add(uniTimeTableHeader);
        uniTimeTableHeader.setWidth("90px");
        for (UniTimeTableHeader.Operation op : hideOps) {
            uniTimeTableHeader.addOperation(op);
        }
        uniTimeTableHeader.addOperation(new UniTimeTableHeader.Operation(){

            public String getName() {
                return MESSAGES.opSortBy(MESSAGES.fieldCurrentEnrollment());
            }

            public boolean hasSeparator() {
                return true;
            }

            public boolean isApplicable() {
                return true;
            }

            public void execute() {
                CurriculaTable.this.iLastSort = new Comparator<CurriculumInterface>(){

                    @Override
                    public int compare(CurriculumInterface a, CurriculumInterface b) {
                        Integer e = a.getEnrollment() == null ? -1 : a.getEnrollment();
                        Integer f = b.getEnrollment() == null ? -1 : b.getEnrollment();
                        int cmp = f.compareTo(e);
                        if (cmp != 0) {
                            return cmp;
                        }
                        return a.compareTo(b);
                    }
                };
                CurriculaTable.this.iLastSortHeader = uniTimeTableHeader;
                CurriculaTable.this.iTable.sort(CurriculaTable.this.iLastSortHeader, CurriculaTable.this.iLastSort);
                CurriculaTable.this.iLastSortOrder = CurriculaTable.this.iLastSortHeader.getOrder();
            }
        });
        final UniTimeTableHeader uniTimeTableHeader2 = new UniTimeTableHeader(MESSAGES.colCourseRequests());
        header.add(uniTimeTableHeader2);
        uniTimeTableHeader2.setWidth("90px");
        for (UniTimeTableHeader.Operation op : hideOps) {
            uniTimeTableHeader2.addOperation(op);
        }
        uniTimeTableHeader2.addOperation(new UniTimeTableHeader.Operation(){

            public String getName() {
                return MESSAGES.opSortBy(MESSAGES.fieldCourseRequests());
            }

            public boolean hasSeparator() {
                return true;
            }

            public boolean isApplicable() {
                return true;
            }

            public void execute() {
                CurriculaTable.this.iLastSort = new Comparator<CurriculumInterface>(){

                    @Override
                    public int compare(CurriculumInterface a, CurriculumInterface b) {
                        Integer e = a.getRequested() == null ? -1 : a.getRequested();
                        Integer f = b.getRequested() == null ? -1 : b.getRequested();
                        int cmp = f.compareTo(e);
                        if (cmp != 0) {
                            return cmp;
                        }
                        return a.compareTo(b);
                    }
                };
                CurriculaTable.this.iLastSortHeader = uniTimeTableHeader2;
                CurriculaTable.this.iTable.sort(CurriculaTable.this.iLastSortHeader, CurriculaTable.this.iLastSort);
                CurriculaTable.this.iLastSortOrder = CurriculaTable.this.iLastSortHeader.getOrder();
            }
        });
        this.iTable.addRow(null, header);
        this.iPanel = new VerticalPanel();
        this.iPanel.add(this.iTable);
        this.iLoadingImage = new Image(RESOURCES.loading_small());
        this.iLoadingImage.setVisible(false);
        this.iLoadingImage.getElement().getStyle().setMargin(20.0, Style.Unit.PX);
        this.iPanel.add((Widget)this.iLoadingImage);
        this.iPanel.setCellHorizontalAlignment((Widget)this.iLoadingImage, HasHorizontalAlignment.ALIGN_CENTER);
        this.iPanel.setCellVerticalAlignment((Widget)this.iLoadingImage, HasVerticalAlignment.ALIGN_MIDDLE);
        this.iErrorLabel = new Label(MESSAGES.errorNoData());
        this.iErrorLabel.setStyleName("unitime-Message");
        this.iPanel.add((Widget)this.iErrorLabel);
        this.iErrorLabel.setVisible(true);
        this.iTable.addMouseClickListener(new UniTimeTable.MouseClickListener<CurriculumInterface>(){

            @Override
            public void onMouseClick(UniTimeTable.TableEvent<CurriculumInterface> event) {
                if (event.getData() == null) {
                    return;
                }
                CurriculaTable.this.setLastSelectedRow(event.getRow());
                CurriculumClickedEvent e = new CurriculumClickedEvent(event.getData());
                for (CurriculumClickHandler h : CurriculaTable.this.iCurriculumClickHandlers) {
                    h.onClick(e);
                }
            }
        });
        this.initWidget((Widget)this.iPanel);
        this.iLoadClassifications = new AsyncCallback<List<CurriculumInterface.CurriculumClassificationInterface>>(){

            public void onFailure(Throwable caught) {
            }

            public void onSuccess(List<CurriculumInterface.CurriculumClassificationInterface> classifications) {
                if (CurriculaTable.this.iTable.getRowCount() <= 1) {
                    return;
                }
                ArrayList<Integer> rows = new ArrayList<Integer>();
                CurriculumInterface last = null;
                block0: for (CurriculumInterface.CurriculumClassificationInterface clasf : classifications) {
                    if (last != null && last.getId().equals(clasf.getCurriculumId())) {
                        last.addClassification(clasf);
                        continue;
                    }
                    for (int row = 0; row < CurriculaTable.this.iTable.getRowCount(); ++row) {
                        CurriculumInterface c = (CurriculumInterface)CurriculaTable.this.iTable.getData(row);
                        if (c == null || !c.getId().equals(clasf.getCurriculumId())) continue;
                        if (c.hasClassifications()) {
                            c.getClassifications().clear();
                        }
                        c.addClassification(clasf);
                        rows.add(row);
                        last = c;
                        continue block0;
                    }
                }
                Iterator<CurriculumInterface.CurriculumClassificationInterface> iterator = rows.iterator();
                while (iterator.hasNext()) {
                    int row = (Integer)((Object)iterator.next());
                    CurriculumInterface c = (CurriculumInterface)CurriculaTable.this.iTable.getData(row);
                    ((Label)CurriculaTable.this.iTable.getWidget(row, 5)).setText(c.getLastLikeString());
                    ((Label)CurriculaTable.this.iTable.getWidget(row, 6)).setText(c.getProjectionString());
                    if (CurriculaTable.this.iTable.getWidget(row, 7) instanceof Image) {
                        CurriculaTable.this.iTable.setWidget(row, 7, (Widget)new Label(c.getExpectedString(), false));
                        CurriculaTable.this.iTable.getFlexCellFormatter().setHorizontalAlignment(row, 7, HasHorizontalAlignment.ALIGN_RIGHT);
                    } else {
                        ((Label)CurriculaTable.this.iTable.getWidget(row, 7)).setText(c.getExpectedString());
                    }
                    ((Label)CurriculaTable.this.iTable.getWidget(row, 8)).setText(c.getEnrollmentString());
                    ((Label)CurriculaTable.this.iTable.getWidget(row, 9)).setText(c.getRequestedString());
                }
                ArrayList<Long> noEnrl = new ArrayList<Long>();
                for (int row = 0; row < CurriculaTable.this.iTable.getRowCount(); ++row) {
                    CurriculumInterface c = (CurriculumInterface)CurriculaTable.this.iTable.getData(row);
                    if (c != null && !c.hasClassifications()) {
                        noEnrl.add(c.getId());
                        if (noEnrl.size() == 1) {
                            CurriculaTable.this.iTable.setWidget(row, 7, (Widget)new Image(RESOURCES.loading_small()));
                            CurriculaTable.this.iTable.getFlexCellFormatter().setHorizontalAlignment(row, 7, HasHorizontalAlignment.ALIGN_LEFT);
                        }
                    }
                    if (noEnrl.size() >= 10) break;
                }
                if (!noEnrl.isEmpty()) {
                    CurriculaTable.this.iService.loadClassifications(noEnrl, (AsyncCallback<List<CurriculumInterface.CurriculumClassificationInterface>>)CurriculaTable.this.iLoadClassifications);
                } else if (CurriculaTable.this.iLastSort != null) {
                    CurriculaTable.this.iTable.sort(CurriculaTable.this.iLastSortHeader, CurriculaTable.this.iLastSort, CurriculaTable.this.iLastSortOrder == null ? true : CurriculaTable.this.iLastSortOrder);
                }
            }
        };
        this.iClassifications = new CurriculaClassifications();
        this.iClassificationsPopup = new PopupPanel();
        this.iClassificationsPopup.setWidget((Widget)this.iClassifications);
        this.iClassificationsPopup.setStyleName("unitime-PopupHint");
        this.iService.isAdmin(new AsyncCallback<Boolean>(){

            public void onFailure(Throwable caught) {
            }

            public void onSuccess(Boolean result) {
                CurriculaTable.this.iIsAdmin = result;
            }
        });
        this.iTable.setHintProvider(new UniTimeTable.HintProvider<CurriculumInterface>(){

            @Override
            public Widget getHint(UniTimeTable.TableEvent<CurriculumInterface> event) {
                if (event.getData() == null || !event.getData().hasClassifications()) {
                    return null;
                }
                CurriculaTable.this.iClassifications.populate(event.getData().getClassifications());
                CurriculaTable.this.iClassifications.setEnabled(false);
                CurriculaTable.this.iClassifications.hideEmptyRows();
                return CurriculaTable.this.iClassifications;
            }
        });
        this.iOperations.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                PopupPanel popup = new PopupPanel(true);
                if (!hSelect.setMenu(popup)) {
                    return;
                }
                popup.showRelativeTo((UIObject)CurriculaTable.this.iOperations);
                ((MenuBar)popup.getWidget()).focus();
            }
        });
    }

    public void setLastSelectedRow(int row) {
        for (int r = 1; r < this.iTable.getRowCount(); ++r) {
            if (!"unitime-TableRowSelected".equals(this.iTable.getRowFormatter().getStyleName(r))) continue;
            this.iTable.getRowFormatter().setStyleName(r, null);
        }
        if (row >= 0) {
            CurriculumInterface c = this.iTable.getData(row);
            if (c != null) {
                this.iLastCurriculumId = c.getId();
                this.iTable.getRowFormatter().setStyleName(row, "unitime-TableRowSelected");
            } else {
                this.iLastCurriculumId = null;
            }
        } else {
            this.iLastCurriculumId = null;
        }
    }

    protected List<CurriculumInterface> selected() {
        ArrayList<CurriculumInterface> selected = new ArrayList<CurriculumInterface>();
        for (int row = 0; row < this.iTable.getRowCount(); ++row) {
            CurriculumInterface c = this.iTable.getData(row);
            if (c == null || !c.isEditable() || !this.iSelectedCurricula.contains(c.getId())) continue;
            selected.add(c);
        }
        return selected;
    }

    protected Set<Long> markSelected() {
        HashSet<Long> markedIds = new HashSet<Long>();
        for (int row = 0; row < this.iTable.getRowCount(); ++row) {
            CurriculumInterface c = this.iTable.getData(row);
            if (c == null || !c.isEditable() || !this.iSelectedCurricula.isEmpty() && !this.iSelectedCurricula.contains(c.getId())) continue;
            markedIds.add(c.getId());
            this.iTable.getRowFormatter().setStyleName(row, "unitime-TableRowProblem");
        }
        return markedIds;
    }

    protected void unmarkSelected() {
        for (int row = 0; row < this.iTable.getRowCount(); ++row) {
            CurriculumInterface c = this.iTable.getData(row);
            if (c == null || !c.isEditable() || !this.iSelectedCurricula.isEmpty() && !this.iSelectedCurricula.contains(c.getId())) continue;
            this.iTable.getRowFormatter().setStyleName(row, c.getId().equals(this.iLastCurriculumId) ? "unitime-TableRowSelected" : null);
        }
    }

    protected void markAll() {
        for (int row = 0; row < this.iTable.getRowCount(); ++row) {
            CurriculumInterface c = this.iTable.getData(row);
            if (c == null || !c.isEditable()) continue;
            this.iTable.getRowFormatter().setStyleName(row, "unitime-TableRowProblem");
        }
    }

    protected void unmarkAll() {
        for (int row = 0; row < this.iTable.getRowCount(); ++row) {
            CurriculumInterface c = this.iTable.getData(row);
            if (c == null || !c.isEditable()) continue;
            this.iTable.getRowFormatter().setStyleName(row, c.getId().equals(this.iLastCurriculumId) ? "unitime-TableRowSelected" : null);
        }
    }

    public void setup(List<CurriculumInterface.AcademicClassificationInterface> classifications) {
        this.iClassifications.setup(classifications);
    }

    public void setMessage(String message) {
        this.iErrorLabel.setStyleName("unitime-Message");
        this.iErrorLabel.setText(message == null ? "" : message);
        this.iErrorLabel.setVisible(message != null && !message.isEmpty());
        if (this.iErrorLabel.isVisible()) {
            this.iErrorLabel.getElement().scrollIntoView();
        }
    }

    public void setError(String message) {
        this.iErrorLabel.setStyleName("unitime-ErrorMessage");
        this.iErrorLabel.setText(message == null ? "" : message);
        this.iErrorLabel.setVisible(message != null && !message.isEmpty());
        if (this.iErrorLabel.isVisible()) {
            this.iErrorLabel.getElement().scrollIntoView();
        }
    }

    private void fillRow(CurriculumInterface c) {
        int row = this.iTable.getRowCount();
        ArrayList<Object> line = new ArrayList<Object>();
        if (c.isEditable()) {
            CheckBox ch = new CheckBox();
            final Long cid = c.getId();
            ch.setValue(Boolean.valueOf(this.iSelectedCurricula.contains(cid)));
            ch.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    event.stopPropagation();
                }
            });
            ch.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

                public void onValueChange(ValueChangeEvent<Boolean> event) {
                    if (((Boolean)event.getValue()).booleanValue()) {
                        CurriculaTable.this.iSelectedCurricula.add(cid);
                    } else {
                        CurriculaTable.this.iSelectedCurricula.remove(cid);
                    }
                }
            });
            line.add(ch);
        } else {
            line.add(new Label(""));
        }
        DisplayMode m = CurriculumCookie.getInstance().getCurriculaDisplayMode();
        line.add(new Label(m.isCurriculumAbbv() ? c.getAbbv() : c.getName(), false));
        line.add(new Label(m.isAreaAbbv() ? c.getAcademicArea().getAbbv() : c.getAcademicArea().getName(), false));
        line.add(new HTML(m.isMajorAbbv() ? c.getMajorCodes(", ") : c.getMajorNames("<br>"), m.isMajorAbbv()));
        line.add(new Label(m.formatDepartment(c.getDepartment()), false));
        line.add(new Label(c.getLastLike() == null ? "" : c.getLastLikeString(), false));
        line.add(new Label(c.getProjection() == null ? "" : c.getProjectionString(), false));
        line.add(new Label(c.getExpected() == null ? "" : c.getExpectedString(), false));
        line.add(new Label(c.getEnrollment() == null ? "" : c.getEnrollmentString(), false));
        line.add(new Label(c.getRequested() == null ? "" : c.getRequestedString(), false));
        this.iTable.setRow(row, c, line);
        this.iTable.getCellFormatter().addStyleName(row, 0, "unitime-NoPrint");
        this.iTable.getFlexCellFormatter().setHorizontalAlignment(row, 5, HasHorizontalAlignment.ALIGN_RIGHT);
        this.iTable.getFlexCellFormatter().setHorizontalAlignment(row, 6, HasHorizontalAlignment.ALIGN_RIGHT);
        this.iTable.getFlexCellFormatter().setHorizontalAlignment(row, 7, HasHorizontalAlignment.ALIGN_RIGHT);
        this.iTable.getFlexCellFormatter().setHorizontalAlignment(row, 8, HasHorizontalAlignment.ALIGN_RIGHT);
        this.iTable.getFlexCellFormatter().setHorizontalAlignment(row, 9, HasHorizontalAlignment.ALIGN_RIGHT);
    }

    public void populate(TreeSet<CurriculumInterface> result, boolean editable) {
        this.iTable.clearTable(1);
        if (result.isEmpty()) {
            this.setError(MESSAGES.errorNoMatchingCurriculaFound());
            return;
        }
        this.setMessage(null);
        ArrayList<Long> ids = new ArrayList<Long>();
        int row = 0;
        int rowToScroll = -1;
        boolean hasEditable = false;
        HashSet<Long> newlySelected = new HashSet<Long>();
        for (CurriculumInterface curriculum : result) {
            if (ids.size() < 10 && !curriculum.hasClassifications()) {
                ids.add(curriculum.getId());
            }
            if (curriculum.isEditable() && editable) {
                hasEditable = true;
            }
            this.fillRow(curriculum);
            if (curriculum.getId().equals(this.iLastCurriculumId)) {
                this.iTable.getRowFormatter().setStyleName(1 + row, "unitime-TableRowSelected");
                rowToScroll = 1 + row;
            }
            if (curriculum.isEditable() && editable && this.iSelectedCurricula.contains(curriculum.getId())) {
                newlySelected.add(curriculum.getId());
            }
            ++row;
        }
        if (!ids.isEmpty()) {
            this.iTable.setWidget(1, 7, (Widget)new Image(RESOURCES.loading_small()));
            this.iTable.getFlexCellFormatter().setHorizontalAlignment(1, 7, HasHorizontalAlignment.ALIGN_LEFT);
        }
        this.iSelectedCurricula.clear();
        this.iSelectedCurricula.addAll(newlySelected);
        if (!hasEditable) {
            for (int r = 0; r < this.iTable.getRowCount(); ++r) {
                this.iTable.getCellFormatter().setVisible(r, 0, false);
            }
            this.iOperations.setVisible(false);
        } else {
            this.iTable.getCellFormatter().setVisible(0, 0, true);
            this.iOperations.setVisible(true);
        }
        if (rowToScroll >= 0) {
            this.iTable.getRowFormatter().getElement(rowToScroll).scrollIntoView();
        }
        if (!ids.isEmpty()) {
            this.iService.loadClassifications(ids, this.iLoadClassifications);
        }
        this.iTable.setColumnVisible(this.iTable.getCellCount(0) - 5, CurriculumCookie.getInstance().isShowLast());
        this.iTable.setColumnVisible(this.iTable.getCellCount(0) - 4, CurriculumCookie.getInstance().isShowProjected());
        this.iTable.setColumnVisible(this.iTable.getCellCount(0) - 3, CurriculumCookie.getInstance().isShowExpected());
        this.iTable.setColumnVisible(this.iTable.getCellCount(0) - 2, CurriculumCookie.getInstance().isShowEnrolled());
        this.iTable.setColumnVisible(this.iTable.getCellCount(0) - 1, CurriculumCookie.getInstance().isShowRequested());
    }

    public void query(CurriculumInterface.CurriculumFilterRpcRequest filter, final Command next) {
        this.iLastQuery = filter;
        this.iTable.clearTable(1);
        this.setMessage(null);
        this.iLoadingImage.setVisible(true);
        this.iService.findCurricula(filter, new AsyncCallback<TreeSet<CurriculumInterface>>(){

            public void onSuccess(TreeSet<CurriculumInterface> result) {
                CurriculaTable.this.iLoadingImage.setVisible(false);
                CurriculaTable.this.populate(result, true);
                if (next != null) {
                    next.execute();
                }
            }

            public void onFailure(Throwable caught) {
                CurriculaTable.this.iLoadingImage.setVisible(false);
                CurriculaTable.this.setError(MESSAGES.failedToLoadCurricula(caught.getMessage()));
                UniTimeNotifications.error(MESSAGES.failedToLoadCurricula(caught.getMessage()), caught);
                ToolBox.checkAccess(caught);
                if (next != null) {
                    next.execute();
                }
            }
        });
    }

    public void scrollIntoView() {
        for (int r = 1; r < this.iTable.getRowCount(); ++r) {
            if (!"unitime-TableRowSelected".equals(this.iTable.getRowFormatter().getStyleName(r))) continue;
            this.iTable.getRowFormatter().getElement(r).scrollIntoView();
        }
    }

    private void openCurriculumProjectionRules() {
        final UniTimeDialogBox dialog = new UniTimeDialogBox(true, true);
        CurriculumProjectionRulesPage rules = new CurriculumProjectionRulesPage();
        rules.setAllowClose(true);
        rules.getElement().getStyle().setMarginRight((double)ToolBox.getScrollBarWidth(), Style.Unit.PX);
        rules.getElement().getStyle().setPaddingLeft(10.0, Style.Unit.PX);
        rules.getElement().getStyle().setPaddingRight(10.0, Style.Unit.PX);
        ScrollPanel panel = new ScrollPanel((Widget)rules);
        panel.setHeight(Math.round(0.9 * (double)Window.getClientHeight()) + "px");
        panel.setStyleName("unitime-ScrollPanel");
        dialog.setWidget((Widget)panel);
        dialog.setText(MESSAGES.dialogCurriculumProjectionRules());
        rules.addProjectionRulesHandler(new CurriculumProjectionRulesPage.ProjectionRulesHandler(){

            public void onRulesSaved(CurriculumProjectionRulesPage.ProjectionRulesEvent evt) {
                dialog.hide();
                CurriculaTable.this.query(CurriculaTable.this.iLastQuery, null);
            }

            public void onRulesLoaded(CurriculumProjectionRulesPage.ProjectionRulesEvent evt) {
                dialog.center();
            }

            public void onRulesClosed(CurriculumProjectionRulesPage.ProjectionRulesEvent evt) {
                dialog.hide();
            }

            public void onException(Throwable caught) {
                CurriculaTable.this.setError(MESSAGES.failedToOpenCurriculumProjectionRules(caught.getMessage()));
                UniTimeNotifications.error(MESSAGES.failedToOpenCurriculumProjectionRules(caught.getMessage()), caught);
            }
        });
    }

    public void addCurriculumClickHandler(CurriculumClickHandler h) {
        this.iCurriculumClickHandlers.add(h);
    }

    public List<CurriculumInterface> getCurricula() {
        return this.iTable.getData();
    }

    public void setEditClassificationHandler(EditClassificationHandler h) {
        this.iEditClassificationHandler = h;
    }

    public Button getOperations() {
        return this.iOperations;
    }

    public CurriculumInterface next(Long id) {
        if (id == null) {
            return null;
        }
        for (int row = 0; row < this.iTable.getRowCount() - 1; ++row) {
            CurriculumInterface c = this.iTable.getData(row);
            if (c == null || !id.equals(c.getId())) continue;
            return this.iTable.getData(1 + row);
        }
        return null;
    }

    public CurriculumInterface previous(Long id) {
        if (id == null) {
            return null;
        }
        for (int row = 1; row < this.iTable.getRowCount(); ++row) {
            CurriculumInterface c = this.iTable.getData(row);
            if (c == null || !id.equals(c.getId())) continue;
            return this.iTable.getData(row - 1);
        }
        return null;
    }

    public static abstract class DisplayMode {
        private boolean iCurriculumAbbv = true;
        private boolean iAreaAbbv = false;
        private boolean iMajorAbbv = false;
        private DeptMode iDeptMode = DeptMode.ABBV_NAME;

        public boolean isCurriculumAbbv() {
            return this.iCurriculumAbbv;
        }

        public void setCurriculumAbbv(boolean curriculumAbbv) {
            this.iCurriculumAbbv = curriculumAbbv;
            this.changed();
        }

        public boolean isAreaAbbv() {
            return this.iAreaAbbv;
        }

        public void setAreaAbbv(boolean areaAbbv) {
            this.iAreaAbbv = areaAbbv;
            this.changed();
        }

        public boolean isMajorAbbv() {
            return this.iMajorAbbv;
        }

        public void setMajorAbbv(boolean majorAbbv) {
            this.iMajorAbbv = majorAbbv;
            this.changed();
        }

        public DeptMode getDeptMode() {
            return this.iDeptMode;
        }

        public void setDeptMode(DeptMode deptMode) {
            this.iDeptMode = deptMode;
            this.changed();
        }

        public String formatDepartment(CurriculumInterface.DepartmentInterface dept) {
            switch (this.iDeptMode) {
                case CODE: {
                    return dept.getCode();
                }
                case ABBV: {
                    return dept.getAbbv() == null || dept.getAbbv().isEmpty() ? dept.getCode() : dept.getAbbv();
                }
                case NAME: {
                    return dept.getName();
                }
                case CODE_NAME: {
                    return dept.getCode() + " - " + dept.getName();
                }
            }
            return (dept.getAbbv() == null || dept.getAbbv().isEmpty() ? dept.getCode() : dept.getAbbv()) + " - " + dept.getName();
        }

        public String toString() {
            String ret = "";
            if (this.iCurriculumAbbv) {
                ret = ret + "c";
            }
            if (this.iAreaAbbv) {
                ret = ret + "a";
            }
            if (this.iMajorAbbv) {
                ret = ret + "m";
            }
            ret = ret + this.iDeptMode.getCode();
            return ret;
        }

        public void fromString(String str) {
            this.iCurriculumAbbv = str.indexOf(99) >= 0;
            this.iAreaAbbv = str.indexOf(97) >= 0;
            this.iMajorAbbv = str.indexOf(109) >= 0;
            for (DeptMode m : DeptMode.values()) {
                if (str.indexOf(m.getCode()) < 0) continue;
                this.iDeptMode = m;
                break;
            }
        }

        public abstract void changed();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DeptMode {
        CODE('0', MESSAGES.fieldCode()),
        ABBV('1', MESSAGES.fieldAbbreviation()),
        NAME('2', MESSAGES.fieldName()),
        ABBV_NAME('3', MESSAGES.fieldAbbv() + " - " + MESSAGES.fieldName()),
        CODE_NAME('4', MESSAGES.fieldCode() + " - " + MESSAGES.fieldName());

        private char iCode;
        private String iName;

        private DeptMode(char code, String name) {
            this.iCode = code;
            this.iName = name;
        }

        public String getName() {
            return this.iName;
        }

        public char getCode() {
            return this.iCode;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface EditClassificationHandler {
        public void doEdit(List<CurriculumInterface> var1);
    }

    public static interface CurriculumClickHandler {
        public void onClick(CurriculumClickedEvent var1);
    }

    public static class CurriculumClickedEvent {
        private CurriculumInterface iCurriculum;

        public CurriculumClickedEvent(CurriculumInterface curriculum) {
            this.iCurriculum = curriculum;
        }

        public CurriculumInterface getCurriculum() {
            return this.iCurriculum;
        }
    }
}

