/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.curricula;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import org.unitime.timetable.gwt.client.Client;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.client.aria.AriaButton;
import org.unitime.timetable.gwt.client.curricula.ClassificationsEdit;
import org.unitime.timetable.gwt.client.curricula.CurriculaTable;
import org.unitime.timetable.gwt.client.curricula.CurriculumEdit;
import org.unitime.timetable.gwt.client.curricula.CurriculumFilterBox;
import org.unitime.timetable.gwt.client.page.UniTimeNotifications;
import org.unitime.timetable.gwt.client.page.UniTimePageLabel;
import org.unitime.timetable.gwt.client.widgets.LoadingWidget;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.resources.GwtResources;
import org.unitime.timetable.gwt.services.CurriculaService;
import org.unitime.timetable.gwt.services.CurriculaServiceAsync;
import org.unitime.timetable.gwt.shared.CurriculumInterface;

public class CurriculaPage
extends Composite {
    protected static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    public static final GwtResources RESOURCES = (GwtResources)GWT.create(GwtResources.class);
    private CurriculumFilterBox iFilter = null;
    private AriaButton iSearch = null;
    private AriaButton iNew = null;
    private AriaButton iPrint = null;
    private CurriculaTable iCurriculaTable = null;
    private VerticalPanel iCurriculaPanel = null;
    private SimplePanel iPanel = null;
    private HorizontalPanel iFilterPanel = null;
    private final CurriculaServiceAsync iService = (CurriculaServiceAsync)GWT.create(CurriculaService.class);
    private CurriculumEdit iCurriculumPanel = null;
    private ClassificationsEdit iClassificationsEdit = null;

    public CurriculaPage() {
        this.iPanel = new SimplePanel();
        this.iCurriculaPanel = new VerticalPanel();
        this.iFilterPanel = new HorizontalPanel();
        this.iFilterPanel.setSpacing(3);
        Label filterLabel = new Label(MESSAGES.propFilter());
        this.iFilterPanel.add((Widget)filterLabel);
        this.iFilterPanel.setCellVerticalAlignment((Widget)filterLabel, HasVerticalAlignment.ALIGN_MIDDLE);
        this.iFilter = new CurriculumFilterBox();
        this.iFilterPanel.add((Widget)this.iFilter);
        this.iSearch = new AriaButton(MESSAGES.buttonSearch());
        this.iSearch.addStyleName("unitime-NoPrint");
        this.iFilterPanel.add((Widget)this.iSearch);
        this.iPrint = new AriaButton(MESSAGES.buttonPrint());
        this.iPrint.addStyleName("unitime-NoPrint");
        this.iFilterPanel.add((Widget)this.iPrint);
        this.iNew = new AriaButton(MESSAGES.buttonAddNew());
        this.iNew.setEnabled(false);
        this.iNew.addStyleName("unitime-NoPrint");
        this.iFilterPanel.add((Widget)this.iNew);
        this.iService.canAddCurriculum(new AsyncCallback<Boolean>(){

            public void onFailure(Throwable caught) {
            }

            public void onSuccess(Boolean result) {
                CurriculaPage.this.iNew.setEnabled(result);
            }
        });
        this.iCurriculaPanel.add((Widget)this.iFilterPanel);
        this.iCurriculaPanel.setCellHorizontalAlignment((Widget)this.iFilterPanel, HasHorizontalAlignment.ALIGN_CENTER);
        this.iCurriculaTable = new CurriculaTable();
        this.iCurriculaTable.getElement().getStyle().setMarginTop(10.0, Style.Unit.PX);
        this.iFilterPanel.add((Widget)this.iCurriculaTable.getOperations());
        this.iCurriculaTable.getOperations().setEnabled(false);
        this.iCurriculaPanel.add((Widget)this.iCurriculaTable);
        this.iCurriculaPanel.setWidth("100%");
        this.iPanel.setWidget((Widget)this.iCurriculaPanel);
        this.iCurriculumPanel = new CurriculumEdit(new CurriculumEdit.NavigationProvider(){

            public CurriculumInterface previous(CurriculumInterface curriculum) {
                return CurriculaPage.this.iCurriculaTable.previous(curriculum == null ? null : curriculum.getId());
            }

            public CurriculumInterface next(CurriculumInterface curriculum) {
                return CurriculaPage.this.iCurriculaTable.next(curriculum == null ? null : curriculum.getId());
            }

            public void onChange(CurriculumInterface curriculum) {
                if (curriculum.getId() != null) {
                    History.newItem((String)("detail=" + curriculum.getId()), (boolean)false);
                }
            }
        });
        this.iClassificationsEdit = new ClassificationsEdit();
        this.initWidget((Widget)this.iPanel);
        this.iSearch.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                CurriculaPage.this.loadCurricula();
            }
        });
        this.iPrint.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                Window.print();
            }
        });
        Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                CurriculaPage.this.iFilter.setFocus(true);
            }
        });
        if (Window.Location.getParameter((String)"q") != null) {
            this.iFilter.setValue(Window.Location.getParameter((String)"q"), true);
            this.loadCurricula();
        } else {
            this.showLoading(MESSAGES.waitLoadingCurricula());
            this.iService.lastCurriculaFilter(new AsyncCallback<String>(){

                public void onSuccess(String result) {
                    if (CurriculaPage.this.iFilter.getValue().isEmpty()) {
                        CurriculaPage.this.iFilter.setValue(result, true);
                        CurriculaPage.this.loadCurricula();
                    }
                    CurriculaPage.this.hideLoading();
                }

                public void onFailure(Throwable caught) {
                    CurriculaPage.this.iCurriculaTable.setError(MESSAGES.failedToLoadCurricula(caught.getMessage()));
                    UniTimeNotifications.error(MESSAGES.failedToLoadCurricula(caught.getMessage()), caught);
                    CurriculaPage.this.hideLoading();
                    ToolBox.checkAccess(caught);
                }
            });
        }
        History.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

            public void onValueChange(ValueChangeEvent<String> event) {
                if (event.getValue() == null || "0:0".equals(event.getValue())) {
                    return;
                }
                String command = (String)event.getValue();
                if (command.startsWith("detail=")) {
                    CurriculaPage.this.showLoading(MESSAGES.waitLoadingCurriculum());
                    CurriculaPage.this.iService.loadCurriculum(Long.parseLong(command.substring("detail=".length())), new AsyncCallback<CurriculumInterface>(){

                        public void onFailure(Throwable caught) {
                            CurriculaPage.this.hideLoading();
                        }

                        public void onSuccess(CurriculumInterface result) {
                            CurriculaPage.this.iCurriculumPanel.edit(result, true);
                            CurriculaPage.this.iPanel.setWidget((Widget)CurriculaPage.this.iCurriculumPanel);
                            CurriculaPage.this.hideLoading();
                            Client.fireGwtPageChanged(new Client.GwtPageChangeEvent());
                        }
                    });
                } else if ("new".equals(command)) {
                    UniTimePageLabel.getInstance().setPageName(MESSAGES.pageAddCurriculum());
                    CurriculaPage.this.iCurriculumPanel.addNew();
                    CurriculaPage.this.iPanel.setWidget((Widget)CurriculaPage.this.iCurriculumPanel);
                    Client.fireGwtPageChanged(new Client.GwtPageChangeEvent());
                } else {
                    if (!"requests".equals(command)) {
                        CurriculaPage.this.iFilter.setValue(command.replace("%20", " "), true);
                    }
                    CurriculaPage.this.loadCurricula();
                    if (CurriculaPage.this.iCurriculumPanel.isVisible()) {
                        UniTimePageLabel.getInstance().setPageName(MESSAGES.pageCurricula());
                        CurriculaPage.this.iPanel.setWidget((Widget)CurriculaPage.this.iCurriculaPanel);
                        CurriculaPage.this.iCurriculaTable.scrollIntoView();
                        Client.fireGwtPageChanged(new Client.GwtPageChangeEvent());
                    }
                }
            }
        });
        this.iCurriculaTable.addCurriculumClickHandler(new CurriculaTable.CurriculumClickHandler(){

            public void onClick(CurriculaTable.CurriculumClickedEvent evt) {
                CurriculaPage.this.showLoading(MESSAGES.waitLoadingCurriculumWithName(evt.getCurriculum().getName()));
                CurriculaPage.this.iService.loadCurriculum(evt.getCurriculum().getId(), new AsyncCallback<CurriculumInterface>(){

                    public void onFailure(Throwable caught) {
                        CurriculaPage.this.hideLoading();
                    }

                    public void onSuccess(CurriculumInterface result) {
                        History.newItem((String)("detail=" + result.getId()), (boolean)false);
                        CurriculaPage.this.iCurriculumPanel.edit(result, true);
                        CurriculaPage.this.iPanel.setWidget((Widget)CurriculaPage.this.iCurriculumPanel);
                        CurriculaPage.this.hideLoading();
                        Client.fireGwtPageChanged(new Client.GwtPageChangeEvent());
                    }
                });
            }
        });
        this.iNew.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                History.newItem((String)"new", (boolean)false);
                UniTimePageLabel.getInstance().setPageName(MESSAGES.pageAddCurriculum());
                CurriculaPage.this.iCurriculumPanel.addNew();
                CurriculaPage.this.iPanel.setWidget((Widget)CurriculaPage.this.iCurriculumPanel);
                Client.fireGwtPageChanged(new Client.GwtPageChangeEvent());
            }
        });
        this.iCurriculaTable.setEditClassificationHandler(new CurriculaTable.EditClassificationHandler(){

            @Override
            public void doEdit(List<CurriculumInterface> curricula) {
                CurriculaPage.this.iClassificationsEdit.setData(curricula);
                UniTimePageLabel.getInstance().setPageName(MESSAGES.pageCurriculumRequestedEnrollments());
                CurriculaPage.this.iPanel.setWidget((Widget)CurriculaPage.this.iClassificationsEdit);
                Client.fireGwtPageChanged(new Client.GwtPageChangeEvent());
                History.newItem((String)"requests", (boolean)false);
            }
        });
        this.iCurriculumPanel.addEditFinishedHandler(new CurriculumEdit.EditFinishedHandler(){

            public void onSave(CurriculumEdit.EditFinishedEvent evt) {
                UniTimePageLabel.getInstance().setPageName(MESSAGES.pageCurricula());
                CurriculaPage.this.iPanel.setWidget((Widget)CurriculaPage.this.iCurriculaPanel);
                CurriculaPage.this.loadCurricula();
                Client.fireGwtPageChanged(new Client.GwtPageChangeEvent());
                History.newItem((String)CurriculaPage.this.iFilter.getValue(), (boolean)false);
            }

            public void onDelete(CurriculumEdit.EditFinishedEvent evt) {
                UniTimePageLabel.getInstance().setPageName(MESSAGES.pageCurricula());
                CurriculaPage.this.iPanel.setWidget((Widget)CurriculaPage.this.iCurriculaPanel);
                CurriculaPage.this.loadCurricula();
                Client.fireGwtPageChanged(new Client.GwtPageChangeEvent());
                History.newItem((String)CurriculaPage.this.iFilter.getValue(), (boolean)false);
            }

            public void onBack(CurriculumEdit.EditFinishedEvent evt) {
                UniTimePageLabel.getInstance().setPageName(MESSAGES.pageCurricula());
                CurriculaPage.this.iPanel.setWidget((Widget)CurriculaPage.this.iCurriculaPanel);
                CurriculaPage.this.iCurriculaTable.scrollIntoView();
                Client.fireGwtPageChanged(new Client.GwtPageChangeEvent());
                History.newItem((String)CurriculaPage.this.iFilter.getValue(), (boolean)false);
            }
        });
        this.iClassificationsEdit.addEditFinishedHandler(new ClassificationsEdit.EditFinishedHandler(){

            public void onSave(ClassificationsEdit.EditFinishedEvent evt) {
                UniTimePageLabel.getInstance().setPageName(MESSAGES.pageCurricula());
                CurriculaPage.this.iPanel.setWidget((Widget)CurriculaPage.this.iCurriculaPanel);
                CurriculaPage.this.loadCurricula();
                Client.fireGwtPageChanged(new Client.GwtPageChangeEvent());
                History.newItem((String)CurriculaPage.this.iFilter.getValue(), (boolean)false);
            }

            public void onBack(ClassificationsEdit.EditFinishedEvent evt) {
                UniTimePageLabel.getInstance().setPageName(MESSAGES.pageCurricula());
                CurriculaPage.this.iPanel.setWidget((Widget)CurriculaPage.this.iCurriculaPanel);
                CurriculaPage.this.iCurriculaTable.scrollIntoView();
                Client.fireGwtPageChanged(new Client.GwtPageChangeEvent());
                History.newItem((String)CurriculaPage.this.iFilter.getValue(), (boolean)false);
            }
        });
        this.iService.loadAcademicAreas(new AsyncCallback<TreeSet<CurriculumInterface.AcademicAreaInterface>>(){

            public void onFailure(Throwable caught) {
            }

            public void onSuccess(TreeSet<CurriculumInterface.AcademicAreaInterface> result) {
                CurriculaPage.this.iCurriculumPanel.setupAreas(result);
            }
        });
        this.iService.loadDepartments(new AsyncCallback<TreeSet<CurriculumInterface.DepartmentInterface>>(){

            public void onFailure(Throwable caught) {
            }

            public void onSuccess(TreeSet<CurriculumInterface.DepartmentInterface> result) {
                CurriculaPage.this.iCurriculumPanel.setupDepartments(result);
            }
        });
        this.iService.loadAcademicClassifications(new AsyncCallback<TreeSet<CurriculumInterface.AcademicClassificationInterface>>(){

            public void onFailure(Throwable caught) {
            }

            public void onSuccess(TreeSet<CurriculumInterface.AcademicClassificationInterface> result) {
                CurriculaPage.this.iCurriculumPanel.setupClassifications(result);
                CurriculaPage.this.iCurriculaTable.setup(new ArrayList<CurriculumInterface.AcademicClassificationInterface>(result));
            }
        });
    }

    private void loadCurricula() {
        if (!this.iSearch.isEnabled()) {
            return;
        }
        this.iSearch.setEnabled(false);
        this.iPrint.setEnabled(false);
        this.iCurriculaTable.getOperations().setEnabled(false);
        final boolean newEnabled = this.iNew.isEnabled();
        if (newEnabled) {
            this.iNew.setEnabled(false);
        }
        History.newItem((String)this.iFilter.getValue(), (boolean)false);
        this.iCurriculaTable.query((CurriculumInterface.CurriculumFilterRpcRequest)this.iFilter.getElementsRequest(), new Command(){

            public void execute() {
                CurriculaPage.this.iSearch.setEnabled(true);
                CurriculaPage.this.iPrint.setEnabled(true);
                CurriculaPage.this.iCurriculaTable.getOperations().setEnabled(true);
                if (newEnabled) {
                    CurriculaPage.this.iNew.setEnabled(true);
                }
            }
        });
    }

    public void showLoading(String message) {
        LoadingWidget.getInstance().show(message);
    }

    public void hideLoading() {
        LoadingWidget.getInstance().hide();
    }
}

