/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.admin;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Focusable;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.unitime.timetable.gwt.client.Client;
import org.unitime.timetable.gwt.client.Lookup;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.client.events.SingleDateSelector;
import org.unitime.timetable.gwt.client.page.UniTimeNotifications;
import org.unitime.timetable.gwt.client.page.UniTimePageLabel;
import org.unitime.timetable.gwt.client.widgets.NumberBox;
import org.unitime.timetable.gwt.client.widgets.SimpleForm;
import org.unitime.timetable.gwt.client.widgets.UniTimeDialogBox;
import org.unitime.timetable.gwt.client.widgets.UniTimeHeaderPanel;
import org.unitime.timetable.gwt.client.widgets.UniTimeTable;
import org.unitime.timetable.gwt.client.widgets.UniTimeTableHeader;
import org.unitime.timetable.gwt.client.widgets.UniTimeWidget;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseNull;
import org.unitime.timetable.gwt.command.client.GwtRpcService;
import org.unitime.timetable.gwt.command.client.GwtRpcServiceAsync;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.resources.GwtResources;
import org.unitime.timetable.gwt.shared.AcademicSessionProvider;
import org.unitime.timetable.gwt.shared.PersonInterface;
import org.unitime.timetable.gwt.shared.SimpleEditInterface;
import org.unitime.timetable.gwt.shared.UserDataInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleEditPage
extends Composite {
    public static final GwtResources RESOURCES = (GwtResources)GWT.create(GwtResources.class);
    public static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    private static final GwtConstants CONSTANTS = (GwtConstants)GWT.create(GwtConstants.class);
    protected static final GwtRpcServiceAsync RPC = (GwtRpcServiceAsync)GWT.create(GwtRpcService.class);
    private SimpleForm iPanel;
    private UniTimeHeaderPanel iHeader;
    private UniTimeHeaderPanel iBottom;
    private String iType;
    private SimpleEditInterface.PageName iPageName = null;
    private UniTimeTable<SimpleEditInterface.Record> iTable;
    private SimpleEditInterface iData;
    private SimplePanel iSimple;
    private boolean iEditable = false;
    private TextArea iStudentsText = null;
    private Lookup iLookup;
    private boolean[] iVisible = null;
    private AcademicSessionProvider iAcademicSessionProvider = new AcademicSessionProvider(){

        @Override
        public void selectSession(Long sessionId, AsyncCallback<Boolean> callback) {
        }

        @Override
        public String getAcademicSessionName() {
            return SimpleEditPage.this.iData.getSessionName();
        }

        @Override
        public Long getAcademicSessionId() {
            return SimpleEditPage.this.iData.getSessionId();
        }

        @Override
        public void addAcademicSessionChangeHandler(AcademicSessionProvider.AcademicSessionChangeHandler handler) {
        }

        @Override
        public AcademicSessionProvider.AcademicSessionInfo getAcademicSessionInfo() {
            return null;
        }
    };

    public SimpleEditPage() {
        this.iType = Window.Location.getParameter((String)"type");
        if (this.iType == null) {
            throw new RuntimeException(MESSAGES.errorNoEditType());
        }
        ClickHandler save = new ClickHandler(){

            public void onClick(ClickEvent event) {
                String valid = SimpleEditPage.this.validate();
                if (valid != null) {
                    SimpleEditPage.this.iHeader.setErrorMessage(valid);
                    return;
                }
                SimpleEditPage.this.iData.getRecords().clear();
                SimpleEditPage.this.iData.getRecords().addAll(SimpleEditPage.this.iTable.getData());
                SimpleEditPage.this.iHeader.setMessage(MESSAGES.waitSavingData());
                RPC.execute(SimpleEditInterface.SaveDataRpcRequest.saveData(SimpleEditPage.this.iType, SimpleEditPage.this.iData), new AsyncCallback<SimpleEditInterface>(){

                    public void onFailure(Throwable caught) {
                        SimpleEditPage.this.iHeader.setErrorMessage(MESSAGES.failedSave(caught.getMessage()));
                    }

                    public void onSuccess(SimpleEditInterface result) {
                        SimpleEditPage.this.iData = result;
                        SimpleEditPage.this.iEditable = false;
                        SimpleEditPage.this.refreshTable();
                        SimpleEditPage.this.saveOrder();
                    }
                });
            }
        };
        ClickHandler edit = new ClickHandler(){

            public void onClick(ClickEvent event) {
                SimpleEditPage.this.iEditable = true;
                SimpleEditPage.this.iHeader.setEnabled("edit", false);
                SimpleEditPage.this.refreshTable();
            }
        };
        ClickHandler back = new ClickHandler(){

            public void onClick(ClickEvent event) {
                SimpleEditPage.this.iEditable = false;
                SimpleEditPage.this.load(null);
            }
        };
        ClickHandler add = new ClickHandler(){

            public void onClick(ClickEvent event) {
                SimpleEditPage.this.detail(SimpleEditPage.this.iData.addRecord(null));
            }
        };
        this.iPanel = new SimpleForm();
        this.iHeader = new UniTimeHeaderPanel();
        this.iHeader.addButton("add", MESSAGES.buttonAdd(), 75, add);
        this.iHeader.addButton("edit", MESSAGES.buttonEdit(), 75, edit);
        this.iHeader.addButton("save", MESSAGES.buttonSave(), 75, save);
        this.iHeader.addButton("back", MESSAGES.buttonBack(), 75, back);
        this.iPanel.addHeaderRow((Widget)this.iHeader);
        this.iTable = new UniTimeTable();
        this.iTable.setAllowSelection(true);
        this.iPanel.addRow((Widget)this.iTable);
        this.iBottom = this.iHeader.clonePanel();
        this.iPanel.addNotPrintableBottomRow((Widget)this.iBottom);
        this.iSimple = new SimplePanel((Widget)this.iPanel);
        this.initWidget((Widget)this.iSimple);
        final Timer timer = new Timer(){

            public void run() {
                SimpleEditPage.this.saveOrder();
            }
        };
        this.iTable.addDataChangedListener(new UniTimeTable.DataChangedListener<SimpleEditInterface.Record>(){

            @Override
            public void onDataInserted(UniTimeTable.DataChangedEvent<SimpleEditInterface.Record> event) {
            }

            @Override
            public void onDataMoved(List<UniTimeTable.DataChangedEvent<SimpleEditInterface.Record>> event) {
                timer.schedule(5000);
            }

            @Override
            public void onDataRemoved(UniTimeTable.DataChangedEvent<SimpleEditInterface.Record> event) {
            }

            @Override
            public void onDataSorted(List<UniTimeTable.DataChangedEvent<SimpleEditInterface.Record>> event) {
            }
        });
        this.iTable.addMouseClickListener(new UniTimeTable.MouseClickListener<SimpleEditInterface.Record>(){

            @Override
            public void onMouseClick(UniTimeTable.TableEvent<SimpleEditInterface.Record> event) {
                if (event.getCol() == 0 && event.getData() != null && SimpleEditPage.this.hasDetails()) {
                    if ("+".equals(event.getData().getField(0))) {
                        SimpleEditPage.this.setDetailsVisible(event.getData().getUniqueId(), true);
                        return;
                    }
                    if ("-".equals(event.getData().getField(0))) {
                        SimpleEditPage.this.setDetailsVisible(event.getData().getUniqueId(), false);
                        return;
                    }
                }
                if (SimpleEditPage.this.iEditable || !SimpleEditPage.this.iData.isEditable() || event.getData() == null || !event.getData().isEditable()) {
                    return;
                }
                SimpleEditPage.this.detail(event.getData());
            }
        });
        this.iLookup = new Lookup();
        this.iLookup.setOptions("mustHaveExternalId,source=students");
        this.iLookup.addValueChangeHandler(new ValueChangeHandler<PersonInterface>(){

            public void onValueChange(ValueChangeEvent<PersonInterface> event) {
                PersonInterface student = (PersonInterface)event.getValue();
                if (student != null) {
                    SimpleEditPage.this.iStudentsText.setValue((Object)(SimpleEditPage.this.iStudentsText.getValue() + (SimpleEditPage.this.iStudentsText.getValue().isEmpty() ? "" : "\n") + student.getId() + " " + student.getLastName() + ", " + student.getFirstName() + (student.getMiddleName() == null ? "" : " " + student.getMiddleName())), true);
                }
            }
        });
        RPC.execute(SimpleEditInterface.GetPageNameRpcRequest.getPageName(this.iType), new AsyncCallback<SimpleEditInterface.PageName>(){

            public void onFailure(Throwable caught) {
                SimpleEditPage.this.iHeader.setErrorMessage(MESSAGES.failedWrongEditType(caught.getMessage()));
                UniTimeNotifications.error(caught.getMessage(), caught);
            }

            public void onSuccess(SimpleEditInterface.PageName result) {
                SimpleEditPage.this.iPageName = result;
                UniTimePageLabel.getInstance().setPageName(SimpleEditPage.this.iPageName.plural());
                SimpleEditPage.this.load(null);
            }
        });
    }

    private SimpleEditInterface.Record next(SimpleEditInterface.Record record) {
        if (record == null || record.getUniqueId() == null) {
            return null;
        }
        boolean next = false;
        for (int row = 0; row < this.iTable.getRowCount(); ++row) {
            SimpleEditInterface.Record rec = this.iTable.getData(row);
            if (rec == null || rec.getUniqueId() == null || !this.iTable.getRowFormatter().isVisible(row)) continue;
            if (next) {
                return rec;
            }
            if (!record.getUniqueId().equals(rec.getUniqueId())) continue;
            next = true;
        }
        return null;
    }

    private SimpleEditInterface.Record previous(SimpleEditInterface.Record record) {
        if (record == null || record.getUniqueId() == null) {
            return null;
        }
        SimpleEditInterface.Record previous = null;
        for (int row = 0; row < this.iTable.getRowCount(); ++row) {
            SimpleEditInterface.Record rec = this.iTable.getData(row);
            if (rec == null || rec.getUniqueId() == null || !this.iTable.getRowFormatter().isVisible(row)) continue;
            if (record.getUniqueId().equals(rec.getUniqueId())) {
                return previous;
            }
            previous = rec;
        }
        return null;
    }

    private void detail(final SimpleEditInterface.Record record) {
        SimpleFormWithMouseOver detail = new SimpleFormWithMouseOver();
        final ArrayList<MyCell> cells = new ArrayList<MyCell>();
        UniTimePageLabel.getInstance().setPageName(record.getUniqueId() == null ? MESSAGES.pageAdd(this.iPageName.singular()) : MESSAGES.pageEdit(this.iPageName.singular()));
        final UniTimeHeaderPanel header = new UniTimeHeaderPanel();
        SimpleEditInterface.Record prev = this.previous(record);
        SimpleEditInterface.Record next = this.next(record);
        final SimpleEditInterface.Record backup = record.cloneRecord();
        header.addButton("save", MESSAGES.buttonSave(), 75, new ClickHandler(){

            public void onClick(ClickEvent event) {
                String valid = SimpleEditPage.this.validate(record, cells);
                if (valid != null) {
                    header.setErrorMessage(valid);
                    return;
                }
                header.setMessage(MESSAGES.waitSavingRecord());
                RPC.execute(SimpleEditInterface.SaveRecordRpcRequest.saveRecord(SimpleEditPage.this.iType, record), new AsyncCallback<SimpleEditInterface.Record>(){

                    public void onFailure(Throwable caught) {
                        header.setErrorMessage(MESSAGES.failedSave(caught.getMessage()));
                    }

                    public void onSuccess(SimpleEditInterface.Record result) {
                        record.copyFrom(result);
                        SimpleEditPage.this.iEditable = false;
                        SimpleEditPage.this.iSimple.setWidget((Widget)SimpleEditPage.this.iPanel);
                        SimpleEditPage.this.refreshTable();
                        SimpleEditPage.this.saveOrder();
                        for (int r = 0; r < SimpleEditPage.this.iTable.getRowCount(); ++r) {
                            if (SimpleEditPage.this.iTable.getData(r) == null || !record.getUniqueId().equals(((SimpleEditInterface.Record)SimpleEditPage.this.iTable.getData(r)).getUniqueId())) continue;
                            SimpleEditPage.this.iTable.setSelected(r, true);
                            ToolBox.scrollToElement((Element)SimpleEditPage.this.iTable.getRowFormatter().getElement(r - 1));
                            break;
                        }
                        Client.fireGwtPageChanged(new Client.GwtPageChangeEvent());
                    }
                });
            }
        });
        if (record.getUniqueId() != null && record.isDeletable()) {
            header.addButton("delete", MESSAGES.buttonDelete(), 75, new ClickHandler(){

                public void onClick(ClickEvent event) {
                    header.setMessage(MESSAGES.waitDeletingRecord());
                    RPC.execute(SimpleEditInterface.DeleteRecordRpcRequest.deleteRecord(SimpleEditPage.this.iType, record), new AsyncCallback<SimpleEditInterface.Record>(){

                        public void onFailure(Throwable caught) {
                            header.setErrorMessage(MESSAGES.failedDelete(SimpleEditPage.this.iPageName.singular().toLowerCase(), caught.getMessage()));
                        }

                        public void onSuccess(SimpleEditInterface.Record result) {
                            SimpleEditPage.this.iData.getRecords().remove(result);
                            SimpleEditPage.this.iEditable = false;
                            SimpleEditPage.this.iSimple.setWidget((Widget)SimpleEditPage.this.iPanel);
                            SimpleEditPage.this.refreshTable();
                            SimpleEditPage.this.saveOrder();
                            Client.fireGwtPageChanged(new Client.GwtPageChangeEvent());
                        }
                    });
                }
            });
        }
        if (prev != null) {
            header.addButton("prev", MESSAGES.buttonPrevious(), 75, new ClickHandler(){

                public void onClick(ClickEvent event) {
                    String valid = SimpleEditPage.this.validate(record, cells);
                    if (valid != null) {
                        header.setErrorMessage(valid);
                        return;
                    }
                    header.setMessage(MESSAGES.waitSavingRecord());
                    RPC.execute(SimpleEditInterface.SaveRecordRpcRequest.saveRecord(SimpleEditPage.this.iType, record), new AsyncCallback<SimpleEditInterface.Record>(){

                        public void onFailure(Throwable caught) {
                            header.setErrorMessage(MESSAGES.failedSave(caught.getMessage()));
                        }

                        public void onSuccess(SimpleEditInterface.Record result) {
                            record.copyFrom(result);
                            SimpleEditPage.this.refreshTable();
                            SimpleEditInterface.Record prev = SimpleEditPage.this.previous(record);
                            if (prev != null) {
                                SimpleEditPage.this.detail(prev);
                            } else {
                                SimpleEditPage.this.iSimple.setWidget((Widget)SimpleEditPage.this.iPanel);
                            }
                            Client.fireGwtPageChanged(new Client.GwtPageChangeEvent());
                        }
                    });
                }
            });
        }
        if (next != null) {
            header.addButton("next", MESSAGES.buttonNext(), 75, new ClickHandler(){

                public void onClick(ClickEvent event) {
                    String valid = SimpleEditPage.this.validate(record, cells);
                    if (valid != null) {
                        header.setErrorMessage(valid);
                        return;
                    }
                    header.setMessage(MESSAGES.waitSavingRecord());
                    RPC.execute(SimpleEditInterface.SaveRecordRpcRequest.saveRecord(SimpleEditPage.this.iType, record), new AsyncCallback<SimpleEditInterface.Record>(){

                        public void onFailure(Throwable caught) {
                            header.setErrorMessage(MESSAGES.failedSave(caught.getMessage()));
                        }

                        public void onSuccess(SimpleEditInterface.Record result) {
                            record.copyFrom(result);
                            SimpleEditPage.this.refreshTable();
                            SimpleEditInterface.Record next = SimpleEditPage.this.next(record);
                            if (next != null) {
                                SimpleEditPage.this.detail(next);
                            } else {
                                SimpleEditPage.this.iSimple.setWidget((Widget)SimpleEditPage.this.iPanel);
                            }
                            Client.fireGwtPageChanged(new Client.GwtPageChangeEvent());
                        }
                    });
                }
            });
        }
        header.addButton("back", MESSAGES.buttonBack(), 75, new ClickHandler(){

            public void onClick(ClickEvent event) {
                SimpleEditPage.this.iSimple.setWidget((Widget)SimpleEditPage.this.iPanel);
                record.copyFrom(backup);
                if (record.isEmpty()) {
                    SimpleEditPage.this.iData.getRecords().remove(record);
                }
                SimpleEditPage.this.iEditable = false;
                SimpleEditPage.this.iSimple.setWidget((Widget)SimpleEditPage.this.iPanel);
                SimpleEditPage.this.refreshTable();
                SimpleEditPage.this.saveOrder();
                if (record.getUniqueId() != null) {
                    for (int r = 0; r < SimpleEditPage.this.iTable.getRowCount(); ++r) {
                        if (SimpleEditPage.this.iTable.getData(r) == null || !record.getUniqueId().equals(((SimpleEditInterface.Record)SimpleEditPage.this.iTable.getData(r)).getUniqueId())) continue;
                        SimpleEditPage.this.iTable.setSelected(r, true);
                        ToolBox.scrollToElement((Element)SimpleEditPage.this.iTable.getRowFormatter().getElement(r - 1));
                        break;
                    }
                }
                Client.fireGwtPageChanged(new Client.GwtPageChangeEvent());
            }
        });
        detail.addHeaderRow((Widget)header);
        int idx = 0;
        for (SimpleEditInterface.Field field : this.iData.getFields()) {
            MyCell cell = new MyCell(record.isEditable(idx), field, record, idx, true);
            cells.add(cell);
            if (field.isVisible() && field.getType() != SimpleEditInterface.FieldType.parent) {
                String name = field.getName();
                if (this.hasDetails() && name.contains("|")) {
                    name = this.isParent(record) ? name.split("\\|")[0] : name.split("\\|")[1];
                }
                detail.addRow(name + ":", (Widget)cell);
            }
            ++idx;
        }
        UniTimeHeaderPanel bottom = header.clonePanel();
        detail.addNotPrintableBottomRow((Widget)bottom);
        this.iSimple.setWidget((Widget)detail);
        ToolBox.scrollToElement((Element)detail.getElement());
        Client.fireGwtPageChanged(new Client.GwtPageChangeEvent());
    }

    private boolean hasDetails() {
        return this.iData != null && this.iData.getFields().length > 0 && this.iData.getFields()[0].getType() == SimpleEditInterface.FieldType.parent;
    }

    private boolean isParent(SimpleEditInterface.Record r) {
        return this.hasDetails() && ("+".equals(r.getField(0)) || "-".equals(r.getField(0)));
    }

    private boolean isChild(SimpleEditInterface.Record r) {
        return this.hasDetails() && !"+".equals(r.getField(0)) && !"-".equals(r.getField(0));
    }

    private void setDetailsVisible(Long recordId, boolean show) {
        if (!this.hasDetails()) {
            return;
        }
        for (int i = 0; i < this.iTable.getRowCount(); ++i) {
            SimpleEditInterface.Record r = this.iTable.getData(i);
            if (r == null) continue;
            if (r.getUniqueId().equals(recordId)) {
                Image details = (Image)((MyCell)this.iTable.getWidget(i, 0)).getInnerWidget();
                details.setResource(show ? RESOURCES.treeOpen() : RESOURCES.treeClosed());
                r.setField(0, show ? "-" : "+");
                continue;
            }
            if (!String.valueOf(recordId).equals(r.getField(0))) continue;
            this.iTable.getRowFormatter().setVisible(i, show);
        }
        this.saveOrder();
    }

    public void load(final AsyncCallback<Boolean> callback) {
        this.iBottom.setVisible(false);
        this.iHeader.setEnabled("add", false);
        this.iHeader.setEnabled("save", false);
        this.iHeader.setEnabled("edit", false);
        this.iHeader.setEnabled("back", false);
        this.iHeader.setMessage(MESSAGES.waitLoadingData());
        this.iTable.clearTable();
        RPC.execute(SimpleEditInterface.LoadDataRpcRequest.loadData(this.iType), new AsyncCallback<SimpleEditInterface>(){

            public void onSuccess(SimpleEditInterface result) {
                SimpleEditPage.this.iData = result;
                final SimpleEditInterface.RecordComparator cmp = SimpleEditPage.this.iData.getComparator();
                if (SimpleEditPage.this.iData.isSaveOrder()) {
                    UserDataInterface.GetUserDataRpcRequest ordRequest = new UserDataInterface.GetUserDataRpcRequest();
                    ordRequest.add("SimpleEdit.Order[" + SimpleEditPage.this.iType.toString() + "]");
                    if (SimpleEditPage.this.hasDetails()) {
                        ordRequest.add("SimpleEdit.Open[" + SimpleEditPage.this.iType.toString() + "]");
                    }
                    ordRequest.add("SimpleEdit.Hidden[" + SimpleEditPage.this.iType.toString() + "]");
                    RPC.execute(ordRequest, new AsyncCallback<UserDataInterface>(){

                        public void onSuccess(UserDataInterface result) {
                            final String order = "|" + (String)result.get("SimpleEdit.Order[" + SimpleEditPage.this.iType.toString() + "]") + "|";
                            if (SimpleEditPage.this.hasDetails()) {
                                String open = "|" + (String)result.get("SimpleEdit.Open[" + SimpleEditPage.this.iType.toString() + "]") + "|";
                                for (SimpleEditInterface.Record r : SimpleEditPage.this.iData.getRecords()) {
                                    if (!SimpleEditPage.this.isParent(r)) continue;
                                    r.setField(0, open.indexOf("|" + r.getUniqueId() + "|") >= 0 ? "-" : "+");
                                }
                            }
                            Collections.sort(SimpleEditPage.this.iData.getRecords(), new Comparator<SimpleEditInterface.Record>(){

                                @Override
                                public int compare(SimpleEditInterface.Record r1, SimpleEditInterface.Record r2) {
                                    int i1;
                                    if (SimpleEditPage.this.iData.getFields()[0].getType() == SimpleEditInterface.FieldType.parent) {
                                        SimpleEditInterface.Record p2;
                                        SimpleEditInterface.Record p1 = "+".equals(r1.getField(0)) || "-".equals(r1.getField(0)) ? null : SimpleEditPage.this.iData.getRecord(Long.valueOf(r1.getField(0)));
                                        if ((p1 == null ? r1 : p1).equals((p2 = "+".equals(r2.getField(0)) || "-".equals(r2.getField(0)) ? null : SimpleEditPage.this.iData.getRecord(Long.valueOf(r2.getField(0)))) == null ? r2 : p2)) {
                                            if (p1 != null && p2 == null) {
                                                return 1;
                                            }
                                            if (p1 == null && p2 != null) {
                                                return -1;
                                            }
                                        } else if (p1 != null || p2 != null) {
                                            return this.compare(p1 == null ? r1 : p1, p2 == null ? r2 : p2);
                                        }
                                    }
                                    int n = i1 = r1.getUniqueId() == null ? -1 : order.indexOf("|" + r1.getUniqueId() + "|");
                                    if (i1 >= 0) {
                                        int i2;
                                        int n2 = i2 = r2.getUniqueId() == null ? -1 : order.indexOf("|" + r2.getUniqueId() + "|");
                                        if (i2 >= 0) {
                                            return i1 < i2 ? -1 : (i1 > i2 ? 1 : cmp.compare(r1, r2));
                                        }
                                    }
                                    return cmp.compare(r1, r2);
                                }
                            });
                            SimpleEditPage.this.refreshTable("|" + (String)result.get("SimpleEdit.Hidden[" + SimpleEditPage.this.iType.toString() + "]") + "|");
                            if (callback != null) {
                                callback.onSuccess((Object)true);
                            }
                        }

                        public void onFailure(Throwable caught) {
                            Collections.sort(SimpleEditPage.this.iData.getRecords(), cmp);
                            SimpleEditPage.this.refreshTable();
                            if (callback != null) {
                                callback.onSuccess((Object)false);
                            }
                        }
                    });
                } else {
                    SimpleEditPage.this.refreshTable();
                    if (callback != null) {
                        callback.onSuccess((Object)true);
                    }
                }
            }

            public void onFailure(Throwable caught) {
                SimpleEditPage.this.iHeader.setErrorMessage(MESSAGES.failedLoadData(caught.getMessage()));
                ToolBox.checkAccess(caught);
                if (callback != null) {
                    callback.onFailure(caught);
                }
            }
        });
    }

    private List<UniTimeTableHeader> header(boolean top) {
        ArrayList<UniTimeTableHeader> header = new ArrayList<UniTimeTableHeader>();
        int col = 0;
        for (final SimpleEditInterface.Field field : this.iData.getFields()) {
            String name = field.getName();
            if (this.hasDetails() && name.contains("|")) {
                name = name.replace("|", "<br>&nbsp;&nbsp;");
            }
            UniTimeTableHeader cell = new UniTimeTableHeader(name);
            if (!top) {
                cell.addStyleName("unitime-TopLineDash");
                cell.getElement().getStyle().setPaddingTop(2.0, Style.Unit.PX);
            }
            header.add(cell);
            final int index = col;
            if (field.getType() == SimpleEditInterface.FieldType.number) {
                cell.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_RIGHT);
            }
            if (field.getType() == SimpleEditInterface.FieldType.parent) {
                cell.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_CENTER);
                cell.addOperation(new UniTimeTableHeader.Operation(){

                    public void execute() {
                        for (int row = 0; row < SimpleEditPage.this.iTable.getRowCount(); ++row) {
                            SimpleEditInterface.Record r = (SimpleEditInterface.Record)SimpleEditPage.this.iTable.getData(row);
                            if (r == null) continue;
                            if ("+".equals(r.getField(0))) {
                                Image details = (Image)((MyCell)SimpleEditPage.this.iTable.getWidget(row, 0)).getInnerWidget();
                                details.setResource(RESOURCES.treeOpen());
                                r.setField(0, "-");
                                continue;
                            }
                            if ("-".equals(r.getField(0))) continue;
                            SimpleEditPage.this.iTable.getRowFormatter().setVisible(row, true);
                        }
                        SimpleEditPage.this.saveOrder();
                    }

                    public boolean isApplicable() {
                        for (int row = 0; row < SimpleEditPage.this.iTable.getRowCount(); ++row) {
                            SimpleEditInterface.Record r = (SimpleEditInterface.Record)SimpleEditPage.this.iTable.getData(row);
                            if (r == null || !"+".equals(r.getField(0))) continue;
                            return true;
                        }
                        return false;
                    }

                    public boolean hasSeparator() {
                        return false;
                    }

                    public String getName() {
                        return MESSAGES.opExpandAll();
                    }
                });
                cell.addOperation(new UniTimeTableHeader.Operation(){

                    public void execute() {
                        for (int row = 0; row < SimpleEditPage.this.iTable.getRowCount(); ++row) {
                            SimpleEditInterface.Record r = (SimpleEditInterface.Record)SimpleEditPage.this.iTable.getData(row);
                            if (r == null) continue;
                            if ("-".equals(r.getField(0))) {
                                Image details = (Image)((MyCell)SimpleEditPage.this.iTable.getWidget(row, 0)).getInnerWidget();
                                details.setResource(RESOURCES.treeClosed());
                                r.setField(0, "+");
                                continue;
                            }
                            if ("+".equals(r.getField(0))) continue;
                            SimpleEditPage.this.iTable.getRowFormatter().setVisible(row, false);
                        }
                        SimpleEditPage.this.saveOrder();
                    }

                    public boolean isApplicable() {
                        for (int row = 0; row < SimpleEditPage.this.iTable.getRowCount(); ++row) {
                            SimpleEditInterface.Record r = (SimpleEditInterface.Record)SimpleEditPage.this.iTable.getData(row);
                            if (r == null || !"-".equals(r.getField(0))) continue;
                            return true;
                        }
                        return false;
                    }

                    public boolean hasSeparator() {
                        return false;
                    }

                    public String getName() {
                        return MESSAGES.opCollapseAll();
                    }
                });
            } else {
                cell.addOperation(new UniTimeTableHeader.Operation(){

                    public void execute() {
                        SimpleEditPage.this.iTable.sort(index, new Comparator<SimpleEditInterface.Record>(){
                            SimpleEditInterface.RecordComparator iComparator;
                            {
                                this.iComparator = SimpleEditPage.this.iData.getComparator();
                            }

                            @Override
                            public int compare(SimpleEditInterface.Record a, SimpleEditInterface.Record b) {
                                int cmp = this.iComparator.compare(index, a, b);
                                if (cmp != 0) {
                                    return cmp;
                                }
                                return this.iComparator.compare(a, b);
                            }
                        });
                        SimpleEditPage.this.saveOrder();
                    }

                    public boolean isApplicable() {
                        return true;
                    }

                    public boolean hasSeparator() {
                        return false;
                    }

                    public String getName() {
                        return MESSAGES.opSortBy(field.getName());
                    }
                });
                if (col == 0) {
                    cell.addOperation(new UniTimeTableHeader.Operation(){

                        public void execute() {
                            SimpleEditPage.this.iTable.sort(index, SimpleEditPage.this.iData.getComparator());
                            SimpleEditPage.this.saveOrder();
                        }

                        public boolean isApplicable() {
                            return true;
                        }

                        public boolean hasSeparator() {
                            return false;
                        }

                        public String getName() {
                            return MESSAGES.opSortDefault();
                        }
                    });
                }
            }
            if (col == 0) {
                cell.addOperation(new UniTimeTableHeader.Operation(){

                    public void execute() {
                        for (int index = 1; index < SimpleEditPage.this.iData.getFields().length; ++index) {
                            if (!SimpleEditPage.this.iData.getFields()[index].isEditable() || !SimpleEditPage.this.iTable.isColumnVisible(index)) continue;
                            SimpleEditPage.this.iTable.setColumnVisible(index, false);
                            ((SimpleEditPage)SimpleEditPage.this).iVisible[index] = false;
                        }
                        SimpleEditPage.this.saveOrder();
                    }

                    public boolean isApplicable() {
                        for (int index = 1; index < SimpleEditPage.this.iData.getFields().length; ++index) {
                            if (!SimpleEditPage.this.iData.getFields()[index].isEditable() || !SimpleEditPage.this.iTable.isColumnVisible(index)) continue;
                            return true;
                        }
                        return false;
                    }

                    public boolean hasSeparator() {
                        return true;
                    }

                    public String getName() {
                        return MESSAGES.opHideAll();
                    }
                });
                cell.addOperation(new UniTimeTableHeader.Operation(){

                    public void execute() {
                        for (int index = 1; index < SimpleEditPage.this.iData.getFields().length; ++index) {
                            if (!SimpleEditPage.this.iData.getFields()[index].isEditable() || SimpleEditPage.this.iTable.isColumnVisible(index)) continue;
                            SimpleEditPage.this.iTable.setColumnVisible(index, true);
                            ((SimpleEditPage)SimpleEditPage.this).iVisible[index] = true;
                        }
                        SimpleEditPage.this.saveOrder();
                    }

                    public boolean isApplicable() {
                        for (int index = 1; index < SimpleEditPage.this.iData.getFields().length; ++index) {
                            if (!SimpleEditPage.this.iData.getFields()[index].isEditable() || SimpleEditPage.this.iTable.isColumnVisible(index)) continue;
                            return true;
                        }
                        return false;
                    }

                    public boolean hasSeparator() {
                        for (int index = 1; index < SimpleEditPage.this.iData.getFields().length; ++index) {
                            if (!SimpleEditPage.this.iData.getFields()[index].isEditable() || !SimpleEditPage.this.iTable.isColumnVisible(index)) continue;
                            return false;
                        }
                        return true;
                    }

                    public String getName() {
                        return MESSAGES.opShowAll();
                    }
                });
            }
            ++col;
        }
        for (UniTimeTableHeader h : header) {
            col = 0;
            boolean first = true;
            for (final SimpleEditInterface.Field field : this.iData.getFields()) {
                final int index = col;
                if (field.isEditable()) {
                    final boolean sep = first;
                    first = false;
                    h.addOperation(new UniTimeTableHeader.Operation(){

                        public void execute() {
                            SimpleEditPage.this.iTable.setColumnVisible(index, !SimpleEditPage.this.iTable.isColumnVisible(index));
                            ((SimpleEditPage)SimpleEditPage.this).iVisible[index] = SimpleEditPage.this.iTable.isColumnVisible(index);
                            SimpleEditPage.this.saveOrder();
                        }

                        public boolean isApplicable() {
                            if (!SimpleEditPage.this.iTable.isColumnVisible(index)) {
                                return true;
                            }
                            int nrVisible = 0;
                            for (boolean v : SimpleEditPage.this.iVisible) {
                                if (!v) continue;
                                ++nrVisible;
                            }
                            return nrVisible > 1;
                        }

                        public boolean hasSeparator() {
                            return sep;
                        }

                        public String getName() {
                            return SimpleEditPage.this.iTable.isColumnVisible(index) ? MESSAGES.opHide(field.getName()) : MESSAGES.opShow(field.getName());
                        }
                    });
                }
                ++col;
            }
        }
        if (this.iData.isEditable() && this.iEditable) {
            header.add(new UniTimeTableHeader());
            header.add(new UniTimeTableHeader());
        }
        return header;
    }

    private void refreshTable() {
        this.refreshTable(null);
    }

    private void refreshTable(String hidden) {
        UniTimePageLabel.getInstance().setPageName(this.iEditable ? MESSAGES.pageEdit(this.iPageName.plural()) : this.iPageName.plural());
        this.iTable.clearTable();
        this.iTable.setAllowSelection(!this.hasDetails());
        this.iTable.addRow(null, this.header(true));
        if (this.iVisible == null) {
            this.iVisible = new boolean[this.iData.getFields().length];
            for (int i = 0; i < this.iVisible.length; ++i) {
                this.iVisible[i] = this.iData.getFields()[i].isVisible() && (hidden == null || !hidden.contains("|" + this.iData.getFields()[i].getName() + "|"));
            }
        }
        boolean empty = false;
        int row = 1;
        for (SimpleEditInterface.Record r : this.iData.getRecords()) {
            this.fillRow(r, row++);
            empty = r.isEmpty();
            if (row % 31 != 0 || this.hasDetails()) continue;
            this.iTable.addRow(null, this.header(false));
            ++row;
        }
        if (!empty && this.iEditable && this.iData.isEditable() && this.iData.isAddable()) {
            this.fillRow(this.iData.addRecord(null), row);
        }
        this.iBottom.setVisible(true);
        if (this.iData.isEditable()) {
            this.iHeader.setEnabled("back", this.iEditable);
            this.iHeader.setEnabled("save", this.iEditable);
            this.iHeader.setEnabled("edit", !this.iEditable);
            this.iHeader.setEnabled("add", !this.iEditable && this.iData.isAddable());
        }
        for (int i = 0; i < this.iVisible.length; ++i) {
            this.iTable.setColumnVisible(i, this.iVisible[i]);
        }
        this.iHeader.clearMessage();
    }

    private void fillRow(SimpleEditInterface.Record record, int row) {
        ArrayList<MyCell> line = new ArrayList<MyCell>();
        int col = 0;
        for (SimpleEditInterface.Field field : this.iData.getFields()) {
            MyCell cell = new MyCell(this.iData.isEditable() && this.iEditable && record.isEditable(col), field, record, col, false);
            line.add(cell);
            ++col;
        }
        if (this.iData.isAddable() && this.iEditable) {
            Image add = new Image(RESOURCES.add());
            add.getElement().getStyle().setCursor(Style.Cursor.POINTER);
            add.setTitle(MESSAGES.titleInsertRowAbove());
            add.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    int row = SimpleEditPage.this.iTable.getCellForEvent(event).getRowIndex();
                    SimpleEditPage.this.fillRow(SimpleEditPage.this.iData.addRecord(null), SimpleEditPage.this.iTable.insertRow(row));
                }
            });
            line.add((MyCell)add);
        } else if (this.iEditable && this.iData.isEditable()) {
            line.add((MyCell)new Label());
        }
        if (this.iData.isEditable() && this.iEditable && record.isDeletable()) {
            Image delete = new Image(RESOURCES.delete());
            delete.setTitle(MESSAGES.titleDeleteRow());
            delete.getElement().getStyle().setCursor(Style.Cursor.POINTER);
            delete.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    int row = SimpleEditPage.this.iTable.getCellForEvent(event).getRowIndex();
                    SimpleEditPage.this.iData.getRecords().remove(SimpleEditPage.this.iTable.getData(row));
                    SimpleEditPage.this.iTable.removeRow(row);
                }
            });
            line.add((MyCell)delete);
        } else if (this.iEditable && this.iData.isEditable()) {
            line.add((MyCell)new Label());
        }
        this.iTable.setRow(row, record, line);
        if (this.hasDetails()) {
            SimpleEditInterface.Record p;
            if (!"+".equals(record.getField(0)) && !"-".equals(record.getField(0)) && (p = this.iData.getRecord(Long.valueOf(record.getField(0)))) != null && "+".equals(p.getField(0))) {
                this.iTable.getRowFormatter().setVisible(row, false);
            }
            if (this.isParent(record)) {
                this.iTable.getRowFormatter().getElement(row).getStyle().setBackgroundColor("#f3f3f3");
            }
        }
    }

    public void saveOrder() {
        int i;
        if (!this.iData.isSaveOrder()) {
            return;
        }
        this.iHeader.setMessage(MESSAGES.waitSavingOrder());
        String ord = "";
        for (int i2 = 0; i2 < this.iTable.getRowCount(); ++i2) {
            SimpleEditInterface.Record r = this.iTable.getData(i2);
            if (r == null || r.getUniqueId() == null) continue;
            if (!ord.isEmpty()) {
                ord = ord + "|";
            }
            ord = ord + r.getUniqueId();
        }
        UserDataInterface.SetUserDataRpcRequest data = new UserDataInterface.SetUserDataRpcRequest();
        data.put("SimpleEdit.Order[" + this.iType.toString() + "]", ord);
        if (this.iData.getFields()[0].getType() == SimpleEditInterface.FieldType.parent) {
            String open = "";
            for (i = 0; i < this.iTable.getRowCount(); ++i) {
                SimpleEditInterface.Record r = this.iTable.getData(i);
                if (r == null || r.getUniqueId() == null || !"-".equals(r.getField(0))) continue;
                if (!open.isEmpty()) {
                    open = open + "|";
                }
                open = open + r.getUniqueId();
            }
            data.put("SimpleEdit.Open[" + this.iType.toString() + "]", open);
        }
        String hidden = "";
        for (i = 0; i < this.iData.getFields().length; ++i) {
            if (this.iTable.isColumnVisible(i)) continue;
            if (!hidden.isEmpty()) {
                hidden = hidden + "|";
            }
            hidden = hidden + this.iData.getFields()[i].getName();
        }
        data.put("SimpleEdit.Hidden[" + this.iType.toString() + "]", hidden);
        RPC.execute(data, new AsyncCallback<GwtRpcResponseNull>(){

            public void onFailure(Throwable caught) {
                SimpleEditPage.this.iHeader.clearMessage();
            }

            public void onSuccess(GwtRpcResponseNull result) {
                SimpleEditPage.this.iHeader.clearMessage();
            }
        });
    }

    public String validate() {
        return this.validate(null, null);
    }

    /*
     * Unable to fully structure code
     */
    public String validate(SimpleEditInterface.Record detailRecord, List<MyCell> detailCells) {
        block23: {
            valid = null;
            dateFormat = DateTimeFormat.getFormat((String)SimpleEditPage.CONSTANTS.eventDateFormat());
            uniqueMap = new HashMap<Integer, HashMap<K, V>>();
            for (row = 0; row < this.iTable.getRowCount(); ++row) {
                record = this.iTable.getData(row);
                if (record == null || record.isEmpty() || detailRecord != null && detailRecord.getUniqueId() != null && detailRecord.getUniqueId().equals(record.getUniqueId())) continue;
                block13: for (col = 0; col < this.iData.getFields().length; ++col) {
                    field = this.iData.getFields()[col];
                    value = record.getField(col);
                    widget = (MyCell)this.iTable.getWidget(row, col);
                    widget.setError(null);
                    if (!field.isEditable()) continue;
                    if (field.isUnique()) {
                        values = (HashMap<String, MyCell>)uniqueMap.get(col);
                        if (values == null) {
                            values = new HashMap<String, MyCell>();
                            uniqueMap.put(col, values);
                        }
                        if (value == null || value.isEmpty()) {
                            widget.setError(SimpleEditPage.MESSAGES.errorMustBeSet(field.getName()));
                            if (valid != null || detailRecord != null) continue;
                            valid = SimpleEditPage.MESSAGES.errorMustBeSet(field.getName());
                            continue;
                        }
                        old = values.put(value, widget);
                        if (old == null) continue;
                        widget.setError(SimpleEditPage.MESSAGES.errorMustBeUnique(field.getName()));
                        old.setError(SimpleEditPage.MESSAGES.errorMustBeUnique(field.getName()));
                        if (valid != null || detailRecord != null) continue;
                        valid = SimpleEditPage.MESSAGES.errorMustBeUnique(field.getName());
                        continue;
                    }
                    if (field.isNotEmpty() || this.isParent(record) && field.isParentNotEmpty()) {
                        if (value != null && !value.isEmpty()) continue;
                        widget.setError(SimpleEditPage.MESSAGES.errorMustBeSet(field.getName()));
                        if (valid != null || detailRecord != null) continue;
                        valid = SimpleEditPage.MESSAGES.errorMustBeSet(field.getName());
                        continue;
                    }
                    switch (27.$SwitchMap$org$unitime$timetable$gwt$shared$SimpleEditInterface$FieldType[field.getType().ordinal()]) {
                        case 9: {
                            date = null;
                            try {
                                date = dateFormat.parse(value);
                            }
                            catch (Exception e) {
                                widget.setError(SimpleEditPage.MESSAGES.errorNotValidDate(value));
                                if (valid != null || detailRecord != null) ** GOTO lbl47
                                valid = SimpleEditPage.MESSAGES.errorNotValidDate(value);
                            }
lbl47:
                            // 3 sources

                            if (date != null || !field.isNotEmpty()) continue block13;
                            widget.setError(SimpleEditPage.MESSAGES.errorMustBeSet(field.getName()));
                            if (valid != null || detailRecord != null) continue block13;
                            valid = SimpleEditPage.MESSAGES.errorMustBeSet(field.getName());
                            continue block13;
                        }
                        case 2: {
                            if (value.length() <= field.getLength()) continue block13;
                            widget.setError(SimpleEditPage.MESSAGES.errorTooLong(field.getName()));
                            if (valid != null || detailRecord != null) continue block13;
                            valid = SimpleEditPage.MESSAGES.errorTooLong(field.getName());
                        }
                    }
                }
            }
            if (detailRecord == null || detailCells.isEmpty()) break block23;
            record = detailRecord;
            block14: for (col = 0; col < this.iData.getFields().length; ++col) {
                field = this.iData.getFields()[col];
                value = record.getField(col);
                widget = detailCells.get(col);
                widget.setError(null);
                if (!field.isEditable()) continue;
                if (field.isUnique()) {
                    values = (HashMap<String, MyCell>)uniqueMap.get(col);
                    if (values == null) {
                        values = new HashMap<String, MyCell>();
                        uniqueMap.put(col, values);
                    }
                    if (value == null || value.isEmpty()) {
                        widget.setError(SimpleEditPage.MESSAGES.errorMustBeSet(field.getName()));
                        if (valid != null) continue;
                        valid = SimpleEditPage.MESSAGES.errorMustBeSet(field.getName());
                        continue;
                    }
                    old = values.put(value, widget);
                    if (old == null) continue;
                    widget.setError(SimpleEditPage.MESSAGES.errorMustBeUnique(field.getName()));
                    old.setError(SimpleEditPage.MESSAGES.errorMustBeUnique(field.getName()));
                    if (valid != null) continue;
                    valid = SimpleEditPage.MESSAGES.errorMustBeUnique(field.getName());
                    continue;
                }
                if (field.isNotEmpty() || this.isParent(record) && field.isParentNotEmpty()) {
                    if (value != null && !value.isEmpty()) continue;
                    widget.setError(SimpleEditPage.MESSAGES.errorMustBeSet(field.getName()));
                    if (valid != null) continue;
                    valid = SimpleEditPage.MESSAGES.errorMustBeSet(field.getName());
                    continue;
                }
                switch (27.$SwitchMap$org$unitime$timetable$gwt$shared$SimpleEditInterface$FieldType[field.getType().ordinal()]) {
                    case 9: {
                        date = null;
                        try {
                            date = dateFormat.parse(value);
                        }
                        catch (Exception e) {
                            widget.setError(SimpleEditPage.MESSAGES.errorNotValidDate(value));
                            if (valid != null) ** GOTO lbl101
                            valid = SimpleEditPage.MESSAGES.errorNotValidDate(value);
                        }
lbl101:
                        // 3 sources

                        if (date != null || !field.isNotEmpty()) continue block14;
                        widget.setError(SimpleEditPage.MESSAGES.errorMustBeSet(field.getName()));
                        if (valid != null) continue block14;
                        valid = SimpleEditPage.MESSAGES.errorMustBeSet(field.getName());
                        continue block14;
                    }
                    case 2: {
                        if (value.length() <= field.getLength()) continue block14;
                        widget.setError(SimpleEditPage.MESSAGES.errorTooLong(field.getName()));
                        if (valid != null) continue block14;
                        valid = SimpleEditPage.MESSAGES.errorTooLong(field.getName());
                    }
                }
            }
        }
        return valid;
    }

    public static class SimpleFormWithMouseOver
    extends SimpleForm {
        public SimpleFormWithMouseOver() {
            this.sinkEvents(16);
            this.sinkEvents(32);
        }

        public void onBrowserEvent(Event event) {
            com.google.gwt.user.client.Element td = this.getEventTargetCell(event);
            if (td == null) {
                return;
            }
            com.google.gwt.user.client.Element tr = DOM.getParent((Element)td);
            int col = DOM.getChildIndex((Element)tr, (Element)td);
            com.google.gwt.user.client.Element body = DOM.getParent((Element)tr);
            int row = DOM.getChildIndex((Element)body, (Element)tr);
            Widget widget = this.getWidget(row, col);
            if (widget != null && widget instanceof UniTimeHeaderPanel) {
                super.onBrowserEvent(event);
                return;
            }
            switch (DOM.eventGetType((Event)event)) {
                case 16: {
                    this.getRowFormatter().addStyleName(row, "hover");
                    break;
                }
                case 32: {
                    this.getRowFormatter().removeStyleName(row, "hover");
                }
            }
            super.onBrowserEvent(event);
        }
    }

    public class MyCell
    extends Composite
    implements UniTimeTable.HasFocus,
    UniTimeTable.HasCellAlignment {
        private SimpleEditInterface.Field iField;
        private SimpleEditInterface.Record iRecord;
        private int iIndex;
        private boolean iDetail;

        public MyCell(boolean editable, final SimpleEditInterface.Field field, final SimpleEditInterface.Record record, final int index, boolean detail) {
            this.iField = field;
            this.iRecord = record;
            this.iIndex = index;
            this.iDetail = detail;
            if (field.getType() == SimpleEditInterface.FieldType.parent) {
                if ("+".equals(record.getField(index))) {
                    this.initWidget((Widget)new Image(RESOURCES.treeClosed()));
                } else if ("-".equals(record.getField(index))) {
                    this.initWidget((Widget)new Image(RESOURCES.treeOpen()));
                } else {
                    this.initWidget((Widget)new Label());
                }
                return;
            }
            if (editable) {
                switch (field.getType()) {
                    case text: {
                        final TextBox text = new TextBox();
                        text.setStyleName("unitime-TextBox");
                        text.setMaxLength(field.getLength());
                        text.setText(record.getField(index));
                        text.setWidth(field.getWidth() + "px");
                        text.addChangeHandler(new ChangeHandler(){

                            public void onChange(ChangeEvent event) {
                                record.setField(index, text.getText());
                                MyCell.this.setError(null);
                            }
                        });
                        this.initWidget((Widget)new UniTimeWidget<TextBox>(text));
                        if (!SimpleEditPage.this.iEditable || !SimpleEditPage.this.iData.isAddable() || record.getUniqueId() != null) break;
                        text.addChangeHandler(new ChangeHandler(){

                            public void onChange(ChangeEvent event) {
                                if (SimpleEditPage.this.iData.getRecords().indexOf(MyCell.this.iRecord) == SimpleEditPage.this.iData.getRecords().size() - 1 && !record.isEmpty()) {
                                    SimpleEditPage.this.fillRow(SimpleEditPage.this.iData.addRecord(null), SimpleEditPage.this.iTable.insertRow(SimpleEditPage.this.iTable.getRowCount()));
                                }
                            }
                        });
                        break;
                    }
                    case textarea: {
                        final TextArea textarea = new TextArea();
                        textarea.setStyleName("unitime-TextArea");
                        if (detail) {
                            textarea.setVisibleLines(Math.max(5, field.getHeight()));
                            textarea.setCharacterWidth(Math.max(80, field.getWidth()));
                        } else {
                            textarea.setVisibleLines(field.getHeight() <= 0 ? 2 : Math.min(3, field.getHeight()));
                            textarea.setCharacterWidth(field.getWidth() <= 0 ? 40 : Math.min(60, field.getWidth()));
                        }
                        textarea.setText(record.getField(index));
                        textarea.addChangeHandler(new ChangeHandler(){

                            public void onChange(ChangeEvent event) {
                                record.setField(index, textarea.getText());
                                MyCell.this.setError(null);
                            }
                        });
                        this.initWidget((Widget)new UniTimeWidget<TextArea>(textarea));
                        if (!SimpleEditPage.this.iEditable || !SimpleEditPage.this.iData.isAddable() || record.getUniqueId() != null) break;
                        textarea.addChangeHandler(new ChangeHandler(){

                            public void onChange(ChangeEvent event) {
                                if (SimpleEditPage.this.iData.getRecords().indexOf(MyCell.this.iRecord) == SimpleEditPage.this.iData.getRecords().size() - 1 && !record.isEmpty()) {
                                    SimpleEditPage.this.fillRow(SimpleEditPage.this.iData.addRecord(null), SimpleEditPage.this.iTable.insertRow(SimpleEditPage.this.iTable.getRowCount()));
                                }
                            }
                        });
                        break;
                    }
                    case number: {
                        final NumberBox number = new NumberBox();
                        number.getElement().getStyle().setTextAlign(Style.TextAlign.RIGHT);
                        number.setText(record.getField(index));
                        number.setDecimal(field.isAllowFloatingPoint());
                        number.setNegative(field.isAllowNegative());
                        number.setWidth(field.getWidth() + "px");
                        number.addChangeHandler(new ChangeHandler(){

                            public void onChange(ChangeEvent event) {
                                record.setField(index, number.getText());
                                MyCell.this.setError(null);
                            }
                        });
                        this.initWidget((Widget)new UniTimeWidget<NumberBox>(number));
                        if (!SimpleEditPage.this.iEditable || !SimpleEditPage.this.iData.isAddable() || record.getUniqueId() != null) break;
                        number.addChangeHandler(new ChangeHandler(){

                            public void onChange(ChangeEvent event) {
                                if (SimpleEditPage.this.iData.getRecords().indexOf(MyCell.this.iRecord) == SimpleEditPage.this.iData.getRecords().size() - 1 && !record.isEmpty()) {
                                    SimpleEditPage.this.fillRow(SimpleEditPage.this.iData.addRecord(null), SimpleEditPage.this.iTable.insertRow(SimpleEditPage.this.iTable.getRowCount()));
                                }
                            }
                        });
                        break;
                    }
                    case list: {
                        final ListBox list = new ListBox(false);
                        list.setStyleName("unitime-TextBox");
                        if ((record.getField(index) == null || record.getField(index).isEmpty() || !field.isNotEmpty() && (SimpleEditPage.this.isChild(record) || field.isParentNotEmpty())) && (field.getValues().isEmpty() || !field.getValues().get(0).getValue().isEmpty())) {
                            list.addItem("", "");
                        }
                        for (SimpleEditInterface.ListItem item : field.getValues()) {
                            list.addItem(item.getText(), item.getValue());
                        }
                        for (int i = 0; i < list.getItemCount(); ++i) {
                            if (!list.getValue(i).equals(record.getField(index))) continue;
                            list.setSelectedIndex(i);
                        }
                        list.addChangeHandler(new ChangeHandler(){

                            public void onChange(ChangeEvent event) {
                                record.setField(index, list.getSelectedIndex() < 0 || list.getValue(list.getSelectedIndex()).isEmpty() ? null : list.getValue(list.getSelectedIndex()));
                                MyCell.this.setError(null);
                            }
                        });
                        this.initWidget((Widget)new UniTimeWidget<ListBox>(list));
                        if (!SimpleEditPage.this.iEditable || !SimpleEditPage.this.iData.isAddable() || record.getUniqueId() != null) break;
                        list.addChangeHandler(new ChangeHandler(){

                            public void onChange(ChangeEvent event) {
                                if (SimpleEditPage.this.iData.getRecords().indexOf(MyCell.this.iRecord) == SimpleEditPage.this.iData.getRecords().size() - 1 && !record.isEmpty()) {
                                    SimpleEditPage.this.fillRow(SimpleEditPage.this.iData.addRecord(null), SimpleEditPage.this.iTable.insertRow(SimpleEditPage.this.iTable.getRowCount()));
                                }
                            }
                        });
                        break;
                    }
                    case multi: {
                        final ListBox multi = new ListBox(true);
                        multi.setStyleName("unitime-TextBox");
                        multi.setVisibleItemCount(3);
                        for (SimpleEditInterface.ListItem listItem : field.getValues()) {
                            multi.addItem(listItem.getText(), listItem.getValue());
                        }
                        String[] vals = record.getValues(index);
                        if (vals != null) {
                            for (String val : vals) {
                                for (int i = 0; i < multi.getItemCount(); ++i) {
                                    if (!multi.getValue(i).equals(val)) continue;
                                    multi.setItemSelected(i, true);
                                }
                            }
                        }
                        multi.addChangeHandler(new ChangeHandler(){

                            public void onChange(ChangeEvent event) {
                                record.setField(index, null);
                                for (int i = 0; i < multi.getItemCount(); ++i) {
                                    if (!multi.isItemSelected(i)) continue;
                                    record.addToField(index, multi.getValue(i));
                                }
                                MyCell.this.setError(null);
                            }
                        });
                        this.initWidget((Widget)new UniTimeWidget<ListBox>(multi));
                        if (!SimpleEditPage.this.iEditable || !SimpleEditPage.this.iData.isAddable() || record.getUniqueId() != null) break;
                        multi.addChangeHandler(new ChangeHandler(){

                            public void onChange(ChangeEvent event) {
                                if (SimpleEditPage.this.iData.getRecords().indexOf(MyCell.this.iRecord) == SimpleEditPage.this.iData.getRecords().size() - 1 && !record.isEmpty()) {
                                    SimpleEditPage.this.fillRow(SimpleEditPage.this.iData.addRecord(null), SimpleEditPage.this.iTable.insertRow(SimpleEditPage.this.iTable.getRowCount()));
                                }
                            }
                        });
                        break;
                    }
                    case toggle: {
                        final CheckBox checkBox = new CheckBox();
                        checkBox.setValue(record.getField(index) == null ? null : Boolean.valueOf("true".equalsIgnoreCase(record.getField(index))));
                        checkBox.addClickHandler(new ClickHandler(){

                            public void onClick(ClickEvent event) {
                                record.setField(index, checkBox.getValue() == null ? null : (checkBox.getValue() != false ? "true" : "false"));
                                MyCell.this.setError(null);
                            }
                        });
                        this.initWidget((Widget)new UniTimeWidget<CheckBox>(checkBox));
                        if (!SimpleEditPage.this.iEditable || !SimpleEditPage.this.iData.isAddable() || record.getUniqueId() != null) break;
                        checkBox.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

                            public void onValueChange(ValueChangeEvent<Boolean> event) {
                                if (SimpleEditPage.this.iData.getRecords().indexOf(MyCell.this.iRecord) == SimpleEditPage.this.iData.getRecords().size() - 1 && !record.isEmpty()) {
                                    SimpleEditPage.this.fillRow(SimpleEditPage.this.iData.addRecord(null), SimpleEditPage.this.iTable.insertRow(SimpleEditPage.this.iTable.getRowCount()));
                                }
                            }
                        });
                        break;
                    }
                    case students: {
                        if (detail) {
                            final TextArea area = new TextArea();
                            area.setValue((Object)this.getValue());
                            area.setStyleName("unitime-TextArea");
                            area.setVisibleLines(10);
                            area.setCharacterWidth(80);
                            area.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

                                public void onValueChange(ValueChangeEvent<String> event) {
                                    record.setField(index, area.getText());
                                    MyCell.this.setError(null);
                                }
                            });
                            VerticalPanel students = new VerticalPanel();
                            students.add((Widget)area);
                            Button lookup = new Button(MESSAGES.buttonLookup());
                            lookup.setAccessKey(UniTimeHeaderPanel.guessAccessKey(MESSAGES.buttonLookup()).charValue());
                            lookup.addClickHandler(new ClickHandler(){

                                public void onClick(ClickEvent event) {
                                    SimpleEditPage.this.iStudentsText = area;
                                    SimpleEditPage.this.iLookup.center();
                                }
                            });
                            students.add((Widget)lookup);
                            students.setCellHorizontalAlignment((Widget)lookup, HasHorizontalAlignment.ALIGN_RIGHT);
                            this.initWidget((Widget)new UniTimeWidget<VerticalPanel>(students));
                            break;
                        }
                        HorizontalPanel hp = new HorizontalPanel();
                        final Label label = new Label(String.valueOf(this.getValue().isEmpty() ? 0 : this.getValue().split("\\n").length));
                        hp.add((Widget)label);
                        Image change = new Image(RESOURCES.edit());
                        hp.add((Widget)change);
                        hp.setCellVerticalAlignment((Widget)change, HasVerticalAlignment.ALIGN_MIDDLE);
                        label.getElement().getStyle().setPaddingRight(5.0, Style.Unit.PX);
                        change.addClickHandler(new ClickHandler(){

                            public void onClick(ClickEvent event) {
                                final UniTimeDialogBox dialog = new UniTimeDialogBox(true, true);
                                SimpleForm form = new SimpleForm();
                                final TextArea text = new TextArea();
                                text.setValue((Object)MyCell.this.getValue());
                                text.setStyleName("unitime-TextArea");
                                text.setVisibleLines(10);
                                text.setCharacterWidth(80);
                                text.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

                                    public void onValueChange(ValueChangeEvent<String> event) {
                                        record.setField(index, (String)event.getValue());
                                        label.setText(String.valueOf(((String)event.getValue()).isEmpty() ? 0 : ((String)event.getValue()).split("\\n").length));
                                        MyCell.this.setError(null);
                                    }
                                });
                                form.addRow((Widget)text);
                                UniTimeHeaderPanel header = new UniTimeHeaderPanel();
                                header.addButton("lookup", MESSAGES.buttonLookup(), 75, new ClickHandler(){

                                    public void onClick(ClickEvent event) {
                                        SimpleEditPage.this.iStudentsText = text;
                                        SimpleEditPage.this.iLookup.center();
                                    }
                                });
                                header.addButton("close", MESSAGES.buttonClose(), 75, new ClickHandler(){

                                    public void onClick(ClickEvent event) {
                                        dialog.hide();
                                    }
                                });
                                form.addBottomRow((Widget)header);
                                dialog.setText(field.getName());
                                dialog.setWidget((Widget)form);
                                dialog.setEscapeToHide(true);
                                dialog.center();
                            }
                        });
                        this.initWidget((Widget)new UniTimeWidget<HorizontalPanel>(hp));
                        break;
                    }
                    case person: {
                        HorizontalPanel hp = new HorizontalPanel();
                        String[] name = record.getValues(index);
                        final HTML label = new HTML(name.length <= 2 ? "<i>" + MESSAGES.notSet() + "</i>" : (name.length >= 6 && !name[6].isEmpty() ? name[6] : name[0] + ", " + name[1] + (name[2].isEmpty() ? "" : " " + name[2])));
                        label.setWidth(field.getWidth() + "px");
                        hp.add((Widget)label);
                        Image change = new Image(RESOURCES.edit());
                        hp.add((Widget)change);
                        hp.setCellVerticalAlignment((Widget)change, HasVerticalAlignment.ALIGN_MIDDLE);
                        hp.setWidth("100%");
                        hp.setCellHorizontalAlignment((Widget)change, HasHorizontalAlignment.ALIGN_RIGHT);
                        label.getElement().getStyle().setPaddingRight(5.0, Style.Unit.PX);
                        change.addClickHandler(new ClickHandler(){

                            public void onClick(ClickEvent event) {
                                Lookup lookup = new Lookup();
                                lookup.setOptions("mustHaveExternalId");
                                String[] name = record.getValues(index);
                                if (name != null && name.length > 2) {
                                    lookup.setQuery(name[0] + ", " + name[1] + (name[2].isEmpty() ? "" : " " + name[2]));
                                }
                                lookup.addValueChangeHandler(new ValueChangeHandler<PersonInterface>(){

                                    public void onValueChange(ValueChangeEvent<PersonInterface> event) {
                                        PersonInterface person = (PersonInterface)event.getValue();
                                        if (person != null) {
                                            label.setText(person.hasFormattedName() ? person.getFormattedName() : person.getLastName() + ", " + person.getFirstName() + (person.getMiddleName() == null ? "" : " " + person.getMiddleName()));
                                            record.setField(index, null);
                                            record.addToField(index, person.getLastName() == null ? "" : person.getLastName());
                                            record.addToField(index, person.getFirstName() == null ? "" : person.getFirstName());
                                            record.addToField(index, person.getMiddleName() == null ? "" : person.getMiddleName());
                                            record.addToField(index, person.getId() == null ? "" : person.getId());
                                            record.addToField(index, person.getEmail() == null ? "" : person.getEmail());
                                            record.addToField(index, person.getAcademicTitle() == null ? "" : person.getAcademicTitle());
                                            record.addToField(index, person.getFormattedName() == null ? "" : person.getFormattedName());
                                            MyCell.this.setError(null);
                                        }
                                    }
                                });
                                lookup.center();
                            }
                        });
                        this.initWidget((Widget)new UniTimeWidget<HorizontalPanel>(hp));
                        break;
                    }
                    case date: {
                        final SingleDateSelector date = new SingleDateSelector(SimpleEditPage.this.iData.getSessionId() == null ? null : SimpleEditPage.this.iAcademicSessionProvider, false);
                        date.setText(record.getField(index));
                        date.addValueChangeHandler(new ValueChangeHandler<Date>(){

                            public void onValueChange(ValueChangeEvent<Date> event) {
                                record.setField(index, date.getText());
                                MyCell.this.setError(null);
                            }
                        });
                        this.initWidget((Widget)new UniTimeWidget<SingleDateSelector>(date));
                        if (!SimpleEditPage.this.iEditable || !SimpleEditPage.this.iData.isAddable() || record.getUniqueId() != null) break;
                        date.addValueChangeHandler(new ValueChangeHandler<Date>(){

                            public void onValueChange(ValueChangeEvent<Date> event) {
                                if (SimpleEditPage.this.iData.getRecords().indexOf(MyCell.this.iRecord) == SimpleEditPage.this.iData.getRecords().size() - 1 && !record.isEmpty()) {
                                    SimpleEditPage.this.fillRow(SimpleEditPage.this.iData.addRecord(null), SimpleEditPage.this.iTable.insertRow(SimpleEditPage.this.iTable.getRowCount()));
                                }
                            }
                        });
                    }
                }
            } else {
                switch (field.getType()) {
                    case toggle: {
                        Image image = new Image(record.getField(index) != null && "true".equalsIgnoreCase(record.getField(index)) ? RESOURCES.on() : RESOURCES.off());
                        this.initWidget((Widget)image);
                        break;
                    }
                    case students: {
                        if (detail) {
                            HTML html = new HTML(this.getValue().replaceAll("\\n", "<br>"));
                            this.initWidget((Widget)html);
                            break;
                        }
                        Label label = new Label(String.valueOf(this.getValue().isEmpty() ? 0 : this.getValue().split("\\n").length));
                        this.initWidget((Widget)label);
                        break;
                    }
                    case person: {
                        String[] name = record.getValues(index);
                        this.initWidget((Widget)new HTML(name.length <= 2 ? "<i>" + MESSAGES.notSet() + "</i>" : (name.length >= 6 && !name[6].isEmpty() ? name[6] : name[0] + ", " + name[1] + (name[2].isEmpty() ? "" : " " + name[2]))));
                        break;
                    }
                    case textarea: {
                        HTML html = new HTML(this.getValue());
                        this.initWidget((Widget)html);
                        break;
                    }
                    default: {
                        Label label = new Label(this.getValue());
                        this.initWidget((Widget)label);
                        if (field.getType() != SimpleEditInterface.FieldType.number) break;
                        label.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_RIGHT);
                    }
                }
            }
            if (!detail && index > 0 && SimpleEditPage.this.iData.getFields()[index].getName().contains("|") && SimpleEditPage.this.isChild(record)) {
                this.getElement().getStyle().setPaddingLeft(20.0, Style.Unit.PX);
            }
            this.setError(null);
        }

        public void setError(String message) {
            if (this.getWidget() instanceof UniTimeWidget) {
                UniTimeWidget w = (UniTimeWidget)this.getWidget();
                if (message == null || message.isEmpty()) {
                    String parent;
                    w.clearHint();
                    if (this.iDetail && this.iField.isShowParentWhenEmpty() && (parent = this.getParentValue()) != null && !parent.isEmpty()) {
                        w.setHint(MESSAGES.hintDefaultsToWhenEmpty(parent.length() > 80 ? parent.substring(0, 77) + "..." : parent));
                    }
                } else {
                    w.setErrorHint(message);
                }
            }
        }

        public String getParentValue() {
            if (!SimpleEditPage.this.isChild(this.iRecord)) {
                return null;
            }
            SimpleEditInterface.Record parent = SimpleEditPage.this.iData.getRecord(Long.valueOf(this.iRecord.getField(0)));
            if (parent == null) {
                return null;
            }
            String value = parent.getField(this.iIndex);
            if (value == null) {
                return "";
            }
            if (this.iField.getType() == SimpleEditInterface.FieldType.list) {
                for (SimpleEditInterface.ListItem item : this.iField.getValues()) {
                    if (!item.getValue().equals(value)) continue;
                    return item.getText();
                }
            } else if (this.iField.getType() == SimpleEditInterface.FieldType.multi) {
                String text = "";
                for (String val : parent.getValues(this.iIndex)) {
                    for (SimpleEditInterface.ListItem item : this.iField.getValues()) {
                        if (!item.getValue().equals(val)) continue;
                        if (!text.isEmpty()) {
                            text = text + ", ";
                        }
                        text = text + item.getText();
                    }
                }
                return text;
            }
            return value;
        }

        public String getValue() {
            String value = this.iRecord.getField(this.iIndex);
            if (value == null) {
                return "";
            }
            if (this.iField.getType() == SimpleEditInterface.FieldType.list) {
                for (SimpleEditInterface.ListItem item : this.iField.getValues()) {
                    if (!item.getValue().equals(value)) continue;
                    return item.getText();
                }
            } else if (this.iField.getType() == SimpleEditInterface.FieldType.multi) {
                String text = "";
                for (String val : this.iRecord.getValues(this.iIndex)) {
                    for (SimpleEditInterface.ListItem item : this.iField.getValues()) {
                        if (!item.getValue().equals(val)) continue;
                        if (!text.isEmpty()) {
                            text = text + ", ";
                        }
                        text = text + item.getText();
                    }
                }
                return text;
            }
            return value;
        }

        public SimpleEditInterface.Record getRecord() {
            return this.iRecord;
        }

        public boolean focus() {
            Object w = this.getWidget();
            if (w instanceof UniTimeWidget) {
                w = ((UniTimeWidget)w).getWidget();
            }
            if (w instanceof Focusable) {
                ((Focusable)w).setFocus(true);
                if (w instanceof TextBox) {
                    ((TextBox)w).selectAll();
                }
                return true;
            }
            return false;
        }

        public Widget getInnerWidget() {
            return this.getWidget();
        }

        public HasHorizontalAlignment.HorizontalAlignmentConstant getCellAlignment() {
            switch (this.iField.getType()) {
                case toggle: {
                    return HasHorizontalAlignment.ALIGN_CENTER;
                }
                case students: {
                    return HasHorizontalAlignment.ALIGN_RIGHT;
                }
            }
            return HasHorizontalAlignment.ALIGN_LEFT;
        }
    }
}

