/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.form;

import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.TimePattern;
import org.unitime.timetable.model.TimePatternDays;
import org.unitime.timetable.model.TimePatternTime;
import org.unitime.timetable.model.TimePref;
import org.unitime.timetable.model.dao.DepartmentDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.model.dao.TimePatternDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.context.HttpSessionContext;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.webutil.RequiredTimeTable;

public class TimePatternEditForm
extends ActionForm {
    private static final long serialVersionUID = 2957933039987971879L;
    private String iOp;
    private Long iUniqueId;
    private String iType;
    private String iNrMtgs;
    private String iMinPerMtg;
    private String iSlotsPerMtg;
    private String iDayCodes;
    private String iStartTimes;
    private boolean iEditable;
    private boolean iVisible;
    private String iName;
    private Vector iDepartmentIds = new Vector();
    private Long iDepartmentId;
    private String iBreakTime;

    public ActionErrors validate(ActionMapping mapping, HttpServletRequest request) {
        ActionErrors errors = new ActionErrors();
        if (this.iName == null || this.iName.trim().length() == 0) {
            errors.add("name", new ActionMessage("errors.required", (Object)""));
        } else {
            try {
                TimePattern pat = TimePattern.findByName(HttpSessionContext.getSessionContext(request.getSession().getServletContext()).getUser().getCurrentAcademicSessionId(), this.iName);
                if (pat != null && !pat.getUniqueId().equals(this.iUniqueId)) {
                    errors.add("name", new ActionMessage("errors.exists", (Object)this.iName));
                }
            }
            catch (Exception e) {
                errors.add("name", new ActionMessage("errors.generic", (Object)e.getMessage()));
            }
        }
        try {
            if (Integer.parseInt(this.getNrMtgs()) <= 0 && this.getTypeInt() != 5) {
                errors.add("nrMtgs", new ActionMessage("errors.required", (Object)""));
            }
        }
        catch (NumberFormatException e) {
            errors.add("nrMtgs", new ActionMessage("errors.required", (Object)""));
        }
        try {
            if (Integer.parseInt(this.getMinPerMtg()) <= 0 && this.getTypeInt() != 5) {
                errors.add("minPerMtg", new ActionMessage("errors.required", (Object)""));
            }
        }
        catch (NumberFormatException e) {
            errors.add("minPerMtg", new ActionMessage("errors.required", (Object)""));
        }
        try {
            if (Integer.parseInt(this.getSlotsPerMtg()) <= 0 && this.getTypeInt() != 5) {
                errors.add("slotsPerMtg", new ActionMessage("errors.required", (Object)""));
            }
        }
        catch (NumberFormatException e) {
            errors.add("slotsPerMtg", new ActionMessage("errors.required", (Object)""));
        }
        if (this.getTypeInt() < 0) {
            errors.add("type", new ActionMessage("errors.required", (Object)""));
        }
        if (this.getBreakTime() == null || this.getBreakTime().isEmpty()) {
            this.setBreakTime("0");
        } else {
            try {
                Integer.parseInt(this.getBreakTime());
            }
            catch (NumberFormatException e) {
                errors.add("breakTime", new ActionMessage("errors.numeric", (Object)""));
            }
        }
        try {
            this.str2dayCodes(this.iDayCodes, "\n, ");
        }
        catch (Exception e) {
            errors.add("dayCodes", new ActionMessage("errors.generic", (Object)e.getMessage()));
        }
        try {
            this.str2startSlots(this.iStartTimes, "\n, ");
        }
        catch (Exception e) {
            errors.add("startTimes", new ActionMessage("errors.generic", (Object)e.getMessage()));
        }
        if (this.getTypeInt() != 4 && this.getTypeInt() != 5 && !this.iDepartmentIds.isEmpty()) {
            errors.add("type", new ActionMessage("errors.generic", (Object)"Only extended or exact time pattern can contain relations with departments."));
        }
        return errors;
    }

    public void reset(ActionMapping mapping, HttpServletRequest request) {
        this.iOp = null;
        this.iUniqueId = new Long(-1L);
        this.iType = TimePattern.sTypes[0];
        this.iNrMtgs = "";
        this.iMinPerMtg = "";
        this.iSlotsPerMtg = "";
        this.iDayCodes = "";
        this.iStartTimes = "";
        this.iEditable = false;
        this.iVisible = false;
        this.iName = "";
        this.iBreakTime = "";
        this.iDepartmentId = null;
        this.iDepartmentIds.clear();
    }

    public void load(TimePattern tp, Long sessionId) {
        if (tp == null) {
            this.reset(null, null);
            this.iOp = "Save";
            this.iVisible = true;
            this.iEditable = true;
        } else {
            this.setName(tp.getName());
            this.setVisible(tp.isVisible());
            this.setEditable(tp.isEditable());
            this.setTypeInt(tp.getType());
            this.setMinPerMtg(tp.getMinPerMtg().toString());
            this.setNrMtgs(tp.getNrMeetings().toString());
            this.setBreakTime(tp.getBreakTime().toString());
            this.setSlotsPerMtg(tp.getSlotsPerMtg().toString());
            this.setUniqueId(tp.getUniqueId());
            this.setDayCodes(TimePatternEditForm.dayCodes2str(tp.getDays(), this.getEditable() ? "\n" : ", "));
            this.setStartTimes(TimePatternEditForm.startSlots2str(tp.getTimes(), this.getEditable() ? "\n" : ", "));
            this.iDepartmentIds.clear();
            for (Department d : tp.getDepartments(sessionId)) {
                this.iDepartmentIds.add(d.getUniqueId());
            }
            this.iOp = "Update";
        }
    }

    public void update(TimePattern tp, org.hibernate.Session hibSession) throws Exception {
        tp.setName(this.getName());
        tp.setVisible(new Boolean(this.getVisible()));
        tp.setType(new Integer(this.getTypeInt()));
        tp.setBreakTime(new Integer(this.getBreakTime()));
        if (this.getEditable()) {
            tp.setMinPerMtg(new Integer(this.getMinPerMtg()));
            tp.setNrMeetings(new Integer(this.getNrMtgs()));
            tp.setSlotsPerMtg(new Integer(this.getSlotsPerMtg()));
            for (TimePatternTime t : tp.getTimes()) {
                hibSession.delete((Object)t);
            }
            for (TimePatternDays d : tp.getDays()) {
                hibSession.delete((Object)d);
            }
            tp.setTimes(this.str2startSlots(this.getStartTimes(), "\n, "));
            tp.setDays(this.str2dayCodes(this.getDayCodes(), "\n, "));
            for (TimePatternTime t : tp.getTimes()) {
                hibSession.save((Object)t);
            }
            for (TimePatternDays d : tp.getDays()) {
                hibSession.save((Object)d);
            }
            if (tp.getSession() != null && tp.getSession().getStatusType().isAllowRollForward()) {
                List l = hibSession.createQuery("from TimePref tp where tp.timePattern.uniqueId = :tpid").setLong("tpid", tp.getUniqueId().longValue()).list();
                for (TimePref tpref : l) {
                    tpref.setPreference(null);
                    hibSession.update((Object)tpref);
                }
            }
        }
        HashSet<Department> oldDepts = new HashSet<Department>(tp.getDepartments());
        Enumeration e = this.iDepartmentIds.elements();
        while (e.hasMoreElements()) {
            Long departmentId = (Long)e.nextElement();
            Department d = (Department)new DepartmentDAO().get(departmentId, hibSession);
            if (d == null || oldDepts.remove(d)) continue;
            tp.getDepartments().add(d);
            d.getTimePatterns().add(tp);
            hibSession.saveOrUpdate((Object)d);
        }
        for (Department d : oldDepts) {
            tp.getDepartments().remove(d);
            d.getTimePatterns().remove(tp);
            hibSession.saveOrUpdate((Object)d);
        }
        hibSession.saveOrUpdate((Object)tp);
    }

    public TimePattern create(SessionContext context, org.hibernate.Session hibSession) throws Exception {
        TimePattern tp = new TimePattern();
        tp.setName(this.getName());
        tp.setVisible(new Boolean(this.getVisible()));
        tp.setType(new Integer(this.getTypeInt()));
        tp.setMinPerMtg(new Integer(this.getMinPerMtg()));
        tp.setNrMeetings(new Integer(this.getNrMtgs()));
        tp.setBreakTime(new Integer(this.getBreakTime()));
        tp.setSlotsPerMtg(new Integer(this.getSlotsPerMtg()));
        tp.setTimes(this.str2startSlots(this.getStartTimes(), "\n, "));
        tp.setDays(this.str2dayCodes(this.getDayCodes(), "\n, "));
        tp.setSession((Session)SessionDAO.getInstance().get(context.getUser().getCurrentAcademicSessionId(), hibSession));
        for (TimePatternTime t : tp.getTimes()) {
            hibSession.save((Object)t);
        }
        for (TimePatternDays d : tp.getDays()) {
            hibSession.save((Object)d);
        }
        HashSet<Department> newDepts = new HashSet<Department>();
        Enumeration e = this.iDepartmentIds.elements();
        while (e.hasMoreElements()) {
            Long departmentId = (Long)e.nextElement();
            Department d = (Department)new DepartmentDAO().get(departmentId, hibSession);
            if (d == null) continue;
            newDepts.add(d);
        }
        tp.setDepartments(newDepts);
        hibSession.save((Object)tp);
        for (Department d : newDepts) {
            d.getTimePatterns().add(tp);
            hibSession.saveOrUpdate((Object)d);
        }
        this.setUniqueId(tp.getUniqueId());
        return tp;
    }

    public TimePattern saveOrUpdate(SessionContext context, org.hibernate.Session hibSession) throws Exception {
        TimePattern tp = null;
        if (this.getUniqueId().intValue() >= 0) {
            tp = (TimePattern)new TimePatternDAO().get(this.getUniqueId());
        }
        if (tp == null) {
            tp = this.create(context, hibSession);
            ChangeLog.addChange(hibSession, context, tp, ChangeLog.Source.TIME_PATTERN_EDIT, ChangeLog.Operation.CREATE, null, null);
        } else {
            this.update(tp, hibSession);
            ChangeLog.addChange(hibSession, context, tp, ChangeLog.Source.TIME_PATTERN_EDIT, ChangeLog.Operation.UPDATE, null, null);
        }
        return tp;
    }

    public void delete(SessionContext context, org.hibernate.Session hibSession) throws Exception {
        if (this.getUniqueId().intValue() < 0) {
            return;
        }
        if (!this.getEditable()) {
            return;
        }
        TimePattern tp = (TimePattern)new TimePatternDAO().get(this.getUniqueId(), hibSession);
        for (Department d : tp.getDepartments()) {
            d.getTimePatterns().remove(tp);
            hibSession.saveOrUpdate((Object)d);
        }
        ChangeLog.addChange(hibSession, context, tp, ChangeLog.Source.TIME_PATTERN_EDIT, ChangeLog.Operation.DELETE, null, null);
        hibSession.delete((Object)tp);
    }

    public String getOp() {
        return this.iOp;
    }

    public void setOp(String op) {
        this.iOp = op;
    }

    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    public String getType() {
        return this.iType;
    }

    public void setType(String type) {
        this.iType = type;
    }

    public String[] getTypes() {
        return TimePattern.sTypes;
    }

    public int getTypeInt() {
        for (int i = 0; i < TimePattern.sTypes.length; ++i) {
            if (!TimePattern.sTypes[i].equals(this.iType)) continue;
            return i;
        }
        return -1;
    }

    public void setTypeInt(int type) {
        this.iType = type < 0 ? "" : TimePattern.sTypes[type];
    }

    public String getNrMtgs() {
        return this.iNrMtgs;
    }

    public void setNrMtgs(String nrMtgs) {
        this.iNrMtgs = nrMtgs;
    }

    public String getBreakTime() {
        return this.iBreakTime;
    }

    public void setBreakTime(String breakTime) {
        this.iBreakTime = breakTime;
    }

    public String getMinPerMtg() {
        return this.iMinPerMtg;
    }

    public void setMinPerMtg(String minPerMtg) {
        this.iMinPerMtg = minPerMtg;
    }

    public String getSlotsPerMtg() {
        return this.iSlotsPerMtg;
    }

    public void setSlotsPerMtg(String slotsPerMtg) {
        this.iSlotsPerMtg = slotsPerMtg;
    }

    public String getDayCodes() {
        return this.iDayCodes;
    }

    public void setDayCodes(String dayCodes) {
        this.iDayCodes = dayCodes;
    }

    public String getStartTimes() {
        return this.iStartTimes;
    }

    public void setStartTimes(String startTimes) {
        this.iStartTimes = startTimes;
    }

    public boolean getEditable() {
        return this.iEditable;
    }

    public void setEditable(boolean editable) {
        this.iEditable = editable;
    }

    public boolean getVisible() {
        return this.iVisible;
    }

    public void setVisible(boolean visible) {
        this.iVisible = visible;
    }

    public String getName() {
        return this.iName;
    }

    public void setName(String name) {
        this.iName = name;
    }

    public Vector getDepartmentIds() {
        return this.iDepartmentIds;
    }

    public void setDepartmentIds(Vector departmentIds) {
        this.iDepartmentIds = departmentIds;
    }

    public Long getDepartmentId() {
        return this.iDepartmentId;
    }

    public void setDepartmentId(Long deptId) {
        this.iDepartmentId = deptId;
    }

    public static String dayCodes2str(Collection dayCodes, String delim) {
        StringBuffer sb = new StringBuffer();
        Iterator i = new TreeSet(dayCodes).iterator();
        while (i.hasNext()) {
            int j;
            int dayCode = ((TimePatternDays)i.next()).getDayCode();
            int nrDays = 0;
            for (j = 0; j < Constants.NR_DAYS; ++j) {
                if ((dayCode & Constants.DAY_CODES[j]) == 0) continue;
                ++nrDays;
            }
            for (j = 0; j < Constants.NR_DAYS; ++j) {
                if ((Constants.DAY_CODES[j] & dayCode) == 0) continue;
                sb.append(nrDays == 1 ? Constants.DAY_NAME[j] : Constants.DAY_NAMES_SHORT[j]);
            }
            if (!i.hasNext()) continue;
            sb.append(delim);
        }
        return sb.toString();
    }

    public static String startSlots2str(Collection startSlots, String delim) {
        StringBuffer sb = new StringBuffer();
        Iterator i = new TreeSet(startSlots).iterator();
        while (i.hasNext()) {
            int startSlot = ((TimePatternTime)i.next()).getStartSlot();
            int min = startSlot * Constants.SLOT_LENGTH_MIN + Constants.FIRST_SLOT_TIME_MIN;
            int time = 100 * (min / 60) + min % 60;
            sb.append(time);
            if (!i.hasNext()) continue;
            sb.append(delim);
        }
        return sb.toString();
    }

    public static int getDayCode(String token, int day, int dayCode) {
        int code;
        if (day == Constants.NR_DAYS) {
            if (token.length() == 0) {
                return dayCode;
            }
            return -1;
        }
        if (token.startsWith(Constants.DAY_NAMES_SHORT[day]) && (code = TimePatternEditForm.getDayCode(token.substring(Constants.DAY_NAMES_SHORT[day].length()), day + 1, dayCode + Constants.DAY_CODES[day])) >= 0) {
            return code;
        }
        if (token.startsWith(Constants.DAY_NAME[day]) && (code = TimePatternEditForm.getDayCode(token.substring(Constants.DAY_NAME[day].length()), day + 1, dayCode + Constants.DAY_CODES[day])) >= 0) {
            return code;
        }
        return TimePatternEditForm.getDayCode(token, day + 1, dayCode);
    }

    public Set str2dayCodes(String dayCodes, String delim) throws Exception {
        TreeSet<TimePatternDays> ret = new TreeSet<TimePatternDays>();
        StringTokenizer stk = new StringTokenizer(dayCodes, delim == null ? " ,\t\n\r\f" : delim);
        while (stk.hasMoreTokens()) {
            String token = stk.nextToken();
            if (token.trim().length() == 0) continue;
            int dayCode = TimePatternEditForm.getDayCode(token.trim(), 0, 0);
            if (dayCode < 0) {
                throw new Exception("Invalid days '" + token + "'.");
            }
            int nrDays = 0;
            for (int i = 0; i < Constants.NR_DAYS; ++i) {
                if ((dayCode & Constants.DAY_CODES[i]) == 0) continue;
                ++nrDays;
            }
            try {
                if (nrDays != Integer.parseInt(this.getNrMtgs())) {
                    throw new Exception("Days '" + token + "' invalid -- wrong number of days.");
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            TimePatternDays days = new TimePatternDays();
            days.setDayCode(new Integer(dayCode));
            if (ret.contains(days)) {
                throw new Exception("Days '" + token + "' included more than once.");
            }
            ret.add(days);
        }
        return ret;
    }

    public Set str2startSlots(String startTimes, String delim) throws Exception {
        TreeSet<TimePatternTime> ret = new TreeSet<TimePatternTime>();
        StringTokenizer stk = new StringTokenizer(startTimes, delim == null ? " ,\t\n\r\f" : delim);
        while (stk.hasMoreTokens()) {
            String token = stk.nextToken();
            if (token.trim().length() == 0) continue;
            int slot = -1;
            try {
                int time = Integer.parseInt(token.trim());
                int hour = time / 100;
                int min = time % 100;
                if (hour >= 24) {
                    throw new Exception("Invalid time '" + token + "' -- hour (" + hour + ") must be between 0 and 23.");
                }
                if (min >= 60) {
                    throw new Exception("Invalid time '" + token + "' -- minute (" + min + ") must be between 0 and 59.");
                }
                if (min % Constants.SLOT_LENGTH_MIN != 0) {
                    throw new Exception("Invalid time '" + token + "' -- minute (" + min + ") must be divisible by " + Constants.SLOT_LENGTH_MIN + ".");
                }
                try {
                    int endTime = hour * 60 + min + Constants.SLOT_LENGTH_MIN * Integer.parseInt(this.getSlotsPerMtg());
                    if (endTime / Constants.SLOT_LENGTH_MIN - Constants.FIRST_SLOT_TIME_MIN > 288) {
                        throw new Exception("Invalid time '" + token + "' -- the time cannot go over midnight).");
                    }
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
                slot = (hour * 60 + min - Constants.FIRST_SLOT_TIME_MIN) / Constants.SLOT_LENGTH_MIN;
            }
            catch (NumberFormatException ex) {
                throw new Exception("Invalid time '" + token + "' -- not a number.");
            }
            if (slot < 0) {
                throw new Exception("Invalid time '" + token + "'.");
            }
            TimePatternTime time = new TimePatternTime();
            time.setStartSlot(new Integer(slot));
            if (ret.contains(time)) {
                throw new Exception("Time '" + token + "' included more than once.");
            }
            ret.add(time);
        }
        return ret;
    }

    public String getExample() {
        try {
            TimePattern tp = new TimePattern(new Long(Long.MAX_VALUE));
            tp.setName(this.getName());
            tp.setVisible(new Boolean(this.getVisible()));
            tp.setType(new Integer(this.getTypeInt()));
            tp.setMinPerMtg(new Integer(this.getMinPerMtg()));
            tp.setNrMeetings(new Integer(this.getNrMtgs()));
            tp.setBreakTime(new Integer(this.getBreakTime()));
            tp.setSlotsPerMtg(new Integer(this.getSlotsPerMtg()));
            tp.setTimes(this.str2startSlots(this.getStartTimes(), "\n, "));
            tp.setDays(this.str2dayCodes(this.getDayCodes(), "\n, "));
            if (tp.getTimes().isEmpty() || tp.getDays().isEmpty()) {
                return null;
            }
            RequiredTimeTable rtt = tp.getRequiredTimeTable(true);
            return rtt.print(false, false, false, false);
        }
        catch (Exception e) {
            return null;
        }
    }
}

