/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.form;

import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.unitime.timetable.model.SponsoringOrganization;
import org.unitime.timetable.model.dao.SponsoringOrganizationDAO;

public class SponsoringOrgEditForm
extends ActionForm {
    private static final long serialVersionUID = 5587107210035732698L;
    private String iScreen = "edit";
    private String iOrgName;
    private String iOrgEmail;
    private String iOp;
    private SponsoringOrganization iOrg;
    private Long iId;

    public ActionErrors validate(ActionMapping mapping, HttpServletRequest request) {
        ActionErrors errors = new ActionErrors();
        if (this.iOrgName == null || this.iOrgName.length() == 0) {
            errors.add("orgName", new ActionMessage("errors.generic", (Object)"Please enter the name of the organization."));
        } else {
            for (SponsoringOrganization so2 : SponsoringOrganization.findAll()) {
                if (this.iOrgName.compareToIgnoreCase(so2.getName()) != 0) continue;
                if (this.iId != null) {
                    if (this.iId.compareTo(so2.getUniqueId()) == 0) continue;
                    errors.add("orgNameExists", new ActionMessage("errors.generic", (Object)"Another organization with this name already exists."));
                    break;
                }
                errors.add("orgNameExists", new ActionMessage("errors.generic", (Object)"Another organization with this name already exists."));
                break;
            }
        }
        return errors;
    }

    public void reset(ActionMapping mapping, HttpServletRequest request) {
        if ("add".equals(request.getAttribute("op"))) {
            this.iScreen = "add";
            this.iOrg = null;
        } else if (request.getParameter("id") != null && request.getParameter("id").length() > 0) {
            this.iId = Long.valueOf(request.getParameter("id"));
            this.iOrg = (SponsoringOrganization)SponsoringOrganizationDAO.getInstance().get(this.iId);
        }
        this.iOrgName = this.iOrg == null ? "" : this.iOrg.getName();
        this.iOrgEmail = this.iOrg == null ? "" : this.iOrg.getEmail();
    }

    public String getScreen() {
        return this.iScreen;
    }

    public void setScreen(String screen) {
        this.iScreen = screen;
    }

    public String getOrgName() {
        return this.iOrgName;
    }

    public void setOrgName(String name) {
        this.iOrgName = name;
    }

    public String getOrgEmail() {
        return this.iOrgEmail;
    }

    public void setOrgEmail(String email) {
        this.iOrgEmail = email;
    }

    public String getOp() {
        return this.iOp;
    }

    public void setOp(String op) {
        this.iOp = op;
    }

    public Long getId() {
        return this.iId;
    }

    public void setId(Long id) {
        this.iId = id;
    }

    public SponsoringOrganization getOrg() {
        return this.iOrg;
    }

    public void setOrg(SponsoringOrganization org) {
        this.iOrg = org;
    }
}

