/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.form;

import java.util.Hashtable;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.form.ExamReportForm;
import org.unitime.timetable.reports.exam.AbbvExamScheduleByCourseReport;
import org.unitime.timetable.reports.exam.AbbvScheduleByCourseReport;
import org.unitime.timetable.reports.exam.ConflictsByCourseAndInstructorReport;
import org.unitime.timetable.reports.exam.ConflictsByCourseAndStudentReport;
import org.unitime.timetable.reports.exam.ExamPeriodChartReport;
import org.unitime.timetable.reports.exam.ExamScheduleByPeriodReport;
import org.unitime.timetable.reports.exam.ExamVerificationReport;
import org.unitime.timetable.reports.exam.InstructorExamReport;
import org.unitime.timetable.reports.exam.PeriodChartReport;
import org.unitime.timetable.reports.exam.ScheduleByCourseReport;
import org.unitime.timetable.reports.exam.ScheduleByPeriodReport;
import org.unitime.timetable.reports.exam.ScheduleByRoomReport;
import org.unitime.timetable.reports.exam.StudentExamReport;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.util.Formats;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExamPdfReportForm
extends ExamReportForm {
    private static final long serialVersionUID = 4349609058043519671L;
    protected static Logger sLog = Logger.getLogger(ExamPdfReportForm.class);
    private String[] iReports = null;
    private String iMode = null;
    private boolean iAll = false;
    private String[] iSubjects = null;
    private boolean iDispRooms = true;
    private String iNoRoom = "";
    private boolean iDirect = true;
    private boolean iM2d = true;
    private boolean iBtb = false;
    private String iLimit = null;
    private boolean iTotals = false;
    private boolean iDispLimit = true;
    private String iRoomCodes = null;
    private boolean iEmail = false;
    private String iAddr;
    private String iCc;
    private String iBcc = null;
    private boolean iEmailDeputies = false;
    private boolean iItype = false;
    private String iMessage = null;
    private String iSubject = null;
    private String iSince = null;
    private boolean iEmailInstructors;
    private boolean iEmailStudents;
    private boolean iClassSchedule = false;
    private boolean iIgnoreEmptyExams = false;
    private boolean iDispNote = true;
    private boolean iCompact = false;
    public static Hashtable<String, Class> sRegisteredReports = new Hashtable();
    public static String[] sModes = new String[]{"PDF (Letter)", "PDF (Ledger)", "Text"};
    public static int sDeliveryDownload = 0;
    public static int sDeliveryEmail = 1;

    @Override
    public ActionErrors validate(ActionMapping mapping, HttpServletRequest request) {
        ActionErrors errors = super.validate(mapping, request);
        if (this.iReports == null || this.iReports.length == 0) {
            errors.add("reports", new ActionMessage("errors.generic", (Object)"No report selected."));
        }
        if (!(this.iAll || this.iSubjects != null && this.iSubjects.length != 0)) {
            errors.add("subjects", new ActionMessage("errors.generic", (Object)"No subject area selected."));
        }
        if (this.iSince != null && !this.iSince.isEmpty() && !Formats.getDateFormat(Formats.Pattern.DATE_ENTRY_FORMAT).isValid(this.iSince)) {
            errors.add("since", new ActionMessage("errors.invalidDate", (Object)this.iSince));
        }
        return errors;
    }

    @Override
    public void reset(ActionMapping mapping, HttpServletRequest request) {
        super.reset(mapping, request);
        this.iReports = null;
        this.iMode = sModes[0];
        this.iAll = false;
        this.iDispRooms = false;
        this.iNoRoom = null;
        this.iDirect = false;
        this.iM2d = false;
        this.iBtb = false;
        this.iLimit = null;
        this.iTotals = false;
        this.iRoomCodes = null;
        this.iEmail = false;
        this.iAddr = null;
        this.iCc = null;
        this.iBcc = null;
        this.iEmailDeputies = false;
        this.iSubject = "Examination Report";
        this.iMessage = null;
        this.iDispLimit = false;
        this.iSince = null;
        this.iEmailInstructors = false;
        this.iEmailStudents = false;
        this.iClassSchedule = false;
        this.iIgnoreEmptyExams = false;
        this.iItype = false;
        this.iDispNote = false;
        this.iCompact = false;
    }

    @Override
    public void load(SessionContext session) {
        super.load(session, true);
        this.setAll(session.getAttribute("ExamPdfReport.all") == null ? true : (Boolean)session.getAttribute("ExamPdfReport.all"));
        this.setReports((String[])session.getAttribute("ExamPdfReport.reports"));
        this.setMode(session.getAttribute("ExamPdfReport.mode") == null ? sModes[0] : (String)session.getAttribute("ExamPdfReport.mode"));
        this.setSubjects((String[])session.getAttribute("ExamPdfReport.subjects"));
        this.setDispRooms("1".equals(session.getUser().getProperty("ExamPdfReport.dispRooms", "1")));
        this.setNoRoom(session.getUser().getProperty("ExamPdfReport.noRoom", ApplicationProperty.ExaminationsNoRoomText.value()));
        this.setDirect("1".equals(session.getUser().getProperty("ExamPdfReport.direct", "1")));
        this.setM2d("1".equals(session.getUser().getProperty("ExamPdfReport.m2d", "1")));
        this.setBtb("1".equals(session.getUser().getProperty("ExamPdfReport.btb", "0")));
        this.setLimit(session.getUser().getProperty("ExamPdfReport.limit"));
        this.setTotals("1".equals(session.getUser().getProperty("ExamPdfReport.totals", "1")));
        this.setRoomCodes(session.getUser().getProperty("ExamPdfReport.roomCodes", ApplicationProperty.ExaminationRoomCode.value()));
        this.setEmail("1".equals(session.getUser().getProperty("ExamPdfReport.email", "0")));
        this.setAddress(session.getUser().getProperty("ExamPdfReport.addr"));
        this.setCc(session.getUser().getProperty("ExamPdfReport.cc"));
        this.setBcc(session.getUser().getProperty("ExamPdfReport.bcc"));
        this.setEmailDeputies("1".equals(session.getUser().getProperty("ExamPdfReport.emailDeputies", "0")));
        this.setMessage(session.getUser().getProperty("ExamPdfReport.message"));
        this.setSubject(session.getUser().getProperty("ExamPdfReport.subject", "Examination Report"));
        this.setDispLimit("1".equals(session.getUser().getProperty("ExamPdfReport.dispLimit", "1")));
        this.setSince(session.getUser().getProperty("ExamPdfReport.since"));
        this.setEmailInstructors("1".equals(session.getUser().getProperty("ExamPdfReport.emailInstructors", "0")));
        this.setEmailStudents("1".equals(session.getUser().getProperty("ExamPdfReport.emailStudents", "0")));
        this.setItype("1".equals(session.getUser().getProperty("ExamPdfReport.itype", ApplicationProperty.ExaminationReportsShowInstructionalType.isTrue() ? "1" : "0")));
        this.setClassSchedule("1".equals(session.getUser().getProperty("ExamPdfReport.cschedule", "1")));
        this.setIgnoreEmptyExams("1".equals(session.getUser().getProperty("ExamPdfReport.ignempty", "1")));
        this.setDispNote("1".equals(session.getUser().getProperty("ExamPdfReport.dispNote", "0")));
        this.setCompact("1".equals(session.getUser().getProperty("ExamPdfReport.compact", "0")));
    }

    @Override
    public void save(SessionContext session) {
        super.save(session);
        session.setAttribute("ExamPdfReport.reports", (Object)this.getReports());
        session.setAttribute("ExamPdfReport.mode", (Object)this.getMode());
        session.setAttribute("ExamPdfReport.all", (Object)this.getAll());
        session.setAttribute("ExamPdfReport.subjects", (Object)this.getSubjects());
        session.getUser().setProperty("ExamPdfReport.dispRooms", this.getDispRooms() ? "1" : "0");
        session.getUser().setProperty("ExamPdfReport.noRoom", this.getNoRoom());
        session.getUser().setProperty("ExamPdfReport.direct", this.getDirect() ? "1" : "0");
        session.getUser().setProperty("ExamPdfReport.m2d", this.getM2d() ? "1" : "0");
        session.getUser().setProperty("ExamPdfReport.btb", this.getBtb() ? "1" : "0");
        session.getUser().setProperty("ExamPdfReport.limit", this.getLimit());
        session.getUser().setProperty("ExamPdfReport.totals", this.getTotals() ? "1" : "0");
        session.getUser().setProperty("ExamPdfReport.roomCodes", this.getRoomCodes());
        session.getUser().setProperty("ExamPdfReport.email", this.getEmail() ? "1" : "0");
        session.getUser().setProperty("ExamPdfReport.addr", this.getAddress());
        session.getUser().setProperty("ExamPdfReport.cc", this.getCc());
        session.getUser().setProperty("ExamPdfReport.bcc", this.getBcc());
        session.getUser().setProperty("ExamPdfReport.emailDeputies", this.getEmailDeputies() ? "1" : "0");
        session.getUser().setProperty("ExamPdfReport.message", this.getMessage());
        session.getUser().setProperty("ExamPdfReport.subject", this.getSubject());
        session.getUser().setProperty("ExamPdfReport.dispLimit", this.getDispLimit() ? "1" : "0");
        session.getUser().setProperty("ExamPdfReport.since", this.getSince());
        session.getUser().setProperty("ExamPdfReport.emailInstructors", this.getEmailInstructors() ? "1" : "0");
        session.getUser().setProperty("ExamPdfReport.emailStudents", this.getEmailStudents() ? "1" : "0");
        session.getUser().setProperty("ExamPdfReport.itype", this.getItype() ? "1" : "0");
        session.getUser().setProperty("ExamPdfReport.cschedule", this.getClassSchedule() ? "1" : "0");
        session.getUser().setProperty("ExamPdfReport.ignempty", this.getIgnoreEmptyExams() ? "1" : "0");
        session.getUser().setProperty("ExamPdfReport.dispNote", this.getDispNote() ? "1" : "0");
        session.getUser().setProperty("ExamPdfReport.compact", this.getCompact() ? "1" : "0");
    }

    public String[] getReports() {
        return this.iReports;
    }

    public void setReports(String[] reports) {
        this.iReports = reports;
    }

    public String getMode() {
        return this.iMode;
    }

    public void setMode(String mode) {
        this.iMode = mode;
    }

    public int getModeIdx() {
        for (int i = 0; i < sModes.length; ++i) {
            if (!sModes[i].equals(this.iMode)) continue;
            return i;
        }
        return 0;
    }

    public boolean getAll() {
        return this.iAll;
    }

    public void setAll(boolean all) {
        this.iAll = all;
    }

    public String[] getSubjects() {
        return this.iSubjects;
    }

    public void setSubjects(String[] subjects) {
        this.iSubjects = subjects;
    }

    public boolean getDispRooms() {
        return this.iDispRooms;
    }

    public void setDispRooms(boolean dispRooms) {
        this.iDispRooms = dispRooms;
    }

    public String getNoRoom() {
        return this.iNoRoom;
    }

    public void setNoRoom(String noRoom) {
        this.iNoRoom = noRoom;
    }

    public boolean getBtb() {
        return this.iBtb;
    }

    public void setBtb(boolean btb) {
        this.iBtb = btb;
    }

    public boolean getM2d() {
        return this.iM2d;
    }

    public void setM2d(boolean m2d) {
        this.iM2d = m2d;
    }

    public boolean getDirect() {
        return this.iDirect;
    }

    public void setDirect(boolean direct) {
        this.iDirect = direct;
    }

    public String getLimit() {
        return this.iLimit;
    }

    public void setLimit(String limit) {
        this.iLimit = limit;
    }

    public boolean getTotals() {
        return this.iTotals;
    }

    public void setTotals(boolean totals) {
        this.iTotals = totals;
    }

    public String getRoomCodes() {
        return this.iRoomCodes;
    }

    public void setRoomCodes(String roomCodes) {
        this.iRoomCodes = roomCodes;
    }

    public boolean getEmail() {
        return this.iEmail;
    }

    public void setEmail(boolean email) {
        this.iEmail = email;
    }

    public boolean getEmailDeputies() {
        return this.iEmailDeputies;
    }

    public void setEmailDeputies(boolean emailDeputies) {
        this.iEmailDeputies = emailDeputies;
    }

    public String getAddress() {
        return this.iAddr;
    }

    public void setAddress(String addr) {
        this.iAddr = addr;
    }

    public String getCc() {
        return this.iCc;
    }

    public void setCc(String cc) {
        this.iCc = cc;
    }

    public String getBcc() {
        return this.iBcc;
    }

    public void setBcc(String bcc) {
        this.iBcc = bcc;
    }

    public boolean getCanEmail() {
        return true;
    }

    public String getMessage() {
        return this.iMessage;
    }

    public void setMessage(String message) {
        this.iMessage = message;
    }

    public String getSubject() {
        return this.iSubject;
    }

    public void setSubject(String subject) {
        this.iSubject = subject;
    }

    public boolean getDispNote() {
        return this.iDispNote;
    }

    public void setDispNote(boolean dispNote) {
        this.iDispNote = dispNote;
    }

    public boolean getCompact() {
        return this.iCompact;
    }

    public void setCompact(boolean compact) {
        this.iCompact = compact;
    }

    public TreeSet<String> getAllReports() {
        return new TreeSet<String>(sRegisteredReports.keySet());
    }

    public String[] getModes() {
        return sModes;
    }

    public boolean getDispLimit() {
        return this.iDispLimit;
    }

    public void setDispLimit(boolean dispLimit) {
        this.iDispLimit = dispLimit;
    }

    public String getSince() {
        return this.iSince;
    }

    public void setSince(String since) {
        this.iSince = since;
    }

    public boolean getEmailInstructors() {
        return this.iEmailInstructors;
    }

    public void setEmailInstructors(boolean emailInstructors) {
        this.iEmailInstructors = emailInstructors;
    }

    public boolean getEmailStudents() {
        return this.iEmailStudents;
    }

    public void setEmailStudents(boolean emailStudents) {
        this.iEmailStudents = emailStudents;
    }

    public boolean getItype() {
        return this.iItype;
    }

    public void setItype(boolean itype) {
        this.iItype = itype;
    }

    public boolean getClassSchedule() {
        return this.iClassSchedule;
    }

    public void setClassSchedule(boolean classSchedule) {
        this.iClassSchedule = classSchedule;
    }

    public boolean getIgnoreEmptyExams() {
        return this.iIgnoreEmptyExams;
    }

    public void setIgnoreEmptyExams(boolean ignoreEmptyExams) {
        this.iIgnoreEmptyExams = ignoreEmptyExams;
    }

    public Object clone() {
        ExamPdfReportForm x = new ExamPdfReportForm();
        x.setAll(this.getAll());
        x.setReports(this.getReports());
        x.setMode(this.getMode());
        x.setSubjects(this.getSubjects());
        x.setDispRooms(this.getDispRooms());
        x.setNoRoom(this.getNoRoom());
        x.setDirect(this.getDirect());
        x.setM2d(this.getM2d());
        x.setBtb(this.getBtb());
        x.setLimit(this.getLimit());
        x.setTotals(this.getTotals());
        x.setRoomCodes(this.getRoomCodes());
        x.setEmail(this.getEmail());
        x.setAddress(this.getAddress());
        x.setCc(this.getCc());
        x.setBcc(this.getBcc());
        x.setEmailDeputies(this.getEmailDeputies());
        x.setMessage(this.getMessage());
        x.setSubject(this.getSubject());
        x.setDispLimit(this.getDispLimit());
        x.setSince(this.getSince());
        x.setEmailInstructors(this.getEmailInstructors());
        x.setEmailStudents(this.getEmailStudents());
        x.setItype(this.getItype());
        x.setClassSchedule(this.getClassSchedule());
        x.setIgnoreEmptyExams(this.getIgnoreEmptyExams());
        x.setShowSections(this.getShowSections());
        x.setSubjectArea(this.getSubjectArea());
        x.setExamType(this.getExamType());
        x.setDispNote(this.getDispNote());
        x.setCompact(this.getCompact());
        return x;
    }

    static {
        sRegisteredReports.put("Schedule by Course", ScheduleByCourseReport.class);
        sRegisteredReports.put("Student Conflicts", ConflictsByCourseAndStudentReport.class);
        sRegisteredReports.put("Instuctor Conflicts", ConflictsByCourseAndInstructorReport.class);
        sRegisteredReports.put("Schedule by Period", ScheduleByPeriodReport.class);
        sRegisteredReports.put("Schedule by Period (Exams)", ExamScheduleByPeriodReport.class);
        sRegisteredReports.put("Schedule by Room", ScheduleByRoomReport.class);
        sRegisteredReports.put("Period Chart", PeriodChartReport.class);
        sRegisteredReports.put("Period Chart (Exams)", ExamPeriodChartReport.class);
        sRegisteredReports.put("Verification", ExamVerificationReport.class);
        sRegisteredReports.put("Abbreviated Schedule", AbbvScheduleByCourseReport.class);
        sRegisteredReports.put("Abbreviated Schedule (Exams)", AbbvExamScheduleByCourseReport.class);
        sRegisteredReports.put("Individual Instructor Schedule", InstructorExamReport.class);
        sRegisteredReports.put("Individual Student Schedule", StudentExamReport.class);
    }
}

