/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.export.events;

import biweekly.Biweekly;
import biweekly.ICalendar;
import biweekly.component.VEvent;
import biweekly.parameter.Role;
import biweekly.property.Attendee;
import biweekly.property.CalendarScale;
import biweekly.property.DateEnd;
import biweekly.property.DateStart;
import biweekly.property.DateTimeStamp;
import biweekly.property.ExceptionDates;
import biweekly.property.Method;
import biweekly.property.Organizer;
import biweekly.property.RecurrenceId;
import biweekly.property.Status;
import biweekly.property.Version;
import biweekly.util.Recurrence;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;
import java.util.TreeSet;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.springframework.stereotype.Service;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.export.ExportHelper;
import org.unitime.timetable.export.events.EventsExporter;
import org.unitime.timetable.gwt.client.events.EventComparator;
import org.unitime.timetable.gwt.shared.EventInterface;
import org.unitime.timetable.util.Constants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(value="org.unitime.timetable.export.Exporter:events.ics")
public class EventsExportEventsToICal
extends EventsExporter {
    @Override
    public String reference() {
        return "events.ics";
    }

    @Override
    protected void print(ExportHelper helper, List<EventInterface> events, int eventCookieFlags, EventComparator.EventMeetingSortBy sort, boolean asc) throws IOException {
        helper.setup("text/calendar", this.reference(), false);
        ICalendar ical = new ICalendar();
        ical.setVersion(Version.v2_0());
        ical.setCalendarScale(CalendarScale.gregorian());
        ical.setMethod(new Method("PUBLISH"));
        ical.setExperimentalProperty("X-WR-CALNAME", "UniTime Schedule");
        ical.setExperimentalProperty("X-WR-TIMEZONE", TimeZone.getDefault().getID());
        ical.setProductId("-//UniTime LLC/UniTime " + Constants.getVersion() + " Events//EN");
        for (EventInterface event : events) {
            this.print(ical, event);
        }
        Biweekly.write((ICalendar[])new ICalendar[]{ical}).go((Writer)helper.getWriter());
    }

    public boolean print(ICalendar ical, EventInterface event) throws IOException {
        return this.print(ical, event, null);
    }

    public boolean print(ICalendar ical, EventInterface event, Status status) throws IOException {
        if (event.getType() == EventInterface.EventType.Unavailabile) {
            return false;
        }
        TreeSet<ICalendarMeeting> meetings = new TreeSet<ICalendarMeeting>();
        TreeSet<Integer> days = new TreeSet<Integer>();
        if (event.hasMeetings()) {
            block9: for (EventInterface.MeetingInterface m : event.getMeetings()) {
                if (m.isArrangeHours() || m.getApprovalStatus() != EventInterface.ApprovalStatus.Approved && m.getApprovalStatus() != EventInterface.ApprovalStatus.Pending) continue;
                ICalendarMeeting x = new ICalendarMeeting(m, status);
                for (ICalendarMeeting icm : meetings) {
                    if (!icm.merge(x)) continue;
                    continue block9;
                }
                meetings.add(x);
                days.add(x.getStart().getDayOfWeek());
            }
        }
        if (meetings.isEmpty()) {
            return false;
        }
        ICalendarMeeting first = (ICalendarMeeting)meetings.first();
        VEvent master = new VEvent();
        master.setDateStart(first.getDateStart());
        master.setDateEnd(first.getDateEnd());
        master.setLocation(first.getLocation());
        master.setStatus(first.getStatus());
        ArrayList<VEvent> events = new ArrayList<VEvent>();
        events.add(master);
        if (meetings.size() > 1) {
            DateTime until = new DateTime(((ICalendarMeeting)meetings.last()).getStart().getYear(), ((ICalendarMeeting)meetings.last()).getStart().getMonthOfYear(), ((ICalendarMeeting)meetings.last()).getStart().getDayOfMonth(), first.getEnd().getHourOfDay(), first.getEnd().getMinuteOfHour(), first.getEnd().getSecondOfMinute());
            int nrMeetingDays = 0;
            DateTime date = first.getStart();
            while (!date.isAfter((ReadableInstant)until)) {
                if (days.contains(date.getDayOfWeek())) {
                    ++nrMeetingDays;
                }
                date = date.plusDays(1);
            }
            while (nrMeetingDays < meetings.size()) {
                if (!days.contains((until = until.plusDays(1)).getDayOfWeek())) continue;
                ++nrMeetingDays;
            }
            Recurrence.Builder recur = new Recurrence.Builder(Recurrence.Frequency.WEEKLY);
            Iterator i = days.iterator();
            while (i.hasNext()) {
                switch ((Integer)i.next()) {
                    case 1: {
                        recur.byDay(Recurrence.DayOfWeek.MONDAY);
                        break;
                    }
                    case 2: {
                        recur.byDay(Recurrence.DayOfWeek.TUESDAY);
                        break;
                    }
                    case 3: {
                        recur.byDay(Recurrence.DayOfWeek.WEDNESDAY);
                        break;
                    }
                    case 4: {
                        recur.byDay(Recurrence.DayOfWeek.THURSDAY);
                        break;
                    }
                    case 5: {
                        recur.byDay(Recurrence.DayOfWeek.FRIDAY);
                        break;
                    }
                    case 6: {
                        recur.byDay(Recurrence.DayOfWeek.SATURDAY);
                        break;
                    }
                    case 7: {
                        recur.byDay(Recurrence.DayOfWeek.SUNDAY);
                    }
                }
            }
            recur.workweekStarts(Recurrence.DayOfWeek.MONDAY).until(until.toDate());
            master.setRecurrenceRule(recur.build());
            ExceptionDates exdates = new ExceptionDates(true);
            Object date2 = first.getStart();
            while (!date2.isAfter((ReadableInstant)until)) {
                block41: {
                    if (days.contains(date2.getDayOfWeek())) {
                        ICalendarMeeting ics;
                        Iterator i2 = meetings.iterator();
                        while (i2.hasNext()) {
                            ics = (ICalendarMeeting)i2.next();
                            if (date2.getYear() != ics.getStart().getYear() || date2.getDayOfYear() != ics.getStart().getDayOfYear() || !first.same(ics)) continue;
                            i2.remove();
                            break block41;
                        }
                        i2 = meetings.iterator();
                        while (i2.hasNext()) {
                            ics = (ICalendarMeeting)i2.next();
                            if (date2.getYear() != ics.getStart().getYear() || date2.getDayOfYear() != ics.getStart().getDayOfYear()) continue;
                            VEvent x = new VEvent();
                            RecurrenceId id = new RecurrenceId(date2.toDate(), true);
                            id.setLocalTime(false);
                            id.setTimezoneId(TimeZone.getDefault().getID());
                            x.setRecurrenceId(id);
                            x.setDateStart(ics.getDateStart());
                            x.setDateEnd(ics.getDateEnd());
                            x.setLocation(ics.getLocation());
                            x.setStatus(ics.getStatus());
                            events.add(x);
                            i2.remove();
                            break block41;
                        }
                        exdates.addValue((Object)date2.toDate());
                    }
                }
                date2 = date2.plusDays(1);
            }
            for (ICalendarMeeting ics : meetings) {
                VEvent x = new VEvent();
                x.setDateStart(ics.getDateStart());
                x.setDateEnd(ics.getDateEnd());
                x.setLocation(ics.getLocation());
                x.setStatus(ics.getStatus());
                if (!exdates.getValues().isEmpty()) {
                    RecurrenceId id = new RecurrenceId((Date)exdates.getValues().get(0), true);
                    id.setLocalTime(false);
                    id.setTimezoneId(TimeZone.getDefault().getID());
                    x.setRecurrenceId(id);
                    exdates.getValues().remove(0);
                }
                events.add(x);
            }
            if (!exdates.getValues().isEmpty()) {
                master.addExceptionDates(exdates);
            }
        }
        for (VEvent vevent : events) {
            Organizer organizer;
            String description;
            vevent.setSequence(Integer.valueOf(event.getSequence()));
            vevent.setUid(event.getId().toString());
            String name = event.getName();
            String string = description = event.hasInstruction() ? event.getInstruction() : event.getType().getName(CONSTANTS);
            if (event.hasCourseTitles() && event.getType() == EventInterface.EventType.Class && ApplicationProperty.EventGridDisplayTitle.isTrue()) {
                name = event.getCourseTitles().get(0);
                if (event.hasInstruction() && event.hasExternalIds()) {
                    description = event.getInstruction() + " " + event.getExternalIds().get(0);
                } else if (event.hasInstruction() && event.hasSectionNumber()) {
                    description = event.getInstruction() + " " + event.getSectionNumber();
                }
            }
            if (event.hasInstructors() && ApplicationProperty.EventCalendarDisplayInstructorsInDescription.isTrue()) {
                for (EventInterface.ContactInterface instructor : event.getInstructors()) {
                    description = description + "\n" + instructor.getName(MESSAGES);
                }
            }
            vevent.setSummary(name);
            vevent.setDescription(description);
            if (event.hasTimeStamp()) {
                DateTimeStamp ts = new DateTimeStamp(event.getTimeStamp());
                vevent.setDateTimeStamp(ts);
            }
            if (event.hasInstructors()) {
                int idx = 0;
                for (EventInterface.ContactInterface instructor : event.getInstructors()) {
                    if (idx++ == 0) {
                        Organizer organizer2 = new Organizer("mailto:" + (instructor.hasEmail() ? instructor.getEmail() : ""));
                        organizer2.setCommonName(instructor.getName(MESSAGES));
                        vevent.setOrganizer(organizer2);
                        continue;
                    }
                    Attendee attendee = new Attendee("mailto:" + (instructor.hasEmail() ? instructor.getEmail() : ""));
                    attendee.setCommonName(instructor.getName(MESSAGES));
                    attendee.setRole(Role.CHAIR);
                    vevent.addAttendee(attendee);
                }
            } else if (event.hasSponsor()) {
                organizer = new Organizer("mailto:" + (event.getSponsor().hasEmail() ? event.getSponsor().getEmail() : ""));
                organizer.setCommonName(event.getSponsor().getName());
                vevent.setOrganizer(organizer);
            } else if (event.hasContact()) {
                organizer = new Organizer("mailto:" + (event.getContact().hasEmail() ? event.getContact().getEmail() : ""));
                organizer.setCommonName(event.getContact().getName(MESSAGES));
                vevent.setOrganizer(organizer);
            }
            ical.addEvent(vevent);
        }
        return true;
    }

    @Override
    protected boolean checkRights() {
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ICalendarMeeting
    implements Comparable<ICalendarMeeting> {
        private DateTime iStart;
        private DateTime iEnd;
        private String iLocation;
        private Status iStatus;

        public ICalendarMeeting(EventInterface.MeetingInterface meeting, Status status) {
            this.iStart = meeting.getStartTime() != null ? new DateTime((Object)meeting.getStartTime()) : new DateTime((Object)meeting.getMeetingDate()).plusMinutes(5 * meeting.getStartSlot() + meeting.getStartOffset());
            this.iEnd = meeting.getStartTime() != null ? new DateTime((Object)meeting.getStopTime()) : new DateTime((Object)meeting.getMeetingDate()).plusMinutes(5 * meeting.getEndSlot() + meeting.getEndOffset());
            if (this.iStart.getSecondOfMinute() != 0) {
                this.iStart = this.iStart.minusSeconds(this.iStart.getSecondOfMinute());
            }
            if (this.iEnd.getSecondOfMinute() != 0) {
                this.iEnd = this.iEnd.minusSeconds(this.iEnd.getSecondOfMinute());
            }
            if (this.iStart.getMillisOfSecond() != 0) {
                this.iStart = this.iStart.minusMillis(this.iStart.getMillisOfSecond());
            }
            if (this.iEnd.getMillisOfSecond() != 0) {
                this.iEnd = this.iEnd.minusMillis(this.iEnd.getMillisOfSecond());
            }
            this.iLocation = meeting.getLocationName();
            this.iStatus = status != null ? status : (meeting.isApproved() ? Status.confirmed() : Status.tentative());
        }

        public DateTime getStart() {
            return this.iStart;
        }

        public DateStart getDateStart() {
            DateStart ds = new DateStart(this.iStart.toDate(), true);
            ds.setLocalTime(false);
            ds.setTimezoneId(TimeZone.getDefault().getID());
            return ds;
        }

        public DateTime getEnd() {
            return this.iEnd;
        }

        public DateEnd getDateEnd() {
            DateEnd de = new DateEnd(this.iEnd.toDate(), true);
            de.setLocalTime(false);
            de.setTimezoneId(TimeZone.getDefault().getID());
            return de;
        }

        public String getLocation() {
            return this.iLocation;
        }

        public Status getStatus() {
            return this.iStatus;
        }

        public boolean merge(ICalendarMeeting m) {
            if (m.getStart().equals((Object)this.getStart()) && m.getEnd().equals((Object)this.getEnd())) {
                if (m.getStatus().isTentative()) {
                    this.iStatus = Status.tentative();
                }
                this.iLocation = this.iLocation + ", " + m.getLocation();
                return true;
            }
            return false;
        }

        public boolean same(ICalendarMeeting m) {
            return m.getStart().getSecondOfDay() == this.getStart().getSecondOfDay() && m.getEnd().getSecondOfDay() == this.getEnd().getSecondOfDay() && this.getLocation().equals(m.getLocation()) && ((String)this.getStatus().getValue()).equals(m.getStatus().getValue());
        }

        @Override
        public int compareTo(ICalendarMeeting m) {
            int cmp = this.getStart().compareTo((ReadableInstant)m.getStart());
            if (cmp != 0) {
                return cmp;
            }
            return this.getEnd().compareTo((ReadableInstant)m.getEnd());
        }
    }
}

