/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.export;

import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPCellEvent;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfPageEvent;
import com.lowagie.text.pdf.PdfWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.unitime.timetable.export.Exporter;
import org.unitime.timetable.util.PdfEventHandler;
import org.unitime.timetable.util.PdfFont;

public class PDFPrinter
implements Exporter.Printer {
    private static Pattern sNumber = Pattern.compile("[+-]?[0-9]*\\.?[0-9]*[a-z]?");
    private OutputStream iOutput;
    private String[] iLastLine = null;
    private boolean iCheckLast = false;
    private PdfPTable iTable = null;
    private float[] iMaxWidth = null;
    private Set<Integer> iHiddenColumns = new HashSet<Integer>();
    List<Element> iElements = new ArrayList<Element>();

    public PDFPrinter(OutputStream output, boolean checkLast) {
        this.iOutput = output;
        this.iCheckLast = checkLast;
    }

    public String getContentType() {
        return "application/pdf";
    }

    public void hideColumn(int col) {
        this.iHiddenColumns.add(col);
    }

    public void printHeader(String ... fields) {
        this.iTable = new PdfPTable(fields.length - this.iHiddenColumns.size());
        this.iMaxWidth = new float[fields.length];
        this.iTable.setHeaderRows(1);
        this.iTable.setWidthPercentage(100.0f);
        for (int idx = 0; idx < fields.length; ++idx) {
            if (this.iHiddenColumns.contains(idx)) continue;
            String f = fields[idx];
            PdfPCell cell = new PdfPCell();
            cell.setBorder(2);
            cell.setVerticalAlignment(4);
            cell.setHorizontalAlignment(0);
            Font font = PdfFont.getFont(true);
            cell.addElement((Element)new Chunk(f, font));
            this.iTable.addCell(cell);
            float width = 0.0f;
            if (f.indexOf(10) >= 0) {
                StringTokenizer s = new StringTokenizer(f, "\n");
                while (s.hasMoreTokens()) {
                    width = Math.max(width, font.getBaseFont().getWidthPoint(s.nextToken(), font.getSize()));
                }
            } else {
                width = Math.max(width, font.getBaseFont().getWidthPoint(f, font.getSize()));
            }
            this.iMaxWidth[idx] = width;
        }
    }

    public void printLine(String ... fields) {
        PdfPCellEvent setLineDashEvent = new PdfPCellEvent(){

            public void cellLayout(PdfPCell cell, Rectangle rect, PdfContentByte[] canvas) {
                PdfContentByte cb = canvas[2];
                cb.setLineDash(new float[]{2.0f, 2.0f}, 0.0f);
            }
        };
        for (int idx = 0; idx < fields.length; ++idx) {
            if (this.iHiddenColumns.contains(idx)) continue;
            String f = fields[idx];
            if (f == null || f.isEmpty() || this.iCheckLast && f.equals(this.iLastLine == null || idx >= this.iLastLine.length ? null : this.iLastLine[idx])) {
                f = "";
            }
            boolean number = sNumber.matcher(f).matches();
            Font font = PdfFont.getFont();
            Phrase p = new Phrase(f, PdfFont.getSmallFont());
            PdfPCell cell = new PdfPCell(p);
            cell.setBorder(this.iLastLine == null ? 1 : 0);
            cell.setVerticalAlignment(4);
            cell.setHorizontalAlignment(number ? 2 : 0);
            cell.setPaddingBottom(4.0f);
            cell.setCellEvent(setLineDashEvent);
            if (number) {
                cell.setPaddingRight(10.0f);
            }
            this.iTable.addCell(cell);
            float width = 0.0f;
            if (f.indexOf(10) >= 0) {
                StringTokenizer s = new StringTokenizer(f, "\n");
                while (s.hasMoreTokens()) {
                    width = Math.max(width, font.getBaseFont().getWidthPoint(s.nextToken(), font.getSize()));
                }
            } else {
                width = Math.max(width, font.getBaseFont().getWidthPoint(f, font.getSize()));
            }
            this.iMaxWidth[idx] = Math.max(this.iMaxWidth[idx], width + (float)(number ? 10 : 0));
        }
        this.iLastLine = fields;
    }

    public void flush() {
        this.iLastLine = null;
    }

    public void close() throws IOException {
        try {
            float width = 0.0f;
            float[] w = new float[this.iMaxWidth.length - this.iHiddenColumns.size()];
            int wi = 0;
            for (int i = 0; i < this.iMaxWidth.length; ++i) {
                if (this.iHiddenColumns.contains(i)) continue;
                width += 15.0f + this.iMaxWidth[i];
                w[wi++] = this.iMaxWidth[i];
            }
            Document document = new Document(new Rectangle(60.0f + width, 60.0f + width * 0.75f), 30.0f, 30.0f, 30.0f, 30.0f);
            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)this.iOutput);
            writer.setPageEvent((PdfPageEvent)new PdfEventHandler());
            document.open();
            this.iTable.setWidths(w);
            document.add((Element)this.iTable);
            document.close();
        }
        catch (DocumentException e) {
            throw new IOException(e.getMessage(), e);
        }
    }
}

