/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.events;

import java.util.TreeSet;
import org.hibernate.Session;
import org.unitime.timetable.events.EventAction;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseList;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.shared.EventInterface;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.comparators.ClassComparator;
import org.unitime.timetable.model.comparators.InstrOfferingConfigComparator;
import org.unitime.timetable.model.comparators.SchedulingSubpartComparator;
import org.unitime.timetable.model.dao.CourseOfferingDAO;
import org.unitime.timetable.model.dao.SchedulingSubpartDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.security.rights.Right;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtRpcImplements(value=EventInterface.RelatedObjectLookupRpcRequest.class)
public class RelatedObjectLookupBackend
extends EventAction<EventInterface.RelatedObjectLookupRpcRequest, GwtRpcResponseList<EventInterface.RelatedObjectLookupRpcResponse>> {
    @Override
    public GwtRpcResponseList<EventInterface.RelatedObjectLookupRpcResponse> execute(EventInterface.RelatedObjectLookupRpcRequest request, EventAction.EventContext context) {
        context.checkPermission(Right.EventAddCourseRelated);
        GwtRpcResponseList<EventInterface.RelatedObjectLookupRpcResponse> response = new GwtRpcResponseList<EventInterface.RelatedObjectLookupRpcResponse>();
        Session hibSession = SessionDAO.getInstance().getSession();
        switch (request.getLevel()) {
            case SESSION: {
                for (Object[] object : hibSession.createQuery("select s.uniqueId, s.subjectAreaAbbreviation from SubjectArea s where s.session.uniqueId = :sessionId order by s.subjectAreaAbbreviation").setLong("sessionId", request.getUniqueId().longValue()).setCacheable(true).list()) {
                    response.add(new EventInterface.RelatedObjectLookupRpcResponse(EventInterface.RelatedObjectLookupRpcRequest.Level.SUBJECT, (Long)object[0], (String)object[1]));
                }
                break;
            }
            case SUBJECT: {
                for (CourseOffering course : hibSession.createQuery("select co from CourseOffering co where co.subjectArea.uniqueId = :subjectAreaId and co.instructionalOffering.notOffered = false order by co.courseNbr").setLong("subjectAreaId", request.getUniqueId().longValue()).setCacheable(true).list()) {
                    EventInterface.RelatedObjectInterface related = new EventInterface.RelatedObjectInterface();
                    if (course.getIsControl().booleanValue()) {
                        related.setType(EventInterface.RelatedObjectInterface.RelatedObjectType.Offering);
                        related.setUniqueId(course.getInstructionalOffering().getUniqueId());
                        related.setName(course.getCourseName());
                        related.addCourseName(course.getCourseName());
                        related.addCourseTitle(course.getTitle() == null ? "" : course.getTitle());
                        related.setSelection(new long[]{course.getSubjectArea().getUniqueId(), course.getUniqueId()});
                        related.setNote(course.getScheduleBookNote());
                        if (context.hasPermission(course.getInstructionalOffering(), Right.InstructionalOfferingDetail)) {
                            related.setDetailPage("instructionalOfferingDetail.do?io=" + course.getInstructionalOffering().getUniqueId());
                        }
                    } else {
                        related.setType(EventInterface.RelatedObjectInterface.RelatedObjectType.Course);
                        related.setUniqueId(course.getUniqueId());
                        related.setName(course.getCourseName());
                        related.addCourseName(course.getCourseName());
                        related.addCourseTitle(course.getTitle() == null ? "" : course.getTitle());
                        related.setSelection(new long[]{course.getSubjectArea().getUniqueId(), course.getUniqueId()});
                        related.setNote(course.getScheduleBookNote());
                        if (context.hasPermission(course.getInstructionalOffering(), Right.InstructionalOfferingDetail)) {
                            related.setDetailPage("instructionalOfferingDetail.do?io=" + course.getInstructionalOffering().getUniqueId());
                        }
                    }
                    response.add(new EventInterface.RelatedObjectLookupRpcResponse(EventInterface.RelatedObjectLookupRpcRequest.Level.COURSE, course.getUniqueId(), course.getCourseNbr(), course.getTitle(), related));
                }
                break;
            }
            case COURSE: {
                CourseOffering course = (CourseOffering)CourseOfferingDAO.getInstance().get(request.getUniqueId());
                if (course == null) break;
                if (course.isIsControl().booleanValue()) {
                    EventInterface.RelatedObjectInterface relatedOffering = new EventInterface.RelatedObjectInterface();
                    relatedOffering.setType(EventInterface.RelatedObjectInterface.RelatedObjectType.Offering);
                    relatedOffering.setUniqueId(course.getInstructionalOffering().getUniqueId());
                    relatedOffering.setName(course.getCourseName());
                    relatedOffering.setNote(course.getScheduleBookNote());
                    relatedOffering.addCourseName(course.getCourseName());
                    relatedOffering.addCourseTitle(course.getTitle() == null ? "" : course.getTitle());
                    relatedOffering.setSelection(new long[]{course.getSubjectArea().getUniqueId(), course.getUniqueId()});
                    if (context.hasPermission(course.getInstructionalOffering(), Right.InstructionalOfferingDetail)) {
                        relatedOffering.setDetailPage("instructionalOfferingDetail.do?io=" + course.getInstructionalOffering().getUniqueId());
                    }
                    response.add(new EventInterface.RelatedObjectLookupRpcResponse(EventInterface.RelatedObjectLookupRpcRequest.Level.OFFERING, course.getInstructionalOffering().getUniqueId(), "Offering", relatedOffering));
                }
                EventInterface.RelatedObjectInterface relatedCourse = new EventInterface.RelatedObjectInterface();
                relatedCourse.setType(EventInterface.RelatedObjectInterface.RelatedObjectType.Course);
                relatedCourse.setUniqueId(course.getUniqueId());
                relatedCourse.setName(course.getCourseName());
                relatedCourse.setNote(course.getScheduleBookNote());
                relatedCourse.addCourseName(course.getCourseName());
                relatedCourse.addCourseTitle(course.getTitle() == null ? "" : course.getTitle());
                relatedCourse.setSelection(new long[]{course.getSubjectArea().getUniqueId(), course.getUniqueId()});
                if (context.hasPermission(course.getInstructionalOffering(), Right.InstructionalOfferingDetail)) {
                    relatedCourse.setDetailPage("instructionalOfferingDetail.do?io=" + course.getInstructionalOffering().getUniqueId());
                }
                response.add(new EventInterface.RelatedObjectLookupRpcResponse(EventInterface.RelatedObjectLookupRpcRequest.Level.COURSE, course.getUniqueId(), "Course", relatedCourse));
                TreeSet<InstrOfferingConfig> configs = new TreeSet<InstrOfferingConfig>(new InstrOfferingConfigComparator(null));
                configs.addAll(course.getInstructionalOffering().getInstrOfferingConfigs());
                TreeSet<SchedulingSubpart> subparts = new TreeSet<SchedulingSubpart>(new SchedulingSubpartComparator(null));
                if (!configs.isEmpty()) {
                    response.add(new EventInterface.RelatedObjectLookupRpcResponse(EventInterface.RelatedObjectLookupRpcRequest.Level.NONE, null, "-- Configurations --"));
                    for (InstrOfferingConfig config : configs) {
                        EventInterface.RelatedObjectInterface relatedConfig = new EventInterface.RelatedObjectInterface();
                        relatedConfig.setType(EventInterface.RelatedObjectInterface.RelatedObjectType.Config);
                        relatedConfig.setUniqueId(config.getUniqueId());
                        relatedConfig.setName(config.getName());
                        relatedConfig.addCourseName(course.getCourseName());
                        relatedConfig.addCourseTitle(course.getTitle() == null ? "" : course.getTitle());
                        relatedConfig.setSelection(new long[]{course.getSubjectArea().getUniqueId(), course.getUniqueId(), config.getUniqueId()});
                        if (context.hasPermission(config.getInstructionalOffering(), Right.InstructionalOfferingDetail)) {
                            relatedCourse.setDetailPage("instructionalOfferingDetail.do?io=" + config.getInstructionalOffering().getUniqueId());
                        }
                        response.add(new EventInterface.RelatedObjectLookupRpcResponse(EventInterface.RelatedObjectLookupRpcRequest.Level.CONFIG, config.getUniqueId(), config.getName(), relatedConfig));
                        subparts.addAll(config.getSchedulingSubparts());
                    }
                }
                if (subparts.isEmpty()) break;
                response.add(new EventInterface.RelatedObjectLookupRpcResponse(EventInterface.RelatedObjectLookupRpcRequest.Level.NONE, null, "-- Subparts --"));
                for (SchedulingSubpart subpart : subparts) {
                    String name = subpart.getItype().getAbbv();
                    String sufix = subpart.getSchedulingSubpartSuffix();
                    for (SchedulingSubpart parent = subpart.getParentSubpart(); parent != null; parent = parent.getParentSubpart()) {
                        name = "\u00a0\u00a0\u00a0\u00a0" + name;
                    }
                    if (subpart.getInstrOfferingConfig().getInstructionalOffering().getInstrOfferingConfigs().size() > 1) {
                        name = name + " [" + subpart.getInstrOfferingConfig().getName() + "]";
                    }
                    response.add(new EventInterface.RelatedObjectLookupRpcResponse(EventInterface.RelatedObjectLookupRpcRequest.Level.SUBPART, subpart.getUniqueId(), name + (sufix == null || sufix.isEmpty() ? "" : " (" + sufix + ")")));
                }
                break;
            }
            case SUBPART: {
                CourseOffering course = (CourseOffering)CourseOfferingDAO.getInstance().get(request.getCourseId());
                SchedulingSubpart subpart = (SchedulingSubpart)SchedulingSubpartDAO.getInstance().get(request.getUniqueId());
                if (subpart == null) break;
                TreeSet<Class_> classes = new TreeSet<Class_>(new ClassComparator(5));
                classes.addAll(subpart.getClasses());
                for (Class_ clazz : classes) {
                    String extId = clazz.getClassSuffix(course);
                    EventInterface.RelatedObjectInterface relatedClass = new EventInterface.RelatedObjectInterface();
                    relatedClass.setType(EventInterface.RelatedObjectInterface.RelatedObjectType.Class);
                    relatedClass.setUniqueId(clazz.getUniqueId());
                    relatedClass.setName(clazz.getClassLabel(course));
                    String note = course.getScheduleBookNote();
                    if (clazz.getSchedulePrintNote() != null && !clazz.getSchedulePrintNote().isEmpty()) {
                        note = (note == null || note.isEmpty() ? "" : note + "\n") + clazz.getSchedulePrintNote();
                    }
                    relatedClass.setNote(note);
                    relatedClass.addCourseName(course.getCourseName());
                    relatedClass.addCourseTitle(course.getTitle() == null ? "" : course.getTitle());
                    relatedClass.setSelection(new long[]{course.getSubjectArea().getUniqueId(), course.getUniqueId(), subpart.getUniqueId(), clazz.getUniqueId()});
                    if (context.hasPermission(clazz, Right.ClassDetail)) {
                        relatedClass.setDetailPage("classDetail.do?cid=" + clazz.getUniqueId());
                    }
                    response.add(new EventInterface.RelatedObjectLookupRpcResponse(EventInterface.RelatedObjectLookupRpcRequest.Level.CLASS, clazz.getUniqueId(), clazz.getSectionNumberString(hibSession), extId == null || extId.isEmpty() || extId.equalsIgnoreCase(clazz.getSectionNumberString(hibSession)) ? null : extId, relatedClass));
                }
                break;
            }
            default: {
                response.add(new EventInterface.RelatedObjectLookupRpcResponse(EventInterface.RelatedObjectLookupRpcRequest.Level.NONE, null, "N/A"));
            }
        }
        return response;
    }
}

