/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.events;

import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.command.client.GwtRpcException;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.shared.EventInterface;
import org.unitime.timetable.security.SessionContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtRpcImplements(value=EventInterface.EncodeQueryRpcRequest.class)
public class QueryEncoderBackend
implements GwtRpcImplementation<EventInterface.EncodeQueryRpcRequest, EventInterface.EncodeQueryRpcResponse> {
    @Override
    public EventInterface.EncodeQueryRpcResponse execute(EventInterface.EncodeQueryRpcRequest request, SessionContext context) {
        return new EventInterface.EncodeQueryRpcResponse(QueryEncoderBackend.encode(request.getQuery() + (context.getUser() == null ? "" : "&user=" + context.getUser().getExternalUserId() + (context.getUser() == null || context.getUser().getCurrentAuthority() == null ? "" : "&role=" + context.getUser().getCurrentAuthority().getRole()))));
    }

    private static SecretKey secret() throws NoSuchAlgorithmException, InvalidKeySpecException {
        byte[] salt = new byte[]{51, 123, 9, 14, -49, 90, 88, -39};
        SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
        PBEKeySpec spec = new PBEKeySpec(ApplicationProperty.UrlEncoderSecret.value().toCharArray(), salt, 1024, 128);
        SecretKey key = factory.generateSecret(spec);
        return new SecretKeySpec(key.getEncoded(), "AES");
    }

    public static String encode(String text) {
        try {
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            cipher.init(1, QueryEncoderBackend.secret());
            return new BigInteger(cipher.doFinal(text.getBytes())).toString(36);
        }
        catch (Exception e) {
            throw new GwtRpcException("Encoding failed: " + e.getMessage(), e);
        }
    }

    public static String decode(String text) {
        try {
            if (text == null || text.isEmpty()) {
                return null;
            }
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            cipher.init(2, QueryEncoderBackend.secret());
            return new String(cipher.doFinal(new BigInteger(text, 36).toByteArray()));
        }
        catch (Exception e) {
            throw new GwtRpcException("Decoding failed: " + e.getMessage(), e);
        }
    }
}

