/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.events;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.events.EventAction;
import org.unitime.timetable.events.EventFilterBackend;
import org.unitime.timetable.events.QueryEncoderBackend;
import org.unitime.timetable.events.RoomFilterBackend;
import org.unitime.timetable.gwt.command.client.GwtRpcException;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseList;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.shared.EventInterface;
import org.unitime.timetable.model.ClassEvent;
import org.unitime.timetable.model.ClassInstructor;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseEvent;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentStatusType;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.Event;
import org.unitime.timetable.model.EventContact;
import org.unitime.timetable.model.EventNote;
import org.unitime.timetable.model.ExamEvent;
import org.unitime.timetable.model.ExamOwner;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.Meeting;
import org.unitime.timetable.model.RelatedCourseInfo;
import org.unitime.timetable.model.RoomPref;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.Solution;
import org.unitime.timetable.model.base.BaseClassEvent;
import org.unitime.timetable.model.base.BaseCourseEvent;
import org.unitime.timetable.model.dao.ClassEventDAO;
import org.unitime.timetable.model.dao.CourseEventDAO;
import org.unitime.timetable.model.dao.DepartmentDAO;
import org.unitime.timetable.model.dao.EventDAO;
import org.unitime.timetable.model.dao.ExamEventDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.CalendarUtils;
import org.unitime.timetable.util.Constants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtRpcImplements(value=EventInterface.EventLookupRpcRequest.class)
public class EventLookupBackend
extends EventAction<EventInterface.EventLookupRpcRequest, GwtRpcResponseList<EventInterface>> {
    private static Logger sLog = Logger.getLogger(EventLookupBackend.class);

    @Override
    public GwtRpcResponseList<EventInterface> execute(EventInterface.EventLookupRpcRequest request, EventAction.EventContext context) {
        if (request.getResourceType() == EventInterface.ResourceType.PERSON) {
            if (!request.hasResourceExternalId()) {
                request.setResourceExternalId(context.isAuthenticated() ? context.getUser().getExternalUserId() : null);
            } else if (!request.getResourceExternalId().equals(context.isAuthenticated() ? context.getUser().getExternalUserId() : null)) {
                context.checkPermission(Right.EventLookupSchedule);
            }
        }
        if (request.getEventFilter() == null) {
            EventInterface.EventFilterRpcRequest eventFilter = new EventInterface.EventFilterRpcRequest();
            eventFilter.setSessionId(request.getSessionId());
            request.setEventFilter(eventFilter);
        }
        return this.findEvents(request, context);
    }

    private boolean hasChild(Set<Long> restrictions, Class_ clazz) {
        if (restrictions.contains(clazz.getUniqueId())) {
            return true;
        }
        for (Class_ child : clazz.getChildClasses()) {
            if (!this.hasChild(restrictions, child)) continue;
            return true;
        }
        return false;
    }

    private boolean hasClassRestrictionChild(Set<Long> restrictions, SchedulingSubpart subpart) {
        for (Class_ other : subpart.getClasses()) {
            if (!restrictions.contains(other.getUniqueId())) continue;
            return true;
        }
        for (SchedulingSubpart child : subpart.getChildSubparts()) {
            if (!this.hasClassRestrictionChild(restrictions, child)) continue;
            return true;
        }
        return false;
    }

    private boolean hasClassRestriction(Set<Long> restrictions, Class_ clazz) {
        if (restrictions.isEmpty()) {
            return false;
        }
        for (SchedulingSubpart parent = clazz.getSchedulingSubpart().getParentSubpart(); parent != null; parent = parent.getParentSubpart()) {
            for (Class_ other : parent.getClasses()) {
                if (!restrictions.contains(other.getUniqueId())) continue;
                return true;
            }
        }
        return this.hasClassRestrictionChild(restrictions, clazz.getSchedulingSubpart());
    }

    protected boolean hide(Set<Long>[] restrictions, Class_ clazz) {
        if (!restrictions[0].isEmpty() && !restrictions[0].contains(clazz.getSchedulingSubpart().getInstrOfferingConfig().getUniqueId())) {
            return true;
        }
        if (this.hasClassRestriction(restrictions[1], clazz)) {
            for (Class_ parent = clazz; parent != null; parent = parent.getParentClass()) {
                if (!restrictions[1].contains(parent.getUniqueId())) continue;
                return false;
            }
            for (Class_ child : clazz.getChildClasses()) {
                if (!this.hasChild(restrictions[1], child)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive exception aggregation
     */
    public GwtRpcResponseList<EventInterface> findEvents(EventInterface.EventLookupRpcRequest request, EventAction.EventContext context) {
        try {
            GwtRpcResponseList<EventInterface> gwtRpcResponseList;
            org.hibernate.Session hibSession = EventDAO.getInstance().getSession();
            try {
                HashMap<Long, Double> distances = new HashMap<Long, Double>();
                HashMap<Long, Location> locationMap = null;
                if (request.getRoomFilter() != null && !request.getRoomFilter().isEmpty()) {
                    locationMap = new HashMap<Long, Location>();
                    if (context.isAuthenticated()) {
                        request.getRoomFilter().setOption("user", context.getUser().getExternalUserId());
                    }
                    for (Location location : new RoomFilterBackend().locations(request.getSessionId(), request.getRoomFilter(), 1000, distances)) {
                        request.getEventFilter().addOption("room", location.getUniqueId().toString());
                        locationMap.put(location.getPermanentId(), location);
                    }
                }
                if (request.getResourceType() == EventInterface.ResourceType.ROOM && request.getEventFilter().hasOptions("type") && !request.getEventFilter().getOptions("type").contains(Event.sEventTypesAbbv[5])) {
                    request.getEventFilter().addOption("type", Event.sEventTypesAbbv[5]);
                }
                EventFilterBackend.EventQuery query = EventFilterBackend.getQuery(request.getEventFilter(), context);
                int limit = request.getLimit();
                String nameFormat = context.getUser().getProperty(UserProperty.NameFormat);
                List meetings = null;
                Hashtable<Long, Set[]> restrictions = null;
                Session session = (Session)SessionDAO.getInstance().get(request.getSessionId(), hibSession);
                Collection curriculumCourses = null;
                Department department = null;
                switch (request.getResourceType()) {
                    case ROOM: {
                        if (request.getResourceId() == null) {
                            meetings = query.select("distinct m").limit(1 + limit).query(hibSession).list();
                            break;
                        }
                        meetings = query.select("distinct m").joinWithLocation().where("l.uniqueId = :resourceId").set("resourceId", request.getResourceId()).limit(1 + limit).query(hibSession).list();
                        break;
                    }
                    case SUBJECT: 
                    case COURSE: {
                        String resourceCheck = request.getResourceType() == EventInterface.ResourceType.SUBJECT ? "co.subjectArea.uniqueId = :resourceId" : "co.uniqueId = :resourceId";
                        meetings = new ArrayList();
                        if (limit <= 0 || meetings.size() < limit) {
                            meetings.addAll(query.select("distinct m").type("ClassEvent").from("inner join e.clazz.schedulingSubpart.instrOfferingConfig.instructionalOffering.courseOfferings co").where(resourceCheck).set("resourceId", request.getResourceId()).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                        }
                        if (limit <= 0 || meetings.size() < limit) {
                            meetings.addAll(query.select("distinct m").type("CourseEvent").from("inner join e.relatedCourses o, CourseOffering co").where("o.ownerType = :type and o.ownerId = co.uniqueId").set("type", 1).where(resourceCheck).set("resourceId", request.getResourceId()).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                        }
                        if (limit <= 0 || meetings.size() < limit) {
                            meetings.addAll(query.select("distinct m").type("CourseEvent").from("inner join e.relatedCourses o, CourseOffering co").where("o.ownerType = :type and o.ownerId = co.instructionalOffering.uniqueId").set("type", 0).where(resourceCheck).set("resourceId", request.getResourceId()).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                        }
                        if (limit <= 0 || meetings.size() < limit) {
                            meetings.addAll(query.select("distinct m").type("CourseEvent").from("inner join e.relatedCourses o, Class_ c inner join c.schedulingSubpart.instrOfferingConfig.instructionalOffering.courseOfferings co").where("o.ownerType = :type and o.ownerId = c.uniqueId").set("type", 3).where(resourceCheck).set("resourceId", request.getResourceId()).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                        }
                        if (limit <= 0 || meetings.size() < limit) {
                            meetings.addAll(query.select("distinct m").type("CourseEvent").from("inner join e.relatedCourses o, CourseOffering co inner join co.instructionalOffering.instrOfferingConfigs cfg").where("o.ownerType = :type and o.ownerId = cfg.uniqueId").set("type", 2).where(resourceCheck).set("resourceId", request.getResourceId()).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                        }
                        if (limit <= 0 || meetings.size() < limit) {
                            meetings.addAll(query.select("distinct m").type("ExamEvent").from("inner join e.exam.owners o, CourseOffering co").where("o.ownerType = :type and o.ownerId = co.uniqueId").set("type", 1).where(resourceCheck).set("resourceId", request.getResourceId()).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                        }
                        if (limit <= 0 || meetings.size() < limit) {
                            meetings.addAll(query.select("distinct m").type("ExamEvent").from("inner join e.exam.owners o, CourseOffering co").where("o.ownerType = :type and o.ownerId = co.instructionalOffering.uniqueId").set("type", 0).where(resourceCheck).set("resourceId", request.getResourceId()).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                        }
                        if (limit <= 0 || meetings.size() < limit) {
                            meetings.addAll(query.select("distinct m").type("ExamEvent").from("inner join e.exam.owners o, Class_ c inner join c.schedulingSubpart.instrOfferingConfig.instructionalOffering.courseOfferings co").where("o.ownerType = :type and o.ownerId = c.uniqueId").set("type", 3).where(resourceCheck).set("resourceId", request.getResourceId()).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                        }
                        if (limit > 0 && meetings.size() >= limit) break;
                        meetings.addAll(query.select("distinct m").type("ExamEvent").from("inner join e.exam.owners o, CourseOffering co inner join co.instructionalOffering.instrOfferingConfigs cfg").where("o.ownerType = :type and o.ownerId = cfg.uniqueId").set("type", 2).where(resourceCheck).set("resourceId", request.getResourceId()).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                        break;
                    }
                    case CURRICULUM: {
                        curriculumCourses = hibSession.createQuery("select cc.course.uniqueId from CurriculumCourse cc where cc.classification.curriculum.uniqueId = :resourceId or cc.classification.uniqueId = :resourceId").setLong("resourceId", request.getResourceId().longValue()).list();
                        meetings = new ArrayList();
                        if (limit <= 0 || meetings.size() < limit) {
                            meetings.addAll(query.select("distinct m").type("ClassEvent").from("inner join e.clazz.schedulingSubpart.instrOfferingConfig.instructionalOffering.courseOfferings co, CurriculumCourse cc").where("co = cc.course").where("cc.classification.curriculum.uniqueId = :resourceId or cc.classification.uniqueId = :resourceId").set("resourceId", request.getResourceId()).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                        }
                        restrictions = new Hashtable<Long, Set[]>();
                        for (Object[] o : hibSession.createQuery("select distinct cc.course.instructionalOffering.uniqueId, g.uniqueId, z.uniqueId from CurriculumReservation r left outer join r.configurations g left outer join r.classes z left outer join r.majors rm left outer join r.classifications rc, CurriculumCourse cc inner join cc.classification.curriculum.majors cm where (cc.classification.curriculum.uniqueId = :resourceId or cc.classification.uniqueId = :resourceId) and cc.course.instructionalOffering = r.instructionalOffering and r.area = cc.classification.curriculum.academicArea and (rm is null or rm = cm) and (rc is null or rc = cc.classification.academicClassification)").setLong("resourceId", request.getResourceId().longValue()).setCacheable(true).list()) {
                            Long offeringId = (Long)o[0];
                            Long configId = (Long)o[1];
                            Long clazzId = (Long)o[2];
                            Set[] r = (Set[])restrictions.get(offeringId);
                            if (r == null) {
                                r = new Set[]{new HashSet(), new HashSet()};
                                restrictions.put(offeringId, r);
                            }
                            if (configId != null) {
                                r[0].add(configId);
                            }
                            if (clazzId == null) continue;
                            r[1].add(clazzId);
                        }
                        if (limit <= 0 || meetings.size() < limit) {
                            meetings.addAll(query.select("distinct m").type("ExamEvent").from("inner join e.exam.owners o, CourseOffering co, CurriculumCourse cc").where("co = cc.course").where("cc.classification.curriculum.uniqueId = :resourceId or cc.classification.uniqueId = :resourceId").set("resourceId", request.getResourceId()).where("o.ownerType = :type and o.ownerId = co.uniqueId").set("type", 1).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                        }
                        if (limit <= 0 || meetings.size() < limit) {
                            meetings.addAll(query.select("distinct m").type("ExamEvent").from("inner join e.exam.owners o, CourseOffering co, CurriculumCourse cc").where("co = cc.course").where("cc.classification.curriculum.uniqueId = :resourceId or cc.classification.uniqueId = :resourceId").set("resourceId", request.getResourceId()).where("o.ownerType = :type and o.ownerId = co.instructionalOffering.uniqueId").set("type", 0).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                        }
                        if (limit <= 0 || meetings.size() < limit) {
                            meetings.addAll(query.select("distinct m").type("ExamEvent").from("inner join e.exam.owners o, Class_ c inner join c.schedulingSubpart.instrOfferingConfig.instructionalOffering.courseOfferings co, CurriculumCourse cc").where("co = cc.course").where("cc.classification.curriculum.uniqueId = :resourceId or cc.classification.uniqueId = :resourceId").set("resourceId", request.getResourceId()).where("o.ownerType = :type and o.ownerId = c.uniqueId").set("type", 3).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                        }
                        if (limit <= 0 || meetings.size() < limit) {
                            meetings.addAll(query.select("distinct m").type("ExamEvent").from("inner join e.exam.owners o, CourseOffering co inner join co.instructionalOffering.instrOfferingConfigs cfg, CurriculumCourse cc").where("co = cc.course").where("cc.classification.curriculum.uniqueId = :resourceId or cc.classification.uniqueId = :resourceId").set("resourceId", request.getResourceId()).where("o.ownerType = :type and o.ownerId = cfg.uniqueId").set("type", 2).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                        }
                        if (limit <= 0 || meetings.size() < limit) {
                            meetings.addAll(query.select("distinct m").type("CourseEvent").from("inner join e.relatedCourses o, CourseOffering co, CurriculumCourse cc").where("co = cc.course").where("cc.classification.curriculum.uniqueId = :resourceId or cc.classification.uniqueId = :resourceId").set("resourceId", request.getResourceId()).where("o.ownerType = :type and o.ownerId = co.uniqueId").set("type", 1).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                        }
                        if (limit <= 0 || meetings.size() < limit) {
                            meetings.addAll(query.select("distinct m").type("CourseEvent").from("inner join e.relatedCourses o, CourseOffering co, CurriculumCourse cc").where("co = cc.course").where("cc.classification.curriculum.uniqueId = :resourceId or cc.classification.uniqueId = :resourceId").set("resourceId", request.getResourceId()).where("o.ownerType = :type and o.ownerId = co.instructionalOffering.uniqueId").set("type", 0).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                        }
                        if (limit <= 0 || meetings.size() < limit) {
                            meetings.addAll(query.select("distinct m").type("CourseEvent").from("inner join e.relatedCourses o, Class_ c inner join c.schedulingSubpart.instrOfferingConfig.instructionalOffering.courseOfferings co, CurriculumCourse cc").where("co = cc.course").where("cc.classification.curriculum.uniqueId = :resourceId or cc.classification.uniqueId = :resourceId").set("resourceId", request.getResourceId()).where("o.ownerType = :type and o.ownerId = c.uniqueId").set("type", 3).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                        }
                        if (limit > 0 && meetings.size() >= limit) break;
                        meetings.addAll(query.select("distinct m").type("CourseEvent").from("inner join e.relatedCourses o, CourseOffering co inner join co.instructionalOffering.instrOfferingConfigs cfg, CurriculumCourse cc").where("co = cc.course").where("cc.classification.curriculum.uniqueId = :resourceId or cc.classification.uniqueId = :resourceId").set("resourceId", request.getResourceId()).where("o.ownerType = :type and o.ownerId = cfg.uniqueId").set("type", 2).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                        break;
                    }
                    case DEPARTMENT: {
                        department = (Department)DepartmentDAO.getInstance().get(request.getResourceId(), hibSession);
                        if (department.isExternalManager().booleanValue()) {
                            meetings = query.select("distinct m").type("ClassEvent").from("inner join e.clazz.managingDept d").where("d.uniqueId = :resourceId").set("resourceId", request.getResourceId()).limit(1 + limit).query(hibSession).list();
                            break;
                        }
                        meetings = query.select("distinct m").type("ClassEvent").from("inner join e.clazz.schedulingSubpart.instrOfferingConfig.instructionalOffering.courseOfferings co inner join co.subjectArea.department d").where("d.uniqueId = :resourceId").set("resourceId", request.getResourceId()).limit(1 + limit).query(hibSession).list();
                        if (limit <= 0 || meetings.size() < limit) {
                            meetings.addAll(query.select("distinct m").type("ExamEvent").from("inner join e.exam.owners o, CourseOffering co inner join co.subjectArea.department d").where("d.uniqueId = :resourceId").set("resourceId", request.getResourceId()).where("o.ownerType = :type and o.ownerId = co.uniqueId").set("type", 1).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                        }
                        if (limit <= 0 || meetings.size() < limit) {
                            meetings.addAll(query.select("distinct m").type("ExamEvent").from("inner join e.exam.owners o, CourseOffering co inner join co.subjectArea.department d").where("d.uniqueId = :resourceId").set("resourceId", request.getResourceId()).where("o.ownerType = :type and o.ownerId = co.instructionalOffering.uniqueId").set("type", 0).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                        }
                        if (limit <= 0 || meetings.size() < limit) {
                            meetings.addAll(query.select("distinct m").type("ExamEvent").from("inner join e.exam.owners o, Class_ c inner join c.schedulingSubpart.instrOfferingConfig.instructionalOffering.courseOfferings co inner join co.subjectArea.department d").where("d.uniqueId = :resourceId").set("resourceId", request.getResourceId()).where("o.ownerType = :type and o.ownerId = c.uniqueId").set("type", 3).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                        }
                        if (limit <= 0 || meetings.size() < limit) {
                            meetings.addAll(query.select("distinct m").type("ExamEvent").from("inner join e.exam.owners o, CourseOffering co inner join co.instructionalOffering.instrOfferingConfigs cfg inner join co.subjectArea.department d").where("d.uniqueId = :resourceId").set("resourceId", request.getResourceId()).where("o.ownerType = :type and o.ownerId = cfg.uniqueId").set("type", 2).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                        }
                        if (limit <= 0 || meetings.size() < limit) {
                            meetings.addAll(query.select("distinct m").type("CourseEvent").from("inner join e.relatedCourses o, CourseOffering co inner join co.subjectArea.department d").where("d.uniqueId = :resourceId").set("resourceId", request.getResourceId()).where("o.ownerType = :type and o.ownerId = co.uniqueId").set("type", 1).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                        }
                        if (limit <= 0 || meetings.size() < limit) {
                            meetings.addAll(query.select("distinct m").type("CourseEvent").from("inner join e.relatedCourses o, CourseOffering co inner join co.subjectArea.department d").where("d.uniqueId = :resourceId").set("resourceId", request.getResourceId()).where("o.ownerType = :type and o.ownerId = co.instructionalOffering.uniqueId").set("type", 0).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                        }
                        if (limit <= 0 || meetings.size() < limit) {
                            meetings.addAll(query.select("distinct m").type("CourseEvent").from("inner join e.relatedCourses o, Class_ c inner join c.schedulingSubpart.instrOfferingConfig.instructionalOffering.courseOfferings co inner join co.subjectArea.department d").where("d.uniqueId = :resourceId").set("resourceId", request.getResourceId()).where("o.ownerType = :type and o.ownerId = c.uniqueId").set("type", 3).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                        }
                        if (limit > 0 && meetings.size() >= limit) break;
                        meetings.addAll(query.select("distinct m").type("CourseEvent").from("inner join e.relatedCourses o, CourseOffering co inner join co.instructionalOffering.instrOfferingConfigs cfg inner join co.subjectArea.department d").where("d.uniqueId = :resourceId").set("resourceId", request.getResourceId()).where("o.ownerType = :type and o.ownerId = cfg.uniqueId").set("type", 2).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                        break;
                    }
                    case PERSON: {
                        boolean overrideStatus = context.hasPermission(Right.EventLookupSchedule);
                        boolean canViewFinalExams = overrideStatus || session.getStatusType().canNoRoleReportExamFinal();
                        boolean canViewMidtermExams = overrideStatus || session.getStatusType().canNoRoleReportExamMidterm();
                        boolean canViewClasses = overrideStatus || session.getStatusType().canNoRoleReportClass();
                        boolean allSessions = request.getEventFilter().hasOption("flag") && request.getEventFilter().getOptions("flag").contains("All Sessions");
                        Set<String> roles = request.getEventFilter().getOptions("role");
                        boolean student = roles == null || roles.contains("student") || roles.contains("Student");
                        boolean instructor = roles == null || roles.contains("instructor") || roles.contains("Instructor");
                        boolean contact = roles == null || roles.contains("contact") || roles.contains("Contact");
                        boolean coordinator = roles != null && (roles.contains("coordinator") || roles.contains("Coordinator"));
                        curriculumCourses = new HashSet();
                        if (allSessions) {
                            if (student) {
                                curriculumCourses.addAll(hibSession.createQuery("select e.courseOffering.uniqueId from StudentClassEnrollment e where e.student.externalUniqueId = :externalId").setString("externalId", request.getResourceExternalId()).list());
                            }
                            if (instructor) {
                                curriculumCourses.addAll(hibSession.createQuery("select o.course.uniqueId from Exam x inner join x.owners o inner join x.instructors i where i.externalUniqueId = :externalId").setString("externalId", request.getResourceExternalId()).list());
                            }
                        } else {
                            if (student) {
                                curriculumCourses.addAll(hibSession.createQuery("select e.courseOffering.uniqueId from StudentClassEnrollment e where e.student.session.uniqueId = :sessionId and e.student.externalUniqueId = :externalId").setLong("sessionId", request.getSessionId().longValue()).setString("externalId", request.getResourceExternalId()).list());
                            }
                            if (instructor) {
                                curriculumCourses.addAll(hibSession.createQuery("select o.course.uniqueId from Exam x inner join x.owners o inner join x.instructors i where x.session.uniqueId = :sessionId and i.externalUniqueId = :externalId").setLong("sessionId", request.getSessionId().longValue()).setString("externalId", request.getResourceExternalId()).list());
                            }
                        }
                        meetings = new ArrayList();
                        if (allSessions) {
                            if (overrideStatus) {
                                if (student && (limit <= 0 || meetings.size() < limit)) {
                                    meetings.addAll(query.select("distinct m").type("ClassEvent").from("inner join e.clazz.studentEnrollments enrl").where("enrl.student.externalUniqueId = :externalId").where("enrl.student.session.uniqueId = s.uniqueId").set("externalId", request.getResourceExternalId()).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                                }
                                if (instructor && (limit <= 0 || meetings.size() < limit)) {
                                    meetings.addAll(query.select("distinct m").type("ClassEvent").from("inner join e.clazz.classInstructors ci").where("ci.instructor.externalUniqueId = :externalId").where("ci.instructor.department.session.uniqueId = s.uniqueId").set("externalId", request.getResourceExternalId()).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                                }
                                if (coordinator && (limit <= 0 || meetings.size() < limit)) {
                                    meetings.addAll(query.select("distinct m").type("ClassEvent").from("inner join e.clazz.schedulingSubpart.instrOfferingConfig.instructionalOffering.coordinators cc").where("cc.externalUniqueId = :externalId").where("cc.department.session.uniqueId = s.uniqueId").set("externalId", request.getResourceExternalId()).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                                }
                            } else {
                                if (student && (limit <= 0 || meetings.size() < limit)) {
                                    meetings.addAll(query.select("distinct m").type("ClassEvent").from("inner join e.clazz.studentEnrollments enrl").where("enrl.student.externalUniqueId = :externalId").where("enrl.student.session.uniqueId = s.uniqueId").where("bit_and(s.statusType.status, :flag) > 0").set("flag", DepartmentStatusType.Status.ReportClasses.toInt()).set("externalId", request.getResourceExternalId()).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                                }
                                if (instructor && (limit <= 0 || meetings.size() < limit)) {
                                    meetings.addAll(query.select("distinct m").type("ClassEvent").from("inner join e.clazz.classInstructors ci").where("ci.instructor.externalUniqueId = :externalId").where("ci.instructor.department.session.uniqueId = s.uniqueId").where("bit_and(s.statusType.status, :flag) > 0").set("flag", DepartmentStatusType.Status.ReportClasses.toInt()).set("externalId", request.getResourceExternalId()).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                                }
                                if (coordinator && (limit <= 0 || meetings.size() < limit)) {
                                    meetings.addAll(query.select("distinct m").type("ClassEvent").from("inner join e.clazz.schedulingSubpart.instrOfferingConfig.instructionalOffering.coordinators cc").where("cc.externalUniqueId = :externalId").where("cc.department.session.uniqueId = s.uniqueId").where("bit_and(s.statusType.status, :flag) > 0").set("flag", DepartmentStatusType.Status.ReportClasses.toInt()).set("externalId", request.getResourceExternalId()).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                                }
                            }
                        } else if (canViewClasses) {
                            if (student && (limit <= 0 || meetings.size() < limit)) {
                                meetings.addAll(query.select("distinct m").type("ClassEvent").from("inner join e.clazz.studentEnrollments enrl").where("enrl.student.externalUniqueId = :externalId").set("externalId", request.getResourceExternalId()).where("enrl.student.session = s").limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                            }
                            if (instructor && (limit <= 0 || meetings.size() < limit)) {
                                meetings.addAll(query.select("distinct m").type("ClassEvent").from("inner join e.clazz.classInstructors ci").where("ci.instructor.externalUniqueId = :externalId").set("externalId", request.getResourceExternalId()).where("ci.instructor.department.session = s").limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                            }
                            if (coordinator && (limit <= 0 || meetings.size() < limit)) {
                                meetings.addAll(query.select("distinct m").type("ClassEvent").from("inner join e.clazz.schedulingSubpart.instrOfferingConfig.instructionalOffering.coordinators cc").where("cc.externalUniqueId = :externalId").set("externalId", request.getResourceExternalId()).where("cc.department.session = s").limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                            }
                        }
                        if (allSessions) {
                            if (overrideStatus) {
                                if (student && (limit <= 0 || meetings.size() < limit)) {
                                    meetings.addAll(query.select("distinct m").type("ExamEvent").from("inner join e.exam.owners o, StudentClassEnrollment enrl inner join enrl.courseOffering co").where("enrl.student.externalUniqueId = :externalId").set("externalId", request.getResourceExternalId()).where("o.ownerType = :type and o.ownerId = co.uniqueId").set("type", 1).where("enrl.student.session.uniqueId = s.uniqueId").limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                                }
                                if (student && (limit <= 0 || meetings.size() < limit)) {
                                    meetings.addAll(query.select("distinct m").type("ExamEvent").from("inner join e.exam.owners o, StudentClassEnrollment enrl inner join enrl.courseOffering co").where("enrl.student.externalUniqueId = :externalId").set("externalId", request.getResourceExternalId()).where("o.ownerType = :type and o.ownerId = co.instructionalOffering.uniqueId").set("type", 0).where("enrl.student.session.uniqueId = s.uniqueId").limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                                }
                                if (student && (limit <= 0 || meetings.size() < limit)) {
                                    meetings.addAll(query.select("distinct m").type("ExamEvent").from("inner join e.exam.owners o, StudentClassEnrollment enrl inner join enrl.clazz c inner join c.schedulingSubpart.instrOfferingConfig.instructionalOffering.courseOfferings co").where("enrl.student.externalUniqueId = :externalId").set("externalId", request.getResourceExternalId()).where("o.ownerType = :type and o.ownerId = c.uniqueId").set("type", 3).where("enrl.student.session.uniqueId = s.uniqueId").limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                                }
                                if (student && (limit <= 0 || meetings.size() < limit)) {
                                    meetings.addAll(query.select("distinct m").type("ExamEvent").from("inner join e.exam.owners o, StudentClassEnrollment enrl inner join enrl.clazz c inner join c.schedulingSubpart.instrOfferingConfig cfg").where("enrl.student.externalUniqueId = :externalId").set("externalId", request.getResourceExternalId()).where("o.ownerType = :type and o.ownerId = cfg.uniqueId").set("type", 2).where("enrl.student.session.uniqueId = s.uniqueId").limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                                }
                                if (instructor && (limit <= 0 || meetings.size() < limit)) {
                                    meetings.addAll(query.select("distinct m").type("ExamEvent").from("inner join e.exam.instructors i").where("i.externalUniqueId = :externalId").set("externalId", request.getResourceExternalId()).where("i.department.session.uniqueId = s.uniqueId").limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                                }
                                if (coordinator && (limit <= 0 || meetings.size() < limit)) {
                                    meetings.addAll(query.select("distinct m").type("ExamEvent").from("inner join e.exam.owners o, CourseOffering co inner join co.instructionalOffering.coordinators cc").where("cc.externalUniqueId = :externalId").set("externalId", request.getResourceExternalId()).where("o.ownerType = :type and o.ownerId = co.uniqueId").set("type", 1).where("cc.department.session.uniqueId = s.uniqueId").limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                                }
                                if (coordinator && (limit <= 0 || meetings.size() < limit)) {
                                    meetings.addAll(query.select("distinct m").type("ExamEvent").from("inner join e.exam.owners o, CourseOffering co inner join co.instructionalOffering.coordinators cc").where("cc.externalUniqueId = :externalId").set("externalId", request.getResourceExternalId()).where("o.ownerType = :type and o.ownerId = co.instructionalOffering.uniqueId").set("type", 0).where("cc.department.session.uniqueId = s.uniqueId").limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                                }
                                if (coordinator && (limit <= 0 || meetings.size() < limit)) {
                                    meetings.addAll(query.select("distinct m").type("ExamEvent").from("inner join e.exam.owners o, Class_ c inner join c.schedulingSubpart.instrOfferingConfig.instructionalOffering.coordinators cc").where("cc.externalUniqueId = :externalId").set("externalId", request.getResourceExternalId()).where("o.ownerType = :type and o.ownerId = c.uniqueId").set("type", 3).where("cc.department.session.uniqueId = s.uniqueId").limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                                }
                                if (coordinator && (limit <= 0 || meetings.size() < limit)) {
                                    meetings.addAll(query.select("distinct m").type("ExamEvent").from("inner join e.exam.owners o, InstrOfferingConfig cfg inner join cfg.instructionalOffering.coordinators cc").where("cc.externalUniqueId = :externalId").set("externalId", request.getResourceExternalId()).where("o.ownerType = :type and o.ownerId = cfg.uniqueId").set("type", 2).where("cc.department.session.uniqueId = s.uniqueId").limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                                }
                            } else {
                                if (student && (limit <= 0 || meetings.size() < limit)) {
                                    meetings.addAll(query.select("distinct m").type("FinalExamEvent").from("inner join e.exam.owners o, StudentClassEnrollment enrl inner join enrl.courseOffering co").where("enrl.student.externalUniqueId = :externalId").set("externalId", request.getResourceExternalId()).where("o.ownerType = :type and o.ownerId = co.uniqueId").set("type", 1).where("enrl.student.session.uniqueId = s.uniqueId").where("bit_and(s.statusType.status, :flag) > 0").set("flag", DepartmentStatusType.Status.ReportExamsFinal.toInt()).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                                }
                                if (student && (limit <= 0 || meetings.size() < limit)) {
                                    meetings.addAll(query.select("distinct m").type("MidtermExamEvent").from("inner join e.exam.owners o, StudentClassEnrollment enrl inner join enrl.courseOffering co").where("enrl.student.externalUniqueId = :externalId").set("externalId", request.getResourceExternalId()).where("o.ownerType = :type and o.ownerId = co.uniqueId").set("type", 1).where("enrl.student.session.uniqueId = s.uniqueId").where("bit_and(s.statusType.status, :flag) > 0").set("flag", DepartmentStatusType.Status.ReportExamsMidterm.toInt()).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                                }
                                if (student && (limit <= 0 || meetings.size() < limit)) {
                                    meetings.addAll(query.select("distinct m").type("FinalExamEvent").from("inner join e.exam.owners o, StudentClassEnrollment enrl inner join enrl.courseOffering co").where("enrl.student.externalUniqueId = :externalId").set("externalId", request.getResourceExternalId()).where("o.ownerType = :type and o.ownerId = co.instructionalOffering.uniqueId").set("type", 0).where("enrl.student.session.uniqueId = s.uniqueId").where("bit_and(s.statusType.status, :flag) > 0").set("flag", DepartmentStatusType.Status.ReportExamsFinal.toInt()).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                                }
                                if (student && (limit <= 0 || meetings.size() < limit)) {
                                    meetings.addAll(query.select("distinct m").type("MidtermExamEvent").from("inner join e.exam.owners o, StudentClassEnrollment enrl inner join enrl.courseOffering co").where("enrl.student.externalUniqueId = :externalId").set("externalId", request.getResourceExternalId()).where("o.ownerType = :type and o.ownerId = co.instructionalOffering.uniqueId").set("type", 0).where("enrl.student.session.uniqueId = s.uniqueId").where("bit_and(s.statusType.status, :flag) > 0").set("flag", DepartmentStatusType.Status.ReportExamsMidterm.toInt()).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                                }
                                if (student && (limit <= 0 || meetings.size() < limit)) {
                                    meetings.addAll(query.select("distinct m").type("FinalExamEvent").from("inner join e.exam.owners o, StudentClassEnrollment enrl inner join enrl.clazz c inner join c.schedulingSubpart.instrOfferingConfig.instructionalOffering.courseOfferings co").where("enrl.student.externalUniqueId = :externalId").set("externalId", request.getResourceExternalId()).where("o.ownerType = :type and o.ownerId = c.uniqueId").set("type", 3).where("enrl.student.session.uniqueId = s.uniqueId").where("bit_and(s.statusType.status, :flag) > 0").set("flag", DepartmentStatusType.Status.ReportExamsFinal.toInt()).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                                }
                                if (student && (limit <= 0 || meetings.size() < limit)) {
                                    meetings.addAll(query.select("distinct m").type("MidtermExamEvent").from("inner join e.exam.owners o, StudentClassEnrollment enrl inner join enrl.clazz c inner join c.schedulingSubpart.instrOfferingConfig.instructionalOffering.courseOfferings co").where("enrl.student.externalUniqueId = :externalId").set("externalId", request.getResourceExternalId()).where("o.ownerType = :type and o.ownerId = c.uniqueId").set("type", 3).where("enrl.student.session.uniqueId = s.uniqueId").where("bit_and(s.statusType.status, :flag) > 0").set("flag", DepartmentStatusType.Status.ReportExamsMidterm.toInt()).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                                }
                                if (student && (limit <= 0 || meetings.size() < limit)) {
                                    meetings.addAll(query.select("distinct m").type("FinalExamEvent").from("inner join e.exam.owners o, StudentClassEnrollment enrl inner join enrl.clazz c inner join c.schedulingSubpart.instrOfferingConfig cfg").where("enrl.student.externalUniqueId = :externalId").set("externalId", request.getResourceExternalId()).where("o.ownerType = :type and o.ownerId = cfg.uniqueId").set("type", 2).where("enrl.student.session.uniqueId = s.uniqueId").where("bit_and(s.statusType.status, :flag) > 0").set("flag", DepartmentStatusType.Status.ReportExamsFinal.toInt()).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                                }
                                if (student && (limit <= 0 || meetings.size() < limit)) {
                                    meetings.addAll(query.select("distinct m").type("MidtermExamEvent").from("inner join e.exam.owners o, StudentClassEnrollment enrl inner join enrl.clazz c inner join c.schedulingSubpart.instrOfferingConfig cfg").where("enrl.student.externalUniqueId = :externalId").set("externalId", request.getResourceExternalId()).where("o.ownerType = :type and o.ownerId = cfg.uniqueId").set("type", 2).where("enrl.student.session.uniqueId = s.uniqueId").where("bit_and(s.statusType.status, :flag) > 0").set("flag", DepartmentStatusType.Status.ReportExamsMidterm.toInt()).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                                }
                                if (instructor && (limit <= 0 || meetings.size() < limit)) {
                                    meetings.addAll(query.select("distinct m").type("FinalExamEvent").from("inner join e.exam.instructors i").where("i.externalUniqueId = :externalId").set("externalId", request.getResourceExternalId()).where("i.department.session.uniqueId = s.uniqueId").where("bit_and(s.statusType.status, :flag) > 0").set("flag", DepartmentStatusType.Status.ReportExamsFinal.toInt()).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                                }
                                if (instructor && (limit <= 0 || meetings.size() < limit)) {
                                    meetings.addAll(query.select("distinct m").type("MidtermExamEvent").from("inner join e.exam.instructors i").where("i.externalUniqueId = :externalId").set("externalId", request.getResourceExternalId()).where("i.department.session.uniqueId = s.uniqueId").where("bit_and(s.statusType.status, :flag) > 0").set("flag", DepartmentStatusType.Status.ReportExamsMidterm.toInt()).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                                }
                                if (coordinator && (limit <= 0 || meetings.size() < limit)) {
                                    meetings.addAll(query.select("distinct m").type("FinalExamEvent").from("inner join e.exam.owners o, CourseOffering co inner join co.instructionalOffering.coordinators cc").where("cc.externalUniqueId = :externalId").set("externalId", request.getResourceExternalId()).where("o.ownerType = :type and o.ownerId = co.uniqueId").set("type", 1).where("cc.department.session.uniqueId = s.uniqueId").where("bit_and(s.statusType.status, :flag) > 0").set("flag", DepartmentStatusType.Status.ReportExamsFinal.toInt()).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                                }
                                if (coordinator && (limit <= 0 || meetings.size() < limit)) {
                                    meetings.addAll(query.select("distinct m").type("MidtermExamEvent").from("inner join e.exam.owners o, CourseOffering co inner join co.instructionalOffering.coordinators cc").where("cc.externalUniqueId = :externalId").set("externalId", request.getResourceExternalId()).where("o.ownerType = :type and o.ownerId = co.uniqueId").set("type", 1).where("cc.department.session.uniqueId = s.uniqueId").where("bit_and(s.statusType.status, :flag) > 0").set("flag", DepartmentStatusType.Status.ReportExamsMidterm.toInt()).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                                }
                                if (coordinator && (limit <= 0 || meetings.size() < limit)) {
                                    meetings.addAll(query.select("distinct m").type("FinalExamEvent").from("inner join e.exam.owners o, CourseOffering co inner join co.instructionalOffering.coordinators cc").where("cc.externalUniqueId = :externalId").set("externalId", request.getResourceExternalId()).where("o.ownerType = :type and o.ownerId = co.instructionalOffering.uniqueId").set("type", 0).where("cc.department.session.uniqueId = s.uniqueId").where("bit_and(s.statusType.status, :flag) > 0").set("flag", DepartmentStatusType.Status.ReportExamsFinal.toInt()).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                                }
                                if (coordinator && (limit <= 0 || meetings.size() < limit)) {
                                    meetings.addAll(query.select("distinct m").type("MidtermExamEvent").from("inner join e.exam.owners o, CourseOffering co inner join co.instructionalOffering.coordinators cc").where("cc.externalUniqueId = :externalId").set("externalId", request.getResourceExternalId()).where("o.ownerType = :type and o.ownerId = co.instructionalOffering.uniqueId").set("type", 0).where("cc.department.session.uniqueId = s.uniqueId").where("bit_and(s.statusType.status, :flag) > 0").set("flag", DepartmentStatusType.Status.ReportExamsMidterm.toInt()).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                                }
                                if (coordinator && (limit <= 0 || meetings.size() < limit)) {
                                    meetings.addAll(query.select("distinct m").type("FinalExamEvent").from("inner join e.exam.owners o, Class_ c inner join c.schedulingSubpart.instrOfferingConfig.instructionalOffering.coordinators cc").where("cc.externalUniqueId = :externalId").set("externalId", request.getResourceExternalId()).where("o.ownerType = :type and o.ownerId = c.uniqueId").set("type", 3).where("cc.department.session.uniqueId = s.uniqueId").where("bit_and(s.statusType.status, :flag) > 0").set("flag", DepartmentStatusType.Status.ReportExamsFinal.toInt()).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                                }
                                if (coordinator && (limit <= 0 || meetings.size() < limit)) {
                                    meetings.addAll(query.select("distinct m").type("MidtermExamEvent").from("inner join e.exam.owners o, Class_ c inner join c.schedulingSubpart.instrOfferingConfig.instructionalOffering.coordinators cc").where("cc.externalUniqueId = :externalId").set("externalId", request.getResourceExternalId()).where("o.ownerType = :type and o.ownerId = c.uniqueId").set("type", 3).where("cc.department.session.uniqueId = s.uniqueId").where("bit_and(s.statusType.status, :flag) > 0").set("flag", DepartmentStatusType.Status.ReportExamsMidterm.toInt()).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                                }
                                if (coordinator && (limit <= 0 || meetings.size() < limit)) {
                                    meetings.addAll(query.select("distinct m").type("FinalExamEvent").from("inner join e.exam.owners o, InstrOfferingConfig cfg inner join cfg.instructionalOffering.coordinators cc").where("cc.externalUniqueId = :externalId").set("externalId", request.getResourceExternalId()).where("o.ownerType = :type and o.ownerId = cfg.uniqueId").set("type", 2).where("cc.department.session.uniqueId = s.uniqueId").where("bit_and(s.statusType.status, :flag) > 0").set("flag", DepartmentStatusType.Status.ReportExamsFinal.toInt()).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                                }
                                if (coordinator && (limit <= 0 || meetings.size() < limit)) {
                                    meetings.addAll(query.select("distinct m").type("MidtermExamEvent").from("inner join e.exam.owners o, InstrOfferingConfig cfg inner join cfg.instructionalOffering.coordinators cc").where("cc.externalUniqueId = :externalId").set("externalId", request.getResourceExternalId()).where("o.ownerType = :type and o.ownerId = cfg.uniqueId").set("type", 2).where("cc.department.session.uniqueId = s.uniqueId").where("bit_and(s.statusType.status, :flag) > 0").set("flag", DepartmentStatusType.Status.ReportExamsMidterm.toInt()).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                                }
                            }
                        } else if (canViewFinalExams || canViewMidtermExams) {
                            String string;
                            String string2 = canViewFinalExams ? (canViewMidtermExams ? "ExamEvent" : "FinalExamEvent") : (string = "MidtermExamEvent");
                            if (student && (limit <= 0 || meetings.size() < limit)) {
                                meetings.addAll(query.select("distinct m").type(string).from("inner join e.exam.owners o, StudentClassEnrollment enrl inner join enrl.courseOffering co").where("enrl.student.externalUniqueId = :externalId").set("externalId", request.getResourceExternalId()).where("o.ownerType = :type and o.ownerId = co.uniqueId").set("type", 1).where("e.exam.session = s").limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                            }
                            if (student && (limit <= 0 || meetings.size() < limit)) {
                                meetings.addAll(query.select("distinct m").type(string).from("inner join e.exam.owners o, StudentClassEnrollment enrl inner join enrl.courseOffering co").where("enrl.student.externalUniqueId = :externalId").set("externalId", request.getResourceExternalId()).where("o.ownerType = :type and o.ownerId = co.instructionalOffering.uniqueId").set("type", 0).where("e.exam.session = s").limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                            }
                            if (student && (limit <= 0 || meetings.size() < limit)) {
                                meetings.addAll(query.select("distinct m").type(string).from("inner join e.exam.owners o, StudentClassEnrollment enrl inner join enrl.clazz c inner join c.schedulingSubpart.instrOfferingConfig.instructionalOffering.courseOfferings co").where("enrl.student.externalUniqueId = :externalId").set("externalId", request.getResourceExternalId()).where("o.ownerType = :type and o.ownerId = c.uniqueId").set("type", 3).where("e.exam.session = s").limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                            }
                            if (student && (limit <= 0 || meetings.size() < limit)) {
                                meetings.addAll(query.select("distinct m").type(string).from("inner join e.exam.owners o, StudentClassEnrollment enrl inner join enrl.clazz c inner join c.schedulingSubpart.instrOfferingConfig cfg").where("enrl.student.externalUniqueId = :externalId").set("externalId", request.getResourceExternalId()).where("o.ownerType = :type and o.ownerId = cfg.uniqueId").set("type", 2).where("e.exam.session = s").limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                            }
                            if (instructor && (limit <= 0 || meetings.size() < limit)) {
                                meetings.addAll(query.select("distinct m").type(string).from("inner join e.exam.instructors i").where("i.externalUniqueId = :externalId").set("externalId", request.getResourceExternalId()).where("e.exam.session = s").limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                            }
                            if (coordinator && (limit <= 0 || meetings.size() < limit)) {
                                meetings.addAll(query.select("distinct m").type("ExamEvent").from("inner join e.exam.owners o, CourseOffering co inner join co.instructionalOffering.coordinators cc").where("cc.externalUniqueId = :externalId").set("externalId", request.getResourceExternalId()).where("o.ownerType = :type and o.ownerId = co.uniqueId").set("type", 1).where("cc.department.session = s").limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                            }
                            if (coordinator && (limit <= 0 || meetings.size() < limit)) {
                                meetings.addAll(query.select("distinct m").type("ExamEvent").from("inner join e.exam.owners o, CourseOffering co inner join co.instructionalOffering.coordinators cc").where("cc.externalUniqueId = :externalId").set("externalId", request.getResourceExternalId()).where("o.ownerType = :type and o.ownerId = co.instructionalOffering.uniqueId").set("type", 0).where("cc.department.session = s").limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                            }
                            if (coordinator && (limit <= 0 || meetings.size() < limit)) {
                                meetings.addAll(query.select("distinct m").type("ExamEvent").from("inner join e.exam.owners o, Class_ c inner join c.schedulingSubpart.instrOfferingConfig.instructionalOffering.coordinators cc").where("cc.externalUniqueId = :externalId").set("externalId", request.getResourceExternalId()).where("o.ownerType = :type and o.ownerId = c.uniqueId").set("type", 3).where("cc.department.session = s").limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                            }
                            if (coordinator && (limit <= 0 || meetings.size() < limit)) {
                                meetings.addAll(query.select("distinct m").type("ExamEvent").from("inner join e.exam.owners o, InstrOfferingConfig cfg inner join cfg.instructionalOffering.coordinators cc").where("cc.externalUniqueId = :externalId").set("externalId", request.getResourceExternalId()).where("o.ownerType = :type and o.ownerId = cfg.uniqueId").set("type", 2).where("cc.department.session = s").limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                            }
                        }
                        if (allSessions) {
                            if (student && (limit <= 0 || meetings.size() < limit)) {
                                meetings.addAll(query.select("distinct m").type("CourseEvent").from("inner join e.relatedCourses o, StudentClassEnrollment enrl inner join enrl.courseOffering co").where("enrl.student.externalUniqueId = :externalId").set("externalId", request.getResourceExternalId()).where("o.ownerType = :type and o.ownerId = co.uniqueId").set("type", 1).where("enrl.student.session.uniqueId = s.uniqueId").limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                            }
                            if (student && (limit <= 0 || meetings.size() < limit)) {
                                meetings.addAll(query.select("distinct m").type("CourseEvent").from("inner join e.relatedCourses o, StudentClassEnrollment enrl inner join enrl.courseOffering co").where("enrl.student.externalUniqueId = :externalId").set("externalId", request.getResourceExternalId()).where("o.ownerType = :type and o.ownerId = co.instructionalOffering.uniqueId").set("type", 0).where("enrl.student.session.uniqueId = s.uniqueId").limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                            }
                            if (student && (limit <= 0 || meetings.size() < limit)) {
                                meetings.addAll(query.select("distinct m").type("CourseEvent").from("inner join e.relatedCourses o, StudentClassEnrollment enrl inner join enrl.clazz c inner join c.schedulingSubpart.instrOfferingConfig.instructionalOffering.courseOfferings co").where("enrl.student.externalUniqueId = :externalId").set("externalId", request.getResourceExternalId()).where("o.ownerType = :type and o.ownerId = c.uniqueId").set("type", 3).where("enrl.student.session.uniqueId = s.uniqueId").limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                            }
                            if (student && (limit <= 0 || meetings.size() < limit)) {
                                meetings.addAll(query.select("distinct m").type("CourseEvent").from("inner join e.relatedCourses o, StudentClassEnrollment enrl inner join enrl.clazz c inner join c.schedulingSubpart.instrOfferingConfig cfg").where("enrl.student.externalUniqueId = :externalId").set("externalId", request.getResourceExternalId()).where("o.ownerType = :type and o.ownerId = cfg.uniqueId").set("type", 2).where("enrl.student.session.uniqueId = s.uniqueId").limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                            }
                            if (instructor && (limit <= 0 || meetings.size() < limit)) {
                                meetings.addAll(query.select("distinct m").type("CourseEvent").from("inner join e.relatedCourses o, ClassInstructor ci inner join ci.classInstructing c inner join c.schedulingSubpart.instrOfferingConfig.instructionalOffering.courseOfferings co").where("ci.instructor.externalUniqueId = :externalId").set("externalId", request.getResourceExternalId()).where("o.ownerType = :type and o.ownerId = co.uniqueId").set("type", 1).where("ci.instructor.department.session.uniqueId = s.uniqueId").limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                            }
                            if (instructor && (limit <= 0 || meetings.size() < limit)) {
                                meetings.addAll(query.select("distinct m").type("CourseEvent").from("inner join e.relatedCourses o, ClassInstructor ci inner join ci.classInstructing c inner join c.schedulingSubpart.instrOfferingConfig.instructionalOffering.courseOfferings co").where("ci.instructor.externalUniqueId = :externalId").set("externalId", request.getResourceExternalId()).where("o.ownerType = :type and o.ownerId = co.instructionalOffering.uniqueId").set("type", 0).where("ci.instructor.department.session.uniqueId = s.uniqueId").limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                            }
                            if (instructor && (limit <= 0 || meetings.size() < limit)) {
                                meetings.addAll(query.select("distinct m").type("CourseEvent").from("inner join e.relatedCourses o, ClassInstructor ci inner join ci.classInstructing c inner join c.schedulingSubpart.instrOfferingConfig cfg").where("ci.instructor.externalUniqueId = :externalId").set("externalId", request.getResourceExternalId()).where("o.ownerType = :type and o.ownerId = cfg.uniqueId").set("type", 2).where("ci.instructor.department.session.uniqueId = s.uniqueId").limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                            }
                            if (instructor && (limit <= 0 || meetings.size() < limit)) {
                                meetings.addAll(query.select("distinct m").type("CourseEvent").from("inner join e.relatedCourses o, ClassInstructor ci inner join ci.classInstructing c").where("ci.instructor.externalUniqueId = :externalId").set("externalId", request.getResourceExternalId()).where("o.ownerType = :type and o.ownerId = c.uniqueId").set("type", 3).where("ci.instructor.department.session.uniqueId = s.uniqueId").limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                            }
                            if (coordinator && (limit <= 0 || meetings.size() < limit)) {
                                meetings.addAll(query.select("distinct m").type("CourseEvent").from("inner join e.relatedCourses o, CourseOffering co inner join co.instructionalOffering.coordinators cc").where("cc.externalUniqueId = :externalId").set("externalId", request.getResourceExternalId()).where("o.ownerType = :type and o.ownerId = co.uniqueId").set("type", 1).where("cc.department.session.uniqueId = s.uniqueId").limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                            }
                            if (coordinator && (limit <= 0 || meetings.size() < limit)) {
                                meetings.addAll(query.select("distinct m").type("CourseEvent").from("inner join e.relatedCourses o, CourseOffering co inner join co.instructionalOffering.coordinators cc").where("cc.externalUniqueId = :externalId").set("externalId", request.getResourceExternalId()).where("o.ownerType = :type and o.ownerId = co.instructionalOffering.uniqueId").set("type", 0).where("cc.department.session.uniqueId = s.uniqueId").limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                            }
                            if (coordinator && (limit <= 0 || meetings.size() < limit)) {
                                meetings.addAll(query.select("distinct m").type("CourseEvent").from("inner join e.relatedCourses o, InstrOfferingConfig cfg inner join cfg.instructionalOffering.coordinators cc").where("cc.externalUniqueId = :externalId").set("externalId", request.getResourceExternalId()).where("o.ownerType = :type and o.ownerId = cfg.uniqueId").set("type", 2).where("cc.department.session.uniqueId = s.uniqueId").limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                            }
                            if (coordinator && (limit <= 0 || meetings.size() < limit)) {
                                meetings.addAll(query.select("distinct m").type("CourseEvent").from("inner join e.relatedCourses o, Class_ c inner join c.schedulingSubpart.instrOfferingConfig.instructionalOffering.coordinators cc").where("cc.externalUniqueId = :externalId").set("externalId", request.getResourceExternalId()).where("o.ownerType = :type and o.ownerId = c.uniqueId").set("type", 3).where("cc.department.session.uniqueId = s.uniqueId").limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                            }
                        } else {
                            if (student && (limit <= 0 || meetings.size() < limit)) {
                                meetings.addAll(query.select("distinct m").type("CourseEvent").from("inner join e.relatedCourses o, StudentClassEnrollment enrl inner join enrl.courseOffering co").where("enrl.student.externalUniqueId = :externalId").set("externalId", request.getResourceExternalId()).where("o.ownerType = :type and o.ownerId = co.uniqueId").where("enrl.student.session = s").set("type", 1).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                            }
                            if (student && (limit <= 0 || meetings.size() < limit)) {
                                meetings.addAll(query.select("distinct m").type("CourseEvent").from("inner join e.relatedCourses o, StudentClassEnrollment enrl inner join enrl.courseOffering co").where("enrl.student.externalUniqueId = :externalId").set("externalId", request.getResourceExternalId()).where("o.ownerType = :type and o.ownerId = co.instructionalOffering.uniqueId").where("enrl.student.session = s").set("type", 0).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                            }
                            if (student && (limit <= 0 || meetings.size() < limit)) {
                                meetings.addAll(query.select("distinct m").type("CourseEvent").from("inner join e.relatedCourses o, StudentClassEnrollment enrl inner join enrl.clazz c inner join c.schedulingSubpart.instrOfferingConfig.instructionalOffering.courseOfferings co").where("enrl.student.externalUniqueId = :externalId").set("externalId", request.getResourceExternalId()).where("o.ownerType = :type and o.ownerId = c.uniqueId").where("enrl.student.session = s").set("type", 3).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                            }
                            if (student && (limit <= 0 || meetings.size() < limit)) {
                                meetings.addAll(query.select("distinct m").type("CourseEvent").from("inner join e.relatedCourses o, StudentClassEnrollment enrl inner join enrl.clazz c inner join c.schedulingSubpart.instrOfferingConfig cfg").where("enrl.student.externalUniqueId = :externalId").set("externalId", request.getResourceExternalId()).where("o.ownerType = :type and o.ownerId = cfg.uniqueId").where("enrl.student.session = s").set("type", 2).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                            }
                            if (instructor && (limit <= 0 || meetings.size() < limit)) {
                                meetings.addAll(query.select("distinct m").type("CourseEvent").from("inner join e.relatedCourses o, ClassInstructor ci inner join ci.classInstructing c inner join c.schedulingSubpart.instrOfferingConfig.instructionalOffering.courseOfferings co").where("ci.instructor.externalUniqueId = :externalId").set("externalId", request.getResourceExternalId()).where("o.ownerType = :type and o.ownerId = co.uniqueId").where("ci.instructor.department.session = s").set("type", 1).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                            }
                            if (instructor && (limit <= 0 || meetings.size() < limit)) {
                                meetings.addAll(query.select("distinct m").type("CourseEvent").from("inner join e.relatedCourses o, ClassInstructor ci inner join ci.classInstructing c inner join c.schedulingSubpart.instrOfferingConfig.instructionalOffering.courseOfferings co").where("ci.instructor.externalUniqueId = :externalId").set("externalId", request.getResourceExternalId()).where("o.ownerType = :type and o.ownerId = co.instructionalOffering.uniqueId").where("ci.instructor.department.session = s").set("type", 0).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                            }
                            if (instructor && (limit <= 0 || meetings.size() < limit)) {
                                meetings.addAll(query.select("distinct m").type("CourseEvent").from("inner join e.relatedCourses o, ClassInstructor ci inner join ci.classInstructing c inner join c.schedulingSubpart.instrOfferingConfig cfg").where("ci.instructor.externalUniqueId = :externalId").set("externalId", request.getResourceExternalId()).where("o.ownerType = :type and o.ownerId = cfg.uniqueId").where("ci.instructor.department.session = s").set("type", 2).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                            }
                            if (instructor && (limit <= 0 || meetings.size() < limit)) {
                                meetings.addAll(query.select("distinct m").type("CourseEvent").from("inner join e.relatedCourses o, ClassInstructor ci inner join ci.classInstructing c").where("ci.instructor.externalUniqueId = :externalId").set("externalId", request.getResourceExternalId()).where("o.ownerType = :type and o.ownerId = c.uniqueId").where("ci.instructor.department.session = s").set("type", 3).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                            }
                            if (coordinator && (limit <= 0 || meetings.size() < limit)) {
                                meetings.addAll(query.select("distinct m").type("CourseEvent").from("inner join e.relatedCourses o, CourseOffering co inner join co.instructionalOffering.coordinators cc").where("cc.externalUniqueId = :externalId").set("externalId", request.getResourceExternalId()).where("o.ownerType = :type and o.ownerId = co.uniqueId").where("cc.department.session = s").set("type", 1).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                            }
                            if (coordinator && (limit <= 0 || meetings.size() < limit)) {
                                meetings.addAll(query.select("distinct m").type("CourseEvent").from("inner join e.relatedCourses o, CourseOffering co inner join co.instructionalOffering.coordinators cc").where("cc.externalUniqueId = :externalId").set("externalId", request.getResourceExternalId()).where("o.ownerType = :type and o.ownerId = co.instructionalOffering.uniqueId").where("cc.department.session = s").set("type", 0).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                            }
                            if (coordinator && (limit <= 0 || meetings.size() < limit)) {
                                meetings.addAll(query.select("distinct m").type("CourseEvent").from("inner join e.relatedCourses o, Class_ c inner join c.schedulingSubpart.instrOfferingConfig.instructionalOffering.coordinators cc").where("cc.externalUniqueId = :externalId").set("externalId", request.getResourceExternalId()).where("o.ownerType = :type and o.ownerId = c.uniqueId").where("cc.department.session = s").set("type", 3).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                            }
                            if (coordinator && (limit <= 0 || meetings.size() < limit)) {
                                meetings.addAll(query.select("distinct m").type("CourseEvent").from("inner join e.relatedCourses o, InstrOfferingConfig cfg inner join cfg.instructionalOffering.coordinators cc").where("cc.externalUniqueId = :externalId").set("externalId", request.getResourceExternalId()).where("o.ownerType = :type and o.ownerId = cfg.uniqueId").where("cc.department.session = s").set("type", 2).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                            }
                        }
                        if (contact && (limit <= 0 || meetings.size() < limit)) {
                            meetings.addAll(query.select("distinct m").where("e.class in (CourseEvent, SpecialEvent, UnavailableEvent)").where("e.mainContact.externalUniqueId = :externalId").set("externalId", request.getResourceExternalId()).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                        }
                        if (contact && (limit <= 0 || meetings.size() < limit)) {
                            meetings.addAll(query.select("distinct m").from("inner join m.event.additionalContacts c").where("c.externalUniqueId = :externalId").set("externalId", request.getResourceExternalId()).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                        }
                        if (!contact || limit > 0 && meetings.size() >= limit) break;
                        meetings.addAll(query.select("distinct m").from("EventContact c").where("c.externalUniqueId = :externalId").where("c.emailAddress is not null").where("lower(m.event.email) like '%' || lower(c.emailAddress) || '%'").set("externalId", request.getResourceExternalId()).limit(limit <= 0 ? -1 : 1 + limit - meetings.size()).query(hibSession).list());
                        break;
                    }
                    default: {
                        throw new GwtRpcException("Resource type " + request.getResourceType().getLabel() + " not supported.");
                    }
                }
                GwtRpcResponseList<EventInterface> ret = new GwtRpcResponseList<EventInterface>();
                Hashtable<Long, EventInterface> events = new Hashtable<Long, EventInterface>();
                Hashtable<Long, HashSet<Location>> unavailableLocations = new Hashtable<Long, HashSet<Location>>();
                for (Meeting m : meetings) {
                    EventInterface event;
                    Location location;
                    if (locationMap != null && m.getLocationPermanentId() != null && (location = (Location)locationMap.get(m.getLocationPermanentId())) != null) {
                        m.setLocation(location);
                    }
                    if ((event = (EventInterface)events.get(m.getEvent().getUniqueId())) == null) {
                        Iterator<EventNote> ce;
                        event = new EventInterface();
                        event.setId(m.getEvent().getUniqueId());
                        event.setName(m.getEvent().getEventName());
                        event.setType(EventInterface.EventType.values()[m.getEvent().getEventType()]);
                        events.put(m.getEvent().getUniqueId(), event);
                        event.setCanView(context.hasPermission(m.getEvent(), Right.EventDetail));
                        event.setMaxCapacity(m.getEvent().getMaxCapacity());
                        if (m.getEvent().getMainContact() != null) {
                            EventInterface.ContactInterface contact = new EventInterface.ContactInterface();
                            contact.setFirstName(m.getEvent().getMainContact().getFirstName());
                            contact.setMiddleName(m.getEvent().getMainContact().getMiddleName());
                            contact.setLastName(m.getEvent().getMainContact().getLastName());
                            contact.setAcademicTitle(m.getEvent().getMainContact().getAcademicTitle());
                            contact.setEmail(m.getEvent().getMainContact().getEmailAddress());
                            contact.setFormattedName(m.getEvent().getMainContact().getName(nameFormat));
                            event.setContact(contact);
                        }
                        for (EventContact additional : m.getEvent().getAdditionalContacts()) {
                            EventInterface.ContactInterface contact = new EventInterface.ContactInterface();
                            contact.setFirstName(additional.getFirstName());
                            contact.setMiddleName(additional.getMiddleName());
                            contact.setLastName(additional.getLastName());
                            contact.setAcademicTitle(additional.getAcademicTitle());
                            contact.setEmail(additional.getEmailAddress());
                            contact.setFormattedName(additional.getName(nameFormat));
                            event.addAdditionalContact(contact);
                        }
                        event.setEmail(m.getEvent().getEmail());
                        if (m.getEvent().getSponsoringOrganization() != null) {
                            EventInterface.SponsoringOrganizationInterface sponsor = new EventInterface.SponsoringOrganizationInterface();
                            sponsor.setEmail(m.getEvent().getSponsoringOrganization().getEmail());
                            sponsor.setName(m.getEvent().getSponsoringOrganization().getName());
                            sponsor.setUniqueId(m.getEvent().getSponsoringOrganization().getUniqueId());
                            event.setSponsor(sponsor);
                        }
                        event.setExpirationDate(m.getEvent().getExpirationDate());
                        if (0 == m.getEvent().getEventType()) {
                            boolean bl;
                            Set[] r;
                            ce = (ClassEvent)ClassEventDAO.getInstance().get(m.getEvent().getUniqueId(), hibSession);
                            Class_ clazz = ((BaseClassEvent)((Object)ce)).getClazz();
                            Set[] setArray = r = restrictions == null ? null : (Set[])restrictions.get(clazz.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering().getUniqueId());
                            if (r != null && this.hide(r, clazz)) continue;
                            event.setEnrollment(clazz.getEnrollment());
                            event.setMaxCapacity(clazz.getClassLimit());
                            if (clazz.getDisplayInstructor().booleanValue()) {
                                for (ClassInstructor i : clazz.getClassInstructors()) {
                                    EventInterface.ContactInterface contactInterface = new EventInterface.ContactInterface();
                                    contactInterface.setFirstName(i.getInstructor().getFirstName());
                                    contactInterface.setMiddleName(i.getInstructor().getMiddleName());
                                    contactInterface.setLastName(i.getInstructor().getLastName());
                                    contactInterface.setAcademicTitle(i.getInstructor().getAcademicTitle());
                                    contactInterface.setEmail(i.getInstructor().getEmail());
                                    contactInterface.setFormattedName(i.getInstructor().getName(nameFormat));
                                    event.addInstructor(contactInterface);
                                }
                            }
                            CourseOffering correctedOffering = clazz.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering().getControllingCourseOffering();
                            ArrayList<CourseOffering> courses = new ArrayList<CourseOffering>(clazz.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering().getCourseOfferings());
                            boolean bl2 = false;
                            if (request.getResourceType() == EventInterface.ResourceType.PERSON && request.getResourceExternalId() != null) {
                                for (ClassInstructor i : clazz.getClassInstructors()) {
                                    if (!request.getResourceExternalId().equals(i.getInstructor().getExternalUniqueId())) continue;
                                    bl = true;
                                    break;
                                }
                            }
                            switch (request.getResourceType()) {
                                case CURRICULUM: 
                                case PERSON: {
                                    Iterator iterator = courses.iterator();
                                    while (iterator.hasNext()) {
                                        CourseOffering co = (CourseOffering)iterator.next();
                                        if (curriculumCourses.contains(co.getUniqueId())) {
                                            if (curriculumCourses.contains(correctedOffering.getUniqueId())) continue;
                                            correctedOffering = co;
                                            continue;
                                        }
                                        if (bl) continue;
                                        iterator.remove();
                                    }
                                    break;
                                }
                            }
                            courses.remove(correctedOffering);
                            event.addCourseName(correctedOffering.getCourseName());
                            event.addCourseTitle(correctedOffering.getTitle() == null ? "" : correctedOffering.getTitle());
                            event.setInstruction(clazz.getSchedulingSubpart().getItype().getDesc().length() <= 20 ? clazz.getSchedulingSubpart().getItype().getDesc() : clazz.getSchedulingSubpart().getItype().getAbbv());
                            event.setInstructionType(clazz.getSchedulingSubpart().getItype().getItype());
                            event.setSectionNumber(clazz.getSectionNumberString(hibSession));
                            if (clazz.getClassSuffix(correctedOffering) == null) {
                                event.setName(clazz.getClassLabel(correctedOffering));
                            } else {
                                event.addExternalId(clazz.getClassSuffix(correctedOffering));
                                event.setName(correctedOffering.getCourseName() + " " + clazz.getClassSuffix(correctedOffering));
                            }
                            for (CourseOffering co : courses) {
                                event.addCourseName(co.getCourseName());
                                event.addCourseTitle(co.getTitle() == null ? "" : co.getTitle());
                                if (clazz.getClassSuffix(co) == null) continue;
                                event.addExternalId(clazz.getClassSuffix(co));
                            }
                            if (correctedOffering.getScheduleBookNote() != null && !correctedOffering.getScheduleBookNote().isEmpty()) {
                                EventInterface.NoteInterface noteInterface = new EventInterface.NoteInterface();
                                noteInterface.setId(-2L);
                                noteInterface.setNote(correctedOffering.getScheduleBookNote());
                                event.addNote(noteInterface);
                            }
                            if (clazz.getSchedulePrintNote() != null && !clazz.getSchedulePrintNote().isEmpty()) {
                                EventInterface.NoteInterface noteInterface = new EventInterface.NoteInterface();
                                noteInterface.setId(-1L);
                                noteInterface.setNote(clazz.getSchedulePrintNote());
                                event.addNote(noteInterface);
                            }
                        } else if (1 == m.getEvent().getEventType() || 2 == m.getEvent().getEventType()) {
                            ExamEvent xe = (ExamEvent)ExamEventDAO.getInstance().get(m.getEvent().getUniqueId(), hibSession);
                            event.setEnrollment(xe.getExam().countStudents());
                            event.setMaxCapacity(xe.getExam().getSize());
                            for (DepartmentalInstructor i : xe.getExam().getInstructors()) {
                                EventInterface.ContactInterface instructor = new EventInterface.ContactInterface();
                                instructor.setFirstName(i.getFirstName());
                                instructor.setMiddleName(i.getMiddleName());
                                instructor.setLastName(i.getLastName());
                                instructor.setAcademicTitle(i.getAcademicTitle());
                                instructor.setEmail(i.getEmail());
                                instructor.setFormattedName(i.getName(nameFormat));
                                event.addInstructor(instructor);
                            }
                            String name = null;
                            for (ExamOwner owner : new TreeSet<ExamOwner>(xe.getExam().getOwners())) {
                                TreeSet<CourseOffering> courses = new TreeSet<CourseOffering>();
                                if (owner.getOwnerType() == 1 || request.getResourceType() == EventInterface.ResourceType.ROOM) {
                                    courses.add(owner.getCourse());
                                } else {
                                    courses.addAll(owner.getCourse().getInstructionalOffering().getCourseOfferings());
                                }
                                block58: for (CourseOffering courseOffering : courses) {
                                    switch (request.getResourceType()) {
                                        case CURRICULUM: 
                                        case PERSON: {
                                            if (curriculumCourses.contains(courseOffering.getUniqueId())) break;
                                            continue block58;
                                        }
                                    }
                                    event.addCourseName(courseOffering.getCourseName());
                                    event.addCourseTitle(courseOffering.getTitle() == null ? "" : courseOffering.getTitle());
                                    name = courseOffering.getCourseName();
                                    switch (owner.getOwnerType()) {
                                        case 3: {
                                            Class_ clazz = (Class_)owner.getOwnerObject();
                                            if (clazz.getClassSuffix(courseOffering) == null) {
                                                event.addExternalId(clazz.getItypeDesc().trim() + " " + clazz.getSectionNumberString(hibSession));
                                                name = courseOffering.getCourseName() + " " + clazz.getClassLabel(courseOffering);
                                                break;
                                            }
                                            event.addExternalId(clazz.getClassSuffix(courseOffering));
                                            name = courseOffering.getCourseName() + " " + clazz.getClassSuffix(courseOffering);
                                            break;
                                        }
                                        case 2: {
                                            InstrOfferingConfig config = (InstrOfferingConfig)owner.getOwnerObject();
                                            event.addExternalId("[" + config.getName() + "]");
                                            break;
                                        }
                                        case 1: {
                                            event.addExternalId(MESSAGES.colCourse());
                                            break;
                                        }
                                        case 0: {
                                            event.addExternalId(MESSAGES.colOffering());
                                        }
                                    }
                                }
                            }
                            if (event.hasCourseNames() && event.getCourseNames().size() == 1 && (request.getResourceType() == EventInterface.ResourceType.PERSON || request.getResourceType() == EventInterface.ResourceType.CURRICULUM)) {
                                event.setName(name);
                            }
                        } else if (3 == m.getEvent().getEventType()) {
                            ce = (CourseEvent)CourseEventDAO.getInstance().get(m.getEvent().getUniqueId(), hibSession);
                            event.setRequiredAttendance(((BaseCourseEvent)((Object)ce)).isReqAttendance());
                            int enrl = 0;
                            int cap = 0;
                            for (RelatedCourseInfo owner : ((BaseCourseEvent)((Object)ce)).getRelatedCourses()) {
                                enrl += owner.countStudents();
                                cap += owner.getLimit();
                                TreeSet<CourseOffering> treeSet = new TreeSet<CourseOffering>();
                                if (owner.getOwnerType() == 1 || request.getResourceType() == EventInterface.ResourceType.ROOM) {
                                    treeSet.add(owner.getCourse());
                                } else {
                                    treeSet.addAll(owner.getCourse().getInstructionalOffering().getCourseOfferings());
                                }
                                block60: for (CourseOffering course : treeSet) {
                                    switch (request.getResourceType()) {
                                        case CURRICULUM: 
                                        case PERSON: {
                                            if (curriculumCourses.contains(course.getUniqueId())) break;
                                            continue block60;
                                        }
                                    }
                                    event.addCourseName(course.getCourseName());
                                    event.addCourseTitle(course.getTitle() == null ? "" : course.getTitle());
                                    switch (owner.getOwnerType()) {
                                        case 3: {
                                            Class_ clazz = (Class_)owner.getOwnerObject();
                                            if (clazz.getClassSuffix(course) == null) {
                                                event.addExternalId(clazz.getClassLabel(course));
                                                break;
                                            }
                                            event.addExternalId(clazz.getClassSuffix(course));
                                            break;
                                        }
                                        case 2: {
                                            InstrOfferingConfig config = (InstrOfferingConfig)owner.getOwnerObject();
                                            event.addExternalId("[" + config.getName() + "]");
                                            break;
                                        }
                                        case 1: {
                                            event.addExternalId(MESSAGES.colCourse());
                                            break;
                                        }
                                        case 0: {
                                            event.addExternalId(MESSAGES.colOffering());
                                        }
                                    }
                                }
                            }
                            event.setEnrollment(enrl);
                            event.setMaxCapacity(cap);
                        }
                        if (event.isCanView()) {
                            for (EventNote n : m.getEvent().getNotes()) {
                                EventInterface.NoteInterface note = new EventInterface.NoteInterface();
                                note.setId(n.getUniqueId());
                                note.setDate(n.getTimeStamp());
                                note.setType(EventInterface.NoteInterface.NoteType.values()[n.getNoteType()]);
                                note.setMeetings(n.getMeetingsHtml());
                                note.setNote(n.getTextNote());
                                note.setUser(n.getUser());
                                note.setAttachment(n.getAttachedName());
                                note.setLink(n.getAttachedName() == null ? null : QueryEncoderBackend.encode("event=" + m.getEvent().getUniqueId() + "&note=" + n.getUniqueId()));
                                event.addNote(note);
                            }
                        }
                        event.setSequence(m.getEvent().getNotes().size());
                        for (EventNote n : m.getEvent().getNotes()) {
                            if (n.getTimeStamp() == null || event.hasTimeStamp() && event.getTimeStamp().compareTo(n.getTimeStamp()) >= 0) continue;
                            event.setTimeStamp(n.getTimeStamp());
                        }
                        ret.add(event);
                    }
                    EventInterface.MeetingInterface meeting = new EventInterface.MeetingInterface();
                    meeting.setId(m.getUniqueId());
                    meeting.setMeetingDate(m.getMeetingDate());
                    meeting.setDayOfWeek(Constants.getDayOfWeek(m.getMeetingDate()));
                    meeting.setStartTime(m.getStartTime().getTime());
                    meeting.setStopTime(m.getStopTime().getTime());
                    meeting.setDayOfYear(CalendarUtils.date2dayOfYear(session.getSessionStartYear(), m.getMeetingDate()));
                    meeting.setStartSlot(m.getStartPeriod());
                    meeting.setEndSlot(m.getStopPeriod());
                    meeting.setStartOffset(m.getStartOffset() == null ? 0 : m.getStartOffset());
                    meeting.setEndOffset(m.getStopOffset() == null ? 0 : m.getStopOffset());
                    meeting.setPast(context.isPastOrOutside(m.getStartTime()));
                    meeting.setCanEdit(context.hasPermission(m, Right.EventMeetingEdit));
                    meeting.setCanInquire(context.hasPermission(m, Right.EventMeetingInquire) || m.getEvent().getEventType() == 0 && context.hasPermission(m, Right.EventMeetingInquireClass) || m.getEvent().getEventType() == 1 && context.hasPermission(m, Right.EventMeetingInquireExam) || m.getEvent().getEventType() == 2 && context.hasPermission(m, Right.EventMeetingInquireExam));
                    meeting.setCanApprove(context.hasPermission(m, Right.EventMeetingApprove));
                    meeting.setCanDelete(context.hasPermission(m, Right.EventMeetingDelete));
                    meeting.setCanCancel(context.hasPermission(m, Right.EventMeetingCancel) || m.getEvent().getEventType() == 0 && context.hasPermission(m, Right.EventMeetingCancelClass) || m.getEvent().getEventType() == 1 && context.hasPermission(m, Right.EventMeetingCancelExam) || m.getEvent().getEventType() == 2 && context.hasPermission(m, Right.EventMeetingCancelExam));
                    meeting.setApprovalDate(m.getApprovalDate());
                    meeting.setApprovalStatus(m.getApprovalStatus());
                    if (m.getLocation() != null) {
                        EventInterface.ResourceInterface location2 = new EventInterface.ResourceInterface();
                        location2.setType(EventInterface.ResourceType.ROOM);
                        location2.setId(m.getLocation().getUniqueId());
                        location2.setName(m.getLocation().getLabel());
                        location2.setSize(m.getLocation().getCapacity());
                        location2.setDistance((Double)distances.get(m.getLocation().getUniqueId()));
                        location2.setRoomType(m.getLocation().getRoomTypeLabel());
                        location2.setBreakTime(m.getLocation().getEffectiveBreakTime());
                        location2.setMessage(m.getLocation().getEventMessage());
                        location2.setIgnoreRoomCheck(m.getLocation().isIgnoreRoomCheck());
                        meeting.setLocation(location2);
                    }
                    if (request.getEventFilter().hasOptions("flag") && request.getEventFilter().getOptions("flag").contains("Conflicts") && m.getLocation() != null && m.getLocation().getEventAvailability() != null && m.getLocation().getEventAvailability().length() == 288 * Constants.DAY_CODES.length) {
                        for (int slot = meeting.getStartSlot(); slot < meeting.getEndSlot(); ++slot) {
                            if (m.getLocation().getEventAvailability().charAt(meeting.getDayOfWeek() * 288 + slot) != '1') continue;
                            HashSet<Location> locations = (HashSet<Location>)unavailableLocations.get(event.getId());
                            if (locations == null) {
                                locations = new HashSet<Location>();
                                unavailableLocations.put(event.getId(), locations);
                            }
                            locations.add(m.getLocation());
                            break;
                        }
                    }
                    event.addMeeting(meeting);
                }
                if (request.getEventFilter().hasOptions("flag") && request.getEventFilter().getOptions("flag").contains("Conflicts")) {
                    request.getEventFilter().setOption("mode", "Conflicting Events");
                    query = EventFilterBackend.getQuery(request.getEventFilter(), context);
                    List conflicts = null;
                    switch (request.getResourceType()) {
                        case ROOM: {
                            if (request.getResourceId() == null) {
                                conflicts = query.select("distinct m.event.uniqueId, Xm").query(hibSession).list();
                                break;
                            }
                            conflicts = query.select("distinct m.event.uniqueId, Xm").joinWithLocation().where("l.uniqueId = :resourceId").set("resourceId", request.getResourceId()).query(hibSession).list();
                            break;
                        }
                        case SUBJECT: 
                        case COURSE: {
                            String resourceCheck = request.getResourceType() == EventInterface.ResourceType.SUBJECT ? "co.subjectArea.uniqueId = :resourceId" : "co.uniqueId = :resourceId";
                            conflicts = new ArrayList();
                            conflicts.addAll(query.select("distinct m.event.uniqueId, Xm").type("ClassEvent").from("inner join e.clazz.schedulingSubpart.instrOfferingConfig.instructionalOffering.courseOfferings co").where(resourceCheck).set("resourceId", request.getResourceId()).query(hibSession).list());
                            conflicts.addAll(query.select("distinct m.event.uniqueId, Xm").type("CourseEvent").from("inner join e.relatedCourses o, CourseOffering co").where("o.ownerType = :type and o.ownerId = co.uniqueId").set("type", 1).where(resourceCheck).set("resourceId", request.getResourceId()).query(hibSession).list());
                            conflicts.addAll(query.select("distinct m.event.uniqueId, Xm").type("CourseEvent").from("inner join e.relatedCourses o, CourseOffering co").where("o.ownerType = :type and o.ownerId = co.instructionalOffering.uniqueId").set("type", 0).where(resourceCheck).set("resourceId", request.getResourceId()).query(hibSession).list());
                            conflicts.addAll(query.select("distinct m.event.uniqueId, Xm").type("CourseEvent").from("inner join e.relatedCourses o, Class_ c inner join c.schedulingSubpart.instrOfferingConfig.instructionalOffering.courseOfferings co").where("o.ownerType = :type and o.ownerId = c.uniqueId").set("type", 3).where(resourceCheck).set("resourceId", request.getResourceId()).query(hibSession).list());
                            conflicts.addAll(query.select("distinct m.event.uniqueId, Xm").type("CourseEvent").from("inner join e.relatedCourses o, CourseOffering co inner join co.instructionalOffering.instrOfferingConfigs cfg").where("o.ownerType = :type and o.ownerId = cfg.uniqueId").set("type", 2).where(resourceCheck).set("resourceId", request.getResourceId()).query(hibSession).list());
                            conflicts.addAll(query.select("distinct m.event.uniqueId, Xm").type("ExamEvent").from("inner join e.exam.owners o, CourseOffering co").where("o.ownerType = :type and o.ownerId = co.uniqueId").set("type", 1).where(resourceCheck).set("resourceId", request.getResourceId()).query(hibSession).list());
                            conflicts.addAll(query.select("distinct m.event.uniqueId, Xm").type("ExamEvent").from("inner join e.exam.owners o, CourseOffering co").where("o.ownerType = :type and o.ownerId = co.instructionalOffering.uniqueId").set("type", 0).where(resourceCheck).set("resourceId", request.getResourceId()).query(hibSession).list());
                            conflicts.addAll(query.select("distinct m.event.uniqueId, Xm").type("ExamEvent").from("inner join e.exam.owners o, Class_ c inner join c.schedulingSubpart.instrOfferingConfig.instructionalOffering.courseOfferings co").where("o.ownerType = :type and o.ownerId = c.uniqueId").set("type", 3).where(resourceCheck).set("resourceId", request.getResourceId()).query(hibSession).list());
                            conflicts.addAll(query.select("distinct m.event.uniqueId, Xm").type("ExamEvent").from("inner join e.exam.owners o, CourseOffering co inner join co.instructionalOffering.instrOfferingConfigs cfg").where("o.ownerType = :type and o.ownerId = cfg.uniqueId").set("type", 2).where(resourceCheck).set("resourceId", request.getResourceId()).query(hibSession).list());
                            break;
                        }
                        case CURRICULUM: {
                            conflicts = new ArrayList();
                            conflicts.addAll(query.select("distinct m.event.uniqueId, Xm").type("ClassEvent").from("inner join e.clazz.schedulingSubpart.instrOfferingConfig.instructionalOffering.courseOfferings co, CurriculumCourse cc").where("co = cc.course").where("cc.classification.curriculum.uniqueId = :resourceId or cc.classification.uniqueId = :resourceId").set("resourceId", request.getResourceId()).query(hibSession).list());
                            conflicts.addAll(query.select("distinct m.event.uniqueId, Xm").type("ExamEvent").from("inner join e.exam.owners o, CourseOffering co, CurriculumCourse cc").where("co = cc.course").where("cc.classification.curriculum.uniqueId = :resourceId or cc.classification.uniqueId = :resourceId").set("resourceId", request.getResourceId()).where("o.ownerType = :type and o.ownerId = co.uniqueId").set("type", 1).query(hibSession).list());
                            conflicts.addAll(query.select("distinct m.event.uniqueId, Xm").type("ExamEvent").from("inner join e.exam.owners o, CourseOffering co, CurriculumCourse cc").where("co = cc.course").where("cc.classification.curriculum.uniqueId = :resourceId or cc.classification.uniqueId = :resourceId").set("resourceId", request.getResourceId()).where("o.ownerType = :type and o.ownerId = co.instructionalOffering.uniqueId").set("type", 0).query(hibSession).list());
                            conflicts.addAll(query.select("distinct m.event.uniqueId, Xm").type("ExamEvent").from("inner join e.exam.owners o, Class_ c inner join c.schedulingSubpart.instrOfferingConfig.instructionalOffering.courseOfferings co, CurriculumCourse cc").where("co = cc.course").where("cc.classification.curriculum.uniqueId = :resourceId or cc.classification.uniqueId = :resourceId").set("resourceId", request.getResourceId()).where("o.ownerType = :type and o.ownerId = c.uniqueId").set("type", 3).query(hibSession).list());
                            conflicts.addAll(query.select("distinct m.event.uniqueId, Xm").type("ExamEvent").from("inner join e.exam.owners o, CourseOffering co inner join co.instructionalOffering.instrOfferingConfigs cfg, CurriculumCourse cc").where("co = cc.course").where("cc.classification.curriculum.uniqueId = :resourceId or cc.classification.uniqueId = :resourceId").set("resourceId", request.getResourceId()).where("o.ownerType = :type and o.ownerId = cfg.uniqueId").set("type", 2).query(hibSession).list());
                            conflicts.addAll(query.select("distinct m.event.uniqueId, Xm").type("CourseEvent").from("inner join e.relatedCourses o, CourseOffering co, CurriculumCourse cc").where("co = cc.course").where("cc.classification.curriculum.uniqueId = :resourceId or cc.classification.uniqueId = :resourceId").set("resourceId", request.getResourceId()).where("o.ownerType = :type and o.ownerId = co.uniqueId").set("type", 1).query(hibSession).list());
                            conflicts.addAll(query.select("distinct m.event.uniqueId, Xm").type("CourseEvent").from("inner join e.relatedCourses o, CourseOffering co, CurriculumCourse cc").where("co = cc.course").where("cc.classification.curriculum.uniqueId = :resourceId or cc.classification.uniqueId = :resourceId").set("resourceId", request.getResourceId()).where("o.ownerType = :type and o.ownerId = co.instructionalOffering.uniqueId").set("type", 0).query(hibSession).list());
                            conflicts.addAll(query.select("distinct m.event.uniqueId, Xm").type("CourseEvent").from("inner join e.relatedCourses o, Class_ c inner join c.schedulingSubpart.instrOfferingConfig.instructionalOffering.courseOfferings co, CurriculumCourse cc").where("co = cc.course").where("cc.classification.curriculum.uniqueId = :resourceId or cc.classification.uniqueId = :resourceId").set("resourceId", request.getResourceId()).where("o.ownerType = :type and o.ownerId = c.uniqueId").set("type", 3).query(hibSession).list());
                            conflicts.addAll(query.select("distinct m.event.uniqueId, Xm").type("CourseEvent").from("inner join e.relatedCourses o, CourseOffering co inner join co.instructionalOffering.instrOfferingConfigs cfg, CurriculumCourse cc").where("co = cc.course").where("cc.classification.curriculum.uniqueId = :resourceId or cc.classification.uniqueId = :resourceId").set("resourceId", request.getResourceId()).where("o.ownerType = :type and o.ownerId = cfg.uniqueId").set("type", 2).query(hibSession).list());
                            break;
                        }
                        case DEPARTMENT: {
                            if (department.isExternalManager().booleanValue()) {
                                conflicts = query.select("distinct m.event.uniqueId, Xm").type("ClassEvent").from("inner join e.clazz.managingDept d").where("d.uniqueId = :resourceId").set("resourceId", request.getResourceId()).query(hibSession).list();
                                break;
                            }
                            conflicts = query.select("distinct m.event.uniqueId, Xm").type("ClassEvent").from("inner join e.clazz.schedulingSubpart.instrOfferingConfig.instructionalOffering.courseOfferings co inner join co.subjectArea.department d").where("d.uniqueId = :resourceId").set("resourceId", request.getResourceId()).query(hibSession).list();
                            conflicts.addAll(query.select("distinct m.event.uniqueId, Xm").type("ExamEvent").from("inner join e.exam.owners o, CourseOffering co inner join co.subjectArea.department d").where("d.uniqueId = :resourceId").set("resourceId", request.getResourceId()).where("o.ownerType = :type and o.ownerId = co.uniqueId").set("type", 1).query(hibSession).list());
                            conflicts.addAll(query.select("distinct m.event.uniqueId, Xm").type("ExamEvent").from("inner join e.exam.owners o, CourseOffering co inner join co.subjectArea.department d").where("d.uniqueId = :resourceId").set("resourceId", request.getResourceId()).where("o.ownerType = :type and o.ownerId = co.instructionalOffering.uniqueId").set("type", 0).query(hibSession).list());
                            conflicts.addAll(query.select("distinct m.event.uniqueId, Xm").type("ExamEvent").from("inner join e.exam.owners o, Class_ c inner join c.schedulingSubpart.instrOfferingConfig.instructionalOffering.courseOfferings co inner join co.subjectArea.department d").where("d.uniqueId = :resourceId").set("resourceId", request.getResourceId()).where("o.ownerType = :type and o.ownerId = c.uniqueId").set("type", 3).query(hibSession).list());
                            conflicts.addAll(query.select("distinct m.event.uniqueId, Xm").type("ExamEvent").from("inner join e.exam.owners o, CourseOffering co inner join co.instructionalOffering.instrOfferingConfigs cfg inner join co.subjectArea.department d").where("d.uniqueId = :resourceId").set("resourceId", request.getResourceId()).where("o.ownerType = :type and o.ownerId = cfg.uniqueId").set("type", 2).query(hibSession).list());
                            conflicts.addAll(query.select("distinct m.event.uniqueId, Xm").type("CourseEvent").from("inner join e.relatedCourses o, CourseOffering co inner join co.subjectArea.department d").where("d.uniqueId = :resourceId").set("resourceId", request.getResourceId()).where("o.ownerType = :type and o.ownerId = co.uniqueId").set("type", 1).query(hibSession).list());
                            conflicts.addAll(query.select("distinct m.event.uniqueId, Xm").type("CourseEvent").from("inner join e.relatedCourses o, CourseOffering co inner join co.subjectArea.department d").where("d.uniqueId = :resourceId").set("resourceId", request.getResourceId()).where("o.ownerType = :type and o.ownerId = co.instructionalOffering.uniqueId").set("type", 0).query(hibSession).list());
                            conflicts.addAll(query.select("distinct m.event.uniqueId, Xm").type("CourseEvent").from("inner join e.relatedCourses o, Class_ c inner join c.schedulingSubpart.instrOfferingConfig.instructionalOffering.courseOfferings co inner join co.subjectArea.department d").where("d.uniqueId = :resourceId").set("resourceId", request.getResourceId()).where("o.ownerType = :type and o.ownerId = c.uniqueId").set("type", 3).query(hibSession).list());
                            conflicts.addAll(query.select("distinct m.event.uniqueId, Xm").type("CourseEvent").from("inner join e.relatedCourses o, CourseOffering co inner join co.instructionalOffering.instrOfferingConfigs cfg inner join co.subjectArea.department d").where("d.uniqueId = :resourceId").set("resourceId", request.getResourceId()).where("o.ownerType = :type and o.ownerId = cfg.uniqueId").set("type", 2).query(hibSession).list());
                        }
                    }
                    if (conflicts != null) {
                        Hashtable<Long, EventInterface> conflictingEvents = new Hashtable<Long, EventInterface>();
                        for (Object[] o : conflicts) {
                            EventInterface event;
                            Location location;
                            EventInterface parent = (EventInterface)events.get((Long)o[0]);
                            if (parent == null) continue;
                            Meeting m = (Meeting)o[1];
                            if (locationMap != null && m.getLocationPermanentId() != null && (location = (Location)locationMap.get(m.getLocationPermanentId())) != null) {
                                m.setLocation(location);
                            }
                            if ((event = (EventInterface)conflictingEvents.get(m.getEvent().getUniqueId())) == null) {
                                event = new EventInterface();
                                event.setId(m.getEvent().getUniqueId());
                                event.setName(m.getEvent().getEventName());
                                event.setType(EventInterface.EventType.values()[m.getEvent().getEventType()]);
                                conflictingEvents.put(m.getEvent().getUniqueId(), event);
                                event.setCanView(context.hasPermission(m.getEvent(), Right.EventDetail));
                                event.setMaxCapacity(m.getEvent().getMaxCapacity());
                                if (m.getEvent().getMainContact() != null) {
                                    EventInterface.ContactInterface contact = new EventInterface.ContactInterface();
                                    contact.setFirstName(m.getEvent().getMainContact().getFirstName());
                                    contact.setMiddleName(m.getEvent().getMainContact().getMiddleName());
                                    contact.setLastName(m.getEvent().getMainContact().getLastName());
                                    contact.setAcademicTitle(m.getEvent().getMainContact().getAcademicTitle());
                                    contact.setEmail(m.getEvent().getMainContact().getEmailAddress());
                                    contact.setFormattedName(m.getEvent().getMainContact().getName(nameFormat));
                                    event.setContact(contact);
                                }
                                for (EventContact eventContact : m.getEvent().getAdditionalContacts()) {
                                    EventInterface.ContactInterface contactInterface = new EventInterface.ContactInterface();
                                    contactInterface.setFirstName(eventContact.getFirstName());
                                    contactInterface.setMiddleName(eventContact.getMiddleName());
                                    contactInterface.setLastName(eventContact.getLastName());
                                    contactInterface.setAcademicTitle(eventContact.getAcademicTitle());
                                    contactInterface.setEmail(eventContact.getEmailAddress());
                                    contactInterface.setFormattedName(eventContact.getName(nameFormat));
                                    event.addAdditionalContact(contactInterface);
                                }
                                event.setEmail(m.getEvent().getEmail());
                                if (m.getEvent().getSponsoringOrganization() != null) {
                                    EventInterface.SponsoringOrganizationInterface sponsor = new EventInterface.SponsoringOrganizationInterface();
                                    sponsor.setEmail(m.getEvent().getSponsoringOrganization().getEmail());
                                    sponsor.setName(m.getEvent().getSponsoringOrganization().getName());
                                    sponsor.setUniqueId(m.getEvent().getSponsoringOrganization().getUniqueId());
                                    event.setSponsor(sponsor);
                                }
                                String note = null;
                                for (EventNote eventNote : m.getEvent().getNotes()) {
                                    if (eventNote.getTextNote() == null || eventNote.getTextNote().isEmpty()) continue;
                                    note = (note == null ? "" : note + "n") + eventNote.getTextNote();
                                }
                                if (0 == m.getEvent().getEventType()) {
                                    ClassEvent classEvent = (ClassEvent)ClassEventDAO.getInstance().get(m.getEvent().getUniqueId(), hibSession);
                                    Class_ class_ = classEvent.getClazz();
                                    event.setEnrollment(class_.getEnrollment());
                                    event.setMaxCapacity(class_.getClassLimit());
                                    if (class_.getDisplayInstructor().booleanValue()) {
                                        for (ClassInstructor i : class_.getClassInstructors()) {
                                            EventInterface.ContactInterface instructor = new EventInterface.ContactInterface();
                                            instructor.setFirstName(i.getInstructor().getFirstName());
                                            instructor.setMiddleName(i.getInstructor().getMiddleName());
                                            instructor.setLastName(i.getInstructor().getLastName());
                                            instructor.setAcademicTitle(i.getInstructor().getAcademicTitle());
                                            instructor.setEmail(i.getInstructor().getEmail());
                                            instructor.setFormattedName(i.getInstructor().getName(nameFormat));
                                            event.addInstructor(instructor);
                                        }
                                    }
                                    CourseOffering correctedOffering = class_.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering().getControllingCourseOffering();
                                    ArrayList<CourseOffering> courses = new ArrayList<CourseOffering>(class_.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering().getCourseOfferings());
                                    courses.remove(correctedOffering);
                                    event.addCourseName(correctedOffering.getCourseName());
                                    event.addCourseTitle(correctedOffering.getTitle() == null ? "" : correctedOffering.getTitle());
                                    event.setInstruction(class_.getSchedulingSubpart().getItype().getDesc().length() <= 20 ? class_.getSchedulingSubpart().getItype().getDesc() : class_.getSchedulingSubpart().getItype().getAbbv());
                                    event.setInstructionType(class_.getSchedulingSubpart().getItype().getItype());
                                    event.setSectionNumber(class_.getSectionNumberString(hibSession));
                                    if (class_.getClassSuffix(correctedOffering) == null) {
                                        event.setName(class_.getClassLabel(correctedOffering));
                                    } else {
                                        event.addExternalId(class_.getClassSuffix(correctedOffering));
                                        event.setName(correctedOffering.getCourseName() + " " + class_.getClassSuffix(correctedOffering));
                                    }
                                    for (CourseOffering co : courses) {
                                        event.addCourseName(co.getCourseName());
                                        event.addCourseTitle(co.getTitle() == null ? "" : co.getTitle());
                                        if (class_.getClassSuffix(co) == null) continue;
                                        event.addExternalId(class_.getClassSuffix(co));
                                    }
                                    note = correctedOffering.getScheduleBookNote();
                                    if (class_.getSchedulePrintNote() != null && !class_.getSchedulePrintNote().isEmpty()) {
                                        note = (note == null || note.isEmpty() ? "" : note + "\n") + class_.getSchedulePrintNote();
                                    }
                                } else if (1 == m.getEvent().getEventType() || 2 == m.getEvent().getEventType()) {
                                    ExamEvent examEvent = (ExamEvent)ExamEventDAO.getInstance().get(m.getEvent().getUniqueId(), hibSession);
                                    event.setEnrollment(examEvent.getExam().countStudents());
                                    event.setMaxCapacity(examEvent.getExam().getSize());
                                    for (DepartmentalInstructor i : examEvent.getExam().getInstructors()) {
                                        EventInterface.ContactInterface instructor = new EventInterface.ContactInterface();
                                        instructor.setFirstName(i.getFirstName());
                                        instructor.setMiddleName(i.getMiddleName());
                                        instructor.setLastName(i.getLastName());
                                        instructor.setAcademicTitle(i.getAcademicTitle());
                                        instructor.setEmail(i.getEmail());
                                        instructor.setFormattedName(i.getName(nameFormat));
                                        event.addInstructor(instructor);
                                    }
                                    for (ExamOwner owner : new TreeSet<ExamOwner>(examEvent.getExam().getOwners())) {
                                        for (CourseOffering course : owner.getCourse().getInstructionalOffering().getCourseOfferings()) {
                                            String courseName = owner.getCourse().getCourseName();
                                            String label = owner.getLabel();
                                            if (label.startsWith(courseName)) {
                                                label = label.substring(courseName.length());
                                            }
                                            event.addCourseName(course.getCourseName());
                                            event.addCourseTitle(course.getTitle() == null ? "" : course.getTitle());
                                            event.addExternalId(label.trim());
                                        }
                                    }
                                    if (event.hasCourseNames() && event.getCourseNames().size() == 1 && (request.getResourceType() == EventInterface.ResourceType.PERSON || request.getResourceType() == EventInterface.ResourceType.CURRICULUM)) {
                                        event.setName((event.getCourseNames().get(0) + " " + event.getExternalIds().get(0)).trim());
                                    }
                                } else if (3 == m.getEvent().getEventType()) {
                                    void var26_132;
                                    CourseEvent courseEvent = (CourseEvent)CourseEventDAO.getInstance().get(m.getEvent().getUniqueId(), hibSession);
                                    event.setRequiredAttendance(courseEvent.isReqAttendance());
                                    boolean bl = false;
                                    int cap = 0;
                                    for (RelatedCourseInfo owner : courseEvent.getRelatedCourses()) {
                                        var26_132 += owner.countStudents();
                                        cap += owner.getLimit();
                                        for (CourseOffering course : owner.getCourse().getInstructionalOffering().getCourseOfferings()) {
                                            String courseName = owner.getCourse().getCourseName();
                                            String label = owner.getLabel();
                                            if (label.startsWith(courseName)) {
                                                label = label.substring(courseName.length());
                                            }
                                            event.addCourseName(course.getCourseName());
                                            event.addCourseTitle(course.getTitle() == null ? "" : course.getTitle());
                                            event.addExternalId(label.trim());
                                        }
                                    }
                                    event.setEnrollment((int)var26_132);
                                    event.setMaxCapacity(cap);
                                }
                                if (note != null && !note.isEmpty()) {
                                    EventInterface.NoteInterface noteInterface = new EventInterface.NoteInterface();
                                    noteInterface.setNote(note);
                                    event.addNote(noteInterface);
                                }
                            }
                            EventInterface.MeetingInterface meeting = new EventInterface.MeetingInterface();
                            meeting.setId(m.getUniqueId());
                            meeting.setMeetingDate(m.getMeetingDate());
                            meeting.setDayOfWeek(Constants.getDayOfWeek(m.getMeetingDate()));
                            meeting.setStartTime(m.getStartTime().getTime());
                            meeting.setStopTime(m.getStopTime().getTime());
                            meeting.setDayOfYear(CalendarUtils.date2dayOfYear(session.getSessionStartYear(), m.getMeetingDate()));
                            meeting.setStartSlot(m.getStartPeriod());
                            meeting.setEndSlot(m.getStopPeriod());
                            meeting.setStartOffset(m.getStartOffset() == null ? 0 : m.getStartOffset());
                            meeting.setEndOffset(m.getStopOffset() == null ? 0 : m.getStopOffset());
                            meeting.setPast(context.isPastOrOutside(m.getStartTime()));
                            meeting.setApprovalDate(m.getApprovalDate());
                            meeting.setApprovalStatus(m.getApprovalStatus());
                            if (m.getLocation() != null) {
                                EventInterface.ResourceInterface resourceInterface = new EventInterface.ResourceInterface();
                                resourceInterface.setType(EventInterface.ResourceType.ROOM);
                                resourceInterface.setId(m.getLocation().getUniqueId());
                                resourceInterface.setName(m.getLocation().getLabel());
                                resourceInterface.setSize(m.getLocation().getCapacity());
                                resourceInterface.setRoomType(m.getLocation().getRoomTypeLabel());
                                resourceInterface.setBreakTime(m.getLocation().getEffectiveBreakTime());
                                resourceInterface.setMessage(m.getLocation().getEventMessage());
                                resourceInterface.setIgnoreRoomCheck(m.getLocation().isIgnoreRoomCheck());
                                meeting.setLocation(resourceInterface);
                            }
                            event.addMeeting(meeting);
                            parent.addConflict(event);
                        }
                    }
                    for (Map.Entry entry : unavailableLocations.entrySet()) {
                        EventInterface parent = (EventInterface)events.get(entry.getKey());
                        if (parent == null) continue;
                        for (Location location : (Set)entry.getValue()) {
                            EventInterface unavailability = EventLookupBackend.generateUnavailabilityEvent(location, parent);
                            if (unavailability == null) continue;
                            parent.addConflict(unavailability);
                        }
                    }
                }
                if (!(request.getEventFilter().hasOptions("type") && !request.getEventFilter().getOptions("type").contains("Class") || request.getEventFilter().hasOptions("from") || request.getEventFilter().hasOptions("to") || request.getEventFilter().hasOptions("requested") || request.getEventFilter().hasOptions("day") || request.getEventFilter().hasOptions("after") || request.getEventFilter().hasOptions("before") || !context.hasPermission(Right.HasRole) && !session.getStatusType().canNoRoleReportClass() || !Solution.hasTimetable(session.getUniqueId()))) {
                    ArrayList arrageHourClasses = null;
                    switch (request.getResourceType()) {
                        case SUBJECT: 
                        case COURSE: {
                            arrageHourClasses = hibSession.createQuery("select c from Class_ c inner join c.schedulingSubpart.instrOfferingConfig.instructionalOffering.courseOfferings co where c.committedAssignment is null and " + (request.getResourceType() == EventInterface.ResourceType.SUBJECT ? "co.subjectArea.uniqueId = :resourceId" : "co.uniqueId = :resourceId")).setLong("resourceId", request.getResourceId().longValue()).setCacheable(true).list();
                            break;
                        }
                        case DEPARTMENT: {
                            arrageHourClasses = hibSession.createQuery("select c from Class_ c inner join c.managingDept d where c.committedAssignment is null and d.uniqueId = :resourceId").setLong("resourceId", request.getResourceId().longValue()).setCacheable(true).list();
                            break;
                        }
                        case CURRICULUM: {
                            arrageHourClasses = hibSession.createQuery("select c from Class_ c inner join c.schedulingSubpart.instrOfferingConfig.instructionalOffering.courseOfferings co, CurriculumCourse cc where c.committedAssignment is null and co = cc.course and (cc.classification.curriculum.uniqueId = :resourceId or cc.classification.uniqueId = :resourceId)").setLong("resourceId", request.getResourceId().longValue()).setCacheable(true).list();
                            break;
                        }
                        case PERSON: {
                            Set<String> roles = request.getEventFilter().getOptions("role");
                            boolean student = roles == null || roles.contains("student") || roles.contains("Student");
                            boolean instructor = roles == null || roles.contains("instructor") || roles.contains("Instructor");
                            boolean coordinator = roles != null && (roles.contains("coordinator") || roles.contains("Coordinator"));
                            arrageHourClasses = new ArrayList();
                            if (student) {
                                arrageHourClasses.addAll(hibSession.createQuery("select c from StudentClassEnrollment e inner join e.clazz c where c.committedAssignment is null and e.student.session.uniqueId = :sessionId and e.student.externalUniqueId = :externalId").setString("externalId", request.getResourceExternalId()).setLong("sessionId", request.getSessionId().longValue()).setCacheable(true).list());
                            }
                            if (instructor) {
                                arrageHourClasses.addAll(hibSession.createQuery("select c from ClassInstructor ci inner join ci.classInstructing c where c.committedAssignment is null and ci.instructor.department.session.uniqueId = :sessionId and  ci.instructor.externalUniqueId = :externalId").setString("externalId", request.getResourceExternalId()).setLong("sessionId", request.getSessionId().longValue()).setCacheable(true).list());
                            }
                            if (!coordinator) break;
                            arrageHourClasses.addAll(hibSession.createQuery("select c from Class_ c inner join c.schedulingSubpart.instrOfferingConfig.instructionalOffering.coordinators cc where c.committedAssignment is null and cc.department.session.uniqueId = :sessionId and  cc.externalUniqueId = :externalId").setString("externalId", request.getResourceExternalId()).setLong("sessionId", request.getSessionId().longValue()).setCacheable(true).list());
                        }
                    }
                    if (arrageHourClasses != null) {
                        for (Class_ clazz : arrageHourClasses) {
                            EventInterface.NoteInterface note;
                            EventInterface event = new EventInterface();
                            event.setId(-clazz.getUniqueId().longValue());
                            event.setName(clazz.getClassLabel(hibSession));
                            event.setType(EventInterface.EventType.Class);
                            event.setCanView(false);
                            event.setMaxCapacity(clazz.getClassLimit());
                            event.setEnrollment(clazz.getEnrollment());
                            if (clazz.getDisplayInstructor().booleanValue()) {
                                for (ClassInstructor i : clazz.getClassInstructors()) {
                                    EventInterface.ContactInterface instructor = new EventInterface.ContactInterface();
                                    instructor.setFirstName(i.getInstructor().getFirstName());
                                    instructor.setMiddleName(i.getInstructor().getMiddleName());
                                    instructor.setLastName(i.getInstructor().getLastName());
                                    instructor.setAcademicTitle(i.getInstructor().getAcademicTitle());
                                    instructor.setEmail(i.getInstructor().getEmail());
                                    instructor.setFormattedName(i.getInstructor().getName(nameFormat));
                                    event.addInstructor(instructor);
                                }
                            }
                            CourseOffering correctedOffering = clazz.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering().getControllingCourseOffering();
                            ArrayList<CourseOffering> courses = new ArrayList<CourseOffering>(clazz.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering().getCourseOfferings());
                            switch (request.getResourceType()) {
                                case CURRICULUM: 
                                case PERSON: {
                                    Iterator i = courses.iterator();
                                    while (i.hasNext()) {
                                        CourseOffering co = (CourseOffering)i.next();
                                        if (curriculumCourses.contains(co.getUniqueId())) {
                                            if (curriculumCourses.contains(correctedOffering.getUniqueId())) continue;
                                            correctedOffering = co;
                                            continue;
                                        }
                                        i.remove();
                                    }
                                    break;
                                }
                            }
                            courses.remove(correctedOffering);
                            event.addCourseName(correctedOffering.getCourseName());
                            event.addCourseTitle(correctedOffering.getTitle() == null ? "" : correctedOffering.getTitle());
                            event.setInstruction(clazz.getSchedulingSubpart().getItype().getDesc().length() <= 20 ? clazz.getSchedulingSubpart().getItype().getDesc() : clazz.getSchedulingSubpart().getItype().getAbbv());
                            event.setInstructionType(clazz.getSchedulingSubpart().getItype().getItype());
                            event.setSectionNumber(clazz.getSectionNumberString(hibSession));
                            if (clazz.getClassSuffix(correctedOffering) == null) {
                                event.setName(clazz.getClassLabel(correctedOffering));
                            } else {
                                event.addExternalId(clazz.getClassSuffix(correctedOffering));
                                event.setName(correctedOffering.getCourseName() + " " + clazz.getClassSuffix(correctedOffering));
                            }
                            for (CourseOffering co : courses) {
                                event.addCourseName(co.getCourseName());
                                event.addCourseTitle(co.getTitle() == null ? "" : co.getTitle());
                                if (clazz.getClassSuffix(co) == null) continue;
                                event.addExternalId(clazz.getClassSuffix(co));
                            }
                            for (RoomPref rp : clazz.effectivePreferences(RoomPref.class)) {
                                if (request.getEventFilter().hasOptions("room") && !request.getEventFilter().getOptions("room").contains(rp.getRoom().getUniqueId().toString())) continue;
                                EventInterface.MeetingInterface meetingInterface = new EventInterface.MeetingInterface();
                                meetingInterface.setPast(true);
                                EventInterface.ResourceInterface resourceInterface = new EventInterface.ResourceInterface();
                                resourceInterface.setType(EventInterface.ResourceType.ROOM);
                                resourceInterface.setId(rp.getRoom().getUniqueId());
                                resourceInterface.setName(rp.getRoom().getLabel());
                                resourceInterface.setSize(rp.getRoom().getCapacity());
                                resourceInterface.setDistance((Double)distances.get(rp.getRoom().getUniqueId()));
                                resourceInterface.setRoomType(rp.getRoom().getRoomTypeLabel());
                                resourceInterface.setBreakTime(rp.getRoom().getEffectiveBreakTime());
                                resourceInterface.setMessage(rp.getRoom().getEventMessage());
                                resourceInterface.setIgnoreRoomCheck(rp.getRoom().isIgnoreRoomCheck());
                                meetingInterface.setLocation(resourceInterface);
                                event.addMeeting(meetingInterface);
                            }
                            if (!event.hasMeetings()) {
                                if (request.getEventFilter().hasOptions("room")) continue;
                                EventInterface.MeetingInterface meeting = new EventInterface.MeetingInterface();
                                meeting.setPast(true);
                                event.addMeeting(meeting);
                            }
                            if (correctedOffering.getScheduleBookNote() != null && !correctedOffering.getScheduleBookNote().isEmpty()) {
                                note = new EventInterface.NoteInterface();
                                note.setId(-2L);
                                note.setNote(correctedOffering.getScheduleBookNote());
                                event.addNote(note);
                            }
                            if (clazz.getSchedulePrintNote() != null && !clazz.getSchedulePrintNote().isEmpty()) {
                                note = new EventInterface.NoteInterface();
                                note.setId(-1L);
                                note.setNote(clazz.getSchedulePrintNote());
                                event.addNote(note);
                            }
                            if (request.getEventFilter().hasText() && !event.getName().toLowerCase().startsWith(request.getEventFilter().getText().toLowerCase()) && (request.getEventFilter().getText().length() < 2 || !event.getName().toLowerCase().contains(" " + request.getEventFilter().getText().toLowerCase()))) continue;
                            ret.add(event);
                        }
                    }
                }
                if (request.getResourceType() == EventInterface.ResourceType.ROOM) {
                    for (Location location : new RoomFilterBackend().locations(request.getSessionId(), request.getRoomFilter(), 1000, distances)) {
                        EventInterface unavailability = EventLookupBackend.generateUnavailabilityEvent(location, null);
                        if (unavailability == null) continue;
                        ret.add(unavailability);
                    }
                }
                gwtRpcResponseList = ret;
                Object var35_147 = null;
            }
            catch (Throwable throwable) {
                Object var35_148 = null;
                hibSession.close();
                throw throwable;
            }
            hibSession.close();
            return gwtRpcResponseList;
        }
        catch (GwtRpcException e) {
            throw e;
        }
        catch (Exception e) {
            sLog.error((Object)("Unable to find events for " + request.getResourceType().getLabel() + " " + request.getResourceId() + ": " + e.getMessage()), (Throwable)e);
            throw new GwtRpcException("Unable to find events for " + request.getResourceType().getLabel() + " " + request.getResourceId() + ": " + e.getMessage(), e);
        }
    }

    public static EventInterface generateUnavailabilityEvent(Location location, EventInterface parent) {
        TreeSet<EventInterface.MeetingInterface> meetings = EventLookupBackend.generateUnavailabilityMeetings(location, false);
        if (meetings == null || meetings.isEmpty()) {
            return null;
        }
        EventInterface event = new EventInterface();
        event.setId(-location.getUniqueId().longValue());
        event.setName(MESSAGES.unavailableEventDefaultName());
        event.setType(EventInterface.EventType.Unavailabile);
        if (parent == null) {
            event.setMeetings(meetings);
        } else {
            for (EventInterface.MeetingInterface m : meetings) {
                if (!parent.inConflict(m)) continue;
                event.addMeeting(m);
            }
        }
        if (location.getNote() != null && !location.getNote().isEmpty()) {
            EventInterface.NoteInterface n = new EventInterface.NoteInterface();
            n.setNote(location.getNote());
            event.addNote(n);
        }
        return event;
    }

    public static TreeSet<EventInterface.MeetingInterface> generateUnavailabilityMeetings(Location location, boolean conflict) {
        if (location.getEventAvailability() == null || location.getEventAvailability().length() != 288 * Constants.DAY_CODES.length) {
            return null;
        }
        TreeSet<EventInterface.MeetingInterface> ret = new TreeSet<EventInterface.MeetingInterface>();
        EventInterface.ResourceInterface resource = new EventInterface.ResourceInterface();
        resource.setType(EventInterface.ResourceType.ROOM);
        resource.setId(location.getUniqueId());
        resource.setName(location.getLabel());
        resource.setSize(location.getCapacity());
        resource.setRoomType(location.getRoomTypeLabel());
        resource.setBreakTime(location.getEffectiveBreakTime());
        resource.setMessage(location.getEventMessage());
        resource.setIgnoreRoomCheck(location.isIgnoreRoomCheck());
        Calendar calendar = Calendar.getInstance();
        for (int day = 0; day < Constants.DAY_CODES.length; ++day) {
            int startTime = 0;
            while (startTime < 288) {
                int endTime;
                if (location.getEventAvailability().charAt(day * 288 + startTime) != '1') {
                    ++startTime;
                    continue;
                }
                for (endTime = startTime + 1; endTime < 288 && location.getEventAvailability().charAt(day * 288 + endTime) == '1'; ++endTime) {
                }
                calendar.setTime(location.getSession().getEventBeginDate());
                int dayOfYear = CalendarUtils.date2dayOfYear(location.getSession().getSessionStartYear(), calendar.getTime());
                do {
                    int dayOfWeek = -1;
                    switch (calendar.get(7)) {
                        case 2: {
                            dayOfWeek = 0;
                            break;
                        }
                        case 3: {
                            dayOfWeek = 1;
                            break;
                        }
                        case 4: {
                            dayOfWeek = 2;
                            break;
                        }
                        case 5: {
                            dayOfWeek = 3;
                            break;
                        }
                        case 6: {
                            dayOfWeek = 4;
                            break;
                        }
                        case 7: {
                            dayOfWeek = 5;
                            break;
                        }
                        case 1: {
                            dayOfWeek = 6;
                        }
                    }
                    if (day == dayOfWeek) {
                        EventInterface.MeetingInterface m = null;
                        if (conflict) {
                            EventInterface.MeetingConflictInterface c = new EventInterface.MeetingConflictInterface();
                            c.setName(MESSAGES.unavailableEventDefaultName());
                            c.setType(EventInterface.EventType.Unavailabile);
                            m = c;
                        } else {
                            m = new EventInterface.MeetingInterface();
                        }
                        m.setStartSlot(startTime);
                        m.setEndSlot(endTime);
                        m.setDayOfWeek(dayOfWeek);
                        m.setMeetingDate(calendar.getTime());
                        m.setDayOfYear(dayOfYear);
                        m.setLocation(resource);
                        ret.add(m);
                    }
                    calendar.add(6, 1);
                    ++dayOfYear;
                } while (!calendar.getTime().after(location.getSession().getEventEndDate()));
                startTime = endTime;
            }
        }
        return ret;
    }
}

