/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.dataexchange;

import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.dom4j.Element;
import org.unitime.timetable.dataexchange.BaseImport;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.model.AcademicArea;
import org.unitime.timetable.model.AcademicAreaClassification;
import org.unitime.timetable.model.AcademicClassification;
import org.unitime.timetable.model.CourseDemand;
import org.unitime.timetable.model.PosMajor;
import org.unitime.timetable.model.PosMinor;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.StudentAccomodation;
import org.unitime.timetable.model.StudentClassEnrollment;
import org.unitime.timetable.model.StudentGroup;
import org.unitime.timetable.model.StudentSectioningQueue;
import org.unitime.timetable.model.base.BaseAcademicArea;
import org.unitime.timetable.model.base.BaseAcademicClassification;
import org.unitime.timetable.model.base.BasePosMajor;
import org.unitime.timetable.model.base.BasePosMinor;
import org.unitime.timetable.model.base.BaseStudent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StudentImport
extends BaseImport {
    @Override
    public void loadXml(Element rootElement) throws Exception {
        try {
            boolean trimLeadingZerosFromExternalId = ApplicationProperty.DataExchangeTrimLeadingZerosFromExternalIds.isTrue();
            String campus = rootElement.attributeValue("campus");
            String year = rootElement.attributeValue("year");
            String term = rootElement.attributeValue("term");
            boolean incremental = "true".equals(rootElement.attributeValue("incremental", "false"));
            Session session = Session.getSessionUsingInitiativeYearTerm(campus, year, term);
            if (session == null) {
                throw new Exception("No session found for the given campus, year, and term.");
            }
            if (incremental) {
                this.info("Incremental mode enabled: only included students will be updated.");
            } else {
                this.info("Incremental mode disabled: students not included in this file will be deleted.");
            }
            this.beginTransaction();
            Hashtable<String, Student> students = new Hashtable<String, Student>();
            for (Object student : this.getHibSession().createQuery("from Student s where s.session.uniqueId=:sessionId and s.externalUniqueId is not null").setLong("sessionId", session.getUniqueId().longValue()).list()) {
                students.put(((BaseStudent)student).getExternalUniqueId(), (Student)student);
            }
            Hashtable<String, AcademicArea> abbv2area = new Hashtable<String, AcademicArea>();
            for (Object area : this.getHibSession().createQuery("from AcademicArea where session.uniqueId=:sessionId").setLong("sessionId", session.getUniqueId().longValue()).list()) {
                abbv2area.put(((BaseAcademicArea)area).getAcademicAreaAbbreviation(), (AcademicArea)area);
            }
            Hashtable<String, AcademicClassification> code2clasf = new Hashtable<String, AcademicClassification>();
            for (Object clasf : this.getHibSession().createQuery("from AcademicClassification where session.uniqueId=:sessionId").setLong("sessionId", session.getUniqueId().longValue()).list()) {
                code2clasf.put(((BaseAcademicClassification)clasf).getCode(), (AcademicClassification)clasf);
            }
            Hashtable<String, PosMajor> code2major = new Hashtable<String, PosMajor>();
            for (Object major : this.getHibSession().createQuery("from PosMajor where session.uniqueId=:sessionId").setLong("sessionId", session.getUniqueId().longValue()).list()) {
                for (AcademicArea academicArea : ((BasePosMajor)major).getAcademicAreas()) {
                    code2major.put(academicArea.getAcademicAreaAbbreviation() + ":" + ((BasePosMajor)major).getCode(), (PosMajor)major);
                }
            }
            Hashtable<String, PosMinor> code2minor = new Hashtable<String, PosMinor>();
            for (Object minor : this.getHibSession().createQuery("from PosMinor where session.uniqueId=:sessionId").setLong("sessionId", session.getUniqueId().longValue()).list()) {
                for (AcademicArea area : ((BasePosMinor)minor).getAcademicAreas()) {
                    code2minor.put(area.getAcademicAreaAbbreviation() + ":" + ((BasePosMinor)minor).getCode(), (PosMinor)minor);
                }
            }
            Hashtable<String, StudentGroup> code2group = new Hashtable<String, StudentGroup>();
            for (StudentGroup studentGroup : this.getHibSession().createQuery("from StudentGroup where session.uniqueId=:sessionId").setLong("sessionId", session.getUniqueId().longValue()).list()) {
                code2group.put(studentGroup.getGroupAbbreviation(), studentGroup);
            }
            Hashtable<String, StudentAccomodation> code2accomodation = new Hashtable<String, StudentAccomodation>();
            for (StudentAccomodation accomodation : this.getHibSession().createQuery("from StudentAccomodation where session.uniqueId=:sessionId").setLong("sessionId", session.getUniqueId().longValue()).list()) {
                code2accomodation.put(accomodation.getAbbreviation(), accomodation);
            }
            HashSet<Long> hashSet = new HashSet<Long>();
            Iterator i1 = rootElement.elementIterator();
            while (i1.hasNext()) {
                Element element = (Element)i1.next();
                String externalId = element.attributeValue("externalId");
                if (externalId == null) continue;
                while (trimLeadingZerosFromExternalId && externalId.startsWith("0")) {
                    externalId = externalId.substring(1);
                }
                this.importStudent(element, externalId, students, session, hashSet, abbv2area, code2clasf, code2major, code2minor, code2group, code2accomodation);
            }
            if (!incremental) {
                for (Student student : students.values()) {
                    hashSet.add(student.getUniqueId());
                    this.getHibSession().delete((Object)student);
                }
            }
            this.info(hashSet.size() + " students changed");
            if (!hashSet.isEmpty()) {
                StudentSectioningQueue.studentChanged(this.getHibSession(), null, session.getUniqueId(), hashSet);
            }
            this.commitTransaction();
        }
        catch (Exception e) {
            this.fatal("Exception: " + e.getMessage(), e);
            this.rollbackTransaction();
            throw e;
        }
    }

    protected Student importStudent(Element element, String externalId, Hashtable<String, Student> students, Session session, Set<Long> updatedStudents, Map<String, AcademicArea> abbv2area, Map<String, AcademicClassification> code2clasf, Map<String, PosMajor> code2major, Map<String, PosMinor> code2minor, Map<String, StudentGroup> code2group, Map<String, StudentAccomodation> code2accomodation) {
        Student student = this.updateStudentInfo(element, externalId, students, session, updatedStudents);
        this.updateStudentAcademicAreaClassifications(element, student, updatedStudents, abbv2area, code2clasf);
        this.updateStudentMajors(element, student, updatedStudents, code2major);
        this.updateStudentMinors(element, student, updatedStudents, code2minor);
        this.updateStudentGroups(element, student, updatedStudents, code2group);
        this.updateStudentAccomodations(element, student, updatedStudents, code2accomodation);
        this.saveOrUpdateStudent(student, updatedStudents);
        return student;
    }

    protected Student updateStudentInfo(Element element, String externalId, Hashtable<String, Student> students, Session session, Set<Long> updatedStudents) {
        String fName = element.attributeValue("firstName", "Name");
        String mName = element.attributeValue("middleName");
        String lName = element.attributeValue("lastName", "Unknown");
        String email = element.attributeValue("email");
        Student student = students.remove(externalId);
        if (student == null) {
            student = new Student();
            student.setSession(session);
            student.setExternalUniqueId(externalId);
            student.setFreeTimeCategory(0);
            student.setSchedulePreference(0);
            student.setClassEnrollments(new HashSet<StudentClassEnrollment>());
            student.setCourseDemands(new HashSet<CourseDemand>());
            student.setFirstName(fName);
            student.setMiddleName(mName);
            student.setLastName(lName);
            student.setEmail(email);
            student.setAcademicAreaClassifications(new HashSet<AcademicAreaClassification>());
            student.setPosMajors(new HashSet<PosMajor>());
            student.setPosMinors(new HashSet<PosMinor>());
            student.setGroups(new HashSet<StudentGroup>());
            student.setAccomodations(new HashSet<StudentAccomodation>());
        } else {
            if (!this.eq(fName, student.getFirstName())) {
                student.setFirstName(fName);
                updatedStudents.add(student.getUniqueId());
            }
            if (!this.eq(mName, student.getMiddleName())) {
                student.setMiddleName(mName);
                updatedStudents.add(student.getUniqueId());
            }
            if (!this.eq(lName, student.getLastName())) {
                student.setLastName(lName);
                updatedStudents.add(student.getUniqueId());
            }
            if (!this.eq(email, student.getEmail())) {
                student.setEmail(email);
                updatedStudents.add(student.getUniqueId());
            }
        }
        return student;
    }

    protected void updateStudentAcademicAreaClassifications(Element element, Student student, Set<Long> updatedStudents, Map<String, AcademicArea> abbv2area, Map<String, AcademicClassification> code2clasf) {
        if (element.element("studentAcadAreaClass") != null) {
            Hashtable<String, AcademicAreaClassification> sAreaClasf = new Hashtable<String, AcademicAreaClassification>();
            for (AcademicAreaClassification aac : student.getAcademicAreaClassifications()) {
                sAreaClasf.put(aac.getAcademicArea().getAcademicAreaAbbreviation() + ":" + aac.getAcademicClassification().getCode(), aac);
            }
            Iterator i2 = element.element("studentAcadAreaClass").elementIterator("acadAreaClass");
            while (i2.hasNext()) {
                Element e = (Element)i2.next();
                String area = e.attributeValue("academicArea");
                String clasf = e.attributeValue("academicClass");
                if (sAreaClasf.remove(area + ":" + clasf) != null) continue;
                AcademicAreaClassification aac = new AcademicAreaClassification();
                if (abbv2area.get(area) == null) {
                    this.warn("Academic area " + area + " not known.");
                    continue;
                }
                aac.setAcademicArea(abbv2area.get(area));
                if (code2clasf.get(clasf) == null) {
                    this.warn("Academic classification " + clasf + " not known.");
                    continue;
                }
                aac.setAcademicClassification(code2clasf.get(clasf));
                aac.setStudent(student);
                student.getAcademicAreaClassifications().add(aac);
                if (student.getUniqueId() == null) continue;
                updatedStudents.add(student.getUniqueId());
            }
            for (AcademicAreaClassification aac : sAreaClasf.values()) {
                student.getAcademicAreaClassifications().remove(aac);
                this.getHibSession().delete((Object)aac);
                if (student.getUniqueId() == null) continue;
                updatedStudents.add(student.getUniqueId());
            }
        }
    }

    protected void updateStudentMajors(Element element, Student student, Set<Long> updatedStudents, Map<String, PosMajor> code2major) {
        if (element.element("studentMajors") != null) {
            Hashtable<String, PosMajor> sMajors = new Hashtable<String, PosMajor>();
            for (PosMajor major : student.getPosMajors()) {
                for (AcademicArea area : major.getAcademicAreas()) {
                    sMajors.put(area.getAcademicAreaAbbreviation() + ":" + major.getCode(), major);
                }
            }
            Iterator i2 = element.element("studentMajors").elementIterator("major");
            while (i2.hasNext()) {
                Element e = (Element)i2.next();
                String area = e.attributeValue("academicArea");
                String code = e.attributeValue("code");
                if (sMajors.remove(area + ":" + code) != null) continue;
                PosMajor major = code2major.get(area + ":" + code);
                if (major == null) {
                    this.warn("Major" + area + " " + code + " not known.");
                    continue;
                }
                student.getPosMajors().add(major);
                if (student.getUniqueId() == null) continue;
                updatedStudents.add(student.getUniqueId());
            }
            for (PosMajor major : sMajors.values()) {
                student.getPosMajors().remove(major);
                if (student.getUniqueId() == null) continue;
                updatedStudents.add(student.getUniqueId());
            }
        }
    }

    protected void updateStudentMinors(Element element, Student student, Set<Long> updatedStudents, Map<String, PosMinor> code2minor) {
        if (element.element("studentMinors") != null) {
            Hashtable<String, PosMinor> sMinors = new Hashtable<String, PosMinor>();
            for (PosMinor minor : student.getPosMinors()) {
                for (AcademicArea area : minor.getAcademicAreas()) {
                    sMinors.put(area.getAcademicAreaAbbreviation() + ":" + minor.getCode(), minor);
                }
            }
            Iterator i2 = element.element("studentMinors").elementIterator("minor");
            while (i2.hasNext()) {
                Element e = (Element)i2.next();
                String area = e.attributeValue("academicArea");
                String code = e.attributeValue("code");
                if (sMinors.remove(area + ":" + code) != null) continue;
                PosMinor minor = code2minor.get(area + ":" + code);
                if (minor == null) {
                    this.warn("Minor" + area + " " + code + " not known.");
                    continue;
                }
                student.getPosMinors().add(minor);
                if (student.getUniqueId() == null) continue;
                updatedStudents.add(student.getUniqueId());
            }
            for (PosMinor minor : sMinors.values()) {
                student.getPosMinors().remove(minor);
                if (student.getUniqueId() == null) continue;
                updatedStudents.add(student.getUniqueId());
            }
        }
    }

    protected void updateStudentGroups(Element element, Student student, Set<Long> updatedStudents, Map<String, StudentGroup> code2group) {
        if (element.element("studentGroups") != null) {
            Hashtable<String, StudentGroup> sGroups = new Hashtable<String, StudentGroup>();
            for (StudentGroup group : student.getGroups()) {
                sGroups.put(group.getGroupAbbreviation(), group);
            }
            Iterator i2 = element.element("studentGroups").elementIterator("studentGroup");
            while (i2.hasNext()) {
                Element e = (Element)i2.next();
                String code = e.attributeValue("group");
                if (sGroups.remove(code) != null) continue;
                StudentGroup group = code2group.get(code);
                if (group == null) {
                    this.warn("Student group " + code + " not known.");
                    continue;
                }
                student.getGroups().add(group);
                group.getStudents().add(student);
                this.getHibSession().saveOrUpdate((Object)group);
                if (student.getUniqueId() == null) continue;
                updatedStudents.add(student.getUniqueId());
            }
            for (StudentGroup group : sGroups.values()) {
                if (group.getExternalUniqueId() == null) continue;
                student.getGroups().remove(group);
                group.getStudents().remove(student);
                this.getHibSession().saveOrUpdate((Object)group);
                if (student.getUniqueId() == null) continue;
                updatedStudents.add(student.getUniqueId());
            }
        }
    }

    protected void updateStudentAccomodations(Element element, Student student, Set<Long> updatedStudents, Map<String, StudentAccomodation> code2accomodation) {
        if (element.element("studentAccomodations") != null) {
            Hashtable<String, StudentAccomodation> sAccomodations = new Hashtable<String, StudentAccomodation>();
            for (StudentAccomodation accomodation : student.getAccomodations()) {
                sAccomodations.put(accomodation.getAbbreviation(), accomodation);
            }
            Iterator i2 = element.element("studentAccomodations").elementIterator("studentAccomodation");
            while (i2.hasNext()) {
                Element e = (Element)i2.next();
                String code = e.attributeValue("accomodation");
                if (sAccomodations.remove(code) != null) continue;
                StudentAccomodation accomodation = code2accomodation.get(code);
                if (accomodation == null) {
                    this.warn("Student accomodation " + code + " not known.");
                    continue;
                }
                student.getAccomodations().add(accomodation);
                accomodation.getStudents().add(student);
                if (student.getUniqueId() == null) continue;
                updatedStudents.add(student.getUniqueId());
            }
            for (StudentAccomodation accomodation : sAccomodations.values()) {
                student.getAccomodations().remove(accomodation);
                accomodation.getStudents().remove(student);
                if (student.getUniqueId() == null) continue;
                updatedStudents.add(student.getUniqueId());
            }
        }
    }

    protected void saveOrUpdateStudent(Student student, Set<Long> updatedStudents) {
        if (student.getUniqueId() == null) {
            updatedStudents.add((Long)this.getHibSession().save((Object)student));
        } else {
            this.getHibSession().update((Object)student);
        }
    }

    protected boolean eq(String a, String b) {
        return a == null ? b == null : a.equals(b);
    }
}

