/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.dataexchange;

import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import org.dom4j.Element;
import org.unitime.timetable.dataexchange.BaseImport;
import org.unitime.timetable.model.AcademicArea;
import org.unitime.timetable.model.PosMinor;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.base.BasePosMinor;

public class PosMinorImport
extends BaseImport {
    public void loadXml(Element root) throws Exception {
        if (!root.getName().equalsIgnoreCase("posMinors")) {
            throw new Exception("Given XML file is not pos minors load file.");
        }
        try {
            this.beginTransaction();
            String campus = root.attributeValue("campus");
            String year = root.attributeValue("year");
            String term = root.attributeValue("term");
            Session session = Session.getSessionUsingInitiativeYearTerm(campus, year, term);
            if (session == null) {
                throw new Exception("No session found for the given campus, year, and term.");
            }
            Hashtable<String, PosMinor> id2minor = new Hashtable<String, PosMinor>();
            Hashtable<String, Object> code2minor = new Hashtable<String, Object>();
            for (Object minor : this.getHibSession().createQuery("from PosMinor where session.uniqueId=:sessionId").setLong("sessionId", session.getUniqueId().longValue()).list()) {
                if (((BasePosMinor)minor).getExternalUniqueId() != null) {
                    id2minor.put(((BasePosMinor)minor).getExternalUniqueId(), (PosMinor)minor);
                }
                for (AcademicArea area : ((BasePosMinor)minor).getAcademicAreas()) {
                    code2minor.put(area.getAcademicAreaAbbreviation() + ":" + ((BasePosMinor)minor).getCode(), minor);
                }
            }
            Hashtable<String, AcademicArea> abbv2area = new Hashtable<String, AcademicArea>();
            for (AcademicArea area : this.getHibSession().createQuery("from AcademicArea where session.uniqueId=:sessionId").setLong("sessionId", session.getUniqueId().longValue()).list()) {
                abbv2area.put(area.getAcademicAreaAbbreviation(), area);
            }
            Iterator it = root.elementIterator();
            while (it.hasNext()) {
                Element element = (Element)it.next();
                String externalId = element.attributeValue("externalId");
                String code = element.attributeValue("code");
                AcademicArea area = (AcademicArea)abbv2area.get(element.attributeValue("academicArea"));
                if (area == null) {
                    this.warn("Unknown academic area " + element.attributeValue("academicArea"));
                    continue;
                }
                PosMinor minor = null;
                if (externalId != null) {
                    minor = (PosMinor)id2minor.remove(externalId);
                }
                if (minor == null) {
                    minor = (PosMinor)code2minor.get(area.getAcademicAreaAbbreviation() + ":" + code);
                }
                if (minor == null) {
                    minor = new PosMinor();
                    minor.setSession(session);
                    minor.setAcademicAreas(new HashSet<AcademicArea>());
                    this.info("Minor " + area.getAcademicAreaAbbreviation() + " " + code + (externalId == null ? "" : " (" + externalId + ")") + " created.");
                } else {
                    this.info("Minor " + area.getAcademicAreaAbbreviation() + " " + code + (externalId == null ? "" : " (" + externalId + ")") + " updated.");
                }
                minor.setExternalUniqueId(externalId);
                minor.setCode(code);
                minor.setName(element.attributeValue("name"));
                minor.getAcademicAreas().clear();
                minor.getAcademicAreas().add(area);
                area.getPosMinors().add(minor);
                this.getHibSession().saveOrUpdate((Object)minor);
            }
            for (PosMinor minor : id2minor.values()) {
                String abbv = null;
                for (AcademicArea area : minor.getAcademicAreas()) {
                    area.getPosMinors().remove(minor);
                    abbv = area.getAcademicAreaAbbreviation();
                }
                this.info("Minor " + abbv + " " + minor.getCode() + " (" + minor.getExternalUniqueId() + ") deleted.");
                this.getHibSession().delete((Object)minor);
            }
            this.commitTransaction();
        }
        catch (Exception e) {
            this.fatal("Exception: " + e.getMessage(), e);
            this.rollbackTransaction();
            throw e;
        }
    }
}

