/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.dataexchange;

import java.util.Iterator;
import org.dom4j.Element;
import org.unitime.timetable.dataexchange.BaseImport;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.SubjectArea;

public class CourseOfferingReservationImport
extends BaseImport {
    public void loadXml(Element root) throws Exception {
        if (!root.getName().equalsIgnoreCase("courseOfferingReservations")) {
            throw new Exception("Given XML file is not a Course Offering Reservations load file.");
        }
        try {
            this.beginTransaction();
            String campus = root.attributeValue("campus");
            String year = root.attributeValue("year");
            String term = root.attributeValue("term");
            Session session = Session.getSessionUsingInitiativeYearTerm(campus, year, term);
            if (session == null) {
                throw new Exception("No session found for the given campus, year, and term.");
            }
            Iterator it = root.elementIterator();
            while (it.hasNext()) {
                Element element = (Element)it.next();
                SubjectArea subject = this.fetchSubjectArea(element.attributeValue("subject"), session.getSessionId());
                CourseOffering course = this.fetchCourseOffering(element.attributeValue("courseNumber"), subject.getUniqueId());
                String r = element.attributeValue("reservation");
                course.setReservation(r == null ? null : Integer.valueOf(r));
                this.getHibSession().saveOrUpdate((Object)course);
                this.flushIfNeeded(false);
            }
            this.commitTransaction();
        }
        catch (Exception e) {
            this.fatal("Exception: " + e.getMessage(), e);
            this.rollbackTransaction();
            throw e;
        }
    }

    SubjectArea fetchSubjectArea(String subject, Long sessionId) {
        return (SubjectArea)this.getHibSession().createQuery("select distinct a from SUBJECT_AREA as a where a.subjectAreaAbbreviation=:subject and a.session.uniqueId=:sessionId").setLong("sessionId", sessionId.longValue()).setString("subject", subject).setCacheable(true).uniqueResult();
    }

    CourseOffering fetchCourseOffering(String courseNumber, Long subjectAreaId) {
        return (CourseOffering)this.getHibSession().createQuery("select distinct a from COURSE_OFFERING as a where a.courseNumber=:courseNumber and a.subjectArea=:subjectArea").setLong("subjectArea", subjectAreaId.longValue()).setString("courseNumber", courseNumber).setCacheable(true).uniqueResult();
    }
}

