/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.dataexchange;

import java.util.Hashtable;
import java.util.Iterator;
import org.dom4j.Element;
import org.unitime.timetable.dataexchange.BaseImport;
import org.unitime.timetable.model.AcademicArea;
import org.unitime.timetable.model.Session;

public class AcademicAreaImport
extends BaseImport {
    public void loadXml(Element root) throws Exception {
        if (!root.getName().equalsIgnoreCase("academicAreas")) {
            throw new Exception("Given XML file is not acedemic areas load file.");
        }
        try {
            this.beginTransaction();
            String campus = root.attributeValue("campus");
            String year = root.attributeValue("year");
            String term = root.attributeValue("term");
            Session session = Session.getSessionUsingInitiativeYearTerm(campus, year, term);
            if (session == null) {
                throw new Exception("No session found for the given campus, year, and term.");
            }
            Hashtable<String, AcademicArea> id2area = new Hashtable<String, AcademicArea>();
            Hashtable<String, AcademicArea> abbv2area = new Hashtable<String, AcademicArea>();
            for (AcademicArea area : this.getHibSession().createQuery("from AcademicArea where session.uniqueId=:sessionId").setLong("sessionId", session.getUniqueId().longValue()).list()) {
                if (area.getExternalUniqueId() != null) {
                    id2area.put(area.getExternalUniqueId(), area);
                }
                abbv2area.put(area.getAcademicAreaAbbreviation(), area);
            }
            Iterator it = root.elementIterator();
            while (it.hasNext()) {
                Element element = (Element)it.next();
                String externalId = element.attributeValue("externalId");
                String abbv = element.attributeValue("abbreviation");
                AcademicArea area = null;
                if (externalId != null) {
                    area = (AcademicArea)id2area.remove(externalId);
                }
                if (area == null) {
                    area = (AcademicArea)abbv2area.get(abbv);
                }
                if (area == null) {
                    area = new AcademicArea();
                    area.setSession(session);
                    this.info("Academic area " + abbv + (externalId == null ? "" : " (" + externalId + ")") + " created.");
                } else {
                    this.info("Academic area " + abbv + (externalId == null ? "" : " (" + externalId + ")") + " updated.");
                }
                area.setExternalUniqueId(externalId);
                area.setAcademicAreaAbbreviation(abbv);
                area.setTitle(element.attributeValue("title", element.attributeValue("longTitle")));
                this.getHibSession().saveOrUpdate((Object)area);
            }
            for (AcademicArea area : id2area.values()) {
                this.info("Academic area " + area.getAcademicAreaAbbreviation() + " (" + area.getExternalUniqueId() + ") deleted.");
                this.getHibSession().delete((Object)area);
            }
            this.commitTransaction();
        }
        catch (Exception e) {
            this.fatal("Exception: " + e.getMessage(), e);
            this.rollbackTransaction();
            throw e;
        }
    }
}

