/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.api.connectors;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Iterator;
import org.springframework.stereotype.Service;
import org.unitime.timetable.api.ApiConnector;
import org.unitime.timetable.api.ApiHelper;
import org.unitime.timetable.events.EventAction;
import org.unitime.timetable.events.EventLookupBackend;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseList;
import org.unitime.timetable.gwt.shared.EventInterface;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.security.Qualifiable;
import org.unitime.timetable.security.rights.Right;

@Service(value="/api/events")
public class EventsConnector
extends ApiConnector {
    public void doGet(ApiHelper helper) throws IOException {
        String type;
        String ext;
        Long sessionId = helper.getAcademicSessionId();
        if (sessionId == null) {
            throw new IllegalArgumentException("Academic session not provided, please set the term parameter.");
        }
        Session session = (Session)SessionDAO.getInstance().get(sessionId, helper.getHibSession());
        if (session == null) {
            throw new IllegalArgumentException("Given academic session no longer exists.");
        }
        helper.getSessionContext().checkPermissionAnyAuthority((Object)session, Right.ApiRetrieveEvents, new Qualifiable[0]);
        EventInterface.EventLookupRpcRequest request = new EventInterface.EventLookupRpcRequest();
        request.setSessionId(sessionId);
        String id = helper.getParameter("id");
        if (id != null) {
            request.setResourceId(Long.valueOf(id));
        }
        if ((ext = helper.getParameter("ext")) != null) {
            request.setResourceExternalId(ext);
        }
        if ((type = helper.getParameter("type")) == null) {
            throw new IllegalArgumentException("Resource type not provided, please set the type parameter.");
        }
        request.setResourceType(EventInterface.ResourceType.valueOf(type.toUpperCase()));
        EventInterface.EventFilterRpcRequest eventFilter = new EventInterface.EventFilterRpcRequest();
        eventFilter.setSessionId(sessionId);
        request.setEventFilter(eventFilter);
        EventInterface.RoomFilterRpcRequest roomFilter = new EventInterface.RoomFilterRpcRequest();
        roomFilter.setSessionId(sessionId);
        Enumeration<String> e = helper.getParameterNames();
        while (e.hasMoreElements()) {
            String command = e.nextElement();
            if (command.equals("e:text")) {
                eventFilter.setText(helper.getParameter("e:text"));
                continue;
            }
            if (command.startsWith("e:")) {
                for (String value : helper.getParameterValues(command)) {
                    eventFilter.addOption(command.substring(2), value);
                }
                continue;
            }
            if (command.equals("r:text")) {
                roomFilter.setText(helper.getParameter("r:text"));
                continue;
            }
            if (!command.startsWith("r:")) continue;
            for (String value : helper.getParameterValues(command)) {
                roomFilter.addOption(command.substring(2), value);
            }
        }
        request.setRoomFilter(roomFilter);
        EventAction.EventContext context = new EventAction.EventContext(helper.getSessionContext(), helper.getSessionContext().getUser(), sessionId);
        GwtRpcResponseList<EventInterface> events = new EventLookupBackend().findEvents(request, context);
        if (!"1".equals(helper.getParameter("ua"))) {
            Iterator i = events.iterator();
            while (i.hasNext()) {
                EventInterface event = (EventInterface)i.next();
                if (event.getType() != EventInterface.EventType.Unavailabile) continue;
                i.remove();
            }
        }
        helper.setResponse(events);
    }

    protected String getName() {
        return "events";
    }
}

