/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.unitime.timetable.defaults.SessionAttribute;
import org.unitime.timetable.form.SolverLogForm;
import org.unitime.timetable.model.Solution;
import org.unitime.timetable.model.dao.SolutionDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.solver.SolverProxy;
import org.unitime.timetable.solver.service.SolverService;
import org.unitime.timetable.solver.ui.LogInfo;

@Service(value="/solverLog")
public class SolverLogAction
extends Action {
    @Autowired
    SessionContext sessionContext;
    @Autowired
    SolverService<SolverProxy> courseTimetablingSolverService;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SolverProxy solver;
        String op;
        SolverLogForm myForm = (SolverLogForm)form;
        this.sessionContext.checkPermission(Right.SolverLog);
        String string = op = myForm.getOp() != null ? myForm.getOp() : request.getParameter("op");
        if ("Change".equals(op)) {
            if (myForm.getLevelNoDefault() != null) {
                this.sessionContext.getUser().setProperty("SolverLog.level", myForm.getLevelNoDefault());
            }
        } else {
            myForm.setLevel(this.sessionContext.getUser().getProperty("SolverLog.level"));
        }
        if ((solver = this.courseTimetablingSolverService.getSolver()) != null) {
            solver.setDebugLevel(myForm.getLevelInt());
            request.setAttribute("log", (Object)solver.getLog());
        } else {
            String solutionIdsStr = (String)this.sessionContext.getAttribute(SessionAttribute.SelectedSolution);
            if (solutionIdsStr != null && !solutionIdsStr.isEmpty()) {
                StringTokenizer s = new StringTokenizer(solutionIdsStr, ",");
                LogInfo[] logInfo = new LogInfo[s.countTokens()];
                String[] ownerName = new String[s.countTokens()];
                for (int i = 0; i < logInfo.length; ++i) {
                    Solution solution = (Solution)new SolutionDAO().get(Long.valueOf(s.nextToken()));
                    if (solution == null) continue;
                    logInfo[i] = (LogInfo)solution.getInfo("LogInfo");
                    ownerName[i] = solution.getOwner().getName();
                }
                myForm.setLogs(logInfo);
                myForm.setOwnerNames(ownerName);
            }
        }
        return mapping.findForward("showLog");
    }
}

