/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.io.Serializable;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.action.ActionRedirect;
import org.apache.struts.config.ForwardConfig;
import org.apache.struts.util.MessageResources;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.unitime.commons.Debug;
import org.unitime.timetable.action.PreferencesAction;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.defaults.CommonValues;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.form.SchedulingSubpartEditForm;
import org.unitime.timetable.interfaces.ExternalSchedulingSubpartEditAction;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.CourseCreditUnitConfig;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.DatePattern;
import org.unitime.timetable.model.DatePatternPref;
import org.unitime.timetable.model.FixedCreditUnitConfig;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.ItypeDesc;
import org.unitime.timetable.model.Preference;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.TimePattern;
import org.unitime.timetable.model.VariableFixedCreditUnitConfig;
import org.unitime.timetable.model.VariableRangeCreditUnitConfig;
import org.unitime.timetable.model.dao.DatePatternDAO;
import org.unitime.timetable.model.dao.ItypeDescDAO;
import org.unitime.timetable.model.dao.SchedulingSubpartDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.LookupTables;
import org.unitime.timetable.webutil.BackTracker;

@Service(value="/schedulingSubpartEdit")
public class SchedulingSubpartEditAction
extends PreferencesAction {
    @Autowired
    SessionContext sessionContext;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            DatePattern selectedDatePattern;
            super.execute(mapping, form, request, response);
            SchedulingSubpartEditForm frm = (SchedulingSubpartEditForm)form;
            MessageResources rsc = this.getResources(request);
            ActionMessages errors = new ActionMessages();
            String subpartId = request.getParameter("ssuid") == null ? (request.getAttribute("ssuid") != null ? request.getAttribute("ssuid").toString() : null) : request.getParameter("ssuid");
            String reloadCause = request.getParameter("reloadCause");
            String op = frm.getOp();
            if (request.getParameter("op2") != null && request.getParameter("op2").length() > 0) {
                op = request.getParameter("op2");
            }
            if (op.equals(MSG.actionAddTimePreference()) || op.equals(MSG.actionAddRoomPreference()) || op.equals(MSG.actionAddBuildingPreference()) || op.equals(MSG.actionAddRoomFeaturePreference()) || op.equals(MSG.actionAddDistributionPreference()) || op.equals(MSG.actionAddRoomGroupPreference()) || op.equals(MSG.actionUpdatePreferences()) || op.equals(MSG.actionAddDatePatternPreference()) || op.equals(MSG.actionClearSubpartPreferences()) || op.equals(MSG.actionRemoveBuildingPreference()) || op.equals(MSG.actionRemoveDistributionPreference()) || op.equals(MSG.actionRemoveRoomFeaturePreference()) || op.equals(MSG.actionRemoveRoomGroupPreference()) || op.equals(MSG.actionRemoveRoomPreference()) || op.equals(MSG.actionRemoveTimePattern()) || op.equals(MSG.actionBackToDetail()) || op.equals(MSG.actionNextSubpart()) || op.equals(MSG.actionPreviousSubpart()) || op.equals("updateDatePattern")) {
                subpartId = frm.getSchedulingSubpartId();
            }
            if (op == null || op.trim().length() == 0 || op.equals(rsc.getMessage("button.reload")) && (reloadCause == null || reloadCause.trim().length() == 0)) {
                op = "init";
            }
            if (op == null || op.trim() == "") {
                throw new Exception(MSG.errorNullOperationNotSupported());
            }
            this.sessionContext.checkPermission((Serializable)((Object)subpartId), "SchedulingSubpart", Right.SchedulingSubpartEdit);
            boolean timeVertical = CommonValues.VerticalGrid.eq(this.sessionContext.getUser().getProperty(UserProperty.GridOrientation));
            Debug.debug("op: " + op);
            Debug.debug("subpart: " + subpartId);
            Debug.debug("reload cause: " + reloadCause);
            if (subpartId == null || subpartId.trim() == "") {
                throw new Exception(MSG.errorSubpartInfoNotSupplied());
            }
            SchedulingSubpartDAO sdao = new SchedulingSubpartDAO();
            SchedulingSubpart ss = (SchedulingSubpart)sdao.get(new Long(subpartId));
            if (op.equals(MSG.actionBackToDetail()) && subpartId != null && subpartId.trim() != "") {
                ActionRedirect redirect = new ActionRedirect((ForwardConfig)mapping.findForward("displaySubpartDetail"));
                redirect.addParameter("ssuid", (Object)subpartId);
                return redirect;
            }
            if (op.equals(MSG.actionClearSubpartPreferences())) {
                this.sessionContext.checkPermission(ss, Right.SchedulingSubpartEditClearPreferences);
                Set<Preference> s = ss.getPreferences();
                s.clear();
                ss.setPreferences(s);
                sdao.update(ss);
                ChangeLog.addChange(null, this.sessionContext, ss, ChangeLog.Source.SCHEDULING_SUBPART_EDIT, ChangeLog.Operation.CLEAR_PREF, ss.getInstrOfferingConfig().getInstructionalOffering().getControllingCourseOffering().getSubjectArea(), ss.getManagingDept());
                ActionRedirect redirect = new ActionRedirect((ForwardConfig)mapping.findForward("displaySubpartDetail"));
                redirect.addParameter("ssuid", (Object)subpartId);
                return redirect;
            }
            if (op.equals("init")) {
                frm.reset(mapping, request);
                frm.setAutoSpreadInTime(ss.isAutoSpreadInTime());
                frm.setStudentAllowOverlap(ss.isStudentAllowOverlap());
            }
            this.doLoad(request, frm, ss, subpartId);
            if (op.equals("init")) {
                frm.setDatePattern(ss.getDatePattern() == null ? new Long(-1L) : ss.getDatePattern().getUniqueId());
            }
            if (op.equals(MSG.actionUpdatePreferences()) || op.equals(MSG.actionNextSubpart()) || op.equals(MSG.actionPreviousSubpart())) {
                errors = frm.validate(mapping, request);
                if (errors.size() == 0) {
                    this.doUpdate(request, frm, ss, sdao, timeVertical);
                    if (op.equals(MSG.actionNextSubpart())) {
                        response.sendRedirect(response.encodeURL("schedulingSubpartEdit.do?ssuid=" + frm.getNextId()));
                        return null;
                    }
                    if (op.equals(MSG.actionPreviousSubpart())) {
                        response.sendRedirect(response.encodeURL("schedulingSubpartEdit.do?ssuid=" + frm.getPreviousId()));
                        return null;
                    }
                    ActionRedirect redirect = new ActionRedirect((ForwardConfig)mapping.findForward("displaySubpartDetail"));
                    redirect.addParameter("ssuid", (Object)subpartId);
                    return redirect;
                }
                this.saveErrors(request, errors);
            }
            Set timePatterns = null;
            frm.setAvailableTimePatterns(TimePattern.findApplicable(this.sessionContext.getUser(), ss.getMinutesPerWk(), false, ss.getManagingDept()));
            if (op.equals("init")) {
                this.initPrefs(frm, ss, null, true);
                timePatterns = ss.getTimePatterns();
                selectedDatePattern = ss.effectiveDatePattern();
                if (selectedDatePattern != null) {
                    for (DatePattern dp : selectedDatePattern.findChildren()) {
                        if (frm.getDatePatternPrefs().contains(dp.getUniqueId().toString())) continue;
                        frm.addToDatePatternPrefs(dp.getUniqueId().toString(), PreferenceLevel.PREF_LEVEL_NEUTRAL);
                    }
                }
            }
            if (op.equals("updateDatePattern")) {
                this.initPrefs(frm, ss, null, true);
                timePatterns = ss.getTimePatterns();
                frm.getDatePatternPrefs().clear();
                frm.getDatePatternPrefLevels().clear();
                DatePattern datePattern = selectedDatePattern = frm.getDatePattern() < 0L ? ss.effectiveDatePattern() : (DatePattern)DatePatternDAO.getInstance().get(frm.getDatePattern());
                if (selectedDatePattern != null) {
                    for (DatePattern dp : selectedDatePattern.findChildren()) {
                        boolean found = false;
                        for (DatePatternPref dpp : ss.getPreferences(DatePatternPref.class)) {
                            if (!dp.equals(dpp.getDatePattern())) continue;
                            frm.addToDatePatternPrefs(dp.getUniqueId().toString(), dpp.getPrefLevel().getUniqueId().toString());
                            found = true;
                        }
                        if (found) continue;
                        frm.addToDatePatternPrefs(dp.getUniqueId().toString(), PreferenceLevel.PREF_LEVEL_NEUTRAL);
                    }
                }
            }
            this.processPrefAction(request, frm, errors);
            super.generateTimePatternGrids(request, frm, ss, timePatterns, op, timeVertical, true, null);
            this.setupChildren(frm, request, ss);
            LookupTables.setupDatePatterns(request, this.sessionContext.getUser(), "Default", ss.canInheritParentPreferences() ? ss.getParentSubpart().effectiveDatePattern() : ss.getSession().getDefaultDatePatternNotNull(), ss.getManagingDept(), ss.effectiveDatePattern());
            LookupTables.setupRooms(request, ss);
            LookupTables.setupBldgs(request, ss);
            LookupTables.setupRoomFeatures(request, ss);
            LookupTables.setupRoomGroups(request, ss);
            LookupTables.setupCourseCreditFormats(request);
            LookupTables.setupCourseCreditTypes(request);
            LookupTables.setupCourseCreditUnitTypes(request);
            frm.setAllowHardPrefs(this.sessionContext.hasPermission(ss, Right.CanUseHardRoomPrefs));
            BackTracker.markForBack(request, "schedulingSubpartDetail.do?ssuid=" + frm.getSchedulingSubpartId(), MSG.backSubpart(ss.getSchedulingSubpartLabel()), true, false);
            return mapping.findForward("editSchedulingSubpart");
        }
        catch (Exception e) {
            Debug.error(e);
            throw e;
        }
    }

    private void doLoad(HttpServletRequest request, SchedulingSubpartEditForm frm, SchedulingSubpart ss, String subpartId) {
        SchedulingSubpart parentSS;
        SchedulingSubpart next;
        CourseOffering co = ss.getInstrOfferingConfig().getInstructionalOffering().getControllingCourseOffering();
        InstrOfferingConfig ioc = ss.getInstrOfferingConfig();
        InstructionalOffering io = ioc.getInstructionalOffering();
        frm.setInstrOfferingId(io.getUniqueId().toString());
        frm.setSchedulingSubpartId(subpartId);
        if (frm.getInstructionalType() == null) {
            frm.setInstructionalType(ss.getItype().getItype().toString());
        }
        String label = ss.getItype().getAbbv();
        if (io.hasMultipleConfigurations()) {
            label = label + " [" + ioc.getName() + "]";
        }
        frm.setInstructionalTypeLabel(label);
        frm.setUnlimitedEnroll(ioc.isUnlimitedEnrollment());
        frm.setItypeBasic(ss.getItype() == null || ss.getItype().getBasic() == 1);
        if (!frm.getItypeBasic()) {
            LookupTables.setupItypes(request, false);
        }
        frm.setSubjectArea(co.getSubjectAreaAbbv());
        frm.setSubjectAreaId(co.getSubjectArea().getUniqueId().toString());
        frm.setCourseNbr(co.getCourseNbr());
        frm.setCourseTitle(co.getTitle());
        if (ss.getParentSubpart() != null && ss.getItype().equals(ss.getParentSubpart().getItype())) {
            frm.setSameItypeAsParent(new Boolean(true));
        } else {
            frm.setSameItypeAsParent(new Boolean(false));
        }
        if (frm.getCreditFormat() == null && ss.getCredit() != null) {
            CourseCreditUnitConfig credit = ss.getCredit();
            frm.setCreditText(credit.creditText());
            frm.setCreditFormat(credit.getCreditFormat());
            frm.setCreditType(credit.getCreditType().getUniqueId());
            frm.setCreditUnitType(credit.getCreditUnitType().getUniqueId());
            if (credit instanceof FixedCreditUnitConfig) {
                frm.setUnits(((FixedCreditUnitConfig)credit).getFixedUnits());
            } else if (credit instanceof VariableFixedCreditUnitConfig) {
                frm.setUnits(((VariableFixedCreditUnitConfig)credit).getMinUnits());
                frm.setMaxUnits(((VariableFixedCreditUnitConfig)credit).getMaxUnits());
                if (credit instanceof VariableRangeCreditUnitConfig) {
                    frm.setFractionalIncrementsAllowed(((VariableRangeCreditUnitConfig)credit).isFractionalIncrementsAllowed());
                }
            }
        }
        frm.setNextId((next = ss.getNextSchedulingSubpart(this.sessionContext, Right.SchedulingSubpartEdit)) == null ? null : next.getUniqueId().toString());
        SchedulingSubpart previous = ss.getPreviousSchedulingSubpart(this.sessionContext, Right.SchedulingSubpartEdit);
        frm.setPreviousId(previous == null ? null : previous.getUniqueId().toString());
        String parentSubpart = "";
        frm.setParentSubpartId(parentSS == null ? null : parentSS.getUniqueId().toString());
        frm.setParentSubpartLabel(parentSS == null ? null : parentSS.getSchedulingSubpartLabel());
        for (parentSS = ss.getParentSubpart(); parentSS != null; parentSS = parentSS.getParentSubpart()) {
            parentSubpart = parentSS.getItype().getAbbv() + " - " + parentSubpart;
        }
        frm.setParentSubpart(parentSubpart);
        frm.setManagingDeptName(ss.getManagingDept() == null ? null : ss.getManagingDept().getManagingDeptLabel());
    }

    private void doUpdate(HttpServletRequest request, SchedulingSubpartEditForm frm, SchedulingSubpart ss, SchedulingSubpartDAO sdao, boolean timeVertical) throws Exception {
        ItypeDesc newItype;
        Set<Preference> s = ss.getPreferences();
        s.clear();
        super.doUpdate(request, frm, ss, s, timeVertical);
        ss.setAutoSpreadInTime(frm.getAutoSpreadInTime());
        ss.setStudentAllowOverlap(frm.getStudentAllowOverlap());
        if (frm.getDatePattern() == null || frm.getDatePattern().intValue() < 0) {
            ss.setDatePattern(null);
        } else {
            ss.setDatePattern((DatePattern)new DatePatternDAO().get(frm.getDatePattern()));
        }
        if (frm.getInstructionalType() != null && frm.getInstructionalType().length() != 0 && (newItype = (ItypeDesc)new ItypeDescDAO().get(new Integer(frm.getInstructionalType()))) != null) {
            ss.setItype(newItype);
        }
        if (frm.getCreditFormat() == null || frm.getCreditFormat().length() == 0 || frm.getCreditFormat().equals(Constants.BLANK_OPTION_VALUE)) {
            CourseCreditUnitConfig origConfig = ss.getCredit();
            if (origConfig != null) {
                ss.setCredit(null);
                sdao.getSession().delete((Object)origConfig);
            }
        } else if (ss.getCredit() != null) {
            CourseCreditUnitConfig ccuc = ss.getCredit();
            if (ccuc.getCreditFormat().equals(frm.getCreditFormat())) {
                boolean changed = false;
                if (!ccuc.getCreditType().getUniqueId().equals(frm.getCreditType())) {
                    changed = true;
                }
                if (!ccuc.getCreditUnitType().getUniqueId().equals(frm.getCreditUnitType())) {
                    changed = true;
                }
                if (ccuc instanceof FixedCreditUnitConfig) {
                    FixedCreditUnitConfig fcuc = (FixedCreditUnitConfig)ccuc;
                    if (!fcuc.getFixedUnits().equals(frm.getUnits())) {
                        changed = true;
                    }
                } else if (ccuc instanceof VariableFixedCreditUnitConfig) {
                    VariableRangeCreditUnitConfig vrcuc;
                    VariableFixedCreditUnitConfig vfcuc = (VariableFixedCreditUnitConfig)ccuc;
                    if (!vfcuc.getMinUnits().equals(frm.getUnits())) {
                        changed = true;
                    }
                    if (!vfcuc.getMaxUnits().equals(frm.getMaxUnits())) {
                        changed = true;
                    }
                    if (vfcuc instanceof VariableRangeCreditUnitConfig && !(vrcuc = (VariableRangeCreditUnitConfig)vfcuc).isFractionalIncrementsAllowed().equals(frm.getFractionalIncrementsAllowed())) {
                        changed = true;
                    }
                }
                if (changed) {
                    CourseCreditUnitConfig origConfig = ss.getCredit();
                    ss.setCredit(null);
                    sdao.getSession().delete((Object)origConfig);
                    ss.setCredit(CourseCreditUnitConfig.createCreditUnitConfigOfFormat(frm.getCreditFormat(), frm.getCreditType(), frm.getCreditUnitType(), frm.getUnits(), frm.getMaxUnits(), frm.getFractionalIncrementsAllowed(), new Boolean(false)));
                    ss.getCredit().setOwner(ss);
                }
            } else {
                CourseCreditUnitConfig origConfig = ss.getCredit();
                ss.setCredit(null);
                sdao.getSession().delete((Object)origConfig);
                ss.setCredit(CourseCreditUnitConfig.createCreditUnitConfigOfFormat(frm.getCreditFormat(), frm.getCreditType(), frm.getCreditUnitType(), frm.getUnits(), frm.getMaxUnits(), frm.getFractionalIncrementsAllowed(), new Boolean(false)));
                ss.getCredit().setOwner(ss);
            }
        } else {
            ss.setCredit(CourseCreditUnitConfig.createCreditUnitConfigOfFormat(frm.getCreditFormat(), frm.getCreditType(), frm.getCreditUnitType(), frm.getUnits(), frm.getMaxUnits(), frm.getFractionalIncrementsAllowed(), new Boolean(false)));
            ss.getCredit().setOwner(ss);
        }
        if (ss.getCredit() != null) {
            sdao.getSession().saveOrUpdate((Object)ss.getCredit());
        }
        sdao.update(ss);
        String className = ApplicationProperty.ExternalActionSchedulingSubpartEdit.value();
        if (className != null && className.trim().length() > 0) {
            ExternalSchedulingSubpartEditAction editAction = (ExternalSchedulingSubpartEditAction)Class.forName(className).newInstance();
            editAction.performExternalSchedulingSubpartEditAction(ss, sdao.getSession());
        }
        ChangeLog.addChange(null, this.sessionContext, ss, ChangeLog.Source.SCHEDULING_SUBPART_EDIT, ChangeLog.Operation.UPDATE, ss.getInstrOfferingConfig().getControllingCourseOffering().getSubjectArea(), ss.getManagingDept());
    }

    protected void setupChildren(SchedulingSubpartEditForm frm, HttpServletRequest request, SchedulingSubpart ss) {
        DatePattern selectedDatePattern = frm.getDatePattern() < 0L ? ss.effectiveDatePattern() : (DatePattern)DatePatternDAO.getInstance().get(frm.getDatePattern());
        try {
            if (selectedDatePattern != null) {
                List<DatePattern> v = selectedDatePattern.findChildren();
                request.setAttribute(DatePattern.DATE_PATTERN_CHILDREN_LIST_ATTR, v);
                frm.sortDatePatternPrefs(frm.getDatePatternPrefs(), frm.getDatePatternPrefLevels(), v);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

