/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import com.lowagie.text.Document;
import com.lowagie.text.Element;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfPageEvent;
import com.lowagie.text.pdf.PdfWriter;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessages;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.unitime.commons.web.WebTable;
import org.unitime.timetable.defaults.SessionAttribute;
import org.unitime.timetable.form.RoomGroupListForm;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.ExamType;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.RoomDept;
import org.unitime.timetable.model.RoomGroup;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.ExportUtils;
import org.unitime.timetable.util.LookupTables;
import org.unitime.timetable.util.PdfEventHandler;
import org.unitime.timetable.util.PdfFont;
import org.unitime.timetable.webutil.PdfWebTable;

@Service(value="/roomGroupList")
public class RoomGroupListAction
extends Action {
    @Autowired
    SessionContext sessionContext;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        RoomGroupListForm roomGroupListForm = (RoomGroupListForm)form;
        this.sessionContext.checkPermission(Right.RoomGroups);
        ActionMessages errors = new ActionMessages();
        String deptCode = (String)request.getAttribute("deptCode");
        if (deptCode != null) {
            roomGroupListForm.setDeptCodeX(deptCode);
        }
        if (this.sessionContext.getAttribute(SessionAttribute.DepartmentCodeRoom) != null && roomGroupListForm.getDeptCodeX() == null && (deptCode = (String)this.sessionContext.getAttribute(SessionAttribute.DepartmentCodeRoom)) != null && ("All".equals(deptCode) || deptCode.matches("Exam[0-9]*") || this.sessionContext.hasPermission((Serializable)((Object)deptCode), "Department", Right.RoomFeatures))) {
            roomGroupListForm.setDeptCodeX((String)this.sessionContext.getAttribute(SessionAttribute.DepartmentCodeRoom));
        }
        if (roomGroupListForm.getDeptCodeX() != null && !roomGroupListForm.getDeptCodeX().isEmpty()) {
            this.sessionContext.setAttribute(SessionAttribute.DepartmentCodeRoom, (Object)roomGroupListForm.getDeptCodeX());
        }
        LookupTables.setupDepartments(request, this.sessionContext, true);
        LookupTables.setupExamTypes(request, this.sessionContext.getUser().getCurrentAcademicSessionId());
        errors = roomGroupListForm.validate(mapping, request);
        if (errors.size() > 0) {
            this.saveErrors(request, errors);
            return mapping.findForward("showRoomGroupSearch");
        }
        this.buildGroupTable(request, roomGroupListForm);
        if ("Export PDF".equals(request.getParameter("op"))) {
            this.sessionContext.checkPermission(Right.RoomGroupsExportPdf);
            OutputStream out = ExportUtils.getPdfOutputStream(response, "roomGroups");
            RoomGroupListAction.printPdfGroupTable(out, this.sessionContext, roomGroupListForm);
            out.flush();
            out.close();
            return null;
        }
        return mapping.findForward("showRoomGroupList");
    }

    private void buildGroupTable(HttpServletRequest request, RoomGroupListForm roomGroupListForm) throws Exception {
        boolean deptCheck;
        WebTable.setOrder(this.sessionContext, "roomGroupList.gord", request.getParameter("gord"), 1);
        WebTable.setOrder(this.sessionContext, "roomGroupList.mord", request.getParameter("mord"), 1);
        WebTable globalWebTable = new WebTable(5, "Global Room Groups", "roomGroupList.do?gord=%%", new String[]{"Name", "Abbreviation", "Default", "Rooms", "Description"}, new String[]{"left", "left", "middle", "left", "left"}, new boolean[]{true, true, true, true, true});
        WebTable departmentWebTable = new WebTable(5, "Department Room Groups", "roomGroupList.do?mord=%%", new String[]{"Name", "Abbreviation", "Department", "Rooms", "Description"}, new String[]{"left", "left", "left", "left", "left"}, new boolean[]{true, true, true, true, true});
        TreeSet<Department> depts = Department.getUserDepartments(this.sessionContext.getUser());
        Long examType = null;
        Department department = null;
        if ("Exam".equals(roomGroupListForm.getDeptCodeX())) {
            TreeSet<ExamType> types = ExamType.findAllUsed(this.sessionContext.getUser().getCurrentAcademicSessionId());
            if (!types.isEmpty()) {
                examType = types.first().getUniqueId();
                roomGroupListForm.setDeptCodeX("Exam" + examType);
            }
        } else if (roomGroupListForm.getDeptCodeX() != null && roomGroupListForm.getDeptCodeX().matches("Exam[0-9]*")) {
            examType = Long.valueOf(roomGroupListForm.getDeptCodeX().substring(4));
        } else if (roomGroupListForm.getDeptCodeX() != null && !roomGroupListForm.getDeptCodeX().isEmpty() && !"All".equals(roomGroupListForm.getDeptCodeX())) {
            department = Department.findByDeptCode(roomGroupListForm.getDeptCodeX(), this.sessionContext.getUser().getCurrentAcademicSessionId());
        }
        boolean bl = deptCheck = examType == null && !this.sessionContext.getUser().getCurrentAuthority().hasRight(Right.DepartmentIndependent);
        if (department != null) {
            deptCheck = true;
            depts = new TreeSet();
            depts.add(department);
        }
        boolean haveGlobalRoomGroup = false;
        for (RoomGroup rg : RoomGroup.getAllGlobalRoomGroups(this.sessionContext.getUser().getCurrentAcademicSessionId())) {
            TreeSet<Location> rs = new TreeSet<Location>(rg.getRooms());
            StringBuffer assignedRoom = new StringBuffer();
            boolean haveRooms = false;
            for (Location r : rs) {
                if (examType != null && !r.isExamEnabled(examType)) continue;
                if (deptCheck) {
                    boolean skip = true;
                    for (RoomDept rd : r.getRoomDepts()) {
                        if (!depts.contains(rd.getDepartment())) continue;
                        skip = false;
                        break;
                    }
                    if (skip) continue;
                }
                if (assignedRoom.length() > 0) {
                    assignedRoom.append(", ");
                }
                assignedRoom.append(r.getLabel().replaceAll(" ", "&nbsp;"));
                haveRooms = true;
            }
            boolean editable = this.sessionContext.hasPermission(rg, Right.GlobalRoomGroupEdit);
            if (!haveRooms && !editable) continue;
            globalWebTable.addLine(editable ? "onClick=\"document.location='roomGroupEdit.do?doit=editRoomGroup&id=" + rg.getUniqueId() + "';\"" : null, new String[]{"<A name=\"A" + rg.getUniqueId() + "\"></A>" + (editable ? "" : "<font color=gray>") + rg.getName().replaceAll(" ", "&nbsp;") + (editable ? "" : "</font>"), (editable ? "" : "<font color=gray>") + rg.getAbbv().replaceAll(" ", "&nbsp;") + (editable ? "" : "</font>"), rg.isDefaultGroup() != false ? "<IMG border='0' title='This group is default group.' alt='Default' align='absmiddle' src='images/accept.png'>" : "", (editable ? "" : "<font color=gray>") + assignedRoom + (editable ? "" : "</font>"), (editable ? "" : "<font color=gray>") + (rg.getDescription() == null ? "" : rg.getDescription()).replaceAll(" ", "&nbsp;").replaceAll("\\\n", "<BR>") + (editable ? "" : "</font>")}, new Comparable[]{rg.getName(), rg.getAbbv(), new Integer(rg.isDefaultGroup() != false ? 0 : 1), null, rg.getDescription() == null ? "" : rg.getDescription()});
            haveGlobalRoomGroup = true;
        }
        TreeSet<RoomGroup> departmentRoomGroups = new TreeSet<RoomGroup>();
        for (Department d : Department.getUserDepartments(this.sessionContext.getUser())) {
            if (!"All".equals(roomGroupListForm.getDeptCodeX()) && !d.getDeptCode().equals(roomGroupListForm.getDeptCodeX())) continue;
            departmentRoomGroups.addAll(RoomGroup.getAllDepartmentRoomGroups(d));
        }
        if (department != null && department.isExternalManager().booleanValue()) {
            departmentRoomGroups.addAll(RoomGroup.getAllDepartmentRoomGroups(department));
        }
        for (RoomGroup rg : departmentRoomGroups) {
            boolean editable = this.sessionContext.hasPermission(rg, Right.DepartmenalRoomGroupEdit);
            String ownerName = "<span title='" + rg.getDepartment().getHtmlTitle() + "'>" + rg.getDepartment().getShortLabel() + "</span>";
            TreeSet<Location> rs = new TreeSet<Location>(rg.getRooms());
            StringBuffer assignedRoom = new StringBuffer();
            for (Location r : rs) {
                if (examType != null) {
                    if (!r.isExamEnabled(examType)) {
                        continue;
                    }
                } else {
                    boolean skip = true;
                    for (RoomDept rd : r.getRoomDepts()) {
                        if (!rg.getDepartment().equals(rd.getDepartment())) continue;
                        skip = false;
                        break;
                    }
                    if (skip) continue;
                }
                if (assignedRoom.length() > 0) {
                    assignedRoom.append(", ");
                }
                assignedRoom.append(r.getLabel().replaceAll(" ", "&nbsp;"));
            }
            departmentWebTable.addLine(editable ? "onClick=\"document.location='roomGroupEdit.do?doit=editRoomGroup&id=" + rg.getUniqueId() + "';\"" : null, new String[]{"<A name=\"A" + rg.getUniqueId() + "\"></A>" + (editable ? "" : "<font color=gray>") + rg.getName().replaceAll(" ", "&nbsp;") + (editable ? "" : "</font>"), (editable ? "" : "<font color=gray>") + rg.getAbbv().replaceAll(" ", "&nbsp;") + (editable ? "" : "</font>"), (editable ? "" : "<font color=gray>") + ownerName + (editable ? "" : "</font>"), (editable ? "" : "<font color=gray>") + assignedRoom + (editable ? "" : "</font>"), (editable ? "" : "<font color=gray>") + (rg.getDescription() == null ? "" : rg.getDescription()).replaceAll(" ", "&nbsp;").replaceAll("\\\n", "<BR>") + (editable ? "" : "</font>")}, new Comparable[]{rg.getName(), rg.getAbbv(), ownerName, null, rg.getDescription() == null ? "" : rg.getDescription()});
        }
        if (haveGlobalRoomGroup) {
            request.setAttribute("roomGroupsGlobal", (Object)globalWebTable.printTable(WebTable.getOrder(this.sessionContext, "roomGroupList.gord")));
        } else {
            request.removeAttribute("roomGroupsGlobal");
        }
        if (!departmentRoomGroups.isEmpty()) {
            request.setAttribute("roomGroupsDepartment", (Object)departmentWebTable.printTable(WebTable.getOrder(this.sessionContext, "roomGroupList.mord")));
        } else {
            request.removeAttribute("roomGroupsDepartment");
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void printPdfGroupTable(OutputStream out, SessionContext context, RoomGroupListForm roomGroupListForm) throws Exception {
        void var12_19;
        void var12_17;
        PdfPTable pdfTable;
        PdfWebTable table;
        boolean skip;
        boolean deptCheck;
        PdfWebTable globalWebTable = new PdfWebTable(5, "Global Room Groups", null, new String[]{"Name", "Abbreviation", "Default ", "Rooms", "Description"}, new String[]{"left", "left", "middle", "left", "left"}, new boolean[]{true, true, true, true, true});
        PdfWebTable departmentWebTable = new PdfWebTable(5, "Department Room Groups", null, new String[]{"Name", "Abbreviation", "Department ", "Rooms", "Description"}, new String[]{"left", "left", "left", "left", "left"}, new boolean[]{true, true, true, true, true});
        TreeSet<Department> depts = Department.getUserDepartments(context.getUser());
        Long examType = null;
        Department department = null;
        if (roomGroupListForm.getDeptCodeX() != null && roomGroupListForm.getDeptCodeX().matches("Exam[0-9]*")) {
            examType = Long.valueOf(roomGroupListForm.getDeptCodeX().substring(4));
        } else if (roomGroupListForm.getDeptCodeX() != null && !roomGroupListForm.getDeptCodeX().isEmpty() && !"All".equals(roomGroupListForm.getDeptCodeX())) {
            department = Department.findByDeptCode(roomGroupListForm.getDeptCodeX(), context.getUser().getCurrentAcademicSessionId());
        }
        boolean bl = deptCheck = examType == null && !context.getUser().getCurrentAuthority().hasRight(Right.DepartmentIndependent);
        if (department != null) {
            deptCheck = true;
            depts = new TreeSet();
            depts.add(department);
        }
        boolean splitRows = false;
        boolean haveGlobalRoomGroup = false;
        for (RoomGroup roomGroup : RoomGroup.getAllGlobalRoomGroups(context.getUser().getCurrentAcademicSessionId())) {
            TreeSet<Location> rs = new TreeSet<Location>(roomGroup.getRooms());
            StringBuffer assignedRoom = new StringBuffer();
            int nrRows = 0;
            boolean haveRooms = false;
            for (Location r : rs) {
                if (examType != null && !r.isExamEnabled(examType)) continue;
                if (deptCheck) {
                    skip = true;
                    for (RoomDept rd : r.getRoomDepts()) {
                        if (!depts.contains(rd.getDepartment())) continue;
                        skip = false;
                        break;
                    }
                    if (skip) continue;
                }
                if (assignedRoom.length() > 0) {
                    assignedRoom.append(", ");
                }
                if (PdfWebTable.getWidthOfLastLine(assignedRoom.toString(), false, false) > 750.0f) {
                    assignedRoom.append("\n");
                    ++nrRows;
                }
                assignedRoom.append(r.getLabel());
                haveRooms = true;
            }
            if (nrRows > 40) {
                splitRows = true;
            }
            if (!haveRooms && !context.hasPermission(roomGroup, Right.GlobalRoomGroupEdit)) continue;
            globalWebTable.addLine(null, new String[]{roomGroup.getName(), roomGroup.getAbbv(), roomGroup.isDefaultGroup() != false ? "Yes" : "No", assignedRoom.toString(), roomGroup.getDescription() == null ? "" : roomGroup.getDescription()}, new Comparable[]{roomGroup.getName(), roomGroup.getAbbv(), new Integer(roomGroup.isDefaultGroup() != false ? 0 : 1), null, roomGroup.getDescription() == null ? "" : roomGroup.getDescription()});
            haveGlobalRoomGroup = true;
        }
        TreeSet<RoomGroup> departmentRoomGroups = new TreeSet<RoomGroup>();
        for (Department d : Department.getUserDepartments(context.getUser())) {
            if (!"All".equals(roomGroupListForm.getDeptCodeX()) && !d.getDeptCode().equals(roomGroupListForm.getDeptCodeX())) continue;
            departmentRoomGroups.addAll(RoomGroup.getAllDepartmentRoomGroups(d));
        }
        if (department != null && department.isExternalManager().booleanValue()) {
            departmentRoomGroups.addAll(RoomGroup.getAllDepartmentRoomGroups(department));
        }
        for (RoomGroup rg : departmentRoomGroups) {
            String ownerName = rg.getDepartment().getShortLabel();
            TreeSet<Location> rs = new TreeSet<Location>(rg.getRooms());
            StringBuffer assignedRoom = new StringBuffer();
            for (Location r : rs) {
                if (examType != null) {
                    if (!r.isExamEnabled(examType)) {
                        continue;
                    }
                } else {
                    skip = true;
                    for (RoomDept rd : r.getRoomDepts()) {
                        if (!rg.getDepartment().equals(rd.getDepartment())) continue;
                        skip = false;
                        break;
                    }
                    if (skip) continue;
                }
                if (assignedRoom.length() > 0) {
                    assignedRoom.append(", ");
                }
                if (PdfWebTable.getWidthOfLastLine(assignedRoom.toString(), false, false) > 750.0f) {
                    assignedRoom.append("\n");
                }
                assignedRoom.append(r.getLabel());
            }
            departmentWebTable.addLine(null, new String[]{rg.getName(), rg.getAbbv(), ownerName, assignedRoom.toString(), rg.getDescription() == null ? "" : rg.getDescription()}, new Comparable[]{rg.getName(), rg.getAbbv(), ownerName, null, rg.getDescription() == null ? "" : rg.getDescription()});
        }
        Object var12_15 = null;
        if (haveGlobalRoomGroup) {
            table = globalWebTable;
            pdfTable = table.printPdfTable(WebTable.getOrder(context, "roomGroupList.gord"));
            pdfTable.setSplitRows(splitRows);
            if (var12_15 == null) {
                Document document = new Document(new Rectangle(60.0f + table.getWidth(), 60.0f + 0.75f * table.getWidth()), 30.0f, 30.0f, 30.0f, 30.0f);
                PdfWriter iWriter = PdfWriter.getInstance((Document)document, (OutputStream)out);
                iWriter.setPageEvent((PdfPageEvent)new PdfEventHandler());
                document.open();
            }
            var12_17.add((Element)new Paragraph(table.getName(), PdfFont.getBigFont(true)));
            var12_17.add((Element)pdfTable);
        }
        if (!departmentRoomGroups.isEmpty()) {
            table = departmentWebTable;
            pdfTable = table.printPdfTable(WebTable.getOrder(context, "roomGroupList.mord"));
            if (var12_17 == null) {
                Document document = new Document(new Rectangle(60.0f + table.getWidth(), 60.0f + 0.75f * table.getWidth()), 30.0f, 30.0f, 30.0f, 30.0f);
                PdfWriter iWriter = PdfWriter.getInstance((Document)document, (OutputStream)out);
                iWriter.setPageEvent((PdfPageEvent)new PdfEventHandler());
                document.open();
            } else {
                var12_17.setPageSize(new Rectangle(60.0f + table.getWidth(), 60.0f + 0.75f * table.getWidth()));
                var12_17.newPage();
            }
            var12_19.add((Element)new Paragraph(table.getName(), PdfFont.getBigFont(true)));
            var12_19.add((Element)pdfTable);
        }
        if (var12_19 != null) {
            var12_19.close();
        }
    }
}

