/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import com.lowagie.text.Document;
import com.lowagie.text.Element;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfPageEvent;
import com.lowagie.text.pdf.PdfWriter;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessages;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.unitime.commons.web.WebTable;
import org.unitime.timetable.defaults.SessionAttribute;
import org.unitime.timetable.form.RoomFeatureListForm;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentRoomFeature;
import org.unitime.timetable.model.ExamType;
import org.unitime.timetable.model.GlobalRoomFeature;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.RoomDept;
import org.unitime.timetable.model.RoomFeature;
import org.unitime.timetable.model.RoomFeatureType;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.ExportUtils;
import org.unitime.timetable.util.LookupTables;
import org.unitime.timetable.util.PdfEventHandler;
import org.unitime.timetable.util.PdfFont;
import org.unitime.timetable.webutil.PdfWebTable;

@Service(value="/roomFeatureList")
public class RoomFeatureListAction
extends Action {
    @Autowired
    SessionContext sessionContext;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Department department;
        RoomFeatureListForm roomFeatureListForm = (RoomFeatureListForm)form;
        this.sessionContext.checkPermission(Right.RoomFeatures);
        ActionMessages errors = new ActionMessages();
        String deptCode = (String)request.getAttribute("deptCode");
        if (deptCode != null) {
            roomFeatureListForm.setDeptCodeX(deptCode);
        }
        if (this.sessionContext.getAttribute(SessionAttribute.DepartmentCodeRoom) != null && roomFeatureListForm.getDeptCodeX() == null && (deptCode = (String)this.sessionContext.getAttribute(SessionAttribute.DepartmentCodeRoom)) != null && ("All".equals(deptCode) || deptCode.matches("Exam[0-9]*") || this.sessionContext.hasPermission((Serializable)((Object)deptCode), "Department", Right.RoomFeatures))) {
            roomFeatureListForm.setDeptCodeX((String)this.sessionContext.getAttribute(SessionAttribute.DepartmentCodeRoom));
        }
        if (roomFeatureListForm.getDeptCodeX() != null && !roomFeatureListForm.getDeptCodeX().isEmpty()) {
            this.sessionContext.setAttribute(SessionAttribute.DepartmentCodeRoom, (Object)roomFeatureListForm.getDeptCodeX());
        }
        errors = roomFeatureListForm.validate(mapping, request);
        LookupTables.setupDepartments(request, this.sessionContext, true);
        LookupTables.setupExamTypes(request, this.sessionContext.getUser().getCurrentAcademicSessionId());
        if (errors.size() > 0) {
            this.saveErrors(request, errors);
            return mapping.findForward("showRoomFeatureSearch");
        }
        roomFeatureListForm.setGlobalRoomFeatures(RoomFeature.getAllGlobalRoomFeatures(this.sessionContext.getUser().getCurrentAcademicSessionId()));
        TreeSet<DepartmentRoomFeature> departmentRoomFeatures = new TreeSet<DepartmentRoomFeature>();
        for (Department d : Department.getUserDepartments(this.sessionContext.getUser())) {
            if (!"All".equals(roomFeatureListForm.getDeptCodeX()) && !d.getDeptCode().equals(roomFeatureListForm.getDeptCodeX())) continue;
            departmentRoomFeatures.addAll(RoomFeature.getAllDepartmentRoomFeatures(d));
        }
        if (roomFeatureListForm.getDeptCodeX() != null && !roomFeatureListForm.getDeptCodeX().isEmpty() && !"All".equals(roomFeatureListForm.getDeptCodeX()) && !roomFeatureListForm.getDeptCodeX().matches("Exam[0-9]*") && (department = Department.findByDeptCode(roomFeatureListForm.getDeptCodeX(), this.sessionContext.getUser().getCurrentAcademicSessionId())) != null && department.isExternalManager().booleanValue()) {
            departmentRoomFeatures.addAll(RoomFeature.getAllDepartmentRoomFeatures(department));
        }
        roomFeatureListForm.setDepartmentRoomFeatures(departmentRoomFeatures);
        this.buildFeatureTable(request, roomFeatureListForm);
        if ("Export PDF".equals(request.getParameter("op"))) {
            this.sessionContext.checkPermission(Right.RoomFeaturesExportPdf);
            OutputStream out = ExportUtils.getPdfOutputStream(response, "roomFeatures");
            RoomFeatureListAction.printPdfFeatureTable(out, this.sessionContext, roomFeatureListForm);
            out.flush();
            out.close();
            return null;
        }
        return mapping.findForward("showRoomFeatureList");
    }

    private void buildFeatureTable(HttpServletRequest request, RoomFeatureListForm roomFeatureListForm) throws Exception {
        boolean deptCheck;
        WebTable.setOrder(this.sessionContext, "roomFeatureList.gord", request.getParameter("gord"), 1);
        WebTable.setOrder(this.sessionContext, "roomFeatureList.mord", request.getParameter("mord"), 1);
        boolean hasTypes = RoomFeatureType.hasFeatureTypes(this.sessionContext.getUser().getCurrentAcademicSessionId());
        WebTable globalWebTable = new WebTable(5, "Global Room Features", "roomFeatureList.do?gord=%%", new String[]{"Name", "Abbreviation", hasTypes ? "Type" : "", "", "Rooms"}, new String[]{"left", "left", "left", "left", "left"}, new boolean[]{true, true, true, true, true});
        WebTable departmentWebTable = new WebTable(5, "Department Room Features", "roomFeatureList.do?mord=%%", new String[]{"Name", "Abbreviation", hasTypes ? "Type" : "", "Department", "Rooms"}, new String[]{"left", "left", "left", "left", "left"}, new boolean[]{true, true, true, true, true});
        TreeSet<Department> depts = Department.getUserDepartments(this.sessionContext.getUser());
        Long examType = null;
        Department department = null;
        if ("Exam".equals(roomFeatureListForm.getDeptCodeX())) {
            TreeSet<ExamType> types = ExamType.findAllUsed(this.sessionContext.getUser().getCurrentAcademicSessionId());
            if (!types.isEmpty()) {
                examType = types.first().getUniqueId();
                roomFeatureListForm.setDeptCodeX("Exam" + examType);
            }
        } else if (roomFeatureListForm.getDeptCodeX() != null && roomFeatureListForm.getDeptCodeX().matches("Exam[0-9]*")) {
            examType = Long.valueOf(roomFeatureListForm.getDeptCodeX().substring(4));
        } else if (roomFeatureListForm.getDeptCodeX() != null && !roomFeatureListForm.getDeptCodeX().isEmpty() && !"All".equals(roomFeatureListForm.getDeptCodeX())) {
            department = Department.findByDeptCode(roomFeatureListForm.getDeptCodeX(), this.sessionContext.getUser().getCurrentAcademicSessionId());
        }
        boolean bl = deptCheck = examType == null && !this.sessionContext.getUser().getCurrentAuthority().hasRight(Right.DepartmentIndependent);
        if (department != null) {
            deptCheck = true;
            depts = new TreeSet();
            depts.add(department);
        }
        Collection globalRoomFeatures = roomFeatureListForm.getGlobalRoomFeatures();
        boolean haveGlobalRoomFeature = false;
        for (GlobalRoomFeature gr : globalRoomFeatures) {
            TreeSet<Location> rs = new TreeSet<Location>(gr.getRooms());
            StringBuffer assignedRoom = new StringBuffer();
            boolean haveRooms = false;
            for (Location r : rs) {
                if (examType != null && !r.isExamEnabled(examType)) continue;
                if (deptCheck) {
                    boolean skip = true;
                    for (RoomDept rd : r.getRoomDepts()) {
                        if (!depts.contains(rd.getDepartment())) continue;
                        skip = false;
                        break;
                    }
                    if (skip) continue;
                }
                if (assignedRoom.length() > 0) {
                    assignedRoom.append(", ");
                }
                assignedRoom.append(r.getLabel().replaceAll(" ", "&nbsp;"));
                haveRooms = true;
            }
            boolean editable = this.sessionContext.hasPermission(gr, Right.GlobalRoomFeatureEdit);
            if (!haveRooms && !editable) continue;
            globalWebTable.addLine(editable ? "onClick=\"document.location='roomFeatureEdit.do?doit=editRoomFeature&id=" + gr.getUniqueId() + "';\"" : null, new String[]{"<A name=\"A" + gr.getUniqueId() + "\"></A>" + (editable ? "" : "<font color=gray>") + gr.getLabel().replaceAll(" ", "&nbsp;") + (editable ? "" : "</font>"), (editable ? "" : "<font color=gray>") + gr.getAbbv().replaceAll(" ", "&nbsp;") + (editable ? "" : "</font>"), gr.getFeatureType() == null ? "" : (editable ? "" : "<font color=gray>") + gr.getFeatureType().getLabel().replaceAll(" ", "&nbsp;") + (editable ? "" : "</font>"), "", (editable ? "" : "<font color=gray>") + assignedRoom + (editable ? "" : "</font>")}, new Comparable[]{gr.getLabel(), gr.getAbbv(), gr.getFeatureType() == null ? "" : gr.getFeatureType().getLabel(), "", null});
            haveGlobalRoomFeature = true;
        }
        Collection departmentRoomFeatures = roomFeatureListForm.getDepartmentRoomFeatures();
        for (DepartmentRoomFeature drf : departmentRoomFeatures) {
            boolean editable = this.sessionContext.hasPermission(drf, Right.DepartmenalRoomFeatureEdit);
            String ownerName = "<span title='" + drf.getDepartment().getHtmlTitle() + "'>" + drf.getDepartment().getShortLabel() + "</span>";
            TreeSet<Location> rs = new TreeSet<Location>(drf.getRooms());
            StringBuffer assignedRoom = new StringBuffer();
            for (Location r : rs) {
                if (examType != null) {
                    if (!r.isExamEnabled(examType)) {
                        continue;
                    }
                } else {
                    boolean skip = true;
                    for (RoomDept rd : r.getRoomDepts()) {
                        if (!drf.getDepartment().equals(rd.getDepartment())) continue;
                        skip = false;
                        break;
                    }
                    if (skip) continue;
                }
                if (assignedRoom.length() > 0) {
                    assignedRoom.append(", ");
                }
                assignedRoom.append(r.getLabel().replaceAll(" ", "&nbsp;"));
            }
            departmentWebTable.addLine(editable ? "onClick=\"document.location='roomFeatureEdit.do?doit=editRoomFeature&id=" + drf.getUniqueId() + "';\"" : null, new String[]{"<A name=\"A" + drf.getUniqueId() + "\"></A>" + (editable ? "" : "<font color=gray>") + drf.getLabel().replaceAll(" ", "&nbsp;") + (editable ? "" : "</font>"), (editable ? "" : "<font color=gray>") + drf.getAbbv().replaceAll(" ", "&nbsp;") + (editable ? "" : "</font>"), drf.getFeatureType() == null ? "" : (editable ? "" : "<font color=gray>") + drf.getFeatureType().getLabel().replaceAll(" ", "&nbsp;") + (editable ? "" : "</font>"), (editable ? "" : "<font color=gray>") + ownerName + (editable ? "" : "</font>"), (editable ? "" : "<font color=gray>") + assignedRoom + (editable ? "" : "</font>")}, new Comparable[]{drf.getLabel(), drf.getAbbv(), drf.getFeatureType() == null ? "" : drf.getFeatureType().getLabel(), ownerName, null});
        }
        if (haveGlobalRoomFeature) {
            request.setAttribute("roomFeaturesGlobal", (Object)globalWebTable.printTable(WebTable.getOrder(this.sessionContext, "roomFeatureList.gord")));
        } else {
            request.removeAttribute("roomFeaturesGlobal");
        }
        if (!departmentRoomFeatures.isEmpty()) {
            request.setAttribute("roomFeaturesDepartment", (Object)departmentWebTable.printTable(WebTable.getOrder(this.sessionContext, "roomFeatureList.mord")));
        } else {
            request.removeAttribute("roomFeaturesDepartment");
        }
    }

    public static void printPdfFeatureTable(OutputStream out, SessionContext context, RoomFeatureListForm roomFeatureListForm) throws Exception {
        PdfPTable pdfTable;
        PdfWebTable table;
        boolean skip;
        boolean deptCheck;
        boolean hasTypes = RoomFeatureType.hasFeatureTypes(context.getUser().getCurrentAcademicSessionId());
        PdfWebTable globalWebTable = new PdfWebTable(5, "Global Room Features", null, new String[]{"Name", "Abbreviation", hasTypes ? "Type" : "", "", "Rooms"}, new String[]{"left", "left", "left", "left", "left"}, new boolean[]{true, true, true, true, true});
        PdfWebTable departmentWebTable = new PdfWebTable(5, "Department Room Features", null, new String[]{"Name", "Abbreviation", hasTypes ? "Type" : "", "Department ", "Rooms"}, new String[]{"left", "left", "left", "left", "left"}, new boolean[]{true, true, true, true, true});
        TreeSet<Department> depts = Department.getUserDepartments(context.getUser());
        Long examType = null;
        Department department = null;
        if (roomFeatureListForm.getDeptCodeX() != null && roomFeatureListForm.getDeptCodeX().matches("Exam[0-9]*")) {
            examType = Long.valueOf(roomFeatureListForm.getDeptCodeX().substring(4));
        } else if (roomFeatureListForm.getDeptCodeX() != null && !roomFeatureListForm.getDeptCodeX().isEmpty() && !"All".equals(roomFeatureListForm.getDeptCodeX())) {
            department = Department.findByDeptCode(roomFeatureListForm.getDeptCodeX(), context.getUser().getCurrentAcademicSessionId());
        }
        boolean bl = deptCheck = examType == null && !context.getUser().getCurrentAuthority().hasRight(Right.DepartmentIndependent);
        if (department != null) {
            deptCheck = true;
            depts = new TreeSet();
            depts.add(department);
        }
        boolean splitRows = false;
        Collection globalRoomFeatures = roomFeatureListForm.getGlobalRoomFeatures();
        boolean haveGlobalRoomFeature = false;
        for (GlobalRoomFeature gr : globalRoomFeatures) {
            TreeSet<Location> rs = new TreeSet<Location>(gr.getRooms());
            StringBuffer assignedRoom = new StringBuffer();
            int nrRows = 0;
            boolean haveRooms = false;
            for (Location r : rs) {
                if (examType != null && !r.isExamEnabled(examType)) continue;
                if (deptCheck) {
                    skip = true;
                    for (RoomDept rd : r.getRoomDepts()) {
                        if (!depts.contains(rd.getDepartment())) continue;
                        skip = false;
                        break;
                    }
                    if (skip) continue;
                }
                if (assignedRoom.length() > 0) {
                    assignedRoom.append(", ");
                }
                if (PdfWebTable.getWidthOfLastLine(assignedRoom.toString(), false, false) > 750.0f) {
                    assignedRoom.append("\n");
                    ++nrRows;
                }
                assignedRoom.append(r.getLabel());
                haveRooms = true;
            }
            if (nrRows > 40) {
                splitRows = true;
            }
            if (!haveRooms && !context.hasPermission(gr, Right.GlobalRoomFeatureEdit)) continue;
            globalWebTable.addLine(null, new String[]{gr.getLabel(), gr.getAbbv(), gr.getFeatureType() == null ? "" : gr.getFeatureType().getLabel(), "", assignedRoom.toString()}, new Comparable[]{gr.getLabel(), gr.getAbbv(), gr.getFeatureType() == null ? "" : gr.getFeatureType().getLabel(), "", null});
            haveGlobalRoomFeature = true;
        }
        Collection departmentRoomFeatures = roomFeatureListForm.getDepartmentRoomFeatures();
        for (DepartmentRoomFeature drf : departmentRoomFeatures) {
            String ownerName = drf.getDepartment().getShortLabel();
            TreeSet<Location> rs = new TreeSet<Location>(drf.getRooms());
            StringBuffer assignedRoom = new StringBuffer();
            for (Location r : rs) {
                if (examType != null) {
                    if (!r.isExamEnabled(examType)) {
                        continue;
                    }
                } else {
                    skip = true;
                    for (RoomDept rd : r.getRoomDepts()) {
                        if (!drf.getDepartment().equals(rd.getDepartment())) continue;
                        skip = false;
                        break;
                    }
                    if (skip) continue;
                }
                if (assignedRoom.length() > 0) {
                    assignedRoom.append(", ");
                }
                if (PdfWebTable.getWidthOfLastLine(assignedRoom.toString(), false, false) > 750.0f) {
                    assignedRoom.append("\n");
                }
                assignedRoom.append(r.getLabel());
            }
            departmentWebTable.addLine(null, new String[]{drf.getLabel(), drf.getAbbv(), drf.getFeatureType() == null ? "" : drf.getFeatureType().getLabel(), ownerName, assignedRoom.toString()}, new Comparable[]{drf.getLabel(), drf.getAbbv(), drf.getFeatureType() == null ? "" : drf.getFeatureType().getLabel(), ownerName, null});
        }
        Document doc = null;
        if (haveGlobalRoomFeature) {
            table = globalWebTable;
            pdfTable = table.printPdfTable(WebTable.getOrder(context, "roomFeatureList.gord"));
            pdfTable.setSplitRows(splitRows);
            if (doc == null) {
                doc = new Document(new Rectangle(60.0f + table.getWidth(), 60.0f + 0.75f * table.getWidth()), 30.0f, 30.0f, 30.0f, 30.0f);
                PdfWriter iWriter = PdfWriter.getInstance((Document)doc, (OutputStream)out);
                iWriter.setPageEvent((PdfPageEvent)new PdfEventHandler());
                doc.open();
            }
            doc.add((Element)new Paragraph(table.getName(), PdfFont.getBigFont(true)));
            doc.add((Element)pdfTable);
        }
        if (!departmentRoomFeatures.isEmpty()) {
            table = departmentWebTable;
            pdfTable = table.printPdfTable(WebTable.getOrder(context, "roomFeatureList.mord"));
            if (doc == null) {
                doc = new Document(new Rectangle(60.0f + table.getWidth(), 60.0f + 0.75f * table.getWidth()), 30.0f, 30.0f, 30.0f, 30.0f);
                PdfWriter iWriter = PdfWriter.getInstance((Document)doc, (OutputStream)out);
                iWriter.setPageEvent((PdfPageEvent)new PdfEventHandler());
                doc.open();
            } else {
                doc.setPageSize(new Rectangle(60.0f + table.getWidth(), 60.0f + 0.75f * table.getWidth()));
                doc.newPage();
            }
            doc.add((Element)new Paragraph(table.getName(), PdfFont.getBigFont(true)));
            doc.add((Element)pdfTable);
        }
        if (doc != null) {
            doc.close();
        }
    }
}

