/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.io.Serializable;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.util.MessageResources;
import org.hibernate.Transaction;
import org.hibernate.criterion.Order;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.unitime.commons.Debug;
import org.unitime.timetable.defaults.SessionAttribute;
import org.unitime.timetable.form.RoomFeatureEditForm;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentRoomFeature;
import org.unitime.timetable.model.GlobalRoomFeature;
import org.unitime.timetable.model.RoomFeatureType;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.dao.DepartmentRoomFeatureDAO;
import org.unitime.timetable.model.dao.GlobalRoomFeatureDAO;
import org.unitime.timetable.model.dao.RoomFeatureTypeDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.LookupTables;

@Service(value="/roomFeatureAdd")
public class RoomFeatureAddAction
extends Action {
    @Autowired
    SessionContext sessionContext;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        RoomFeatureEditForm roomFeatureEditForm = (RoomFeatureEditForm)form;
        MessageResources rsc = this.getResources(request);
        String doit = roomFeatureEditForm.getDoit();
        if (doit != null) {
            if (doit.equals(rsc.getMessage("button.addNew"))) {
                ActionMessages errors = new ActionMessages();
                errors = roomFeatureEditForm.validate(mapping, request);
                if (errors.size() == 0) {
                    this.save(mapping, roomFeatureEditForm, request, response);
                    return mapping.findForward("showRoomFeatureList");
                }
                this.saveErrors(request, errors);
            }
            if (doit.equals(rsc.getMessage("button.returnToRoomFeatureList"))) {
                return mapping.findForward("showRoomFeatureList");
            }
        }
        LookupTables.setupDepartments(request, this.sessionContext, false);
        LookupTables.setupExamTypes(request, this.sessionContext.getUser().getCurrentAcademicSessionId());
        request.setAttribute("featureTypes", RoomFeatureTypeDAO.getInstance().findAll(Order.asc((String)"label")));
        TreeSet<Department> departments = Department.getUserDepartments(this.sessionContext.getUser());
        if (departments.size() == 1) {
            roomFeatureEditForm.setDeptCode(departments.first().getDeptCode());
        } else {
            String deptCode = (String)this.sessionContext.getAttribute(SessionAttribute.DepartmentCodeRoom);
            if (!(deptCode == null || deptCode.isEmpty() || deptCode.equals("All") || deptCode.matches("Exam[0-9]*"))) {
                roomFeatureEditForm.setDeptCode(deptCode);
            }
        }
        if (roomFeatureEditForm.getDeptCode() == null || roomFeatureEditForm.getDeptCode().isEmpty() || roomFeatureEditForm.getDeptCode().matches("Exam[0-9]*") || !this.sessionContext.hasPermission((Serializable)((Object)roomFeatureEditForm.getDeptCode()), "Department", Right.DepartmentRoomFeatureAdd)) {
            this.sessionContext.checkPermission(Right.GlobalRoomFeatureAdd);
            roomFeatureEditForm.setGlobal(true);
        } else {
            this.sessionContext.checkPermission((Serializable)((Object)roomFeatureEditForm.getDeptCode()), "Department", Right.DepartmentRoomFeatureAdd);
            roomFeatureEditForm.setGlobal(false);
        }
        roomFeatureEditForm.setSessionId(this.sessionContext.getUser().getCurrentAcademicSessionId());
        return mapping.findForward("showAdd");
    }

    private void save(ActionMapping mapping, RoomFeatureEditForm roomFeatureEditForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (roomFeatureEditForm.isGlobal()) {
            this.sessionContext.checkPermission(Right.GlobalRoomFeatureAdd);
            GlobalRoomFeatureDAO gdao = new GlobalRoomFeatureDAO();
            org.hibernate.Session hibSession = gdao.getSession();
            Transaction tx = null;
            GlobalRoomFeature rf = new GlobalRoomFeature();
            rf.setLabel(roomFeatureEditForm.getName());
            rf.setAbbv(roomFeatureEditForm.getAbbv());
            rf.setSession((Session)SessionDAO.getInstance().get(this.sessionContext.getUser().getCurrentAcademicSessionId()));
            if (roomFeatureEditForm.getFeatureTypeId() != null && roomFeatureEditForm.getFeatureTypeId() >= 0L) {
                rf.setFeatureType((RoomFeatureType)RoomFeatureTypeDAO.getInstance().get(roomFeatureEditForm.getFeatureTypeId()));
            }
            try {
                tx = hibSession.beginTransaction();
                hibSession.saveOrUpdate((Object)rf);
                ChangeLog.addChange(hibSession, this.sessionContext, rf, ChangeLog.Source.ROOM_FEATURE_EDIT, ChangeLog.Operation.CREATE, null, null);
                tx.commit();
                hibSession.refresh((Object)rf);
                request.setAttribute("hash", (Object)("A" + rf.getUniqueId()));
            }
            catch (Exception e) {
                Debug.error(e);
                if (tx != null && tx.isActive()) {
                    tx.rollback();
                }
                throw e;
            }
        }
        Department department = Department.findByDeptCode(roomFeatureEditForm.getDeptCode(), this.sessionContext.getUser().getCurrentAcademicSessionId());
        this.sessionContext.checkPermission(department, Right.DepartmentRoomFeatureAdd);
        DepartmentRoomFeatureDAO ddao = new DepartmentRoomFeatureDAO();
        org.hibernate.Session hibSession = ddao.getSession();
        Transaction tx = null;
        DepartmentRoomFeature rf = new DepartmentRoomFeature();
        rf.setLabel(roomFeatureEditForm.getName());
        rf.setAbbv(roomFeatureEditForm.getAbbv());
        rf.setDepartment(department);
        if (roomFeatureEditForm.getFeatureTypeId() != null && roomFeatureEditForm.getFeatureTypeId() >= 0L) {
            rf.setFeatureType((RoomFeatureType)RoomFeatureTypeDAO.getInstance().get(roomFeatureEditForm.getFeatureTypeId()));
        }
        try {
            tx = hibSession.beginTransaction();
            hibSession.saveOrUpdate((Object)rf);
            ChangeLog.addChange(hibSession, this.sessionContext, rf, ChangeLog.Source.ROOM_FEATURE_EDIT, ChangeLog.Operation.CREATE, null, rf.getDepartment());
            tx.commit();
            hibSession.refresh((Object)rf);
            request.setAttribute("hash", (Object)("A" + rf.getUniqueId()));
        }
        catch (Exception e) {
            Debug.error(e);
            if (tx != null && tx.isActive()) {
                tx.rollback();
            }
            throw e;
        }
    }
}

