/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.io.Serializable;
import java.util.Iterator;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessages;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.unitime.commons.web.WebTable;
import org.unitime.timetable.defaults.SessionAttribute;
import org.unitime.timetable.form.RoomDeptEditForm;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.ExamType;
import org.unitime.timetable.model.GlobalRoomFeature;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.Room;
import org.unitime.timetable.model.RoomDept;
import org.unitime.timetable.model.RoomGroup;
import org.unitime.timetable.model.dao.DepartmentDAO;
import org.unitime.timetable.model.dao.ExamTypeDAO;
import org.unitime.timetable.model.dao.RoomDeptDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;

@Service(value="/roomDeptEdit")
public class RoomDeptEditAction
extends Action {
    @Autowired
    SessionContext sessionContext;

    /*
     * WARNING - void declaration
     */
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ExamType examType;
        RoomDeptEditForm myForm = (RoomDeptEditForm)form;
        Department d = null;
        if (this.sessionContext.getAttribute(SessionAttribute.DepartmentCodeRoom) != null) {
            String deptCode = (String)this.sessionContext.getAttribute(SessionAttribute.DepartmentCodeRoom);
            if (deptCode != null && deptCode.matches("Exam[0-9]*")) {
                myForm.setId(null);
                myForm.setExamType(Long.valueOf(deptCode.substring(4)));
                this.sessionContext.checkPermission(Right.EditRoomDepartmentsExams);
            } else {
                this.sessionContext.checkPermission((Serializable)((Object)deptCode), "Department", Right.EditRoomDepartments);
                d = Department.findByDeptCode(deptCode, this.sessionContext.getUser().getCurrentAcademicSessionId());
                myForm.setId(d.getUniqueId());
                myForm.setExamType(null);
            }
        }
        if (request.getParameter("deptId") != null) {
            String id = request.getParameter("deptId");
            if (id != null && id.matches("Exam[0-9]*")) {
                this.sessionContext.checkPermission(Right.EditRoomDepartmentsExams);
                myForm.setId(null);
                myForm.setExamType(Long.valueOf(id.substring(4)));
            } else {
                d = (Department)new DepartmentDAO().get(Long.valueOf(id));
                this.sessionContext.checkPermission(d, Right.EditRoomDepartments);
                myForm.setId(d.getUniqueId());
                myForm.setExamType(null);
            }
        }
        if (d == null && myForm.getId() != null && myForm.getExamType() < 0L) {
            d = (Department)new DepartmentDAO().get(myForm.getId());
        }
        TreeSet<Room> rooms = new TreeSet<Room>();
        if (this.sessionContext.getUser().getCurrentAuthority().hasRight(Right.DepartmentIndependent)) {
            rooms.addAll(Location.findAllRooms(this.sessionContext.getUser().getCurrentAcademicSessionId()));
        } else {
            for (Department department : Department.getUserDepartments(this.sessionContext.getUser())) {
                for (RoomDept rd : department.getRoomDepts()) {
                    if (!(rd.getRoom() instanceof Room)) continue;
                    rooms.add((Room)rd.getRoom());
                }
            }
        }
        ExamType examType2 = examType = myForm.getExamType() == null ? null : (ExamType)ExamTypeDAO.getInstance().get(myForm.getExamType());
        if (d != null) {
            myForm.setName(d.getDeptCode() + " " + d.getName());
        } else if (examType != null) {
            myForm.setName(examType.getLabel() + "Examination Rooms");
        } else {
            myForm.setName("Unknown");
        }
        String op = myForm.getOp();
        if (request.getParameter("op") != null) {
            op = request.getParameter("op");
        }
        if (request.getParameter("ord") != null && request.getParameter("ord").length() > 0) {
            op = "ord";
        }
        if (op == null) {
            myForm.getAssignedSet().clear();
            if (d == null) {
                for (Location location : Location.findAllExamLocations(this.sessionContext.getUser().getCurrentAcademicSessionId(), examType)) {
                    myForm.getAssignedSet().add(location.getUniqueId());
                }
            } else {
                for (RoomDept rd : d.getRoomDepts()) {
                    myForm.getAssignedSet().add(rd.getRoom().getUniqueId());
                }
            }
        }
        if ("Back".equals(op)) {
            return mapping.findForward("back");
        }
        if ("Update".equals(op)) {
            ActionErrors errors = myForm.validate(mapping, request);
            if (errors.size() == 0) {
                Transaction tx = null;
                try {
                    Session session = new RoomDeptDAO().getSession();
                    tx = session.beginTransaction();
                    for (Location location : rooms) {
                        RoomDept rd;
                        boolean checked;
                        boolean current = d == null ? location.isExamEnabled(examType) : location.hasRoomDept(d);
                        if (current == (checked = myForm.getAssignedSet().contains(location.getUniqueId()))) continue;
                        if (d == null) {
                            location.setExamEnabled(examType, checked);
                            session.update((Object)location);
                            ChangeLog.addChange(session, this.sessionContext, location, ChangeLog.Source.ROOM_DEPT_EDIT, ChangeLog.Operation.UPDATE, null, null);
                            continue;
                        }
                        if (checked) {
                            rd = new RoomDept();
                            rd.setDepartment(d);
                            rd.setRoom(location);
                            rd.setControl(Boolean.FALSE);
                            d.getRoomDepts().add(rd);
                            location.getRoomDepts().add(rd);
                            session.saveOrUpdate((Object)location);
                            session.saveOrUpdate((Object)rd);
                            ChangeLog.addChange(session, this.sessionContext, location, ChangeLog.Source.ROOM_DEPT_EDIT, ChangeLog.Operation.CREATE, null, d);
                            continue;
                        }
                        rd = null;
                        Iterator<RoomDept> j = location.getRoomDepts().iterator();
                        while (rd == null && j.hasNext()) {
                            RoomDept x = j.next();
                            if (!x.getDepartment().equals(d)) continue;
                            rd = x;
                        }
                        ChangeLog.addChange(session, this.sessionContext, location, ChangeLog.Source.ROOM_DEPT_EDIT, ChangeLog.Operation.DELETE, null, d);
                        d.getRoomDepts().remove(rd);
                        location.getRoomDepts().remove(rd);
                        session.saveOrUpdate((Object)rd.getRoom());
                        session.delete((Object)rd);
                        location.removedFromDepartment(d, session);
                    }
                    if (d != null) {
                        session.saveOrUpdate((Object)d);
                    }
                    tx.commit();
                    if (d != null) {
                        session.refresh((Object)d);
                    }
                    return mapping.findForward("back");
                }
                catch (Exception exception) {
                    if (tx != null) {
                        tx.rollback();
                    }
                    throw exception;
                }
            }
            this.saveErrors(request, (ActionMessages)errors);
        }
        WebTable table = d == null ? new WebTable(7, null, "javascript:document.getElementsByName('ord')[0].value=%%;roomDeptEditForm.submit();", new String[]{"Use", "Room", "Capacity", "Exam Capacity", "Type", "Global<br>Groups", "Global<br>Features"}, new String[]{"left", "left", "right", "right", "left", "left", "left", "left"}, new boolean[]{true, true, true, true, true, true, true}) : new WebTable(6, null, "javascript:document.getElementsByName('ord')[0].value=%%;roomDeptEditForm.submit();", new String[]{"Use", "Room", "Capacity", "Type", "Global<br>Groups", "Global<br>Features"}, new String[]{"left", "left", "right", "left", "left", "left"}, new boolean[]{true, true, true, true, true, true});
        for (Location location : rooms) {
            void var14_18;
            boolean checked = myForm.getAssignedSet().contains(location.getUniqueId());
            String string = "";
            String f = "";
            Iterator<Comparable> j = location.getGlobalRoomFeatures().iterator();
            while (j.hasNext()) {
                GlobalRoomFeature grf = j.next();
                f = f + grf.getAbbv();
                if (!j.hasNext()) continue;
                f = f + ", ";
            }
            for (RoomGroup rg : location.getRoomGroups()) {
                void var14_21;
                if (!rg.isGlobal().booleanValue()) continue;
                if (var14_18.length() > 0) {
                    String string2 = (String)var14_18 + ", ";
                }
                String string3 = (String)var14_21 + rg.getAbbv();
            }
            if (d == null) {
                table.addLine(new String[]{"<input type='checkbox' name='assigned' value='" + location.getUniqueId() + "' " + (checked ? "checked='checked'" : "") + ">", location.getLabel(), String.valueOf(location.getCapacity()), String.valueOf(location.getExamCapacity()), location.getRoomTypeLabel(), var14_18, f}, new Comparable[]{Integer.valueOf(!checked ? 1 : 0), location.getLabel(), location.getCapacity(), location.getExamCapacity(), location.getRoomTypeLabel(), null, null});
                continue;
            }
            table.addLine(new String[]{"<input type='checkbox' name='assigned' value='" + location.getUniqueId() + "' " + (checked ? "checked='checked'" : "") + ">", location.getLabel(), String.valueOf(location.getCapacity()), location.getRoomTypeLabel(), var14_18, f}, new Comparable[]{Integer.valueOf(!checked ? 1 : 0), location.getLabel(), location.getCapacity(), location.getRoomTypeLabel(), null, null});
        }
        WebTable.setOrder(this.sessionContext, "RoomDeptEdit.ord", request.getParameter("ord"), d == null ? 4 : 5);
        myForm.setTable(table.printTable(WebTable.getOrder(this.sessionContext, "RoomDeptEdit.ord")));
        return mapping.findForward("show");
    }
}

