/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.unitime.commons.Debug;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.action.InstructionalOfferingSearchAction;
import org.unitime.timetable.defaults.SessionAttribute;
import org.unitime.timetable.form.InstructionalOfferingListForm;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.dao.SubjectAreaDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.solver.service.ClassAssignmentService;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.webutil.BackTracker;

@Service(value="/instructionalOfferingShowSearch")
public class InstructionalOfferingShowSearchAction
extends Action {
    protected static final CourseMessages MSG = Localization.create(CourseMessages.class);
    @Autowired
    SessionContext sessionContext;
    @Autowired
    ClassAssignmentService classAssignmentService;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.sessionContext.checkPermission(Right.InstructionalOfferings);
        BackTracker.markForBack(request, null, null, false, true);
        this.sessionContext.setAttribute("callingPage", (Object)"instructionalOfferingShowSearch");
        InstructionalOfferingListForm frm = (InstructionalOfferingListForm)form;
        Object sa = this.sessionContext.getAttribute(SessionAttribute.OfferingsSubjectArea);
        Object cn = this.sessionContext.getAttribute(SessionAttribute.OfferingsCourseNumber);
        if (Constants.ALL_OPTION_VALUE.equals(sa)) {
            sa = null;
        }
        if ((sa == null || sa.toString().trim().isEmpty()) && (cn == null || cn.toString().trim().isEmpty())) {
            String saStr;
            sa = this.sessionContext.getAttribute(SessionAttribute.ClassesSubjectAreas);
            cn = this.sessionContext.getAttribute(SessionAttribute.ClassesCourseNumber);
            if (sa != null && (saStr = sa.toString()).indexOf(",") > 0) {
                sa = saStr.substring(0, saStr.indexOf(","));
            }
        }
        InstructionalOfferingSearchAction.setupInstrOffrListSpecificFormFilters(this.sessionContext, frm);
        if (!this.sessionContext.hasPermission(Right.Examinations)) {
            frm.setExams(null);
        }
        if (sa != null) {
            try {
                StringBuffer ids = new StringBuffer();
                StringBuffer names = new StringBuffer();
                StringBuffer subjIds = new StringBuffer();
                for (String id : sa.toString().split(",")) {
                    if (names.length() > 0) {
                        names.append(",");
                        subjIds.append(",");
                    }
                    ids.append("&subjectAreaIds=" + id);
                    subjIds.append(id);
                    names.append(((SubjectArea)new SubjectAreaDAO().get(new Long(id))).getSubjectAreaAbbreviation());
                }
                String courseNbr = "";
                if (cn != null && !cn.toString().isEmpty()) {
                    courseNbr = cn.toString();
                }
                Debug.debug("Subject Areas: " + subjIds);
                Debug.debug("Course Number: " + courseNbr);
                frm.setSubjectAreaIds(sa.toString().split(","));
                frm.setCourseNbr(courseNbr);
                if (this.doSearch(request, frm)) {
                    BackTracker.markForBack(request, "instructionalOfferingSearch.do?doit=Search&loadInstrFilter=1" + ids + "&courseNbr=" + frm.getCourseNbr(), "Instructional Offerings (" + names + (frm.getCourseNbr() == null || frm.getCourseNbr().length() == 0 ? "" : " " + frm.getCourseNbr()) + ")", true, true);
                    return mapping.findForward("showInstructionalOfferingList");
                }
            }
            catch (NumberFormatException nfe) {
                Debug.error("Subject Area Id session attribute is corrupted. Resetting ... ");
                this.sessionContext.removeAttribute(SessionAttribute.OfferingsSubjectArea);
                this.sessionContext.removeAttribute(SessionAttribute.OfferingsCourseNumber);
            }
        } else {
            frm.setSubjectAreas(SubjectArea.getUserSubjectAreas(this.sessionContext.getUser()));
            frm.setInstructionalOfferings(null);
            Set s = (Set)frm.getSubjectAreas();
            if (s.size() == 1) {
                Debug.debug("Exactly 1 subject area found ... ");
                frm.setSubjectAreaIds(new String[]{((SubjectArea)s.iterator().next()).getUniqueId().toString()});
                if (this.doSearch(request, frm)) {
                    BackTracker.markForBack(request, "instructionalOfferingSearch.do?doit=Search&loadInstrFilter=1&subjectAreaIds=" + frm.getSubjectAreaIds()[0] + "&courseNbr=" + frm.getCourseNbr(), "Instructional Offerings (" + (frm.getSubjectAreaAbbv() == null ? ((SubjectArea)new SubjectAreaDAO().get(new Long(frm.getSubjectAreaIds()[0]))).getSubjectAreaAbbreviation() : frm.getSubjectAreaAbbv()) + (frm.getCourseNbr() == null || frm.getCourseNbr().length() == 0 ? "" : " " + frm.getCourseNbr()) + ")", true, true);
                    return mapping.findForward("showInstructionalOfferingList");
                }
            }
        }
        return mapping.findForward("showInstructionalOfferingSearch");
    }

    private boolean doSearch(HttpServletRequest request, InstructionalOfferingListForm frm) throws Exception {
        frm.setSubjectAreas(SubjectArea.getUserSubjectAreas(this.sessionContext.getUser()));
        frm.setInstructionalOfferings(InstructionalOfferingSearchAction.getInstructionalOfferings(this.sessionContext.getUser().getCurrentAcademicSessionId(), this.classAssignmentService.getAssignment(), frm));
        return !frm.getInstructionalOfferings().isEmpty();
    }
}

