/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.action.ActionRedirect;
import org.apache.struts.config.ForwardConfig;
import org.apache.struts.util.MessageResources;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.unitime.commons.Debug;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.defaults.CommonValues;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.form.InstructionalOfferingModifyForm;
import org.unitime.timetable.interfaces.ExternalInstrOffrConfigChangeAction;
import org.unitime.timetable.model.BuildingPref;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.DatePattern;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.Preference;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.RoomFeaturePref;
import org.unitime.timetable.model.RoomGroup;
import org.unitime.timetable.model.RoomGroupPref;
import org.unitime.timetable.model.RoomPref;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.StudentClassEnrollment;
import org.unitime.timetable.model.TimePattern;
import org.unitime.timetable.model.TimePref;
import org.unitime.timetable.model.base.BaseClass_;
import org.unitime.timetable.model.base.BaseDatePattern;
import org.unitime.timetable.model.base.BaseDepartment;
import org.unitime.timetable.model.base.BasePreferenceGroup;
import org.unitime.timetable.model.base.BaseSchedulingSubpart;
import org.unitime.timetable.model.comparators.ClassComparator;
import org.unitime.timetable.model.comparators.SchedulingSubpartComparator;
import org.unitime.timetable.model.dao.Class_DAO;
import org.unitime.timetable.model.dao.DatePatternDAO;
import org.unitime.timetable.model.dao.DepartmentDAO;
import org.unitime.timetable.model.dao.InstrOfferingConfigDAO;
import org.unitime.timetable.model.dao.InstructionalOfferingDAO;
import org.unitime.timetable.model.dao.SchedulingSubpartDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.solver.ClassAssignmentProxy;
import org.unitime.timetable.solver.service.AssignmentService;
import org.unitime.timetable.util.LookupTables;

@Service(value="/instructionalOfferingModify")
public class InstructionalOfferingModifyAction
extends Action {
    protected static final CourseMessages MSG = Localization.create(CourseMessages.class);
    @Autowired
    SessionContext sessionContext;
    @Autowired
    AssignmentService<ClassAssignmentProxy> classAssignmentService;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        InstructionalOffering io;
        String deletedClass;
        ActionErrors errors;
        String op;
        MessageResources rsc = this.getResources(request);
        InstructionalOfferingModifyForm frm = (InstructionalOfferingModifyForm)form;
        LookupTables.setupExternalDepts(request, this.sessionContext.getUser().getCurrentAcademicSessionId());
        TreeSet<Department> ts = new TreeSet<Department>();
        for (Department d : (TreeSet)request.getAttribute(Department.EXTERNAL_DEPT_ATTR_NAME)) {
            if (!this.sessionContext.hasPermission(d, Right.MultipleClassSetupDepartment)) continue;
            ts.add(d);
        }
        request.setAttribute(Department.EXTERNAL_DEPT_ATTR_NAME + "list", ts);
        Object object = request.getParameter("op") == null ? (frm.getOp() == null || frm.getOp().length() == 0 ? (request.getAttribute("op") == null ? null : request.getAttribute("op").toString()) : frm.getOp()) : (op = request.getParameter("op"));
        if (op == null) {
            op = request.getParameter("hdnOp");
        }
        if (op == null || op.trim().length() == 0) {
            throw new Exception(MSG.errorOperationNotInterpreted() + op);
        }
        String instrOffrConfigId = "";
        frm.setOp(op);
        if (op.equalsIgnoreCase(MSG.actionClassSetup())) {
            instrOffrConfigId = request.getParameter("uid") == null ? (request.getAttribute("uid") == null ? null : request.getAttribute("uid").toString()) : request.getParameter("uid");
            this.doLoad(request, frm, instrOffrConfigId);
        }
        if (op.equalsIgnoreCase(rsc.getMessage("button.add"))) {
            errors = frm.validate(mapping, request);
            if (errors.size() == 0) {
                String addTemplateClass = frm.getAddTemplateClassId().toString();
                frm.addNewClassesBasedOnTemplate(addTemplateClass);
            } else {
                this.saveErrors(request, (ActionMessages)errors);
            }
        }
        if (op.equalsIgnoreCase(rsc.getMessage("button.moveUp"))) {
            errors = frm.validate(mapping, request);
            if (errors.size() == 0) {
                String moveUpClass = frm.getMoveUpClassId().toString();
                frm.moveClassUp(moveUpClass);
            } else {
                this.saveErrors(request, (ActionMessages)errors);
            }
        }
        if (op.equalsIgnoreCase(rsc.getMessage("button.moveDown"))) {
            errors = frm.validate(mapping, request);
            if (errors.size() == 0) {
                String moveDownClass = frm.getMoveDownClassId().toString();
                frm.moveClassDown(moveDownClass);
            } else {
                this.saveErrors(request, (ActionMessages)errors);
            }
        }
        if (op.equalsIgnoreCase(rsc.getMessage("button.delete")) && (deletedClass = request.getParameter("deletedClassId")) != null && deletedClass.trim().length() > 0) {
            frm.removeFromClasses(deletedClass);
        }
        if (op.equalsIgnoreCase("multipleLimits")) {
            frm.setDisplayMaxLimit(new Boolean(frm.getDisplayMaxLimit() == false));
            if (!frm.getDisplayMaxLimit().booleanValue() && !frm.maxLimitCanBeHidden()) {
                frm.setDisplayMaxLimit(new Boolean(true));
                frm.setDisplayOptionForMaxLimit(new Boolean(true));
            }
        }
        if (op.equalsIgnoreCase(MSG.actionUpdateMultipleClassSetup())) {
            errors = frm.validate(mapping, request);
            if (errors.size() == 0) {
                this.doUpdate(request, frm);
                ActionRedirect redirect = new ActionRedirect((ForwardConfig)mapping.findForward("instructionalOfferingDetail"));
                redirect.addParameter("io", (Object)frm.getInstrOfferingId());
                redirect.addParameter("op", (Object)"view");
                return redirect;
            }
            this.saveErrors(request, (ActionMessages)errors);
        }
        if (frm.getInstrOfferingId() != null && (io = (InstructionalOffering)new InstructionalOfferingDAO().get(frm.getInstrOfferingId())) != null) {
            LookupTables.setupDatePatterns(request, this.sessionContext.getUser(), "Default", null, io.getDepartment(), io.getSession().getDefaultDatePatternNotNull());
        }
        frm.setDirectionsClassesCanMove();
        frm.initalizeSubpartSubtotalsAndDisplayFlags();
        frm.initializeEnableAllClassesForStudentScheduling();
        frm.initializeDisplayAllClassInstructors();
        return mapping.findForward("instructionalOfferingModify");
    }

    private void doLoad(HttpServletRequest request, InstructionalOfferingModifyForm frm, String instrOffrConfigId) throws Exception {
        if (instrOffrConfigId == null || instrOffrConfigId.trim().length() == 0) {
            throw new Exception(MSG.errorMissingIOConfig());
        }
        this.sessionContext.checkPermission((Serializable)((Object)instrOffrConfigId), "InstrOfferingConfig", Right.MultipleClassSetup);
        InstrOfferingConfigDAO iocDao = new InstrOfferingConfigDAO();
        InstrOfferingConfig ioc = (InstrOfferingConfig)iocDao.get(Long.valueOf(instrOffrConfigId));
        InstructionalOffering io = ioc.getInstructionalOffering();
        frm.setDisplayOptionForMaxLimit(CommonValues.Yes.eq(this.sessionContext.getUser().getProperty(UserProperty.VariableClassLimits)));
        frm.setInstrOffrConfigId(ioc.getUniqueId());
        frm.setInstrOffrConfigLimit(ioc.getLimit());
        frm.setInstrOffrConfigUnlimited(ioc.isUnlimitedEnrollment());
        frm.setInstrOfferingId(io.getUniqueId());
        frm.setDisplayDisplayInstructors(ApplicationProperty.ClassSetupDisplayInstructorFlags.isTrue());
        frm.setDisplayEnabledForStudentScheduling(ApplicationProperty.ClassSetupEnabledForStudentScheduling.isTrue());
        frm.setDisplayExternalId(ApplicationProperty.ClassSetupShowExternalIds.isTrue() && !ApplicationProperty.ClassSetupEditExternalIds.isTrue());
        frm.setEditExternalId(ApplicationProperty.ClassSetupEditExternalIds.isTrue());
        String name = io.getCourseNameWithTitle();
        if (io.hasMultipleConfigurations()) {
            name = name + " [" + ioc.getName() + "]";
        }
        frm.setInstrOfferingName(name);
        if (ioc.getSchedulingSubparts() == null || ioc.getSchedulingSubparts().size() == 0) {
            throw new Exception(MSG.errorIOConfigNotDefined());
        }
        ArrayList<SchedulingSubpart> subpartList = new ArrayList<SchedulingSubpart>(ioc.getSchedulingSubparts());
        Collections.sort(subpartList, new SchedulingSubpartComparator());
        ClassAssignmentProxy proxy = this.classAssignmentService.getAssignment();
        frm.setInstrOffrConfigUnlimitedReadOnly(false);
        for (SchedulingSubpart ss : subpartList) {
            if (ss.getClasses() == null || ss.getClasses().size() == 0) {
                throw new Exception(MSG.errorInitialIOSetupIncomplete());
            }
            if (ss.getParentSubpart() != null) continue;
            this.loadClasses(frm, ss.getClasses(), new Boolean(true), new String(), proxy);
        }
        frm.initializeOrigSubparts();
        frm.setDirectionsClassesCanMove();
        frm.initalizeSubpartSubtotalsAndDisplayFlags();
        frm.initializeEnableAllClassesForStudentScheduling();
        frm.initializeDisplayAllClassInstructors();
    }

    private void loadClasses(InstructionalOfferingModifyForm frm, Set classes, Boolean isReadOnly, String indent, ClassAssignmentProxy proxy) {
        if (classes != null && classes.size() > 0) {
            ArrayList classesList = new ArrayList(classes);
            Collections.sort(classesList, new ClassComparator(3));
            Boolean readOnlyClass = new Boolean(false);
            Class_ cls2 = null;
            boolean first = true;
            for (Class_ cls2 : classesList) {
                if (first) {
                    frm.setDisplayEnrollment(new Boolean(StudentClassEnrollment.sessionHasEnrollments(this.sessionContext.getUser().getCurrentAcademicSessionId())));
                    first = false;
                }
                if ((readOnlyClass = isReadOnly == false ? new Boolean(isReadOnly) : new Boolean(!this.sessionContext.hasPermission(cls2, Right.MultipleClassSetupClass))).booleanValue()) {
                    frm.setInstrOffrConfigUnlimitedReadOnly(true);
                }
                frm.addToClasses(cls2, readOnlyClass, indent, proxy, UserProperty.NameFormat.get(this.sessionContext.getUser()));
                this.loadClasses(frm, cls2.getChildClasses(), new Boolean(true), indent + "&nbsp;&nbsp;&nbsp;&nbsp;", proxy);
            }
        }
    }

    private void doUpdate(HttpServletRequest request, InstructionalOfferingModifyForm frm) throws Exception {
        InstrOfferingConfigDAO iocdao = new InstrOfferingConfigDAO();
        InstrOfferingConfig ioc = (InstrOfferingConfig)iocdao.get(frm.getInstrOffrConfigId());
        Session hibSession = iocdao.getSession();
        RoomGroup rg = RoomGroup.getGlobalDefaultRoomGroup(ioc.getSession());
        this.sessionContext.checkPermission(ioc, Right.MultipleClassSetup);
        Transaction tx = null;
        try {
            tx = hibSession.beginTransaction();
            if (frm.isInstrOffrConfigUnlimited() != ioc.isUnlimitedEnrollment().booleanValue()) {
                ioc.setUnlimitedEnrollment(frm.isInstrOffrConfigUnlimited());
                ioc.setLimit(frm.isInstrOffrConfigUnlimited() ? 0 : frm.getInstrOffrConfigLimit());
                hibSession.update((Object)ioc);
            } else if (!frm.getInstrOffrConfigLimit().equals(ioc.getLimit())) {
                ioc.setLimit(frm.getInstrOffrConfigLimit());
                hibSession.update((Object)ioc);
            }
            HashMap<Long, Department> origSubpartManagingDept = new HashMap<Long, Department>();
            if (ioc.getSchedulingSubparts() != null) {
                SchedulingSubpart ss2 = null;
                for (SchedulingSubpart ss2 : ioc.getSchedulingSubparts()) {
                    origSubpartManagingDept.put(ss2.getUniqueId(), ss2.getManagingDept());
                }
            }
            HashMap tmpClassIdsToClasses = this.addClasses(frm, ioc, hibSession);
            this.modifyClasses(frm, ioc, hibSession, rg, tmpClassIdsToClasses);
            this.modifySubparts(ioc, origSubpartManagingDept, rg, hibSession);
            this.deleteClasses(frm, ioc, hibSession, tmpClassIdsToClasses);
            String className = ApplicationProperty.ExternalActionInstrOffrConfigChange.value();
            ExternalInstrOffrConfigChangeAction configChangeAction = null;
            if (className != null && className.trim().length() > 0 && !(configChangeAction = (ExternalInstrOffrConfigChangeAction)Class.forName(className).newInstance()).validateConfigChangeCanOccur(ioc.getInstructionalOffering(), hibSession)) {
                throw new Exception("Configuration change violates rules for Add On, rolling back the change.");
            }
            ioc.getInstructionalOffering().computeLabels(hibSession);
            ChangeLog.addChange(hibSession, this.sessionContext, ioc, ChangeLog.Source.CLASS_SETUP, ChangeLog.Operation.UPDATE, ioc.getInstructionalOffering().getControllingCourseOffering().getSubjectArea(), null);
            tx.commit();
            hibSession.flush();
            hibSession.refresh((Object)ioc);
            hibSession.refresh((Object)ioc.getInstructionalOffering());
            if (configChangeAction != null) {
                configChangeAction.performExternalInstrOffrConfigChangeAction(ioc.getInstructionalOffering(), hibSession);
            }
        }
        catch (Exception e) {
            Debug.error(e);
            try {
                if (tx != null && tx.isActive()) {
                    tx.rollback();
                }
            }
            catch (Exception e1) {
                // empty catch block
            }
            throw e;
        }
    }

    private void modifySubparts(InstrOfferingConfig ioc, HashMap origSubpartManagingDept, RoomGroup rg, Session hibSession) {
        if (ioc.getSchedulingSubparts() != null) {
            SchedulingSubpart ss2 = null;
            Department origManagingDept = null;
            Department currentManagingDept = null;
            TimePref tp2 = null;
            RoomPref rp2 = null;
            BuildingPref bp2 = null;
            RoomFeaturePref rfp2 = null;
            RoomGroupPref rgp2 = null;
            TimePref ntp = null;
            RoomPref nrp = null;
            BuildingPref nbp = null;
            RoomFeaturePref nrfp = null;
            RoomGroupPref nrgp = null;
            Class_ c2 = null;
            HashSet<Comparable> prefObjs = null;
            Department controllingDept = null;
            PreferenceLevel prefLevel = PreferenceLevel.getPreferenceLevel(PreferenceLevel.sRequired);
            for (SchedulingSubpart ss2 : ioc.getSchedulingSubparts()) {
                if (controllingDept == null) {
                    controllingDept = ss2.getControllingDept();
                }
                currentManagingDept = ss2.getManagingDept();
                origManagingDept = (Department)origSubpartManagingDept.get(ss2.getUniqueId());
                if (origManagingDept == null || currentManagingDept.getUniqueId().equals(origManagingDept.getUniqueId())) continue;
                if (!origManagingDept.getUniqueId().equals(controllingDept.getUniqueId()) && ss2.getClasses() != null) {
                    for (Class_ c2 : ss2.getClasses()) {
                        boolean classChanged = false;
                        if (!c2.getManagingDept().getUniqueId().equals(origManagingDept.getUniqueId())) continue;
                        prefObjs = c2.getTimePatterns();
                        for (TimePref tp2 : ss2.getTimePreferences()) {
                            if (prefObjs == null || prefObjs.contains(tp2.getTimePattern())) continue;
                            ntp = new TimePref();
                            ntp.setOwner(c2);
                            ntp.setPrefLevel(prefLevel);
                            ntp.setTimePattern(tp2.getTimePattern());
                            ntp.setPreference(tp2.getPreference());
                            c2.addTopreferences(ntp);
                            classChanged = true;
                        }
                        prefObjs = new HashSet<Comparable>();
                        Iterator it3 = c2.getBuildingPreferences().iterator();
                        while (it3.hasNext()) {
                            prefObjs.add(((BuildingPref)it3.next()).getBuilding());
                        }
                        for (BuildingPref bp2 : ss2.getBuildingPreferences()) {
                            if (prefObjs.contains(bp2.getBuilding())) continue;
                            nbp = new BuildingPref();
                            nbp.setOwner(c2);
                            nbp.setPrefLevel(bp2.getPrefLevel());
                            nbp.setBuilding(bp2.getBuilding());
                            nbp.setDistanceFrom(bp2.getDistanceFrom());
                            c2.addTopreferences(nbp);
                            classChanged = true;
                        }
                        prefObjs = new HashSet();
                        it3 = c2.getRoomPreferences().iterator();
                        while (it3.hasNext()) {
                            prefObjs.add(((RoomPref)it3.next()).getRoom());
                        }
                        for (RoomPref rp2 : ss2.getRoomPreferences()) {
                            if (prefObjs.contains(rp2.getRoom())) continue;
                            nrp = new RoomPref();
                            nrp.setOwner(c2);
                            nrp.setPrefLevel(rp2.getPrefLevel());
                            nrp.setRoom(rp2.getRoom());
                            c2.addTopreferences(nrp);
                            classChanged = true;
                        }
                        prefObjs = new HashSet();
                        it3 = c2.getRoomFeaturePreferences().iterator();
                        while (it3.hasNext()) {
                            prefObjs.add(((RoomFeaturePref)it3.next()).getRoomFeature());
                        }
                        for (RoomFeaturePref rfp2 : ss2.getRoomFeaturePreferences()) {
                            if (prefObjs.contains(rfp2.getRoomFeature())) continue;
                            nrfp = new RoomFeaturePref();
                            nrfp.setOwner(c2);
                            nrfp.setPrefLevel(rfp2.getPrefLevel());
                            nrfp.setRoomFeature(rfp2.getRoomFeature());
                            c2.addTopreferences(nrfp);
                            classChanged = true;
                        }
                        prefObjs = new HashSet();
                        it3 = c2.getRoomGroupPreferences().iterator();
                        while (it3.hasNext()) {
                            prefObjs.add(((RoomGroupPref)it3.next()).getRoomGroup());
                        }
                        for (RoomGroupPref rgp2 : ss2.getRoomGroupPreferences()) {
                            if (prefObjs.contains(rgp2.getRoomGroup())) continue;
                            nrgp = new RoomGroupPref();
                            nrgp.setOwner(c2);
                            nrgp.setPrefLevel(rgp2.getPrefLevel());
                            nrgp.setRoomGroup(rgp2.getRoomGroup());
                            c2.addTopreferences(nrgp);
                            classChanged = true;
                        }
                        if (!classChanged) continue;
                        hibSession.update((Object)c2);
                    }
                }
                ss2.deleteAllDistributionPreferences(hibSession);
                boolean weaken = true;
                if (!currentManagingDept.isExternalManager().booleanValue()) {
                    weaken = false;
                }
                if (weaken && currentManagingDept.isAllowReqTime() != null && currentManagingDept.isAllowReqTime().booleanValue()) {
                    weaken = false;
                }
                if (weaken && ss2.getControllingDept().isAllowReqTime() != null && ss2.getControllingDept().isAllowReqTime().booleanValue()) {
                    weaken = false;
                }
                Set timePrefs = ss2.getTimePreferences();
                HashSet<Preference> prefs = new HashSet<Preference>();
                prefs.addAll(ss2.getPreferences());
                ss2.getPreferences().removeAll(ss2.getPreferences());
                for (TimePref timePref : timePrefs) {
                    tp2 = new TimePref();
                    tp2.setOwner(ss2);
                    tp2.setPrefLevel(timePref.getPrefLevel());
                    tp2.setTimePattern(timePref.getTimePattern());
                    tp2.setPreference(timePref.getPreference());
                    if (weaken) {
                        tp2.weakenHardPreferences();
                    }
                    ss2.addTopreferences(tp2);
                }
                if (currentManagingDept.getUniqueId().equals(controllingDept.getUniqueId()) && rg != null) {
                    rgp2 = new RoomGroupPref();
                    rgp2.setOwner(ss2);
                    rgp2.setPrefLevel(prefLevel);
                    rgp2.setRoomGroup(rg);
                    ss2.addTopreferences(rgp2);
                }
                hibSession.update((Object)ss2);
            }
        }
    }

    private void buildClassList(Set classes, ArrayList lst) {
        if (classes != null && classes.size() > 0) {
            ArrayList classesList = new ArrayList(classes);
            Collections.sort(classesList, new ClassComparator(3));
            Class_ c2 = null;
            for (Class_ c2 : classesList) {
                lst.add(c2);
                this.buildClassList(c2.getChildClasses(), lst);
            }
        }
    }

    private void deleteClasses(InstructionalOfferingModifyForm frm, InstrOfferingConfig ioc, Session hibSession, HashMap tmpClassIdsToRealClasses) {
        if (ioc.getSchedulingSubparts() != null) {
            SchedulingSubpart ss2 = null;
            ArrayList lst = new ArrayList();
            ArrayList<SchedulingSubpart> subpartList = new ArrayList<SchedulingSubpart>(ioc.getSchedulingSubparts());
            Collections.sort(subpartList, new SchedulingSubpartComparator());
            for (SchedulingSubpart ss2 : subpartList) {
                if (ss2.getParentSubpart() != null) continue;
                this.buildClassList(ss2.getClasses(), lst);
            }
            for (int i = lst.size() - 1; i >= 0; --i) {
                Class_ c = (Class_)lst.get(i);
                if (frm.getClassIds().contains(c.getUniqueId().toString()) || tmpClassIdsToRealClasses.containsValue(c)) continue;
                if (c.getParentClass() != null) {
                    Class_ parent = c.getParentClass();
                    parent.getChildClasses().remove(c);
                    hibSession.update((Object)parent);
                }
                c.getSchedulingSubpart().getClasses().remove(c);
                if (c.getPreferences() != null) {
                    c.getPreferences().removeAll(c.getPreferences());
                }
                c.deleteAllDependentObjects(hibSession, false);
                hibSession.delete((Object)c);
            }
        }
    }

    private HashMap addClasses(InstructionalOfferingModifyForm frm, InstrOfferingConfig ioc, Session hibSession) {
        ListIterator it12;
        HashMap<Long, Class_> tmpClsToRealClass = new HashMap<Long, Class_>();
        SchedulingSubpartDAO ssdao = new SchedulingSubpartDAO();
        BasePreferenceGroup ss = null;
        Class_DAO cdao = new Class_DAO();
        BasePreferenceGroup parentClass = null;
        DepartmentDAO deptdao = new DepartmentDAO();
        BasePreferenceGroup managingDept = null;
        DatePatternDAO dpdao = new DatePatternDAO();
        BaseDatePattern dp = null;
        ListIterator it1 = frm.getClassIds().listIterator();
        ListIterator it2 = frm.getSubpartIds().listIterator();
        ListIterator it3 = frm.getParentClassIds().listIterator();
        ListIterator it4 = frm.getMinClassLimits().listIterator();
        ListIterator it5 = frm.getDepartments().listIterator();
        ListIterator it6 = frm.getDatePatterns().listIterator();
        ListIterator it7 = frm.getNumberOfRooms().listIterator();
        ListIterator it8 = frm.getMaxClassLimits().listIterator();
        ListIterator it9 = frm.getRoomRatios().listIterator();
        ListIterator it10 = frm.getDisplayInstructors().listIterator();
        ListIterator it11 = frm.getEnabledForStudentScheduling().listIterator();
        ListIterator listIterator = it12 = frm.getEditExternalId() != false ? frm.getExternalIds().listIterator() : null;
        while (it1.hasNext()) {
            String suffix;
            Long classId = new Long(it1.next().toString());
            Long subpartId = new Long(it2.next().toString());
            String parentId = it3.next().toString();
            Long parentClassId = null;
            if (parentId.length() != 0) {
                parentClassId = new Long(parentId);
            }
            Integer minClassLimit = new Integer(it4.next().toString());
            String managingDeptIdString = (String)it5.next();
            Long managingDeptId = null;
            if (managingDeptIdString.length() != 0) {
                managingDeptId = new Long(managingDeptIdString);
            }
            String datePatternId = it6.next().toString();
            Long datePattern = null;
            if (datePatternId.length() != 0) {
                datePattern = new Long(datePatternId);
            }
            Integer numberOfRooms = new Integer(it7.next().toString());
            Integer maxClassLimit = new Integer(it8.next().toString());
            Float roomRatio = new Float(it9.next().toString());
            if (frm.isInstrOffrConfigUnlimited()) {
                roomRatio = Float.valueOf(1.0f);
                minClassLimit = 0;
                maxClassLimit = 0;
                numberOfRooms = 0;
            }
            String displayInstructorStr = null;
            if (it10.hasNext()) {
                displayInstructorStr = (String)it10.next();
            }
            Boolean displayInstructor = new Boolean(false);
            if (displayInstructorStr != null && displayInstructorStr.length() > 0) {
                displayInstructor = new Boolean(true);
            }
            String enabledForStudentSchedulingStr = null;
            if (it11.hasNext()) {
                enabledForStudentSchedulingStr = (String)it11.next();
            }
            Boolean enabledForStudentScheduling = new Boolean(false);
            if (enabledForStudentSchedulingStr != null && enabledForStudentSchedulingStr.length() > 0) {
                enabledForStudentScheduling = new Boolean(true);
            }
            String string = suffix = it12 == null ? null : it12.next().toString();
            if (suffix != null && suffix.isEmpty()) {
                suffix = null;
            }
            if (classId >= 0L) continue;
            Class_ newClass = new Class_();
            if (ss == null || !ss.getUniqueId().equals(subpartId)) {
                ss = (SchedulingSubpart)ssdao.get(subpartId);
            }
            newClass.setSchedulingSubpart((SchedulingSubpart)ss);
            ((BaseSchedulingSubpart)ss).addToclasses(newClass);
            if (parentClassId != null) {
                if (!(parentClassId <= 0L || parentClass != null && parentClass.getUniqueId().equals(parentClassId))) {
                    parentClass = (Class_)cdao.get(parentClassId);
                } else if (parentClassId < 0L) {
                    parentClass = (Class_)tmpClsToRealClass.get(parentClassId);
                }
                newClass.setParentClass((Class_)parentClass);
                ((BaseClass_)parentClass).addTochildClasses(newClass);
            }
            if (managingDept == null || !managingDept.getUniqueId().equals(managingDeptId)) {
                managingDept = (Department)deptdao.get(managingDeptId);
            }
            newClass.setControllingDept(((SchedulingSubpart)ss).getControllingDept());
            newClass.setManagingDept((Department)managingDept);
            if (dp == null || !dp.getUniqueId().equals(datePattern)) {
                dp = (DatePattern)dpdao.get(datePattern);
            }
            newClass.setDatePattern((DatePattern)dp);
            newClass.setExpectedCapacity(minClassLimit);
            newClass.setNbrRooms(numberOfRooms);
            newClass.setMaxExpectedCapacity(maxClassLimit);
            newClass.setRoomRatio(roomRatio);
            newClass.setDisplayInstructor(displayInstructor);
            newClass.setEnabledForStudentScheduling(enabledForStudentScheduling);
            newClass.setClassSuffix(suffix);
            hibSession.save((Object)newClass);
            hibSession.save((Object)ss);
            tmpClsToRealClass.put(classId, newClass);
        }
        return tmpClsToRealClass;
    }

    private void modifyClasses(InstructionalOfferingModifyForm frm, InstrOfferingConfig ioc, Session hibSession, RoomGroup rg, HashMap tmpClassIdsToRealClasses) {
        ListIterator it11;
        Class_DAO cdao = new Class_DAO();
        DepartmentDAO deptdao = new DepartmentDAO();
        BasePreferenceGroup managingDept = null;
        DatePatternDAO dpdao = new DatePatternDAO();
        BaseDatePattern dp = null;
        ListIterator it1 = frm.getClassIds().listIterator();
        ListIterator it2 = frm.getMinClassLimits().listIterator();
        ListIterator it3 = frm.getDepartments().listIterator();
        ListIterator it4 = frm.getDatePatterns().listIterator();
        ListIterator it5 = frm.getNumberOfRooms().listIterator();
        ListIterator it6 = frm.getMaxClassLimits().listIterator();
        ListIterator it7 = frm.getRoomRatios().listIterator();
        ListIterator it8 = frm.getDisplayInstructors().listIterator();
        ListIterator it9 = frm.getEnabledForStudentScheduling().listIterator();
        ListIterator it10 = frm.getParentClassIds().listIterator();
        ListIterator listIterator = it11 = frm.getEditExternalId() != false ? frm.getExternalIds().listIterator() : null;
        while (it1.hasNext()) {
            Boolean displayEnabledForStudentScheduling;
            Boolean displayInstructorFlags;
            Long classId = new Long(it1.next().toString());
            Integer minClassLimit = new Integer(it2.next().toString());
            Long managingDeptId = new Long(it3.next().toString());
            String datePatternId = it4.next().toString();
            Long datePattern = null;
            if (datePatternId.length() != 0) {
                datePattern = new Long(datePatternId);
            }
            Integer numberOfRooms = new Integer(it5.next().toString());
            Integer maxClassLimit = new Integer(it6.next().toString());
            Float roomRatio = new Float(it7.next().toString());
            if (frm.isInstrOffrConfigUnlimited()) {
                roomRatio = Float.valueOf(1.0f);
                minClassLimit = 0;
                maxClassLimit = 0;
                numberOfRooms = 0;
            }
            String displayInstructorStr = null;
            if (it8.hasNext()) {
                displayInstructorStr = (String)it8.next();
            }
            Boolean displayInstructor = new Boolean(false);
            if (displayInstructorStr != null && displayInstructorStr.length() > 0) {
                displayInstructor = new Boolean(true);
            }
            String enabledForStudentSchedulingStr = null;
            if (it9.hasNext()) {
                enabledForStudentSchedulingStr = (String)it9.next();
            }
            Boolean enabledForStudentScheduling = new Boolean(false);
            if (enabledForStudentSchedulingStr != null && enabledForStudentSchedulingStr.length() > 0) {
                enabledForStudentScheduling = new Boolean(true);
            }
            String suffix = it11 != null ? it11.next().toString() : null;
            Long parentClassId = null;
            String parentClassIdString = (String)it10.next();
            if (parentClassIdString != null && parentClassIdString.length() > 0) {
                parentClassId = new Long(parentClassIdString);
            }
            if (classId <= 0L) continue;
            boolean changed = false;
            Class_ modifiedClass = (Class_)cdao.get(classId);
            if (modifiedClass.getParentClass() != null && parentClassId != null && !modifiedClass.getParentClass().getUniqueId().equals(parentClassId)) {
                Class_ origParent = modifiedClass.getParentClass();
                if (parentClassId < 0L) {
                    modifiedClass.setParentClass((Class_)tmpClassIdsToRealClasses.get(parentClassId));
                } else {
                    modifiedClass.setParentClass((Class_)cdao.get(parentClassId));
                }
                hibSession.update((Object)modifiedClass.getParentClass());
                hibSession.update((Object)origParent);
            }
            if (managingDeptId.equals(new Long(-1L))) {
                managingDeptId = modifiedClass.getControllingDept().getUniqueId();
            }
            if (!modifiedClass.getManagingDept().getUniqueId().equals(managingDeptId)) {
                changed = true;
                if (managingDept == null || !managingDept.getUniqueId().equals(managingDeptId)) {
                    managingDept = (Department)deptdao.get(managingDeptId);
                }
                modifiedClass.setManagingDept((Department)managingDept);
                Set timePrefs = modifiedClass.getTimePreferences();
                HashSet<Preference> prefs = new HashSet<Preference>();
                prefs.addAll(modifiedClass.getPreferences());
                modifiedClass.getPreferences().removeAll(prefs);
                boolean weaken = true;
                if (!((BaseDepartment)managingDept).isExternalManager().booleanValue()) {
                    weaken = false;
                }
                if (weaken && ((BaseDepartment)managingDept).isAllowReqTime() != null && ((BaseDepartment)managingDept).isAllowReqTime().booleanValue()) {
                    weaken = false;
                }
                if (weaken && modifiedClass.getControllingDept().isAllowReqTime() != null && modifiedClass.getControllingDept().isAllowReqTime().booleanValue()) {
                    weaken = false;
                }
                for (TimePref timePref : timePrefs) {
                    TimePattern timePattern = timePref.getTimePattern();
                    if (5 == timePattern.getType()) continue;
                    TimePref tp = new TimePref();
                    tp.setOwner(modifiedClass);
                    tp.setPrefLevel(timePref.getPrefLevel());
                    tp.setTimePattern(timePattern);
                    tp.setPreference(timePref.getPreference());
                    if (weaken) {
                        tp.weakenHardPreferences();
                    }
                    modifiedClass.addTopreferences(tp);
                }
                modifiedClass.deleteAllDistributionPreferences(hibSession);
            }
            if (modifiedClass.getDatePattern() == null && datePattern != null || modifiedClass.getDatePattern() != null && !modifiedClass.getDatePattern().getUniqueId().equals(datePattern)) {
                changed = true;
                if (dp == null || !dp.getUniqueId().equals(datePattern)) {
                    dp = (DatePattern)dpdao.get(datePattern);
                }
                modifiedClass.setDatePattern((DatePattern)dp);
            }
            if (!modifiedClass.getExpectedCapacity().equals(minClassLimit)) {
                changed = true;
                modifiedClass.setExpectedCapacity(minClassLimit);
            }
            if (!modifiedClass.getNbrRooms().equals(numberOfRooms)) {
                changed = true;
                modifiedClass.setNbrRooms(numberOfRooms);
            }
            if (!modifiedClass.getMaxExpectedCapacity().equals(maxClassLimit)) {
                changed = true;
                modifiedClass.setMaxExpectedCapacity(maxClassLimit);
            }
            if (!modifiedClass.getRoomRatio().equals(roomRatio)) {
                changed = true;
                modifiedClass.setRoomRatio(roomRatio);
            }
            if ((displayInstructorFlags = Boolean.valueOf(ApplicationProperty.ClassSetupDisplayInstructorFlags.isTrue())).booleanValue() && !modifiedClass.isDisplayInstructor().equals(displayInstructor)) {
                changed = true;
                modifiedClass.setDisplayInstructor(displayInstructor);
            }
            if ((displayEnabledForStudentScheduling = Boolean.valueOf(ApplicationProperty.ClassSetupEnabledForStudentScheduling.isTrue())).booleanValue() && !modifiedClass.isEnabledForStudentScheduling().equals(enabledForStudentScheduling)) {
                changed = true;
                modifiedClass.setEnabledForStudentScheduling(enabledForStudentScheduling);
            }
            if (suffix != null) {
                if (suffix.isEmpty()) {
                    suffix = null;
                }
                if (suffix == null ? modifiedClass.getClassSuffix() != null : !suffix.equals(modifiedClass.getClassSuffix())) {
                    modifiedClass.setClassSuffix(suffix);
                    changed = true;
                }
            }
            if (!changed) continue;
            hibSession.update((Object)modifiedClass);
        }
    }
}

