/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.util.MessageResources;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.unitime.commons.Debug;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.defaults.SessionAttribute;
import org.unitime.timetable.form.DistributionPrefsForm;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DistributionObject;
import org.unitime.timetable.model.DistributionPref;
import org.unitime.timetable.model.DistributionType;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.PreferenceGroup;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.base.BaseDepartment;
import org.unitime.timetable.model.base.BasePreferenceGroup;
import org.unitime.timetable.model.base.BaseSchedulingSubpart;
import org.unitime.timetable.model.comparators.ClassComparator;
import org.unitime.timetable.model.comparators.SchedulingSubpartComparator;
import org.unitime.timetable.model.dao.Class_DAO;
import org.unitime.timetable.model.dao.DistributionPrefDAO;
import org.unitime.timetable.model.dao.DistributionTypeDAO;
import org.unitime.timetable.model.dao.InstructionalOfferingDAO;
import org.unitime.timetable.model.dao.SchedulingSubpartDAO;
import org.unitime.timetable.security.Qualifiable;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.ComboBoxLookup;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.ExportUtils;
import org.unitime.timetable.util.LookupTables;
import org.unitime.timetable.webutil.BackTracker;
import org.unitime.timetable.webutil.DistributionPrefsTableBuilder;

@Service(value="/distributionPrefs")
public class DistributionPrefsAction
extends Action {
    protected static final CourseMessages MSG = Localization.create(CourseMessages.class);
    @Autowired
    SessionContext sessionContext;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.sessionContext.checkPermission(Right.DistributionPreferences);
        MessageResources rsc = this.getResources(request);
        ActionMessages errors = new ActionMessages();
        DistributionPrefsForm frm = (DistributionPrefsForm)form;
        String reloadId = request.getParameter("reloadId");
        String reloadCause = request.getParameter("reloadCause");
        String deleteId = request.getParameter("deleteId");
        String deleteType = request.getParameter("deleteType");
        String distPrefId = request.getParameter("dp");
        String op = frm.getOp();
        if (op == null || op.trim().length() == 0) {
            op = "view";
            frm.setOp(op);
        }
        frm.setFilterSubjectAreas(SubjectArea.getUserSubjectAreas(this.sessionContext.getUser()));
        if ("DistTypeChange".equals(request.getParameter("op2")) || "GroupingChange".equals(request.getParameter("op2"))) {
            op = "reload pref";
        }
        Debug.debug("op: " + op);
        Debug.debug("deleteId: " + deleteId);
        Debug.debug("deleteType: " + deleteType);
        Debug.debug("reloadCause: " + reloadCause);
        Debug.debug("reloadId: " + reloadId);
        Debug.debug("distPrefId: " + distPrefId);
        if (reloadCause != null && reloadCause.length() > 0) {
            op = "reload";
        }
        if (op.equals(rsc.getMessage("button.cancel"))) {
            frm.reset(mapping, request);
            if (BackTracker.doBack(request, response)) {
                return null;
            }
            op = "view";
        }
        LookupTables.setupDistribTypes(request, this.sessionContext);
        Vector subjectAreaList = this.setupSubjectAreas(request);
        if (op.equals(rsc.getMessage("button.save")) || op.equals(rsc.getMessage("button.update"))) {
            Debug.debug("Saving distribution pref ...");
            errors = frm.validate(mapping, request);
            if (errors.size() == 0) {
                try {
                    this.doAddOrUpdate(request, frm);
                    if (frm.getDistPrefId() != null) {
                        request.setAttribute("backType", (Object)"PreferenceGroup");
                        request.setAttribute("backId", (Object)frm.getDistPrefId());
                    }
                    frm.reset(mapping, request);
                    if (BackTracker.doBack(request, response)) {
                        return null;
                    }
                    op = "view";
                }
                catch (Exception e) {
                    Debug.error(e);
                    errors.add("classes", new ActionMessage("errors.generic", (Object)e.getMessage()));
                    this.saveErrors(request, errors);
                }
            } else {
                this.saveErrors(request, errors);
            }
        }
        if (op.equals(rsc.getMessage("button.delete"))) {
            if (deleteType.equals("distObject")) {
                frm.removeFromLists(Integer.parseInt(deleteId));
            }
            if (deleteType.equals("distPref")) {
                distPrefId = frm.getDistPrefId();
                this.doDelete(request, distPrefId);
                frm.reset(mapping, request);
                if (BackTracker.doBack(request, response)) {
                    return null;
                }
                op = "view";
            }
        }
        if (op.equals(rsc.getMessage("button.addDistPref")) || MSG.actionAddDistributionPreference().equals(op)) {
            Debug.debug("Adding new Class via redirect ...");
            frm.setDistType("-");
            frm.setGrouping("-");
            if (request.getAttribute("subjectAreaId") != null) {
                frm.addToSubjectArea(request.getAttribute("subjectAreaId").toString());
                frm.addToItype(request.getAttribute("schedSubpartId").toString());
                frm.addToCourseNbr(request.getAttribute("courseOffrId").toString());
                frm.addToClassNumber(request.getAttribute("classId").toString());
                request.setAttribute("addedClass", (Object)("" + (frm.getSubjectArea().size() - 1)));
            }
        }
        if (op.equals(rsc.getMessage("button.addClass_"))) {
            Debug.debug("Adding new Class ...");
            String subjAreaId = null;
            if (subjectAreaList.size() == 1) {
                subjAreaId = ((ComboBoxLookup)subjectAreaList.elementAt(0)).getValue();
            }
            frm.addNewClass(subjAreaId);
            request.setAttribute("addedClass", (Object)("" + (frm.getSubjectArea().size() - 1)));
        }
        if (op.equals(rsc.getMessage("button.search")) || op.equals(rsc.getMessage("button.exportPDF"))) {
            String subjectAreaId = frm.getFilterSubjectAreaId();
            String courseNbr = frm.getFilterCourseNbr();
            if (subjectAreaId != null && subjectAreaId.length() > 0) {
                this.sessionContext.setAttribute(SessionAttribute.OfferingsSubjectArea, (Object)subjectAreaId);
            } else {
                this.sessionContext.removeAttribute(SessionAttribute.OfferingsSubjectArea);
            }
            if (courseNbr != null && courseNbr.length() > 0) {
                this.sessionContext.setAttribute(SessionAttribute.OfferingsCourseNumber, (Object)courseNbr);
            } else {
                this.sessionContext.removeAttribute(SessionAttribute.OfferingsCourseNumber);
            }
            op = op.equals(rsc.getMessage("button.exportPDF")) ? "export" : "view";
        }
        if (op != null && (op.equals("view") || op.equals("export")) && distPrefId != null && distPrefId.trim().length() > 0) {
            Debug.debug("Loading dist pref - " + distPrefId);
            frm.reset(mapping, request);
            this.doLoad(frm, distPrefId);
        }
        if (op != null && op.equals("reload")) {
            if (reloadCause != null && reloadCause.equals("subjectArea")) {
                int index = Integer.parseInt(reloadId);
                Debug.debug("subj area changed ... " + reloadId + " - " + frm.getSubjectArea(index));
                frm.setCourseNbr(index, "-");
                frm.setItype(index, "-");
                frm.setClassNumber(index, "-");
            }
            if (reloadCause != null && reloadCause.equals("moveUp")) {
                int index = Integer.parseInt(reloadId);
                Debug.debug("moving up ... " + reloadId);
                frm.swap(index, index - 1);
            }
            if (reloadCause != null && reloadCause.equals("moveDown")) {
                int index = Integer.parseInt(reloadId);
                Debug.debug("moving down ... " + reloadId);
                frm.swap(index, index + 1);
            }
        }
        this.setLookupLists(request, frm, subjectAreaList, errors);
        if (frm.getDistType() != null && !frm.getDistType().equals("-")) {
            Vector<PreferenceLevel> prefs = new Vector<PreferenceLevel>();
            DistributionType dist = (DistributionType)new DistributionTypeDAO().get(new Long(frm.getDistType()));
            frm.setDescription(dist.getDescr());
            boolean containsPref = false;
            for (PreferenceLevel pref : PreferenceLevel.getPreferenceLevelList()) {
                if (!dist.isAllowed(pref)) continue;
                prefs.addElement(pref);
                if (frm.getPrefLevel() == null || frm.getPrefLevel().equals("-") || !pref.getPrefId().equals(new Integer(frm.getPrefLevel()))) continue;
                containsPref = true;
            }
            if (!containsPref) {
                frm.setPrefLevel("-");
            }
            if (prefs.size() == 1) {
                frm.setPrefLevel(((PreferenceLevel)prefs.firstElement()).getPrefId().toString());
            }
            request.setAttribute(PreferenceLevel.PREF_LEVEL_ATTR_NAME, prefs);
        } else {
            request.setAttribute(PreferenceLevel.PREF_LEVEL_ATTR_NAME, new Vector(0));
            frm.setDescription("");
        }
        if (frm.getGrouping() != null && !frm.getGrouping().equals("-")) {
            frm.setGroupingDescription(DistributionPref.getGroupingDescription(frm.getGroupingInt()));
        }
        if ("export".equals(op) && (frm.getDistPrefId() == null || frm.getDistPrefId().length() == 0)) {
            OutputStream out = ExportUtils.getPdfOutputStream(response, "distprefs");
            new DistributionPrefsTableBuilder().getAllDistPrefsTableForCurrentUserAsPdf(out, this.sessionContext, frm.getFilterSubjectAreaId(), frm.getFilterCourseNbr());
            return null;
        }
        request.setAttribute("listSize", (Object)("" + (frm.getSubjectArea().size() - 1)));
        if ("view".equals(op) && (frm.getDistPrefId() == null || frm.getDistPrefId().length() == 0)) {
            String html;
            String subject = (String)this.sessionContext.getAttribute(SessionAttribute.OfferingsSubjectArea);
            if (subject != null && subject.indexOf(44) >= 0) {
                subject = subject.substring(0, subject.indexOf(44));
            }
            frm.setFilterSubjectAreaId(subject);
            frm.setFilterCourseNbr((String)this.sessionContext.getAttribute(SessionAttribute.OfferingsCourseNumber));
            DistributionPrefsTableBuilder tbl = new DistributionPrefsTableBuilder();
            if (frm.getFilterSubjectAreaId() == null) {
                if (this.sessionContext.getUser().getCurrentAuthority().hasRight(Right.DepartmentIndependent)) {
                    frm.setFilterSubjectAreaId(Constants.BLANK_OPTION_VALUE);
                } else {
                    frm.setFilterSubjectAreaId(Constants.ALL_OPTION_VALUE);
                }
            }
            if ((html = tbl.getAllDistPrefsTableForCurrentUser(request, this.sessionContext, frm.getFilterSubjectAreaId(), frm.getFilterCourseNbr())) != null) {
                request.setAttribute("distPrefs", (Object)html);
            }
            BackTracker.markForBack(request, "distributionPrefs.do", "Distribution Preferences", true, true);
            return mapping.findForward("list");
        }
        return mapping.findForward(frm.getDistPrefId() == null || frm.getDistPrefId().length() == 0 ? "add" : "edit");
    }

    public Vector setupSubjectAreas(HttpServletRequest request) throws Exception {
        TreeSet<SubjectArea> subjectAreas = SubjectArea.getUserSubjectAreas(this.sessionContext.getUser());
        if (subjectAreas == null) {
            return null;
        }
        Vector<ComboBoxLookup> v = new Vector<ComboBoxLookup>(subjectAreas.size());
        for (SubjectArea sa : subjectAreas) {
            v.addElement(new ComboBoxLookup(sa.getSubjectAreaAbbreviation(), sa.getUniqueId().toString()));
        }
        return v;
    }

    private void setLookupLists(HttpServletRequest request, DistributionPrefsForm frm, Vector subjectAreaList, ActionMessages errors) {
        int ct = frm.getSubjectArea().size();
        for (int index = 0; index < ct; ++index) {
            String subjectAreaId = frm.getSubjectArea(index);
            String courseNbr = frm.getCourseNbr(index);
            String subpart = frm.getItype(index);
            String classNumber = frm.getClassNumber(index);
            Vector<ComboBoxLookup> crsNumList = null;
            Vector<ComboBoxLookup> subpartList = null;
            Vector<ComboBoxLookup> classNumList = null;
            if (subjectAreaId != null) {
                if (subjectAreaId.equals("-")) {
                    crsNumList = new Vector<ComboBoxLookup>();
                    subpartList = new Vector<ComboBoxLookup>();
                    classNumList = new Vector<ComboBoxLookup>();
                } else {
                    ComboBoxLookup cbl;
                    Object a;
                    int i;
                    StringBuffer query = new StringBuffer();
                    query.append("select co.uniqueId, co.courseNbr, co.title ");
                    query.append("  from InstructionalOffering as io , CourseOffering co ");
                    query.append(" where co.subjectArea.uniqueId = :subjectAreaId ");
                    query.append("       and io.uniqueId = co.instructionalOffering.uniqueId ");
                    query.append("       and io.notOffered = false ");
                    query.append("       and co.isControl = true ");
                    query.append(" order by co.courseNbr ");
                    InstructionalOfferingDAO idao = new InstructionalOfferingDAO();
                    Session hibSession = idao.getSession();
                    Query q = hibSession.createQuery(query.toString());
                    q.setFetchSize(200);
                    q.setCacheable(true);
                    q.setLong("subjectAreaId", Long.parseLong(subjectAreaId));
                    List result = q.list();
                    crsNumList = new Vector();
                    if (result.size() > 0) {
                        for (i = 0; i < result.size(); ++i) {
                            a = (Object[])result.get(i);
                            cbl = new ComboBoxLookup(a[1].toString() + " - " + (a[2] == null ? "" : a[2].toString()), a[0].toString());
                            crsNumList.addElement(cbl);
                        }
                        if (result.size() == 1) {
                            ComboBoxLookup cbl2 = (ComboBoxLookup)crsNumList.elementAt(0);
                            frm.setCourseNbr(index, cbl2.getValue());
                            courseNbr = frm.getCourseNbr(index);
                        }
                    }
                    if (courseNbr.equals("-")) {
                        subpartList = new Vector();
                        classNumList = new Vector();
                    } else {
                        query = new StringBuffer();
                        query.append(" select distinct s ");
                        query.append("   from CourseOffering co, ");
                        query.append("        InstructionalOffering io, ");
                        query.append("        InstrOfferingConfig ioc, ");
                        query.append("        SchedulingSubpart s ");
                        query.append("  where co.uniqueId=:courseNbr ");
                        query.append("    and co.instructionalOffering.uniqueId=io.uniqueId ");
                        query.append("    and ioc.instructionalOffering.uniqueId=io.uniqueId ");
                        query.append("    and s.instrOfferingConfig.uniqueId=ioc.uniqueId ");
                        q = hibSession.createQuery(query.toString());
                        q.setFetchSize(200);
                        q.setCacheable(true);
                        q.setLong("courseNbr", Long.parseLong(courseNbr));
                        result = new Vector(q.list());
                        if (result != null && result.size() > 0) {
                            Collections.sort(result, new SchedulingSubpartComparator(subjectAreaId == null || subjectAreaId.length() == 0 ? null : new Long(subjectAreaId)));
                            subpartList = new Vector();
                            for (i = 0; i < result.size(); ++i) {
                                a = (SchedulingSubpart)result.get(i);
                                String ssid = ((BasePreferenceGroup)a).getUniqueId().toString();
                                String name = ((BaseSchedulingSubpart)a).getItype().getAbbv();
                                String sufix = ((SchedulingSubpart)a).getSchedulingSubpartSuffix();
                                while (((BaseSchedulingSubpart)a).getParentSubpart() != null) {
                                    name = "&nbsp;&nbsp;&nbsp;&nbsp;" + name;
                                    a = ((BaseSchedulingSubpart)a).getParentSubpart();
                                }
                                if (((BaseSchedulingSubpart)a).getInstrOfferingConfig().getInstructionalOffering().getInstrOfferingConfigs().size() > 1) {
                                    name = name + " [" + ((BaseSchedulingSubpart)a).getInstrOfferingConfig().getName() + "]";
                                }
                                ComboBoxLookup cbl3 = new ComboBoxLookup(name + (sufix == null || sufix.length() == 0 ? "" : " (" + sufix + ")"), ssid);
                                subpartList.addElement(cbl3);
                            }
                            if (result.size() == 1) {
                                ComboBoxLookup cbl4 = (ComboBoxLookup)subpartList.elementAt(0);
                                frm.setItype(index, cbl4.getValue());
                                subpart = frm.getItype(index);
                            }
                        }
                        if (subpartList == null || subpartList.size() == 0) {
                            subpartList = new Vector();
                            errors.add("classes", new ActionMessage("errors.generic", (Object)"No subparts exist for the given course"));
                        }
                        if (subpart.equals("-")) {
                            classNumList = new Vector();
                        } else {
                            query = new StringBuffer();
                            query.append(" select distinct c ");
                            query.append("   from SchedulingSubpart s, ");
                            query.append("        Class_ c ");
                            query.append("  where s.uniqueId=:itype ");
                            query.append("    and s.uniqueId=c.schedulingSubpart.uniqueId ");
                            q = hibSession.createQuery(query.toString());
                            q.setFetchSize(200);
                            q.setCacheable(true);
                            q.setLong("itype", Long.parseLong(subpart));
                            result = q.list();
                            if (result != null && result.size() > 0) {
                                Collections.sort(result, new ClassComparator(5));
                                if (classNumber.equals("-")) {
                                    frm.setClassNumber(index, "-1");
                                }
                                classNumList = new Vector();
                                for (int i2 = 0; i2 < result.size(); ++i2) {
                                    Class_ clazz = (Class_)result.get(i2);
                                    cbl = new ComboBoxLookup(clazz.getSectionNumberString(), clazz.getUniqueId().toString());
                                    classNumList.addElement(cbl);
                                }
                            } else {
                                classNumList = new Vector();
                                errors.add("classes", new ActionMessage("errors.generic", (Object)"No classes exist for the given subpart"));
                            }
                        }
                    }
                }
            }
            request.setAttribute("subjectAreaList" + index, (Object)subjectAreaList);
            request.setAttribute("courseNbrList" + index, crsNumList);
            request.setAttribute("itypeList" + index, subpartList);
            request.setAttribute("classNumList" + index, classNumList);
        }
        this.saveErrors(request, errors);
    }

    private void doLoad(DistributionPrefsForm frm, String distPrefId) {
        DistributionPrefDAO dpDao = new DistributionPrefDAO();
        DistributionPref dp = (DistributionPref)dpDao.get(new Long(distPrefId));
        frm.setDistType(dp.getDistributionType().getUniqueId().toString());
        frm.setGrouping(dp.getGroupingName());
        frm.setOwner(dp.getOwner().getUniqueId().toString());
        frm.setPrefLevel(dp.getPrefLevel().getPrefId().toString());
        frm.setDistPrefId(distPrefId);
        Session hibSession = dpDao.getSession();
        StringBuffer query = new StringBuffer("");
        query.append("select sa.uniqueId, co.uniqueId, su.uniqueId, -1,  do.sequenceNumber ");
        query.append("  from ");
        query.append("       DistributionObject do, ");
        query.append("       SchedulingSubpart su, ");
        query.append("       InstrOfferingConfig ioc, ");
        query.append("       InstructionalOffering io, ");
        query.append("       CourseOffering co, ");
        query.append("       SubjectArea sa ");
        query.append(" where co.isControl=true ");
        query.append("   and do.distributionPref.uniqueId=:distPrefId ");
        query.append("   and do.prefGroup.uniqueId=su.uniqueId ");
        query.append("   and su.instrOfferingConfig.uniqueId=ioc.uniqueId ");
        query.append("   and ioc.instructionalOffering.uniqueId=io.uniqueId ");
        query.append("   and co.instructionalOffering.uniqueId=io.uniqueId ");
        query.append("   and co.subjectArea.uniqueId=sa.uniqueId ");
        Query q = hibSession.createQuery(query.toString());
        q.setLong("distPrefId", Long.parseLong(distPrefId));
        List distPrefs1 = q.list();
        StringBuffer query2 = new StringBuffer("");
        query2.append("select sa.uniqueId, co.uniqueId, su.uniqueId, c.uniqueId, do.sequenceNumber ");
        query2.append("  from ");
        query2.append("       DistributionObject do, ");
        query2.append("       Class_ c, ");
        query2.append("       SchedulingSubpart su, ");
        query2.append("       InstrOfferingConfig ioc, ");
        query2.append("       InstructionalOffering io, ");
        query2.append("       CourseOffering co, ");
        query2.append("       SubjectArea sa ");
        query2.append(" where co.isControl=true ");
        query2.append("   and do.distributionPref.uniqueId=:distPrefId ");
        query2.append("   and do.prefGroup.uniqueId=c.uniqueId ");
        query2.append("   and c.schedulingSubpart.uniqueId=su.uniqueId ");
        query2.append("   and su.instrOfferingConfig.uniqueId=ioc.uniqueId ");
        query2.append("   and ioc.instructionalOffering.uniqueId=io.uniqueId ");
        query2.append("   and co.instructionalOffering.uniqueId=io.uniqueId ");
        query2.append("   and co.subjectArea.uniqueId=sa.uniqueId ");
        q = hibSession.createQuery(query2.toString());
        q.setLong("distPrefId", Long.parseLong(distPrefId));
        List distPrefs2 = q.list();
        ArrayList distPrefs = new ArrayList();
        if (distPrefs1 != null && distPrefs1.size() > 0) {
            distPrefs.addAll(distPrefs1);
        }
        if (distPrefs2 != null && distPrefs2.size() > 0) {
            distPrefs.addAll(distPrefs2);
        }
        if (distPrefs != null && distPrefs.size() > 0) {
            Iterator iter = distPrefs.iterator();
            int i = 0;
            while (iter.hasNext()) {
                Object[] rec = (Object[])iter.next();
                int indx = rec[4] == null ? i : (Integer)rec[4] - 1;
                frm.setSubjectArea(indx, rec[0].toString());
                frm.setCourseNbr(indx, rec[1].toString());
                frm.setItype(indx, rec[2].toString());
                frm.setClassNumber(indx, rec[3].toString());
                ++i;
            }
        }
    }

    private void doAddOrUpdate(HttpServletRequest request, DistributionPrefsForm frm) throws Exception {
        String distPrefId = frm.getDistPrefId();
        List saList = frm.getSubjectArea();
        List suList = frm.getItype();
        List clList = frm.getClassNumber();
        DistributionPref dp = null;
        Department oldOwner = null;
        DistributionPrefDAO dpDao = new DistributionPrefDAO();
        Transaction tx = null;
        Session hibSession = dpDao.getSession();
        HashSet<InstructionalOffering> relatedInstructionalOfferings = new HashSet<InstructionalOffering>();
        try {
            tx = hibSession.beginTransaction();
            if (distPrefId != null && distPrefId.trim().length() > 0) {
                Long distPrefUid = new Long(distPrefId);
                if (distPrefUid > 0L) {
                    dp = (DistributionPref)dpDao.get(distPrefUid, hibSession);
                    Set<DistributionObject> s = dp.getDistributionObjects();
                    for (DistributionObject dObj : s) {
                        PreferenceGroup pg = dObj.getPrefGroup();
                        relatedInstructionalOfferings.add((pg instanceof Class_ ? ((Class_)pg).getSchedulingSubpart() : (SchedulingSubpart)pg).getInstrOfferingConfig().getInstructionalOffering());
                        pg.getDistributionObjects().remove(dObj);
                        hibSession.saveOrUpdate((Object)pg);
                    }
                    s.clear();
                    dp.setDistributionObjects(s);
                    oldOwner = (Department)dp.getOwner();
                }
            } else {
                dp = new DistributionPref();
            }
            dp.setDistributionType((DistributionType)new DistributionTypeDAO().get(new Long(frm.getDistType()), hibSession));
            dp.setGrouping(new Integer(frm.getGroupingInt()));
            dp.setPrefLevel(PreferenceLevel.getPreferenceLevel(Integer.parseInt(frm.getPrefLevel())));
            BasePreferenceGroup owningDept = null;
            for (int i = 0; i < saList.size(); ++i) {
                String su = suList.get(i).toString();
                String cl = clList.get(i).toString();
                DistributionObject dObj = new DistributionObject();
                if (cl.equals("-1")) {
                    SchedulingSubpart subpart = (SchedulingSubpart)new SchedulingSubpartDAO().get(new Long(su), hibSession);
                    if (owningDept == null) {
                        owningDept = subpart.getManagingDept();
                    } else if (!owningDept.getUniqueId().equals(subpart.getManagingDept().getUniqueId())) {
                        if (((BaseDepartment)owningDept).getDistributionPrefPriority() < subpart.getManagingDept().getDistributionPrefPriority()) {
                            owningDept = subpart.getManagingDept();
                        } else if (((BaseDepartment)owningDept).getDistributionPrefPriority().intValue() == subpart.getManagingDept().getDistributionPrefPriority().intValue() && !this.sessionContext.getUser().getCurrentAuthority().hasQualifier((Qualifiable)((Object)owningDept)) && this.sessionContext.getUser().getCurrentAuthority().hasQualifier(subpart.getManagingDept())) {
                            owningDept = subpart.getManagingDept();
                        }
                    }
                    dObj.setPrefGroup(subpart);
                    relatedInstructionalOfferings.add(subpart.getInstrOfferingConfig().getInstructionalOffering());
                } else {
                    Class_ clazz = (Class_)new Class_DAO().get(new Long(cl), hibSession);
                    if (owningDept == null) {
                        owningDept = clazz.getManagingDept();
                    } else if (!((BaseDepartment)owningDept).equals(clazz.getManagingDept())) {
                        if (((BaseDepartment)owningDept).getDistributionPrefPriority() < clazz.getManagingDept().getDistributionPrefPriority()) {
                            owningDept = clazz.getManagingDept();
                        } else if (((BaseDepartment)owningDept).getDistributionPrefPriority().intValue() == clazz.getManagingDept().getDistributionPrefPriority().intValue() && !this.sessionContext.getUser().getCurrentAuthority().hasQualifier((Qualifiable)((Object)owningDept)) && this.sessionContext.getUser().getCurrentAuthority().hasQualifier(clazz.getManagingDept())) {
                            owningDept = clazz.getManagingDept();
                        }
                    }
                    relatedInstructionalOfferings.add(clazz.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering());
                    dObj.setPrefGroup(clazz);
                }
                dObj.setSequenceNumber(new Integer(i + 1));
                dObj.setDistributionPref(dp);
                dObj.getPrefGroup().getDistributionObjects().add(dObj);
                dp.addTodistributionObjects(dObj);
            }
            dp.setOwner((PreferenceGroup)owningDept);
            this.sessionContext.checkPermission(dp, Right.DistributionPreferenceEdit);
            hibSession.saveOrUpdate((Object)dp);
            for (InstructionalOffering io : relatedInstructionalOfferings) {
                ChangeLog.addChange(hibSession, this.sessionContext, io, ChangeLog.Source.DIST_PREF_EDIT, distPrefId != null && distPrefId.trim().length() > 0 ? ChangeLog.Operation.UPDATE : ChangeLog.Operation.CREATE, io.getControllingCourseOffering().getSubjectArea(), null);
            }
            tx.commit();
            hibSession.flush();
            hibSession.refresh((Object)dp.getOwner());
            if (oldOwner != null && !oldOwner.equals(dp.getOwner())) {
                hibSession.refresh((Object)oldOwner);
            }
            frm.setDistPrefId(dp.getUniqueId().toString());
        }
        catch (Exception e) {
            if (tx != null) {
                tx.rollback();
            }
            hibSession.clear();
            throw e;
        }
    }

    private void doDelete(HttpServletRequest request, String distPrefId) {
        block6: {
            Transaction tx = null;
            try {
                DistributionPrefDAO dpDao = new DistributionPrefDAO();
                Session hibSession = dpDao.getSession();
                tx = hibSession.getTransaction();
                if (tx == null || !tx.isActive()) {
                    tx = hibSession.beginTransaction();
                }
                HashSet<InstructionalOffering> relatedInstructionalOfferings = new HashSet<InstructionalOffering>();
                DistributionPref dp = (DistributionPref)dpDao.get(new Long(distPrefId));
                this.sessionContext.checkPermission(dp, Right.DistributionPreferenceDelete);
                Department dept = (Department)dp.getOwner();
                dept.getPreferences().remove(dp);
                for (DistributionObject dObj : dp.getDistributionObjects()) {
                    PreferenceGroup pg = dObj.getPrefGroup();
                    relatedInstructionalOfferings.add((pg instanceof Class_ ? ((Class_)pg).getSchedulingSubpart() : (SchedulingSubpart)pg).getInstrOfferingConfig().getInstructionalOffering());
                    pg.getDistributionObjects().remove(dObj);
                    hibSession.saveOrUpdate((Object)pg);
                }
                hibSession.delete((Object)dp);
                hibSession.saveOrUpdate((Object)dept);
                for (InstructionalOffering io : relatedInstructionalOfferings) {
                    ChangeLog.addChange(hibSession, this.sessionContext, io, ChangeLog.Source.DIST_PREF_EDIT, ChangeLog.Operation.DELETE, io.getControllingCourseOffering().getSubjectArea(), null);
                }
                if (tx != null && tx.isActive()) {
                    tx.commit();
                }
                hibSession.flush();
                hibSession.refresh((Object)dept);
            }
            catch (Exception e) {
                Debug.error(e);
                if (tx == null || !tx.isActive()) break block6;
                tx.rollback();
            }
        }
    }
}

