/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.text.DecimalFormat;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.unitime.commons.web.WebTable;
import org.unitime.timetable.defaults.CommonValues;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.form.DepartmentListForm;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.ExportUtils;
import org.unitime.timetable.webutil.PdfWebTable;

@Service(value="/departmentList")
public class DepartmentListAction
extends Action {
    @Autowired
    SessionContext sessionContext;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String[] stringArray;
        this.sessionContext.checkPermission(Right.Departments);
        DepartmentListForm departmentListForm = (DepartmentListForm)form;
        departmentListForm.setDepartments(Department.findAll(this.sessionContext.getUser().getCurrentAcademicSessionId()));
        if ("Apply".equals(departmentListForm.getOp())) {
            this.sessionContext.getUser().setProperty("Departments.showUnusedDepts", departmentListForm.getShowUnusedDepts() ? "1" : "0");
        } else {
            departmentListForm.setShowUnusedDepts("1".equals(this.sessionContext.getUser().getProperty("Departments.showUnusedDepts", "0")));
        }
        boolean dispLastChanges = CommonValues.Yes.eq(UserProperty.DisplayLastChanges.get(this.sessionContext.getUser()));
        if ("Export PDF".equals(request.getParameter("op"))) {
            String[] stringArray2;
            int n = dispLastChanges ? 12 : 11;
            String string = "Department List - " + this.sessionContext.getUser().getCurrentAuthority().getQualifiers("Session").get(0).getQualifierLabel();
            if (dispLastChanges) {
                String[] stringArray3 = new String[12];
                stringArray3[0] = "Number";
                stringArray3[1] = "Abbv";
                stringArray3[2] = "Name";
                stringArray3[3] = "External\nManager";
                stringArray3[4] = "Subjects";
                stringArray3[5] = "Rooms";
                stringArray3[6] = "Status";
                stringArray3[7] = "Dist Pref\nPriority";
                stringArray3[8] = "Allow\nRequired";
                stringArray3[9] = "Instructor\nPref";
                stringArray3[10] = "Events";
                stringArray2 = stringArray3;
                stringArray3[11] = "Last\nChange";
            } else {
                String[] stringArray4 = new String[11];
                stringArray4[0] = "Number";
                stringArray4[1] = "Abbreviation";
                stringArray4[2] = "Name";
                stringArray4[3] = "External\nManager";
                stringArray4[4] = "Subjects";
                stringArray4[5] = "Rooms";
                stringArray4[6] = "Status";
                stringArray4[7] = "Dist Pref\nPriority";
                stringArray4[8] = "Allow\nRequired";
                stringArray4[9] = "Instructor\nPref";
                stringArray2 = stringArray4;
                stringArray4[10] = "Events";
            }
            PdfWebTable webTable = new PdfWebTable(n, string, "departmentList.do?ord=%%", stringArray2, new String[]{"left", "left", "left", "left", "right", "right", "left", "right", "left", "left", "left", "left"}, new boolean[]{true, true, true, true, true, true, true, true, true, false});
            for (Department d : departmentListForm.getDepartments()) {
                if (!departmentListForm.getShowUnusedDepts() && d.getSubjectAreas().isEmpty() && d.getTimetableManagers().isEmpty() && !d.isExternalManager().booleanValue()) continue;
                DecimalFormat df5 = new DecimalFormat("####0");
                String lastChangeStr = null;
                Long lastChangeCmp = null;
                if (dispLastChanges) {
                    List changes = ChangeLog.findLastNChanges(d.getSession().getUniqueId(), null, null, d.getUniqueId(), 1);
                    ChangeLog lastChange = changes == null || changes.isEmpty() ? null : (ChangeLog)changes.get(0);
                    lastChangeStr = lastChange == null ? "" : ChangeLog.sDFdate.format(lastChange.getTimeStamp()) + " by " + lastChange.getManager().getShortName();
                    lastChangeCmp = new Long(lastChange == null ? 0L : lastChange.getTimeStamp().getTime());
                }
                String allowReq = "";
                int allowReqOrd = 0;
                if (d.isAllowReqRoom() != null && d.isAllowReqRoom().booleanValue()) {
                    if (!allowReq.isEmpty()) {
                        allowReq = allowReq + ", ";
                    }
                    allowReq = allowReq + "room";
                    ++allowReqOrd;
                }
                if (d.isAllowReqTime() != null && d.isAllowReqTime().booleanValue()) {
                    if (!allowReq.isEmpty()) {
                        allowReq = allowReq + ", ";
                    }
                    allowReq = allowReq + "time";
                    allowReqOrd += 2;
                }
                if (d.isAllowReqDistribution() != null && d.isAllowReqDistribution().booleanValue()) {
                    if (!allowReq.isEmpty()) {
                        allowReq = allowReq + ", ";
                    }
                    allowReq = allowReq + "distribution";
                    allowReqOrd += 4;
                }
                if (allowReqOrd == 7) {
                    allowReq = "all";
                }
                webTable.addLine(null, new String[]{d.getDeptCode(), d.getAbbreviation(), d.getName(), d.isExternalManager() != false ? d.getExternalMgrAbbv() : "", df5.format(d.getSubjectAreas().size()), df5.format(d.getRoomDepts().size()), (d.getStatusType() == null ? "@@ITALIC " : "") + d.effectiveStatusType().getLabel() + (d.getStatusType() == null ? "@@END_ITALIC " : ""), d.getDistributionPrefPriority() == null && d.getDistributionPrefPriority() != 0 ? "" : d.getDistributionPrefPriority().toString(), allowReq, d.isInheritInstructorPreferences() != false ? "Yes" : "No", d.isAllowEvents() != false ? "Yes" : "No", lastChangeStr}, new Comparable[]{d.getDeptCode(), d.getAbbreviation(), d.getName(), d.isExternalManager() != false ? d.getExternalMgrAbbv() : "", new Integer(d.getSubjectAreas().size()), new Integer(d.getRoomDepts().size()), d.effectiveStatusType().getOrd(), d.getDistributionPrefPriority(), new Integer(allowReqOrd), d.isInheritInstructorPreferences(), d.isAllowEvents(), lastChangeCmp});
            }
            ExportUtils.exportPDF(webTable, WebTable.getOrder(this.sessionContext, "DepartmentList.ord"), response, "departments");
            return null;
        }
        int n = dispLastChanges ? 12 : 11;
        if (dispLastChanges) {
            String[] stringArray5 = new String[12];
            stringArray5[0] = "Code";
            stringArray5[1] = "Abbv";
            stringArray5[2] = "Name";
            stringArray5[3] = "External<br>Manager";
            stringArray5[4] = "Subjects";
            stringArray5[5] = "Rooms";
            stringArray5[6] = "Status";
            stringArray5[7] = "Dist&nbsp;Pref<br>Priority";
            stringArray5[8] = "Allow<br>Required";
            stringArray5[9] = "Instructor<br>Preferences";
            stringArray5[10] = "Events";
            stringArray = stringArray5;
            stringArray5[11] = "Last<br>Change";
        } else {
            String[] stringArray6 = new String[11];
            stringArray6[0] = "Code";
            stringArray6[1] = "Abbreviation";
            stringArray6[2] = "Name";
            stringArray6[3] = "External Manager";
            stringArray6[4] = "Subjects";
            stringArray6[5] = "Rooms";
            stringArray6[6] = "Status";
            stringArray6[7] = "Dist&nbsp;Pref<br>Priority";
            stringArray6[8] = "Allow<br>Required";
            stringArray6[9] = "Instructor<br>Preferences";
            stringArray = stringArray6;
            stringArray6[10] = "Events";
        }
        WebTable webTable = new WebTable(n, "", "departmentList.do?ord=%%", stringArray, new String[]{"left", "left", "left", "left", "right", "right", "left", "right", "left", "left", "left", "left"}, new boolean[]{true, true, true, true, true, true, true, true, true, true, true, false});
        WebTable.setOrder(this.sessionContext, "DepartmentList.ord", request.getParameter("ord"), 1);
        webTable.enableHR("#9CB0CE");
        webTable.setRowStyle("white-space: nowrap");
        for (Department d : departmentListForm.getDepartments()) {
            if (!departmentListForm.getShowUnusedDepts() && d.getSubjectAreas().isEmpty() && d.getTimetableManagers().isEmpty() && !d.isExternalManager().booleanValue()) continue;
            DecimalFormat df5 = new DecimalFormat("####0");
            String lastChangeStr = null;
            Long lastChangeCmp = null;
            if (dispLastChanges) {
                List changes = ChangeLog.findLastNChanges(d.getSession().getUniqueId(), null, null, d.getUniqueId(), 1);
                ChangeLog lastChange = changes == null || changes.isEmpty() ? null : (ChangeLog)changes.get(0);
                lastChangeStr = lastChange == null ? "&nbsp;" : "<span title='" + lastChange.getLabel() + "'>" + ChangeLog.sDFdate.format(lastChange.getTimeStamp()) + " by " + lastChange.getManager().getShortName() + "</span>";
                lastChangeCmp = new Long(lastChange == null ? 0L : lastChange.getTimeStamp().getTime());
            }
            String allowReq = "";
            int allowReqOrd = 0;
            if (d.isAllowReqRoom() != null && d.isAllowReqRoom().booleanValue()) {
                if (!allowReq.isEmpty()) {
                    allowReq = allowReq + ", ";
                }
                allowReq = allowReq + "room";
                ++allowReqOrd;
            }
            if (d.isAllowReqTime() != null && d.isAllowReqTime().booleanValue()) {
                if (!allowReq.isEmpty()) {
                    allowReq = allowReq + ", ";
                }
                allowReq = allowReq + "time";
                allowReqOrd += 2;
            }
            if (d.isAllowReqDistribution() != null && d.isAllowReqDistribution().booleanValue()) {
                if (!allowReq.isEmpty()) {
                    allowReq = allowReq + ", ";
                }
                allowReq = allowReq + "distribution";
                allowReqOrd += 4;
            }
            if (allowReqOrd == 7) {
                allowReq = "all";
            }
            if (allowReqOrd == 0) {
                allowReq = "&nbsp;";
            }
            webTable.addLine("onClick=\"document.location='departmentEdit.do?op=Edit&id=" + d.getUniqueId() + "';\"", new String[]{d.getDeptCode(), d.getAbbreviation() == null ? "&nbsp;" : d.getAbbreviation(), "<A name='" + d.getUniqueId() + "'>" + d.getName() + "</A>", d.isExternalManager() != false ? "<span title='" + d.getExternalMgrLabel() + "'>" + d.getExternalMgrAbbv() + "</span>" : "&nbsp;", df5.format(d.getSubjectAreas().size()), df5.format(d.getRoomDepts().size()), (d.getStatusType() == null ? "<i>" : "&nbsp;") + d.effectiveStatusType().getLabel() + (d.getStatusType() == null ? "</i>" : ""), d.getDistributionPrefPriority() == null && d.getDistributionPrefPriority() != 0 ? "&nbsp;" : d.getDistributionPrefPriority().toString(), allowReq, d.isInheritInstructorPreferences() != false ? "<IMG border='0' title='Instructor preferences are to be inherited.' alt='Inherit Instructor Preferences' align='absmiddle' src='images/accept.png'>" : "", d.isAllowEvents() != false ? "<IMG border='0' title='This department has event management enabled.' alt='Event Management' align='absmiddle' src='images/accept.png'>" : "", lastChangeStr}, new Comparable[]{d.getDeptCode(), d.getAbbreviation() == null ? "&nbsp;" : d.getAbbreviation(), d.getName(), d.isExternalManager() != false ? d.getExternalMgrAbbv() : "", new Integer(d.getSubjectAreas().size()), new Integer(d.getRoomDepts().size()), d.effectiveStatusType().getOrd(), d.getDistributionPrefPriority(), new Integer(allowReqOrd), d.isInheritInstructorPreferences(), d.isAllowEvents(), lastChangeCmp});
        }
        request.setAttribute("table", (Object)webTable.printTable(WebTable.getOrder(this.sessionContext, "DepartmentList.ord")));
        return mapping.findForward("showDepartmentList");
    }
}

