/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.unitime.commons.Debug;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.action.ClassAssignmentsReportSearchAction;
import org.unitime.timetable.action.ClassSearchAction;
import org.unitime.timetable.defaults.SessionAttribute;
import org.unitime.timetable.form.ClassAssignmentsReportForm;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.dao.SubjectAreaDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.solver.ClassAssignmentProxy;
import org.unitime.timetable.solver.exam.ExamSolverProxy;
import org.unitime.timetable.solver.service.AssignmentService;
import org.unitime.timetable.solver.service.SolverService;
import org.unitime.timetable.webutil.BackTracker;

@Service(value="/classAssignmentsReportShowSearch")
public class ClassAssignmentsReportShowSearchAction
extends Action {
    protected static final CourseMessages MSG = Localization.create(CourseMessages.class);
    @Autowired
    SessionContext sessionContext;
    @Autowired
    AssignmentService<ClassAssignmentProxy> classAssignmentService;
    @Autowired
    SolverService<ExamSolverProxy> examinationSolverService;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.sessionContext.checkPermission(Right.ClassAssignments);
        ClassAssignmentsReportForm classListForm = (ClassAssignmentsReportForm)form;
        request.setAttribute(Department.EXTERNAL_DEPT_ATTR_NAME, Department.findAllExternal(this.sessionContext.getUser().getCurrentAcademicSessionId()));
        ClassAssignmentsReportSearchAction.setupGeneralFormFilters(this.sessionContext.getUser(), classListForm);
        if (request.getParameter("sortBy") != null) {
            classListForm.setSortBy(request.getParameter("sortBy"));
            classListForm.setFilterAssignedRoom(request.getParameter("filterAssignedRoom"));
            classListForm.setFilterManager(request.getParameter("filterManager"));
            classListForm.setFilterIType(request.getParameter("filterIType"));
            classListForm.setFilterAssignedTimeMon(request.getParameter("filterAssignedTimeMon") == null ? false : Boolean.getBoolean(request.getParameter("filterAssignedTimeMon")));
            classListForm.setFilterAssignedTimeTue(request.getParameter("filterAssignedTimeTue") == null ? false : Boolean.getBoolean(request.getParameter("filterAssignedTimeTue")));
            classListForm.setFilterAssignedTimeWed(request.getParameter("filterAssignedTimeWed") == null ? false : Boolean.getBoolean(request.getParameter("filterAssignedTimeWed")));
            classListForm.setFilterAssignedTimeThu(request.getParameter("filterAssignedTimeThu") == null ? false : Boolean.getBoolean(request.getParameter("filterAssignedTimeThu")));
            classListForm.setFilterAssignedTimeFri(request.getParameter("filterAssignedTimeFri") == null ? false : Boolean.getBoolean(request.getParameter("filterAssignedTimeFri")));
            classListForm.setFilterAssignedTimeSat(request.getParameter("filterAssignedTimeSat") == null ? false : Boolean.getBoolean(request.getParameter("filterAssignedTimeSat")));
            classListForm.setFilterAssignedTimeSun(request.getParameter("filterAssignedTimeSun") == null ? false : Boolean.getBoolean(request.getParameter("filterAssignedTimeSun")));
            classListForm.setFilterAssignedTimeHour(request.getParameter("filterAssignedTimeHour"));
            classListForm.setFilterAssignedTimeMin(request.getParameter("filterAssignedTimeMin"));
            classListForm.setFilterAssignedTimeAmPm(request.getParameter("filterAssignedTimeAmPm"));
            classListForm.setFilterAssignedTimeLength(request.getParameter("filterAssignedTimeLength"));
            classListForm.setSortByKeepSubparts(Boolean.getBoolean(request.getParameter("sortByKeepSubparts")));
        }
        classListForm.setSubjectAreas(SubjectArea.getAllSubjectAreas(this.sessionContext.getUser().getCurrentAcademicSessionId()));
        Object sas = this.sessionContext.getAttribute(SessionAttribute.ClassAssignmentsSubjectAreas);
        if (sas != null && sas.toString().trim().length() > 0) {
            String subjectAreaIds = sas.toString();
            try {
                Debug.debug("Subject Areas: " + subjectAreaIds);
                classListForm.setSubjectAreaIds(subjectAreaIds.split(","));
                classListForm.setClasses(ClassSearchAction.getClasses(classListForm, this.classAssignmentService.getAssignment()));
                Collection classes = classListForm.getClasses();
                if (classes.isEmpty()) {
                    ActionMessages errors = new ActionMessages();
                    errors.add("searchResult", new ActionMessage("errors.generic", (Object)"No records matching the search criteria were found."));
                    this.saveErrors(request, errors);
                    return mapping.findForward("showClassAssignmentsReportSearch");
                }
                StringBuffer ids = new StringBuffer();
                StringBuffer names = new StringBuffer();
                for (int i = 0; i < classListForm.getSubjectAreaIds().length; ++i) {
                    if (i > 0) {
                        names.append(",");
                    }
                    ids.append("&subjectAreaIds=" + classListForm.getSubjectAreaIds()[i]);
                    names.append(((SubjectArea)new SubjectAreaDAO().get(new Long(classListForm.getSubjectAreaIds()[i]))).getSubjectAreaAbbreviation());
                }
                BackTracker.markForBack(request, "classAssignmentsReportSearch.do?doit=Search&loadFilter=1" + ids, "Class Assignments (" + names + ")", true, true);
                return mapping.findForward("showClassAssignmentsReportList");
            }
            catch (NumberFormatException nfe) {
                Debug.error("Subject Area Ids session attribute is corrupted. Resetting ... ");
                this.sessionContext.removeAttribute(SessionAttribute.ClassAssignmentsSubjectAreas);
            }
        }
        return mapping.findForward("showClassAssignmentsReportSearch");
    }
}

