/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.text.DecimalFormat;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.cpsolver.ifs.util.DistanceMetric;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.unitime.commons.web.WebTable;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.model.Building;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;

@Service(value="/buildingList")
public class BuildingListAction
extends Action {
    @Autowired
    SessionContext sessionContext;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.sessionContext.checkPermission(Right.BuildingList);
        DistanceMetric.Ellipsoid ellipsoid = DistanceMetric.Ellipsoid.valueOf((String)ApplicationProperty.DistanceEllipsoid.value());
        WebTable webTable = new WebTable(5, null, "buildingList.do?ord=%%", new String[]{"Abbreviation", "Name", "External ID", ellipsoid.getFirstCoordinateName(), ellipsoid.getSecondCoordinateName()}, new String[]{"left", "left", "left", "right", "right"}, new boolean[]{true, true, true, true, true});
        WebTable.setOrder(this.sessionContext, "BuildingList.ord", request.getParameter("ord"), 1);
        DecimalFormat df5 = new DecimalFormat("####0.######");
        for (Building b : Building.findAll(this.sessionContext.getUser().getCurrentAcademicSessionId())) {
            webTable.addLine("onClick=\"document.location='buildingEdit.do?op=Edit&id=" + b.getUniqueId() + "';\"", new String[]{b.getAbbreviation(), b.getName(), b.getExternalUniqueId() == null ? "<i>N/A</i>" : b.getExternalUniqueId().toString(), b.getCoordinateX() == null ? "" : df5.format(b.getCoordinateX()), b.getCoordinateY() == null ? "" : df5.format(b.getCoordinateY())}, new Comparable[]{b.getAbbreviation(), b.getName(), b.getExternalUniqueId() == null ? "" : b.getExternalUniqueId().toString(), b.getCoordinateX(), b.getCoordinateY()});
        }
        request.setAttribute("table", (Object)webTable.printTable(WebTable.getOrder(this.sessionContext, "BuildingList.ord")));
        return mapping.findForward("showBuildingList");
    }
}

