/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.commons;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import org.apache.struts.upload.FormFile;
import org.unitime.timetable.defaults.ApplicationProperty;

public abstract class Email {
    public static Email createEmail() throws Exception {
        return (Email)Class.forName(ApplicationProperty.EmailProvider.value()).newInstance();
    }

    public abstract void setSubject(String var1) throws Exception;

    public abstract void setFrom(String var1, String var2) throws Exception;

    public abstract void setReplyTo(String var1, String var2) throws Exception;

    public abstract void addReplyTo(String var1, String var2) throws Exception;

    public abstract void addRecipient(String var1, String var2) throws Exception;

    public abstract void addRecipientCC(String var1, String var2) throws Exception;

    public abstract void addRecipientBCC(String var1, String var2) throws Exception;

    protected abstract void setBody(String var1, String var2) throws Exception;

    public void setText(String message) throws Exception {
        this.setBody(message, "text/plain; charset=UTF-8");
    }

    public void setHTML(String message) throws Exception {
        this.setBody(message, "text/html; charset=UTF-8");
    }

    public void addNotify() throws Exception {
        this.addRecipient(ApplicationProperty.EmailNotificationAddress.value(), ApplicationProperty.EmailNotificationAddressName.value());
    }

    public void addNotifyCC() throws Exception {
        this.addRecipientCC(ApplicationProperty.EmailNotificationAddress.value(), ApplicationProperty.EmailNotificationAddressName.value());
    }

    protected abstract void addAttachement(String var1, DataHandler var2) throws Exception;

    public void addAttachement(File file, String name) throws Exception {
        this.addAttachement(name == null ? file.getName() : name, new DataHandler((DataSource)new FileDataSource(file)));
    }

    public void addAttachement(final FormFile file) throws Exception {
        this.addAttachement(file.getFileName(), new DataHandler(new DataSource(){

            public OutputStream getOutputStream() throws IOException {
                throw new IOException("No output stream.");
            }

            public String getName() {
                return file.getFileName();
            }

            public InputStream getInputStream() throws IOException {
                return file.getInputStream();
            }

            public String getContentType() {
                return file.getContentType();
            }
        }));
    }

    public void addAttachement(DataSource source) throws Exception {
        this.addAttachement(source.getName(), new DataHandler(source));
    }

    public abstract void send() throws Exception;

    public abstract void setInReplyTo(String var1) throws Exception;

    public abstract String getMessageId() throws Exception;
}

