/*
 * Decompiled with CFR 0.152.
 */
package biweekly.util;

import java.text.DecimalFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class DateTimeComponents {
    private static final Pattern regex = Pattern.compile("^(\\d{4})-?(\\d{2})-?(\\d{2})(T(\\d{2}):?(\\d{2}):?(\\d{2})(Z?))?.*");
    private final int year;
    private final int month;
    private final int date;
    private final int hour;
    private final int minute;
    private final int second;
    private final boolean utc;

    public static DateTimeComponents parse(String dateString) {
        Matcher m = regex.matcher(dateString);
        if (!m.find()) {
            throw new IllegalArgumentException("Cannot parse date: " + dateString);
        }
        int i = 1;
        int year = Integer.parseInt(m.group(i++));
        int month = Integer.parseInt(m.group(i++));
        int date = Integer.parseInt(m.group(i++));
        int n = ++i;
        ++i;
        String hourStr = m.group(n);
        int hour = hourStr == null ? 0 : Integer.parseInt(hourStr);
        String minuteStr = m.group(i++);
        int minute = minuteStr == null ? 0 : Integer.parseInt(minuteStr);
        String secondStr = m.group(i++);
        int second = secondStr == null ? 0 : Integer.parseInt(secondStr);
        boolean utc = "Z".equals(m.group(i++));
        return new DateTimeComponents(year, month, date, hour, minute, second, utc);
    }

    public DateTimeComponents(DateTimeComponents original, Integer year, Integer month, Integer date, Integer hour, Integer minute, Integer second, Boolean utc) {
        this(year == null ? original.year : year, month == null ? original.month : month, date == null ? original.date : date, hour == null ? original.hour : hour, minute == null ? original.minute : minute, second == null ? original.second : second, utc == null ? original.utc : utc);
    }

    public DateTimeComponents(int year, int month, int date, int hour, int minute, int second, boolean utc) {
        this.year = year;
        this.month = month;
        this.date = date;
        this.hour = hour;
        this.minute = minute;
        this.second = second;
        this.utc = utc;
    }

    public int getYear() {
        return this.year;
    }

    public int getMonth() {
        return this.month;
    }

    public int getDate() {
        return this.date;
    }

    public int getHour() {
        return this.hour;
    }

    public int getMinute() {
        return this.minute;
    }

    public int getSecond() {
        return this.second;
    }

    public boolean isUtc() {
        return this.utc;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean extended) {
        DecimalFormat nf = new DecimalFormat("00");
        String dash = extended ? "-" : "";
        String colon = extended ? ":" : "";
        String z = this.utc ? "Z" : "";
        return this.year + dash + nf.format(this.month) + dash + nf.format(this.date) + "T" + nf.format(this.hour) + colon + nf.format(this.minute) + colon + nf.format(this.second) + z;
    }

    public Date toDate() {
        TimeZone tz = this.utc ? TimeZone.getTimeZone("UTC") : TimeZone.getDefault();
        Calendar c = Calendar.getInstance(tz);
        c.clear();
        c.set(1, this.year);
        c.set(2, this.month - 1);
        c.set(5, this.date);
        c.set(11, this.hour);
        c.set(12, this.minute);
        c.set(13, this.second);
        return c.getTime();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.date;
        result = 31 * result + this.hour;
        result = 31 * result + this.minute;
        result = 31 * result + this.month;
        result = 31 * result + this.second;
        result = 31 * result + (this.utc ? 1231 : 1237);
        result = 31 * result + this.year;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DateTimeComponents other = (DateTimeComponents)obj;
        if (this.date != other.date) {
            return false;
        }
        if (this.hour != other.hour) {
            return false;
        }
        if (this.minute != other.minute) {
            return false;
        }
        if (this.month != other.month) {
            return false;
        }
        if (this.second != other.second) {
            return false;
        }
        if (this.utc != other.utc) {
            return false;
        }
        return this.year == other.year;
    }
}

