/*
 * Decompiled with CFR 0.152.
 */
package biweekly.property;

import biweekly.property.EnumProperty;
import java.util.Arrays;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Status
extends EnumProperty {
    private static final String TENTATIVE = "TENTATIVE";
    private static final String CONFIRMED = "CONFIRMED";
    private static final String CANCELLED = "CANCELLED";
    private static final String NEEDS_ACTION = "NEEDS-ACTION";
    private static final String COMPLETED = "COMPLETED";
    private static final String IN_PROGRESS = "IN-PROGRESS";
    private static final String DRAFT = "DRAFT";
    private static final String FINAL = "FINAL";

    public Status(String status) {
        super(status);
    }

    public static Status tentative() {
        return Status.create(TENTATIVE);
    }

    public boolean isTentative() {
        return this.is(TENTATIVE);
    }

    public static Status confirmed() {
        return Status.create(CONFIRMED);
    }

    public boolean isConfirmed() {
        return this.is(CONFIRMED);
    }

    public static Status cancelled() {
        return Status.create(CANCELLED);
    }

    public boolean isCancelled() {
        return this.is(CANCELLED);
    }

    public static Status needsAction() {
        return Status.create(NEEDS_ACTION);
    }

    public boolean isNeedsAction() {
        return this.is(NEEDS_ACTION);
    }

    public static Status completed() {
        return Status.create(COMPLETED);
    }

    public boolean isCompleted() {
        return this.is(COMPLETED);
    }

    public static Status inProgress() {
        return Status.create(IN_PROGRESS);
    }

    public boolean isInProgress() {
        return this.is(IN_PROGRESS);
    }

    public static Status draft() {
        return Status.create(DRAFT);
    }

    public boolean isDraft() {
        return this.is(DRAFT);
    }

    public static Status final_() {
        return Status.create(FINAL);
    }

    public boolean isFinal() {
        return this.is(FINAL);
    }

    private static Status create(String status) {
        return new Status(status);
    }

    @Override
    protected Collection<String> getStandardValues() {
        return Arrays.asList(TENTATIVE, CONFIRMED, CANCELLED, NEEDS_ACTION, COMPLETED, IN_PROGRESS, DRAFT, FINAL);
    }
}

