/*
 * Decompiled with CFR 0.152.
 */
package biweekly.property;

import biweekly.Warning;
import biweekly.component.ICalComponent;
import biweekly.component.VTimezone;
import biweekly.property.ListProperty;
import biweekly.util.ICalDateFormat;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExceptionDates
extends ListProperty<Date> {
    private boolean hasTime = true;

    public ExceptionDates(boolean hasTime) {
        this.setHasTime(hasTime);
    }

    public boolean hasTime() {
        return this.hasTime;
    }

    public void setHasTime(boolean hasTime) {
        this.hasTime = hasTime;
    }

    @Override
    public String getTimezoneId() {
        return super.getTimezoneId();
    }

    @Override
    public void setTimezoneId(String timezoneId) {
        super.setTimezoneId(timezoneId);
    }

    @Override
    public void setTimezone(VTimezone timezone) {
        super.setTimezone(timezone);
    }

    @Override
    protected void validate(List<ICalComponent> components, List<Warning> warnings) {
        super.validate(components, warnings);
        String tzid = this.getTimezoneId();
        if (tzid != null && tzid.contains("/") && ICalDateFormat.parseTimeZoneId(tzid) == null) {
            warnings.add(Warning.validate(27, tzid));
        }
    }
}

