/*
 * Decompiled with CFR 0.152.
 */
package biweekly.io.xml;

import biweekly.ICalendar;
import biweekly.Warning;
import biweekly.component.ICalComponent;
import biweekly.io.CannotParseException;
import biweekly.io.ParseWarnings;
import biweekly.io.SkipMeException;
import biweekly.io.scribe.ScribeIndex;
import biweekly.io.scribe.component.ICalComponentScribe;
import biweekly.io.scribe.property.ICalPropertyScribe;
import biweekly.io.xml.XCalQNames;
import biweekly.parameter.ICalParameters;
import biweekly.property.ICalProperty;
import biweekly.property.Xml;
import biweekly.util.XmlUtils;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import javax.xml.namespace.QName;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XCalReader
implements Closeable {
    private final Source source;
    private final Closeable stream;
    private volatile ICalendar readICal;
    private final ParseWarnings warnings = new ParseWarnings();
    private volatile TransformerException thrown;
    private volatile ScribeIndex index = new ScribeIndex();
    private final ReadThread thread = new ReadThread();
    private final Object lock = new Object();
    private final BlockingQueue<Object> readerBlock = new ArrayBlockingQueue<Object>(1);
    private final BlockingQueue<Object> threadBlock = new ArrayBlockingQueue<Object>(1);

    public XCalReader(String str) {
        this(new StringReader(str));
    }

    public XCalReader(InputStream in) {
        this.source = new StreamSource(in);
        this.stream = in;
    }

    public XCalReader(File file) throws FileNotFoundException {
        this(new FileInputStream(file));
    }

    public XCalReader(Reader reader) {
        this.source = new StreamSource(reader);
        this.stream = reader;
    }

    public XCalReader(Node node) {
        this.source = new DOMSource(node);
        this.stream = null;
    }

    public void registerScribe(ICalComponentScribe<? extends ICalComponent> scribe) {
        this.index.register(scribe);
    }

    public void registerScribe(ICalPropertyScribe<? extends ICalProperty> scribe) {
        this.index.register(scribe);
    }

    public ScribeIndex getScribeIndex() {
        return this.index;
    }

    public void setScribeIndex(ScribeIndex index) {
        this.index = index;
    }

    public List<String> getWarnings() {
        return this.warnings.copy();
    }

    public ICalendar readNext() throws TransformerException {
        this.readICal = null;
        this.warnings.clear();
        this.thrown = null;
        if (!this.thread.started) {
            this.thread.start();
        } else {
            if (this.thread.finished || this.thread.closed) {
                return null;
            }
            try {
                this.threadBlock.put(this.lock);
            }
            catch (InterruptedException e) {
                return null;
            }
        }
        try {
            this.readerBlock.take();
        }
        catch (InterruptedException e) {
            return null;
        }
        if (this.thrown != null) {
            throw this.thrown;
        }
        return this.readICal;
    }

    @Override
    public void close() throws IOException {
        if (this.thread.isAlive()) {
            this.thread.closed = true;
            this.thread.interrupt();
        }
        if (this.stream != null) {
            this.stream.close();
        }
    }

    private class XCalStructure {
        private final List<ElementType> stack = new ArrayList<ElementType>();

        private XCalStructure() {
        }

        public ElementType pop() {
            return this.stack.isEmpty() ? null : this.stack.remove(this.stack.size() - 1);
        }

        public ElementType peek() {
            return this.stack.isEmpty() ? null : this.stack.get(this.stack.size() - 1);
        }

        public void push(ElementType type) {
            this.stack.add(type);
        }

        public boolean isUnderParameters() {
            ElementType nonNull = null;
            for (int i = this.stack.size() - 1; i >= 0; --i) {
                ElementType type = this.stack.get(i);
                if (type == null) continue;
                nonNull = type;
                break;
            }
            return nonNull == ElementType.parameters || nonNull == ElementType.parameter || nonNull == ElementType.parameterValue;
        }

        public boolean isEmpty() {
            return this.stack.isEmpty();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ElementType {
        icalendar,
        components,
        properties,
        component,
        property,
        parameters,
        parameter,
        parameterValue;

    }

    private class ContentHandlerImpl
    extends DefaultHandler {
        private final Document DOC = XmlUtils.createDocument();
        private final XCalStructure structure = new XCalStructure();
        private final StringBuilder characterBuffer = new StringBuilder();
        private final LinkedList<ICalComponent> componentStack = new LinkedList();
        private Element propertyElement;
        private Element parent;
        private QName paramName;
        private ICalComponent curComponent;
        private ICalParameters parameters;

        private ContentHandlerImpl() {
        }

        public void characters(char[] buffer, int start, int length) throws SAXException {
            this.characterBuffer.append(buffer, start, length);
        }

        public void startElement(String namespace, String localName, String qName, Attributes attributes) throws SAXException {
            QName qname = new QName(namespace, localName);
            String textContent = this.characterBuffer.toString();
            this.characterBuffer.setLength(0);
            if (this.structure.isEmpty()) {
                if (XCalQNames.ICALENDAR.equals(qname)) {
                    this.structure.push(ElementType.icalendar);
                }
                return;
            }
            ElementType parentType = this.structure.peek();
            ElementType typeToPush = null;
            if (parentType != null) {
                switch (parentType) {
                    case icalendar: {
                        ICalComponent component;
                        if (!XCalQNames.VCALENDAR.equals(qname)) break;
                        ICalComponentScribe<? extends ICalComponent> scribe = XCalReader.this.index.getComponentScribe(localName);
                        this.curComponent = component = scribe.emptyInstance();
                        XCalReader.this.readICal = (ICalendar)component;
                        typeToPush = ElementType.component;
                        break;
                    }
                    case component: {
                        if (XCalQNames.PROPERTIES.equals(qname)) {
                            typeToPush = ElementType.properties;
                            break;
                        }
                        if (!XCalQNames.COMPONENTS.equals(qname)) break;
                        this.componentStack.add(this.curComponent);
                        this.curComponent = null;
                        typeToPush = ElementType.components;
                        break;
                    }
                    case components: {
                        if (!"urn:ietf:params:xml:ns:icalendar-2.0".equals(namespace)) break;
                        ICalComponentScribe<? extends ICalComponent> scribe = XCalReader.this.index.getComponentScribe(localName);
                        this.curComponent = scribe.emptyInstance();
                        ICalComponent parent = this.componentStack.getLast();
                        parent.addComponent(this.curComponent);
                        typeToPush = ElementType.component;
                        break;
                    }
                    case properties: {
                        this.propertyElement = this.createElement(namespace, localName, attributes);
                        this.parameters = new ICalParameters();
                        this.parent = this.propertyElement;
                        typeToPush = ElementType.property;
                        break;
                    }
                    case property: {
                        if (!XCalQNames.PARAMETERS.equals(qname)) break;
                        typeToPush = ElementType.parameters;
                        break;
                    }
                    case parameters: {
                        if (!"urn:ietf:params:xml:ns:icalendar-2.0".equals(namespace)) break;
                        this.paramName = qname;
                        typeToPush = ElementType.parameter;
                        break;
                    }
                    case parameter: {
                        if (!"urn:ietf:params:xml:ns:icalendar-2.0".equals(namespace)) break;
                        typeToPush = ElementType.parameterValue;
                        break;
                    }
                }
            }
            if (this.propertyElement != null && typeToPush != ElementType.property && typeToPush != ElementType.parameters && !this.structure.isUnderParameters()) {
                if (textContent.length() > 0) {
                    this.parent.appendChild(this.DOC.createTextNode(textContent));
                }
                Element element = this.createElement(namespace, localName, attributes);
                this.parent.appendChild(element);
                this.parent = element;
            }
            this.structure.push(typeToPush);
        }

        public void endElement(String namespace, String localName, String qName) throws SAXException {
            String textContent = this.characterBuffer.toString();
            this.characterBuffer.setLength(0);
            if (this.structure.isEmpty()) {
                return;
            }
            ElementType type = this.structure.pop();
            if (type == null && (this.propertyElement == null || this.structure.isUnderParameters())) {
                return;
            }
            if (type != null) {
                switch (type) {
                    case parameterValue: {
                        this.parameters.put(this.paramName.getLocalPart(), textContent);
                        break;
                    }
                    case parameter: {
                        break;
                    }
                    case parameters: {
                        break;
                    }
                    case property: {
                        this.propertyElement.appendChild(this.DOC.createTextNode(textContent));
                        QName propertyQName = new QName(this.propertyElement.getNamespaceURI(), this.propertyElement.getLocalName());
                        String propertyName = localName;
                        ICalPropertyScribe<? extends ICalProperty> scribe = XCalReader.this.index.getPropertyScribe(propertyQName);
                        try {
                            ICalPropertyScribe.Result<? extends ICalProperty> result = scribe.parseXml(this.propertyElement, this.parameters);
                            ICalProperty property = result.getProperty();
                            this.curComponent.addProperty(property);
                            for (Warning warning : result.getWarnings()) {
                                XCalReader.this.warnings.add(null, propertyName, warning);
                            }
                        }
                        catch (SkipMeException e) {
                            XCalReader.this.warnings.add(null, propertyName, 22, e.getMessage());
                        }
                        catch (CannotParseException e) {
                            String xml = XmlUtils.toString(this.propertyElement);
                            XCalReader.this.warnings.add(null, propertyName, 33, xml, e.getMessage());
                            scribe = XCalReader.this.index.getPropertyScribe(Xml.class);
                            ICalPropertyScribe.Result<? extends ICalProperty> result = scribe.parseXml(this.propertyElement, this.parameters);
                            ICalProperty property = result.getProperty();
                            this.curComponent.addProperty(property);
                        }
                        this.propertyElement = null;
                        break;
                    }
                    case component: {
                        this.curComponent = null;
                        if (!XCalQNames.VCALENDAR.getNamespaceURI().equals(namespace) || !XCalQNames.VCALENDAR.getLocalPart().equals(localName)) break;
                        try {
                            XCalReader.this.readerBlock.put(XCalReader.this.lock);
                            XCalReader.this.threadBlock.take();
                        }
                        catch (InterruptedException e) {
                            throw new SAXException(e);
                        }
                        return;
                    }
                    case properties: {
                        break;
                    }
                    case components: {
                        this.curComponent = this.componentStack.removeLast();
                        break;
                    }
                }
            }
            if (this.propertyElement != null && type != ElementType.property && type != ElementType.parameters && !this.structure.isUnderParameters()) {
                if (textContent.length() > 0) {
                    this.parent.appendChild(this.DOC.createTextNode(textContent));
                }
                this.parent = (Element)this.parent.getParentNode();
            }
        }

        private Element createElement(String namespace, String localName, Attributes attributes) {
            Element element = this.DOC.createElementNS(namespace, localName);
            for (int i = 0; i < attributes.getLength(); ++i) {
                String qname = attributes.getQName(i);
                if (qname.startsWith("xmlns:")) continue;
                String name = attributes.getLocalName(i);
                String value = attributes.getValue(i);
                element.setAttribute(name, value);
            }
            return element;
        }
    }

    private class ReadThread
    extends Thread {
        private final SAXResult result;
        private final Transformer transformer;
        private volatile boolean finished = false;
        private volatile boolean started = false;
        private volatile boolean closed = false;

        public ReadThread() {
            this.setName(this.getClass().getSimpleName());
            try {
                this.transformer = TransformerFactory.newInstance().newTransformer();
            }
            catch (TransformerConfigurationException e) {
                throw new RuntimeException(e);
            }
            this.transformer.setErrorListener(new ErrorListener(){

                public void error(TransformerException e) {
                }

                public void fatalError(TransformerException e) {
                }

                public void warning(TransformerException e) {
                }
            });
            this.result = new SAXResult(new ContentHandlerImpl());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            this.started = true;
            try {
                this.transformer.transform(XCalReader.this.source, this.result);
            }
            catch (TransformerException e) {
                if (!((XCalReader)XCalReader.this).thread.closed) {
                    XCalReader.this.thrown = e;
                }
            }
            finally {
                this.finished = true;
                try {
                    XCalReader.this.readerBlock.put(XCalReader.this.lock);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

