/*
 * Decompiled with CFR 0.152.
 */
package biweekly.io.text;

import biweekly.ICalDataType;
import biweekly.ICalendar;
import biweekly.Warning;
import biweekly.component.ICalComponent;
import biweekly.io.CannotParseException;
import biweekly.io.ParseWarnings;
import biweekly.io.SkipMeException;
import biweekly.io.scribe.ScribeIndex;
import biweekly.io.scribe.component.ICalComponentScribe;
import biweekly.io.scribe.component.ICalendarScribe;
import biweekly.io.scribe.property.ICalPropertyScribe;
import biweekly.io.scribe.property.RawPropertyScribe;
import biweekly.io.text.ICalParseException;
import biweekly.io.text.ICalRawLine;
import biweekly.io.text.ICalRawReader;
import biweekly.parameter.ICalParameters;
import biweekly.property.ICalProperty;
import biweekly.util.IOUtils;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ICalReader
implements Closeable {
    private static final ICalendarScribe icalMarshaller = ScribeIndex.getICalendarScribe();
    private static final String icalComponentName = icalMarshaller.getComponentName();
    private final ParseWarnings warnings = new ParseWarnings();
    private ScribeIndex index = new ScribeIndex();
    private final ICalRawReader reader;

    public ICalReader(String string) {
        this(new StringReader(string));
    }

    public ICalReader(InputStream in) {
        this(IOUtils.utf8Reader(in));
    }

    public ICalReader(File file) throws FileNotFoundException {
        this(IOUtils.utf8Reader(file));
    }

    public ICalReader(Reader reader) {
        this.reader = new ICalRawReader(reader);
    }

    public boolean isCaretDecodingEnabled() {
        return this.reader.isCaretDecodingEnabled();
    }

    public void setCaretDecodingEnabled(boolean enable) {
        this.reader.setCaretDecodingEnabled(enable);
    }

    public void registerScribe(ICalPropertyScribe<? extends ICalProperty> scribe) {
        this.index.register(scribe);
    }

    public void registerScribe(ICalComponentScribe<? extends ICalComponent> scribe) {
        this.index.register(scribe);
    }

    public ScribeIndex getScribeIndex() {
        return this.index;
    }

    public void setScribeIndex(ScribeIndex index) {
        this.index = index;
    }

    public List<String> getWarnings() {
        return this.warnings.copy();
    }

    public ICalendar readNext() throws IOException {
        ICalendar ical;
        this.warnings.clear();
        boolean dataWasRead = false;
        ArrayList<ICalProperty> orphanedProperties = new ArrayList<ICalProperty>();
        ArrayList<ICalComponent> orphanedComponents = new ArrayList<ICalComponent>();
        ArrayList<ICalComponent> componentStack = new ArrayList<ICalComponent>();
        ArrayList<String> componentNamesStack = new ArrayList<String>();
        while (true) {
            String componentName;
            ICalRawLine line;
            try {
                line = this.reader.readLine();
            }
            catch (ICalParseException e) {
                this.warnings.add(this.reader.getLineNum(), null, 3, e.getLine());
                continue;
            }
            if (line == null) break;
            String propertyName = line.getName();
            if ("BEGIN".equalsIgnoreCase(propertyName)) {
                componentName = line.getValue();
                dataWasRead = true;
                ICalComponent parentComponent = componentStack.isEmpty() ? null : (ICalComponent)componentStack.get(componentStack.size() - 1);
                ICalComponentScribe<? extends ICalComponent> marshaller = this.index.getComponentScribe(componentName);
                ICalComponent component = marshaller.emptyInstance();
                componentStack.add(component);
                componentNamesStack.add(componentName);
                if (parentComponent == null) {
                    orphanedComponents.add(component);
                    continue;
                }
                parentComponent.addComponent(component);
                continue;
            }
            if ("END".equalsIgnoreCase(propertyName)) {
                componentName = line.getValue();
                if (icalComponentName.equalsIgnoreCase(componentName)) break;
                int popIndex = -1;
                for (int i = componentStack.size() - 1; i >= 0; --i) {
                    String name = (String)componentNamesStack.get(i);
                    if (!name.equalsIgnoreCase(componentName)) continue;
                    popIndex = i;
                    break;
                }
                if (popIndex == -1) {
                    this.warnings.add(this.reader.getLineNum(), "END", 2, new Object[0]);
                    continue;
                }
                componentStack.subList(popIndex, componentStack.size()).clear();
                componentNamesStack.subList(popIndex, componentNamesStack.size()).clear();
                continue;
            }
            dataWasRead = true;
            ICalParameters parameters = line.getParameters();
            block7: for (Map.Entry entry : parameters) {
                List paramValues = entry.getValue();
                for (String value : paramValues) {
                    if (value != null) continue;
                    String paramName = (String)entry.getKey();
                    this.warnings.add(this.reader.getLineNum(), propertyName, 4, paramName);
                    continue block7;
                }
            }
            ICalPropertyScribe<? extends ICalProperty> marshaller = this.index.getPropertyScribe(propertyName);
            ICalDataType dataType = parameters.getValue();
            if (dataType == null) {
                dataType = marshaller.getDefaultDataType();
            } else {
                parameters.setValue(null);
            }
            ICalProperty property = null;
            String value = line.getValue();
            try {
                ICalPropertyScribe.Result<? extends ICalProperty> result = marshaller.parseText(value, dataType, parameters);
                for (Warning warning : result.getWarnings()) {
                    this.warnings.add(this.reader.getLineNum(), propertyName, warning);
                }
                property = result.getProperty();
            }
            catch (SkipMeException e) {
                this.warnings.add(this.reader.getLineNum(), propertyName, 0, e.getMessage());
                continue;
            }
            catch (CannotParseException e) {
                this.warnings.add(this.reader.getLineNum(), propertyName, 1, value, e.getMessage());
                ICalPropertyScribe.Result result = new RawPropertyScribe(propertyName).parseText(value, dataType, parameters);
                property = result.getProperty();
            }
            if (componentStack.isEmpty()) {
                orphanedProperties.add(property);
                continue;
            }
            ICalComponent parentComponent = (ICalComponent)componentStack.get(componentStack.size() - 1);
            parentComponent.addProperty(property);
        }
        if (!dataWasRead) {
            return null;
        }
        if (orphanedComponents.isEmpty()) {
            ical = (ICalendar)icalMarshaller.emptyInstance();
        } else {
            ICalComponent first = (ICalComponent)orphanedComponents.get(0);
            if (first instanceof ICalendar) {
                ical = (ICalendar)first;
            } else {
                ical = (ICalendar)icalMarshaller.emptyInstance();
                for (ICalComponent component : orphanedComponents) {
                    ical.addComponent(component);
                }
            }
        }
        for (ICalProperty property : orphanedProperties) {
            ical.addProperty(property);
        }
        return ical;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }
}

