/*
 * Decompiled with CFR 0.152.
 */
package biweekly.io.text;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;

public class FoldedLineReader
extends BufferedReader {
    private String lastLine;
    private boolean singleSpaceFolding = true;
    private int lastLineNum = 0;
    private int lineCount = 0;

    public FoldedLineReader(Reader reader) {
        super(reader);
    }

    public FoldedLineReader(String text) {
        this(new StringReader(text));
    }

    public void setSingleSpaceFoldingEnabled(boolean enabled) {
        this.singleSpaceFolding = enabled;
    }

    public boolean isSingleSpaceFoldingEnabled() {
        return this.singleSpaceFolding;
    }

    public int getLineNum() {
        return this.lastLineNum;
    }

    private String readNonEmptyLine() throws IOException {
        String line;
        do {
            if ((line = super.readLine()) == null) continue;
            ++this.lineCount;
        } while (line != null && line.length() == 0);
        return line;
    }

    public String readLine() throws IOException {
        String line;
        String wholeLine = this.lastLine == null ? this.readNonEmptyLine() : this.lastLine;
        this.lastLine = null;
        if (wholeLine == null) {
            return null;
        }
        this.lastLineNum = this.lineCount;
        StringBuilder wholeLineSb = new StringBuilder(wholeLine);
        while ((line = this.readNonEmptyLine()) != null) {
            int lastWhitespace;
            if (!Character.isWhitespace(line.charAt(0))) {
                this.lastLine = line;
                break;
            }
            if (!this.singleSpaceFolding) {
                for (lastWhitespace = 1; lastWhitespace < line.length() && Character.isWhitespace(line.charAt(lastWhitespace)); ++lastWhitespace) {
                }
            }
            wholeLineSb.append(line.substring(lastWhitespace));
        }
        return wholeLineSb.toString();
    }
}

