/*
 * Decompiled with CFR 0.152.
 */
package biweekly.io.scribe.property;

import biweekly.ICalDataType;
import biweekly.Warning;
import biweekly.io.CannotParseException;
import biweekly.io.json.JCalValue;
import biweekly.io.scribe.property.ICalPropertyScribe;
import biweekly.io.xml.XCalElement;
import biweekly.parameter.ICalParameters;
import biweekly.property.UtcOffsetProperty;
import biweekly.property.ValuedProperty;
import biweekly.util.UtcOffset;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UtcOffsetPropertyScribe<T extends UtcOffsetProperty>
extends ICalPropertyScribe<T> {
    public UtcOffsetPropertyScribe(Class<T> clazz, String propertyName) {
        super(clazz, propertyName, ICalDataType.UTC_OFFSET);
    }

    @Override
    protected String _writeText(T property) {
        UtcOffset offset = (UtcOffset)((ValuedProperty)property).getValue();
        if (offset != null) {
            return offset.toString(false);
        }
        return "";
    }

    @Override
    protected T _parseText(String value, ICalDataType dataType, ICalParameters parameters, List<Warning> warnings) {
        value = UtcOffsetPropertyScribe.unescape(value);
        return this.parse(value);
    }

    @Override
    protected void _writeXml(T property, XCalElement element) {
        String offsetStr = null;
        UtcOffset offset = (UtcOffset)((ValuedProperty)property).getValue();
        if (offset != null) {
            offsetStr = offset.toString(true);
        }
        element.append(this.dataType(property), offsetStr);
    }

    @Override
    protected T _parseXml(XCalElement element, ICalParameters parameters, List<Warning> warnings) {
        String value = element.first(this.defaultDataType);
        if (value != null) {
            return this.parse(value);
        }
        throw UtcOffsetPropertyScribe.missingXmlElements(this.defaultDataType);
    }

    @Override
    protected JCalValue _writeJson(T property) {
        UtcOffset offset = (UtcOffset)((ValuedProperty)property).getValue();
        if (offset != null) {
            return JCalValue.single(offset.toString(true));
        }
        return JCalValue.single("");
    }

    @Override
    protected T _parseJson(JCalValue value, ICalDataType dataType, ICalParameters parameters, List<Warning> warnings) {
        return this.parse(value.asSingle());
    }

    protected abstract T newInstance(UtcOffset var1);

    private T parse(String value) {
        if (value == null) {
            return this.newInstance(null);
        }
        try {
            return this.newInstance(UtcOffset.parse(value));
        }
        catch (IllegalArgumentException e) {
            throw new CannotParseException(28, new Object[0]);
        }
    }
}

