/*
 * Decompiled with CFR 0.152.
 */
package biweekly.io.scribe.property;

import biweekly.ICalDataType;
import biweekly.Warning;
import biweekly.io.json.JCalValue;
import biweekly.io.scribe.property.ICalPropertyScribe;
import biweekly.io.xml.XCalElement;
import biweekly.parameter.ICalParameters;
import biweekly.property.RecurrenceProperty;
import biweekly.property.ValuedProperty;
import biweekly.util.ICalDateFormat;
import biweekly.util.ListMultimap;
import biweekly.util.Recurrence;
import biweekly.util.XmlUtils;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RecurrencePropertyScribe<T extends RecurrenceProperty>
extends ICalPropertyScribe<T> {
    private static final String FREQ = "FREQ";
    private static final String UNTIL = "UNTIL";
    private static final String COUNT = "COUNT";
    private static final String INTERVAL = "INTERVAL";
    private static final String BYSECOND = "BYSECOND";
    private static final String BYMINUTE = "BYMINUTE";
    private static final String BYHOUR = "BYHOUR";
    private static final String BYDAY = "BYDAY";
    private static final String BYMONTHDAY = "BYMONTHDAY";
    private static final String BYYEARDAY = "BYYEARDAY";
    private static final String BYWEEKNO = "BYWEEKNO";
    private static final String BYMONTH = "BYMONTH";
    private static final String BYSETPOS = "BYSETPOS";
    private static final String WKST = "WKST";

    public RecurrencePropertyScribe(Class<T> clazz, String propertyName) {
        super(clazz, propertyName, ICalDataType.RECUR);
    }

    @Override
    protected String _writeText(T property) {
        Recurrence recur = (Recurrence)((ValuedProperty)property).getValue();
        if (recur == null) {
            return "";
        }
        ListMultimap<String, Object> components = this.buildComponents(recur, false);
        return RecurrencePropertyScribe.object(components.getMap());
    }

    @Override
    protected T _parseText(String value, ICalDataType dataType, ICalParameters parameters, List<Warning> warnings) {
        Recurrence.Builder builder = new Recurrence.Builder((Recurrence.Frequency)null);
        ListMultimap<String, String> rules = RecurrencePropertyScribe.object(value);
        this.parseFreq(rules, builder, warnings);
        this.parseUntil(rules, builder, warnings);
        this.parseCount(rules, builder, warnings);
        this.parseInterval(rules, builder, warnings);
        this.parseBySecond(rules, builder, warnings);
        this.parseByMinute(rules, builder, warnings);
        this.parseByHour(rules, builder, warnings);
        this.parseByDay(rules, builder, warnings);
        this.parseByMonthDay(rules, builder, warnings);
        this.parseByYearDay(rules, builder, warnings);
        this.parseByWeekNo(rules, builder, warnings);
        this.parseByMonth(rules, builder, warnings);
        this.parseBySetPos(rules, builder, warnings);
        this.parseWkst(rules, builder, warnings);
        this.parseXRules(rules, builder, warnings);
        return this.newInstance(builder.build());
    }

    @Override
    protected void _writeXml(T property, XCalElement element) {
        XCalElement recurElement = element.append(this.dataType(property));
        Recurrence recur = (Recurrence)((ValuedProperty)property).getValue();
        if (recur == null) {
            return;
        }
        ListMultimap<String, Object> components = this.buildComponents(recur, true);
        for (Map.Entry<String, List<Object>> entry : components) {
            String name = entry.getKey().toLowerCase();
            for (Object value : entry.getValue()) {
                recurElement.append(name, value.toString());
            }
        }
    }

    @Override
    protected T _parseXml(XCalElement element, ICalParameters parameters, List<Warning> warnings) {
        XCalElement value = element.child(this.defaultDataType);
        if (value == null) {
            throw RecurrencePropertyScribe.missingXmlElements(this.defaultDataType);
        }
        ListMultimap<String, String> rules = new ListMultimap<String, String>();
        for (Element child : XmlUtils.toElementList(value.getElement().getChildNodes())) {
            if (!"urn:ietf:params:xml:ns:icalendar-2.0".equals(child.getNamespaceURI())) continue;
            String name = child.getLocalName().toUpperCase();
            String text = child.getTextContent();
            rules.put(name, text);
        }
        Recurrence.Builder builder = new Recurrence.Builder((Recurrence.Frequency)null);
        this.parseFreq(rules, builder, warnings);
        this.parseUntil(rules, builder, warnings);
        this.parseCount(rules, builder, warnings);
        this.parseInterval(rules, builder, warnings);
        this.parseBySecond(rules, builder, warnings);
        this.parseByMinute(rules, builder, warnings);
        this.parseByHour(rules, builder, warnings);
        this.parseByDay(rules, builder, warnings);
        this.parseByMonthDay(rules, builder, warnings);
        this.parseByYearDay(rules, builder, warnings);
        this.parseByWeekNo(rules, builder, warnings);
        this.parseByMonth(rules, builder, warnings);
        this.parseBySetPos(rules, builder, warnings);
        this.parseWkst(rules, builder, warnings);
        this.parseXRules(rules, builder, warnings);
        return this.newInstance(builder.build());
    }

    @Override
    protected JCalValue _writeJson(T property) {
        Recurrence recur = (Recurrence)((ValuedProperty)property).getValue();
        if (recur == null) {
            return JCalValue.object(new ListMultimap<String, Object>(0));
        }
        ListMultimap<String, Object> components = this.buildComponents(recur, true);
        ListMultimap<String, Object> object = new ListMultimap<String, Object>(components.keySet().size());
        for (Map.Entry<String, List<Object>> entry : components) {
            String key = entry.getKey().toLowerCase();
            object.putAll(key, (Collection<Object>)entry.getValue());
        }
        return JCalValue.object(object);
    }

    @Override
    protected T _parseJson(JCalValue value, ICalDataType dataType, ICalParameters parameters, List<Warning> warnings) {
        Recurrence.Builder builder = new Recurrence.Builder((Recurrence.Frequency)null);
        ListMultimap<String, String> object = value.asObject();
        ListMultimap<String, String> rules = new ListMultimap<String, String>(object.keySet().size());
        for (Map.Entry<String, List<String>> entry : object) {
            String key = entry.getKey().toUpperCase();
            rules.putAll(key, (Collection<String>)entry.getValue());
        }
        this.parseFreq(rules, builder, warnings);
        this.parseUntil(rules, builder, warnings);
        this.parseCount(rules, builder, warnings);
        this.parseInterval(rules, builder, warnings);
        this.parseBySecond(rules, builder, warnings);
        this.parseByMinute(rules, builder, warnings);
        this.parseByHour(rules, builder, warnings);
        this.parseByDay(rules, builder, warnings);
        this.parseByMonthDay(rules, builder, warnings);
        this.parseByYearDay(rules, builder, warnings);
        this.parseByWeekNo(rules, builder, warnings);
        this.parseByMonth(rules, builder, warnings);
        this.parseBySetPos(rules, builder, warnings);
        this.parseWkst(rules, builder, warnings);
        this.parseXRules(rules, builder, warnings);
        return this.newInstance(builder.build());
    }

    protected abstract T newInstance(Recurrence var1);

    private void parseFreq(ListMultimap<String, String> rules, final Recurrence.Builder builder, final List<Warning> warnings) {
        this.parseFirst(rules, FREQ, new Handler<String>(){

            @Override
            public void handle(String value) {
                value = value.toUpperCase();
                try {
                    Recurrence.Frequency frequency = Recurrence.Frequency.valueOf(value);
                    builder.frequency(frequency);
                }
                catch (IllegalArgumentException e) {
                    warnings.add(Warning.parse(7, RecurrencePropertyScribe.FREQ, value));
                }
            }
        });
    }

    private void parseUntil(ListMultimap<String, String> rules, final Recurrence.Builder builder, final List<Warning> warnings) {
        this.parseFirst(rules, UNTIL, new Handler<String>(){

            @Override
            public void handle(String value) {
                try {
                    Date date = ICalPropertyScribe.date(value).parse();
                    boolean hasTime = ICalDateFormat.dateHasTime(value);
                    builder.until(date, hasTime);
                }
                catch (IllegalArgumentException e) {
                    warnings.add(Warning.parse(7, RecurrencePropertyScribe.UNTIL, value));
                }
            }
        });
    }

    private void parseCount(ListMultimap<String, String> rules, final Recurrence.Builder builder, final List<Warning> warnings) {
        this.parseFirst(rules, COUNT, new Handler<String>(){

            @Override
            public void handle(String value) {
                try {
                    builder.count(Integer.valueOf(value));
                }
                catch (NumberFormatException e) {
                    warnings.add(Warning.parse(7, RecurrencePropertyScribe.COUNT, value));
                }
            }
        });
    }

    private void parseInterval(ListMultimap<String, String> rules, final Recurrence.Builder builder, final List<Warning> warnings) {
        this.parseFirst(rules, INTERVAL, new Handler<String>(){

            @Override
            public void handle(String value) {
                try {
                    builder.interval(Integer.valueOf(value));
                }
                catch (NumberFormatException e) {
                    warnings.add(Warning.parse(7, RecurrencePropertyScribe.INTERVAL, value));
                }
            }
        });
    }

    private void parseBySecond(ListMultimap<String, String> rules, final Recurrence.Builder builder, List<Warning> warnings) {
        this.parseIntegerList(BYSECOND, rules, warnings, new Handler<Integer>(){

            @Override
            public void handle(Integer value) {
                builder.bySecond(value);
            }
        });
    }

    private void parseByMinute(ListMultimap<String, String> rules, final Recurrence.Builder builder, List<Warning> warnings) {
        this.parseIntegerList(BYMINUTE, rules, warnings, new Handler<Integer>(){

            @Override
            public void handle(Integer value) {
                builder.byMinute(value);
            }
        });
    }

    private void parseByHour(ListMultimap<String, String> rules, final Recurrence.Builder builder, List<Warning> warnings) {
        this.parseIntegerList(BYHOUR, rules, warnings, new Handler<Integer>(){

            @Override
            public void handle(Integer value) {
                builder.byHour(value);
            }
        });
    }

    private void parseByDay(ListMultimap<String, String> rules, Recurrence.Builder builder, List<Warning> warnings) {
        Pattern p = Pattern.compile("^([-+]?\\d+)?(.*)$");
        for (String value : rules.removeAll(BYDAY)) {
            Matcher m = p.matcher(value);
            if (!m.find()) {
                warnings.add(Warning.parse(7, BYDAY, value));
                continue;
            }
            String dayStr = m.group(2);
            Recurrence.DayOfWeek day = Recurrence.DayOfWeek.valueOfAbbr(dayStr);
            if (day == null) {
                warnings.add(Warning.parse(7, BYDAY, value));
                continue;
            }
            String prefixStr = m.group(1);
            Integer prefix = prefixStr == null ? null : Integer.valueOf(prefixStr);
            builder.byDay(prefix, day);
        }
    }

    private void parseByMonthDay(ListMultimap<String, String> rules, final Recurrence.Builder builder, List<Warning> warnings) {
        this.parseIntegerList(BYMONTHDAY, rules, warnings, new Handler<Integer>(){

            @Override
            public void handle(Integer value) {
                builder.byMonthDay(value);
            }
        });
    }

    private void parseByYearDay(ListMultimap<String, String> rules, final Recurrence.Builder builder, List<Warning> warnings) {
        this.parseIntegerList(BYYEARDAY, rules, warnings, new Handler<Integer>(){

            @Override
            public void handle(Integer value) {
                builder.byYearDay(value);
            }
        });
    }

    private void parseByWeekNo(ListMultimap<String, String> rules, final Recurrence.Builder builder, List<Warning> warnings) {
        this.parseIntegerList(BYWEEKNO, rules, warnings, new Handler<Integer>(){

            @Override
            public void handle(Integer value) {
                builder.byWeekNo(value);
            }
        });
    }

    private void parseByMonth(ListMultimap<String, String> rules, final Recurrence.Builder builder, List<Warning> warnings) {
        this.parseIntegerList(BYMONTH, rules, warnings, new Handler<Integer>(){

            @Override
            public void handle(Integer value) {
                builder.byMonth(value);
            }
        });
    }

    private void parseBySetPos(ListMultimap<String, String> rules, final Recurrence.Builder builder, List<Warning> warnings) {
        this.parseIntegerList(BYSETPOS, rules, warnings, new Handler<Integer>(){

            @Override
            public void handle(Integer value) {
                builder.bySetPos(value);
            }
        });
    }

    private void parseWkst(ListMultimap<String, String> rules, final Recurrence.Builder builder, final List<Warning> warnings) {
        this.parseFirst(rules, WKST, new Handler<String>(){

            @Override
            public void handle(String value) {
                Recurrence.DayOfWeek day = Recurrence.DayOfWeek.valueOfAbbr(value);
                if (day == null) {
                    warnings.add(Warning.parse(7, RecurrencePropertyScribe.WKST, value));
                    return;
                }
                builder.workweekStarts(day);
            }
        });
    }

    private void parseXRules(ListMultimap<String, String> rules, Recurrence.Builder builder, List<Warning> warnings) {
        for (Map.Entry<String, List<String>> entry : rules) {
            String name = entry.getKey();
            for (String value : entry.getValue()) {
                builder.xrule(name, value);
            }
        }
    }

    private ListMultimap<String, Object> buildComponents(Recurrence recur, boolean extended) {
        ListMultimap<String, Object> components = new ListMultimap<String, Object>();
        if (recur.getFrequency() != null) {
            components.put(FREQ, recur.getFrequency().name());
        }
        if (recur.getUntil() != null) {
            String s = RecurrencePropertyScribe.date(recur.getUntil()).time(recur.hasTimeUntilDate()).extended(extended).write();
            components.put(UNTIL, s);
        }
        if (recur.getCount() != null) {
            components.put(COUNT, recur.getCount());
        }
        if (recur.getInterval() != null) {
            components.put(INTERVAL, recur.getInterval());
        }
        this.addIntegerListComponent(components, BYSECOND, recur.getBySecond());
        this.addIntegerListComponent(components, BYMINUTE, recur.getByMinute());
        this.addIntegerListComponent(components, BYHOUR, recur.getByHour());
        Iterator<Integer> prefixIt = recur.getByDayPrefixes().iterator();
        Iterator<Recurrence.DayOfWeek> dayIt = recur.getByDay().iterator();
        while (prefixIt.hasNext() && dayIt.hasNext()) {
            Integer prefix = prefixIt.next();
            Recurrence.DayOfWeek day = dayIt.next();
            String value = day.getAbbr();
            if (prefix != null) {
                value = prefix + value;
            }
            components.put(BYDAY, value);
        }
        this.addIntegerListComponent(components, BYMONTHDAY, recur.getByMonthDay());
        this.addIntegerListComponent(components, BYYEARDAY, recur.getByYearDay());
        this.addIntegerListComponent(components, BYWEEKNO, recur.getByWeekNo());
        this.addIntegerListComponent(components, BYMONTH, recur.getByMonth());
        this.addIntegerListComponent(components, BYSETPOS, recur.getBySetPos());
        if (recur.getWorkweekStarts() != null) {
            components.put(WKST, recur.getWorkweekStarts().getAbbr());
        }
        for (Map.Entry<String, List<String>> entry : recur.getXRules().entrySet()) {
            String name = entry.getKey();
            for (String value : entry.getValue()) {
                components.put(name, value);
            }
        }
        return components;
    }

    private void addIntegerListComponent(ListMultimap<String, Object> components, String name, List<Integer> values) {
        for (Integer value : values) {
            components.put(name, value);
        }
    }

    private void parseFirst(ListMultimap<String, String> rules, String name, Handler<String> handler) {
        List<String> values = rules.removeAll(name);
        if (values.isEmpty()) {
            return;
        }
        String value = values.get(0);
        handler.handle(value);
    }

    private void parseIntegerList(String name, ListMultimap<String, String> rules, List<Warning> warnings, Handler<Integer> handler) {
        List<String> values = rules.removeAll(name);
        for (String value : values) {
            try {
                handler.handle(Integer.valueOf(value));
            }
            catch (NumberFormatException e) {
                warnings.add(Warning.parse(8, name, value));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface Handler<T> {
        public void handle(T var1);
    }
}

