/*
 * Decompiled with CFR 0.152.
 */
package biweekly.io.scribe.property;

import biweekly.ICalDataType;
import biweekly.Warning;
import biweekly.io.json.JCalValue;
import biweekly.io.scribe.property.ICalPropertyScribe;
import biweekly.io.xml.XCalElement;
import biweekly.parameter.ICalParameters;
import biweekly.property.ListProperty;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ListPropertyScribe<T extends ListProperty<V>, V>
extends ICalPropertyScribe<T> {
    public ListPropertyScribe(Class<T> clazz, String propertyName) {
        this(clazz, propertyName, ICalDataType.TEXT);
    }

    public ListPropertyScribe(Class<T> clazz, String propertyName, ICalDataType dataType) {
        super(clazz, propertyName, dataType);
    }

    @Override
    protected String _writeText(T property) {
        return ListPropertyScribe.list(((ListProperty)property).getValues(), new ICalPropertyScribe.ListCallback<V>((ListProperty)property){
            final /* synthetic */ ListProperty val$property;
            {
                this.val$property = listProperty;
            }

            @Override
            public String asString(V value) {
                return ListPropertyScribe.this.writeValue(this.val$property, value);
            }
        });
    }

    @Override
    protected T _parseText(String value, ICalDataType dataType, ICalParameters parameters, List<Warning> warnings) {
        return this.parse(ListPropertyScribe.list(value), dataType, parameters, warnings);
    }

    @Override
    protected void _writeXml(T property, XCalElement element) {
        for (Object value : ((ListProperty)property).getValues()) {
            String valueStr = this.writeValue(property, value);
            element.append(this.dataType(property), valueStr);
        }
    }

    @Override
    protected T _parseXml(XCalElement element, ICalParameters parameters, List<Warning> warnings) {
        List<String> values = element.all(this.defaultDataType);
        if (!values.isEmpty()) {
            return this.parse(values, this.defaultDataType, parameters, warnings);
        }
        throw ListPropertyScribe.missingXmlElements(this.defaultDataType);
    }

    @Override
    protected JCalValue _writeJson(T property) {
        List values = ((ListProperty)property).getValues();
        if (!values.isEmpty()) {
            return JCalValue.multi(((ListProperty)property).getValues());
        }
        return JCalValue.single("");
    }

    @Override
    protected T _parseJson(JCalValue value, ICalDataType dataType, ICalParameters parameters, List<Warning> warnings) {
        return this.parse(value.asMulti(), dataType, parameters, warnings);
    }

    private T parse(List<String> valueStrs, ICalDataType dataType, ICalParameters parameters, List<Warning> warnings) {
        V property = this.newInstance(dataType, parameters);
        for (String valueStr : valueStrs) {
            V value = this.readValue(valueStr, dataType, parameters, warnings);
            ((ListProperty)property).addValue(value);
        }
        return (T)property;
    }

    protected abstract T newInstance(ICalDataType var1, ICalParameters var2);

    protected abstract String writeValue(T var1, V var2);

    protected abstract V readValue(String var1, ICalDataType var2, ICalParameters var3, List<Warning> var4);
}

