/*
 * Decompiled with CFR 0.152.
 */
package biweekly.io.scribe.property;

import biweekly.ICalDataType;
import biweekly.Warning;
import biweekly.io.CannotParseException;
import biweekly.io.json.JCalValue;
import biweekly.io.scribe.property.ICalPropertyScribe;
import biweekly.io.xml.XCalElement;
import biweekly.parameter.ICalParameters;
import biweekly.property.Geo;
import biweekly.util.ICalFloatFormatter;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeoScribe
extends ICalPropertyScribe<Geo> {
    public GeoScribe() {
        super(Geo.class, "GEO", ICalDataType.FLOAT);
    }

    @Override
    protected String _writeText(Geo property) {
        ICalFloatFormatter formatter = new ICalFloatFormatter();
        StringBuilder sb = new StringBuilder();
        Double latitude = property.getLatitude();
        if (latitude == null) {
            latitude = 0.0;
        }
        sb.append(formatter.format(latitude));
        sb.append(';');
        Double longitude = property.getLongitude();
        if (longitude == null) {
            longitude = 0.0;
        }
        sb.append(formatter.format(longitude));
        return sb.toString();
    }

    @Override
    protected Geo _parseText(String value, ICalDataType dataType, ICalParameters parameters, List<Warning> warnings) {
        ICalPropertyScribe.SemiStructuredIterator it = GeoScribe.semistructured(value, true);
        String latitudeStr = it.next();
        String longitudeStr = it.next();
        if (latitudeStr == null || longitudeStr == null) {
            throw new CannotParseException(20, new Object[0]);
        }
        return this.parse(latitudeStr, longitudeStr);
    }

    @Override
    protected void _writeXml(Geo property, XCalElement element) {
        ICalFloatFormatter formatter = new ICalFloatFormatter();
        Double latitude = property.getLatitude();
        if (latitude == null) {
            latitude = 0.0;
        }
        element.append("latitude", formatter.format(latitude));
        Double longitude = property.getLongitude();
        if (longitude == null) {
            longitude = 0.0;
        }
        element.append("longitude", formatter.format(longitude));
    }

    @Override
    protected Geo _parseXml(XCalElement element, ICalParameters parameters, List<Warning> warnings) {
        String latitudeStr = element.first("latitude");
        String longitudeStr = element.first("longitude");
        if (latitudeStr == null && longitudeStr == null) {
            throw GeoScribe.missingXmlElements("latitude", "longitude");
        }
        if (latitudeStr == null) {
            throw GeoScribe.missingXmlElements("latitude");
        }
        if (longitudeStr == null) {
            throw GeoScribe.missingXmlElements("longitude");
        }
        return this.parse(latitudeStr, longitudeStr);
    }

    @Override
    protected JCalValue _writeJson(Geo property) {
        Double longitude;
        Double latitude = property.getLatitude();
        if (latitude == null) {
            latitude = 0.0;
        }
        if ((longitude = property.getLongitude()) == null) {
            longitude = 0.0;
        }
        return JCalValue.structured(latitude, longitude);
    }

    @Override
    protected Geo _parseJson(JCalValue value, ICalDataType dataType, ICalParameters parameters, List<Warning> warnings) {
        ICalPropertyScribe.StructuredIterator it = GeoScribe.structured(value);
        String latitudeStr = it.nextString();
        String longitudeStr = it.nextString();
        return this.parse(latitudeStr, longitudeStr);
    }

    private Geo parse(String latitudeStr, String longitudeStr) {
        Double latitude = null;
        if (latitudeStr != null) {
            try {
                latitude = Double.valueOf(latitudeStr);
            }
            catch (NumberFormatException e) {
                throw new CannotParseException(21, latitudeStr);
            }
        }
        Double longitude = null;
        if (longitudeStr != null) {
            try {
                longitude = Double.valueOf(longitudeStr);
            }
            catch (NumberFormatException e) {
                throw new CannotParseException(22, longitudeStr);
            }
        }
        return new Geo(latitude, longitude);
    }
}

