/*
 * Decompiled with CFR 0.152.
 */
package biweekly.io.scribe.property;

import biweekly.ICalDataType;
import biweekly.Warning;
import biweekly.io.CannotParseException;
import biweekly.io.json.JCalValue;
import biweekly.io.scribe.property.ICalPropertyScribe;
import biweekly.io.xml.XCalElement;
import biweekly.parameter.ICalParameters;
import biweekly.property.DurationProperty;
import biweekly.util.Duration;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DurationPropertyScribe
extends ICalPropertyScribe<DurationProperty> {
    public DurationPropertyScribe() {
        super(DurationProperty.class, "DURATION", ICalDataType.DURATION);
    }

    @Override
    protected String _writeText(DurationProperty property) {
        Duration duration = (Duration)property.getValue();
        if (duration != null) {
            return duration.toString();
        }
        return "";
    }

    @Override
    protected DurationProperty _parseText(String value, ICalDataType dataType, ICalParameters parameters, List<Warning> warnings) {
        value = DurationPropertyScribe.unescape(value);
        return this.parse(value);
    }

    @Override
    protected void _writeXml(DurationProperty property, XCalElement element) {
        String durationStr = null;
        Duration duration = (Duration)property.getValue();
        if (duration != null) {
            durationStr = duration.toString();
        }
        element.append(this.dataType(property), durationStr);
    }

    @Override
    protected DurationProperty _parseXml(XCalElement element, ICalParameters parameters, List<Warning> warnings) {
        String value = element.first(this.defaultDataType);
        if (value != null) {
            return this.parse(value);
        }
        throw DurationPropertyScribe.missingXmlElements(this.defaultDataType);
    }

    @Override
    protected JCalValue _writeJson(DurationProperty property) {
        Duration value = (Duration)property.getValue();
        if (value != null) {
            return JCalValue.single(value.toString());
        }
        return JCalValue.single("");
    }

    @Override
    protected DurationProperty _parseJson(JCalValue value, ICalDataType dataType, ICalParameters parameters, List<Warning> warnings) {
        String valueStr = value.asSingle();
        return this.parse(valueStr);
    }

    private DurationProperty parse(String value) {
        if (value == null) {
            return new DurationProperty(null);
        }
        try {
            Duration duration = Duration.parse(value);
            return new DurationProperty(duration);
        }
        catch (IllegalArgumentException e) {
            throw new CannotParseException(18, new Object[0]);
        }
    }
}

