/*
 * Decompiled with CFR 0.152.
 */
package biweekly.io.scribe.property;

import biweekly.ICalDataType;
import biweekly.Warning;
import biweekly.io.CannotParseException;
import biweekly.io.json.JCalValue;
import biweekly.io.scribe.property.ICalPropertyScribe;
import biweekly.io.xml.XCalElement;
import biweekly.parameter.ICalParameters;
import biweekly.property.DateOrDateTimeProperty;
import biweekly.util.DateTimeComponents;
import biweekly.util.ICalDateFormat;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DateOrDateTimePropertyScribe<T extends DateOrDateTimeProperty>
extends ICalPropertyScribe<T> {
    public DateOrDateTimePropertyScribe(Class<T> clazz, String propertyName) {
        super(clazz, propertyName, ICalDataType.DATE_TIME);
    }

    @Override
    protected ICalDataType _dataType(T property) {
        return ((DateOrDateTimeProperty)property).getRawComponents() != null || ((DateOrDateTimeProperty)property).getValue() == null || ((DateOrDateTimeProperty)property).hasTime() ? ICalDataType.DATE_TIME : ICalDataType.DATE;
    }

    @Override
    protected String _writeText(T property) {
        DateTimeComponents components = ((DateOrDateTimeProperty)property).getRawComponents();
        if (components != null) {
            return components.toString(false);
        }
        Date value = ((DateOrDateTimeProperty)property).getValue();
        if (value != null) {
            return DateOrDateTimePropertyScribe.date(value).time(((DateOrDateTimeProperty)property).hasTime()).tz(((DateOrDateTimeProperty)property).isLocalTime(), ((DateOrDateTimeProperty)property).getTimezoneId()).write();
        }
        return "";
    }

    @Override
    protected T _parseText(String value, ICalDataType dataType, ICalParameters parameters, List<Warning> warnings) {
        value = DateOrDateTimePropertyScribe.unescape(value);
        return this.parse(value, parameters, warnings);
    }

    @Override
    protected void _writeXml(T property, XCalElement element) {
        String dateStr = null;
        Date value = ((DateOrDateTimeProperty)property).getValue();
        DateTimeComponents components = ((DateOrDateTimeProperty)property).getRawComponents();
        if (components != null) {
            dateStr = components.toString(true);
        } else if (value != null) {
            dateStr = DateOrDateTimePropertyScribe.date(value).time(((DateOrDateTimeProperty)property).hasTime()).tz(((DateOrDateTimeProperty)property).isLocalTime(), ((DateOrDateTimeProperty)property).getTimezoneId()).extended(true).write();
        }
        element.append(this.dataType(property), dateStr);
    }

    @Override
    protected T _parseXml(XCalElement element, ICalParameters parameters, List<Warning> warnings) {
        String value = element.first(ICalDataType.DATE_TIME);
        if (value == null) {
            value = element.first(ICalDataType.DATE);
        }
        if (value != null) {
            return this.parse(value, parameters, warnings);
        }
        throw DateOrDateTimePropertyScribe.missingXmlElements(ICalDataType.DATE_TIME, ICalDataType.DATE);
    }

    @Override
    protected JCalValue _writeJson(T property) {
        DateTimeComponents components = ((DateOrDateTimeProperty)property).getRawComponents();
        if (components != null) {
            return JCalValue.single(components.toString(true));
        }
        Date value = ((DateOrDateTimeProperty)property).getValue();
        if (value != null) {
            return JCalValue.single(DateOrDateTimePropertyScribe.date(value).time(((DateOrDateTimeProperty)property).hasTime()).tz(((DateOrDateTimeProperty)property).isLocalTime(), ((DateOrDateTimeProperty)property).getTimezoneId()).extended(true).write());
        }
        return JCalValue.single("");
    }

    @Override
    protected T _parseJson(JCalValue value, ICalDataType dataType, ICalParameters parameters, List<Warning> warnings) {
        String valueStr = value.asSingle();
        return this.parse(valueStr, parameters, warnings);
    }

    protected abstract T newInstance(Date var1, boolean var2);

    private T parse(String value, ICalParameters parameters, List<Warning> warnings) {
        DateTimeComponents components;
        Date date;
        if (value == null) {
            return this.newInstance(null, true);
        }
        try {
            date = DateOrDateTimePropertyScribe.date(value).tzid(parameters.getTimezoneId(), warnings).parse();
        }
        catch (IllegalArgumentException e) {
            throw new CannotParseException(17, new Object[0]);
        }
        try {
            components = DateTimeComponents.parse(value);
        }
        catch (IllegalArgumentException e) {
            warnings.add(Warning.parse(6, value));
            components = null;
        }
        boolean hasTime = ICalDateFormat.dateHasTime(value);
        boolean localTz = !ICalDateFormat.dateHasTimezone(value) && parameters.getTimezoneId() == null;
        T prop = this.newInstance(date, hasTime);
        ((DateOrDateTimeProperty)prop).setRawComponents(components);
        ((DateOrDateTimeProperty)prop).setLocalTime(localTz);
        return prop;
    }
}

