/*
 * Decompiled with CFR 0.152.
 */
package biweekly.io.scribe.property;

import biweekly.ICalDataType;
import biweekly.Warning;
import biweekly.io.json.JCalValue;
import biweekly.io.scribe.property.ICalPropertyScribe;
import biweekly.io.xml.XCalElement;
import biweekly.parameter.Encoding;
import biweekly.parameter.ICalParameters;
import biweekly.property.Attachment;
import biweekly.util.Base64;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttachmentScribe
extends ICalPropertyScribe<Attachment> {
    public AttachmentScribe() {
        super(Attachment.class, "ATTACH", ICalDataType.URI);
    }

    @Override
    protected void _prepareParameters(Attachment property, ICalParameters copy) {
        if (property.getUri() != null) {
            copy.setEncoding(null);
        } else if (property.getData() != null) {
            copy.setEncoding(Encoding.BASE64);
        }
    }

    @Override
    protected ICalDataType _dataType(Attachment property) {
        if (property.getUri() != null) {
            return ICalDataType.URI;
        }
        if (property.getData() != null) {
            return ICalDataType.BINARY;
        }
        return this.defaultDataType;
    }

    @Override
    protected String _writeText(Attachment property) {
        String uri = property.getUri();
        if (uri != null) {
            return uri;
        }
        byte[] data = property.getData();
        if (data != null) {
            return Base64.encode(data);
        }
        return "";
    }

    @Override
    protected Attachment _parseText(String value, ICalDataType dataType, ICalParameters parameters, List<Warning> warnings) {
        value = AttachmentScribe.unescape(value);
        if (dataType == ICalDataType.BINARY || parameters.getEncoding() == Encoding.BASE64) {
            return new Attachment(null, Base64.decode(value));
        }
        return new Attachment(null, value);
    }

    @Override
    protected void _writeXml(Attachment property, XCalElement element) {
        String uri = property.getUri();
        if (uri != null) {
            element.append(ICalDataType.URI, uri);
            return;
        }
        byte[] data = property.getData();
        if (data != null) {
            element.append(ICalDataType.BINARY, Base64.encode(data));
            return;
        }
        element.append(this.defaultDataType, "");
    }

    @Override
    protected Attachment _parseXml(XCalElement element, ICalParameters parameters, List<Warning> warnings) {
        String uri = element.first(ICalDataType.URI);
        if (uri != null) {
            return new Attachment(null, uri);
        }
        String base64Data = element.first(ICalDataType.BINARY);
        if (base64Data != null) {
            return new Attachment(null, Base64.decode(base64Data));
        }
        throw AttachmentScribe.missingXmlElements(ICalDataType.URI, ICalDataType.BINARY);
    }

    @Override
    protected JCalValue _writeJson(Attachment property) {
        String uri = property.getUri();
        if (uri != null) {
            return JCalValue.single(uri);
        }
        byte[] data = property.getData();
        if (data != null) {
            return JCalValue.single(Base64.encode(data));
        }
        return JCalValue.single("");
    }

    @Override
    protected Attachment _parseJson(JCalValue value, ICalDataType dataType, ICalParameters parameters, List<Warning> warnings) {
        String valueStr = value.asSingle();
        if (dataType == ICalDataType.BINARY) {
            return new Attachment(null, Base64.decode(valueStr));
        }
        return new Attachment(null, valueStr);
    }
}

