/*
 * Decompiled with CFR 0.152.
 */
package biweekly.io.json;

import biweekly.ICalDataType;
import biweekly.ICalendar;
import biweekly.component.ICalComponent;
import biweekly.io.SkipMeException;
import biweekly.io.json.JCalRawWriter;
import biweekly.io.json.JCalValue;
import biweekly.io.scribe.ScribeIndex;
import biweekly.io.scribe.component.ICalComponentScribe;
import biweekly.io.scribe.property.ICalPropertyScribe;
import biweekly.parameter.ICalParameters;
import biweekly.property.ICalProperty;
import biweekly.util.IOUtils;
import java.io.Closeable;
import java.io.File;
import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JCalWriter
implements Closeable,
Flushable {
    private ScribeIndex index = new ScribeIndex();
    private final JCalRawWriter writer;

    public JCalWriter(OutputStream outputStream) {
        this(IOUtils.utf8Writer(outputStream));
    }

    public JCalWriter(OutputStream outputStream, boolean wrapInArray) {
        this(IOUtils.utf8Writer(outputStream), wrapInArray);
    }

    public JCalWriter(File file) throws IOException {
        this(IOUtils.utf8Writer(file));
    }

    public JCalWriter(File file, boolean wrapInArray) throws IOException {
        this(IOUtils.utf8Writer(file), wrapInArray);
    }

    public JCalWriter(Writer writer) {
        this(writer, false);
    }

    public JCalWriter(Writer writer, boolean wrapInArray) {
        this.writer = new JCalRawWriter(writer, wrapInArray);
    }

    public void registerScribe(ICalPropertyScribe<? extends ICalProperty> scribe) {
        this.index.register(scribe);
    }

    public void registerScribe(ICalComponentScribe<? extends ICalComponent> scribe) {
        this.index.register(scribe);
    }

    public ScribeIndex getScribeIndex() {
        return this.index;
    }

    public void setScribeIndex(ScribeIndex index) {
        this.index = index;
    }

    public boolean isIndent() {
        return this.writer.isIndent();
    }

    public void setIndent(boolean indent) {
        this.writer.setIndent(indent);
    }

    public void write(ICalendar ical) throws IOException {
        this.index.hasScribesFor(ical);
        this.writeComponent(ical);
    }

    private void writeComponent(ICalComponent component) throws IOException {
        ICalComponentScribe<? extends ICalComponent> componentScribe = this.index.getComponentScribe(component);
        this.writer.writeStartComponent(componentScribe.getComponentName().toLowerCase());
        Iterator<Object> i$ = componentScribe.getProperties(component).iterator();
        while (i$.hasNext()) {
            JCalValue value;
            ICalParameters parameters;
            ICalProperty iCalProperty;
            ICalProperty property = iCalProperty = i$.next();
            ICalPropertyScribe<? extends ICalProperty> propertyScribe = this.index.getPropertyScribe(property);
            try {
                parameters = propertyScribe.prepareParameters(property);
                value = propertyScribe.writeJson(property);
            }
            catch (SkipMeException e) {
                continue;
            }
            String propertyName = propertyScribe.getPropertyName().toLowerCase();
            ICalDataType dataType = propertyScribe.dataType(property);
            this.writer.writeProperty(propertyName, parameters, dataType, value);
        }
        for (Object object : componentScribe.getComponents(component)) {
            ICalComponent subComponent = (ICalComponent)object;
            this.writeComponent(subComponent);
        }
        this.writer.writeEndComponent();
    }

    @Override
    public void flush() throws IOException {
        this.writer.flush();
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    public void closeJsonStream() throws IOException {
        this.writer.closeJsonStream();
    }
}

