/*
 * Decompiled with CFR 0.152.
 */
package biweekly.io;

import biweekly.Messages;
import biweekly.Warning;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParseWarnings {
    private final List<String> warnings = new ArrayList<String>();

    public void add(Integer line, String propertyName, int code, Object ... args) {
        Warning warning = Warning.parse(code, args);
        this.add(line, propertyName, warning);
    }

    public void add(Integer line, String propertyName, Warning message) {
        if (line == null && propertyName == null) {
            this.warnings.add(message.toString());
            return;
        }
        String key = line == null && propertyName != null ? "parse.prop" : (line != null && propertyName == null ? "parse.line" : "parse.lineWithProp");
        String warning = Messages.INSTANCE.getMessage(key, line, propertyName, message);
        this.warnings.add(warning);
    }

    public List<String> copy() {
        return new ArrayList<String>(this.warnings);
    }

    public void clear() {
        this.warnings.clear();
    }
}

