/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.util;

import java.util.Date;
import java.util.HashMap;
import org.unitime.commons.Debug;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.util.FailedLoginAttempt;

public class LoginManager {
    private static HashMap<String, FailedLoginAttempt> failedLoginAttempts = new HashMap();

    public static boolean isUserLockedOut(String user, Date attemptDateTime) {
        FailedLoginAttempt fla = failedLoginAttempts.get(user);
        if (fla != null) {
            boolean lockedOut = fla.isUserLockedOut(user, attemptDateTime);
            if (lockedOut) {
                Debug.info("Too many failed login attempts - User: " + user + " temporarily locked out.");
                if (fla.getCount() > ApplicationProperty.LoginMaxFailedAttempts.intValue() + 3) {
                    try {
                        Thread.sleep(ApplicationProperty.LoginFailedAttemptDelay.intValue().intValue());
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
            }
            return lockedOut;
        }
        return false;
    }

    public static void addFailedLoginAttempt(String user, Date attemptDateTime) {
        FailedLoginAttempt fla = failedLoginAttempts.get(user);
        if (fla == null) {
            failedLoginAttempts.put(user, new FailedLoginAttempt(user, 1, attemptDateTime));
        } else {
            if (fla.getCount() < ApplicationProperty.LoginMaxFailedAttempts.intValue()) {
                fla.setLastFailedAttempt(attemptDateTime);
            }
            fla.setCount(fla.getCount() + 1);
        }
    }

    public static void loginSuceeded(String user) {
        failedLoginAttempts.remove(user);
    }
}

